/*
 * Decompiled with CFR 0.152.
 */
package robots;

import java.awt.AWTException;
import java.awt.Point;
import java.awt.Robot;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JDialog;
import javax.swing.SwingUtilities;
import multimedia.Multimedia;
import multimedia.SousTitres;
import sun.awt.SunToolkit;
import views.DialogChangeAtom;
import views.DialogChangeHuckelBond;
import views.FrameApp;

public abstract class Tutorial
extends Robot
implements ActionListener,
Runnable {
    public static final boolean FORCE_MOVE_FAST_INSTEAD_SLOW = false;
    protected FrameApp applet;
    private static SunToolkit toolkit;
    protected static Point CurrentMousePosition;
    protected static final int INFINITE_DELAY = 6000;
    protected static final int LONG_DELAY = 50;
    protected static final int NORMAL_DELAY = 5;
    protected static final int RAPID_DELAY = 1;
    protected static final int VERYLONG_DELAY = 500;

    @Override
    public void actionPerformed(ActionEvent e) {
        Thread t = new Thread(this);
        t.start();
    }

    @Override
    public void run() {
        this.setAutoDelay(5);
        this.go();
    }

    public DialogChangeAtom getDialogChangeAtom() {
        Window[] windowArray = JDialog.getWindows();
        int n = windowArray.length;
        int n2 = 0;
        while (n2 < n) {
            Window w = windowArray[n2];
            if (w instanceof DialogChangeAtom && w.isVisible()) {
                return (DialogChangeAtom)w;
            }
            ++n2;
        }
        return null;
    }

    public DialogChangeHuckelBond getDialogChangeHuckelBond() {
        Window[] windowArray = JDialog.getWindows();
        int n = windowArray.length;
        int n2 = 0;
        while (n2 < n) {
            Window w = windowArray[n2];
            if (w instanceof DialogChangeHuckelBond && w.isVisible()) {
                return (DialogChangeHuckelBond)w;
            }
            ++n2;
        }
        return null;
    }

    public void sleep(int delay) {
        super.delay(delay);
    }

    public Tutorial(FrameApp applet) throws AWTException {
        this.applet = applet;
        CurrentMousePosition = new Point();
        this.mouseMove(0, 0);
        toolkit = (SunToolkit)Toolkit.getDefaultToolkit();
    }

    public abstract void go();

    public synchronized void mouseLeftSimpleClick() {
        SousTitres st = new SousTitres("Click", 500);
        this.mousePress(16);
        if (!SwingUtilities.isEventDispatchThread()) {
            this.waitForIdle();
        } else {
            this.sleep(2000);
        }
        this.mouseRelease(16);
        if (!SwingUtilities.isEventDispatchThread()) {
            this.waitForIdle();
        } else {
            this.sleep(2000);
        }
        Tutorial.syncAndDelay();
    }

    private void mouseMove(double x, double y) {
        this.mouseMove((int)x, (int)y);
    }

    @Override
    public synchronized void mouseMove(int x, int y) {
        super.mouseMove(x, y);
        CurrentMousePosition.setLocation(x, y);
    }

    public void mouseMove(Point point) {
        this.mouseMove(point.getX(), point.getY());
    }

    public synchronized void mouseMoveSlowly(int x, int y) {
        Point target = new Point(x, y);
        double dx = 1.0;
        double dy = 1.0;
        while ((int)dx != 0 || (int)dy != 0) {
            dx = Math.signum((double)((int)target.getX()) - CurrentMousePosition.getX());
            dy = Math.signum((double)((int)target.getY()) - CurrentMousePosition.getY());
            Point nextPoint = new Point();
            nextPoint.setLocation(CurrentMousePosition.getX() + dx, CurrentMousePosition.getY() + dy);
            this.mouseMove(nextPoint);
        }
    }

    public void mouseMoveSlowly(Point p) {
        this.mouseMoveSlowly((int)p.getX(), (int)p.getY());
    }

    @Override
    public synchronized void mousePress(int buttons) {
        try {
            Multimedia m = new Multimedia("src-swing-gui/audio/simpleclick.wav");
            m.playwav();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.setAutoDelay(500);
        super.mousePress(buttons);
        this.setAutoDelay(5);
    }

    public static void syncAndDelay() {
        try {
            Thread.sleep(1L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        if (!SwingUtilities.isEventDispatchThread()) {
            toolkit.realSync();
        } else {
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }
}

