/*
 * Decompiled with CFR 0.152.
 */
package robots;

import java.awt.AWTException;
import java.awt.Component;
import java.awt.Point;
import java.awt.geom.Point2D;
import javax.swing.JToggleButton;
import org.ctom.hulis.huckel.Bond;
import org.ctom.hulis.huckel.HuckelAtom;
import org.ctom.hulis.huckel.HuckelBond;
import org.ctom.hulis.huckel.PeriodicTable;
import org.ctom.hulis.huckel.structures.Structure;
import org.ctom.util.maths.Point3D;
import robots.Tutorial;
import util.ComponentsTools;
import views.DialogChangeAtom;
import views.DialogChangeHuckelBond;
import views.FrameApp;
import views.StructureView;

public abstract class TutorialCommands
extends Tutorial {
    public synchronized Point2D getImageLocationAtomBySeqNum(int seqNum) {
        Point3D location = null;
        while (location == null) {
            try {
                if (this.applet.getCurrentMesomery() == null) {
                    throw new Exception("MESOMERY IS NULL");
                }
                if (this.applet.getCurrentMesomery().getDelocalizedStructure() == null) {
                    throw new Exception("STRUCTURE DELOCALIZED IS NULL");
                }
                if (this.applet.getCurrentMesomery().getDelocalizedStructure().getAtomBySeqNum(seqNum) == null) {
                    throw new Exception("NO ATOM WITH SEQNUM==" + seqNum);
                }
                if (this.applet.getCurrentMesomery().getDelocalizedStructure().getAtomBySeqNum(seqNum).getLocation() == null) {
                    throw new Exception("NO LOCATION FOR ATOM SEQNUM==" + seqNum);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            location = this.applet.getCurrentMesomery().getDelocalizedStructure().getAtomBySeqNum(seqNum).getLocation();
            TutorialCommands.syncAndDelay();
        }
        StructureView structureView = this.applet.getCurrentMesomeryView().getCurrentStructureView();
        return structureView.getImagePoint(structureView.getPoint2D(location));
    }

    public synchronized Point2D getImageLocationAtomByIndex(int index) {
        Point3D location = null;
        while (location == null) {
            try {
                if (this.applet.getCurrentMesomery() == null) {
                    throw new Exception("MESOMERY IS NULL");
                }
                if (this.applet.getCurrentMesomery().getDelocalizedStructure() == null) {
                    throw new Exception("STRUCTURE DELOCALIZED IS NULL");
                }
                if (this.applet.getCurrentMesomery().getDelocalizedStructure().getAtomByIndex(index) == null) {
                    throw new Exception("NO ATOM WITH INDEX==" + index);
                }
                if (this.applet.getCurrentMesomery().getDelocalizedStructure().getAtomByIndex(index).getLocation() == null) {
                    throw new Exception("NO LOCATION FOR ATOM INDEX==" + index);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            location = this.applet.getCurrentMesomery().getDelocalizedStructure().getAtomByIndex(index).getLocation();
            TutorialCommands.syncAndDelay();
        }
        StructureView structureView = this.applet.getCurrentMesomeryView().getCurrentStructureView();
        return structureView.getImagePoint(structureView.getPoint2D(location));
    }

    public synchronized void putElectrons(int numAtom, int nb) {
        if (!this.applet.toolBarMesomery.btChangeElectrons.isSelected()) {
            this.clickChangeElectrons();
        }
        StructureView structureView = this.applet.getCurrentMesomeryView().getCurrentStructureView();
        Point2D p = ComponentsTools.getLocationOnScreen(structureView);
        int x2 = (int)p.getX();
        int y2 = (int)p.getY();
        HuckelAtom atom = (HuckelAtom)structureView.getStructure().getAtomBySeqNum(numAtom);
        p = structureView.getImagePoint(structureView.getPoint2D(atom.getLocation()));
        this.mouseMoveSlowly((int)((double)x2 + p.getX()), (int)((double)y2 + p.getY()));
        while (atom.countRadR() != nb) {
            this.mouseLeftSimpleClick();
            TutorialCommands.syncAndDelay();
        }
        TutorialCommands.syncAndDelay();
    }

    public synchronized void putElectrons(int numAtom1, int numAtom2, int nb) {
        if (!this.applet.toolBarMesomery.btChangeElectrons.isSelected()) {
            this.clickChangeElectrons();
        }
        StructureView structureView = this.applet.getCurrentMesomeryView().getCurrentStructureView();
        Point2D p = ComponentsTools.getLocationOnScreen(structureView);
        int x2 = (int)p.getX();
        int y2 = (int)p.getY();
        Structure s = structureView.getStructure();
        HuckelBond b = (HuckelBond)s.getBond(s.getAtomBySeqNum(numAtom1), s.getAtomBySeqNum(numAtom2));
        p = structureView.getImagePoint(structureView.getPoint2D(b.getLocation()));
        this.mouseMoveSlowly((int)((double)x2 + p.getX()), (int)((double)y2 + p.getY()));
        while (b.getBondType() != nb) {
            this.mouseLeftSimpleClick();
            TutorialCommands.syncAndDelay();
        }
        TutorialCommands.syncAndDelay();
    }

    public synchronized void clickAddMoleculeCharge(int nb) {
        int i2 = 0;
        while (i2 < nb) {
            this.clickBT(this.applet.toolBarHuckel.btMoleculeRemoveElecCharge);
            ++i2;
        }
        TutorialCommands.syncAndDelay();
    }

    public synchronized void clickRemoveMoleculeCharge(int nb) {
        int i2 = 0;
        while (i2 < nb) {
            this.clickBT(this.applet.toolBarHuckel.btMoleculeAddElecCharge);
            ++i2;
        }
        TutorialCommands.syncAndDelay();
    }

    public synchronized void selectDelocalizedStructure() {
        this.applet.getCurrentMesomeryView().setCurrentStructure(this.applet.getCurrentMesomeryView().getMesomery().getDelocalizedStructure());
        TutorialCommands.syncAndDelay();
    }

    public synchronized void clickCreate1() {
        this.clickBT(this.applet.toolBarMesomery.btDuplicate);
    }

    public void clickChangeElectrons() {
        this.clickBT(this.applet.toolBarMesomery.btChangeElectrons);
    }

    public synchronized void clickEraseMesomery() {
        this.clickBT(this.applet.toolBarMesomery.btEraseMesomery);
        this.applet.getCurrentMesomeryView().setSelectedIndex(0);
        TutorialCommands.syncAndDelay();
    }

    public synchronized void clickOnTab(String name) {
        TutorialCommands.syncAndDelay();
        if (name == "tot") {
            this.applet.getCurrentMesomeryView().setSelectedIndex(0);
        } else {
            this.applet.getCurrentMesomeryView().setSelectedIndex(Integer.valueOf(name));
        }
        TutorialCommands.syncAndDelay();
    }

    public synchronized void clickOnTab(int n) {
        TutorialCommands.syncAndDelay();
        this.applet.getCurrentMesomeryView().setSelectedIndex(n);
        TutorialCommands.syncAndDelay();
        this.delay(5);
    }

    public synchronized void clickErase1() {
        this.clickBT(this.applet.toolBarMesomery.btErase1);
        TutorialCommands.syncAndDelay();
    }

    public synchronized void clickEraseAll() {
        if (this.applet.getCurrentMesomery().countLocalizedStructs() == 0 && this.applet.getCurrentMesomery().getDelocalizedStructure().countAtoms() == 0) {
            return;
        }
        this.clickBT(this.applet.toolBarHuckel.btErase);
        TutorialCommands.syncAndDelay();
    }

    public void clickBTAdd() {
        this.clickBT(this.applet.toolBarHuckel.btAdd);
    }

    public void clickBTShowHxHxy() {
        this.clickBT(this.applet.toolBarHuckel.btDisplayHxHxy);
    }

    public void clickBTShowNumbering() {
        this.clickBT(this.applet.toolBarHuckel.btDisplayNum);
    }

    public void clickBTChange() {
        this.clickBT(this.applet.toolBarHuckel.btChange);
    }

    public void clickBTBloc() {
        this.clickMenuExpert();
        this.clickBT(this.applet.toolBarMesomery.btBloc);
    }

    public void clickBTEndBloc() {
        this.clickBT(this.applet.toolBarMesomery.btEndBloc);
    }

    public void clickBTShowStructureResults() {
        this.clickBT(this.applet.toolBarHuckel.btShowResults);
    }

    public void clickBTShowMesomeryResults() {
        this.clickBT(this.applet.toolBarMesomery.btShowResultsMesomery);
    }

    public void clickBTGenerateAll() {
        this.clickBT(this.applet.toolBarMesomery.btAutoGenStruct);
        TutorialCommands.syncAndDelay();
        this.delay(5);
        TutorialCommands.syncAndDelay();
    }

    public synchronized void clickMenuExpert() {
        if (this.applet.menuBar.menuExp.isSelected()) {
            return;
        }
        this.clickBT(this.applet.menuBar.computeMenu);
        this.clickBT(this.applet.menuBar.menuExp);
        this.delay(5);
    }

    public synchronized void selectSliderValue(double value) {
        this.applet.toolBarMesomery.setValueManually(value);
        TutorialCommands.syncAndDelay();
    }

    public synchronized void clickMenuHLCI() {
        if (this.applet.menuBar.getItemMethod("HLCI").isSelected()) {
            return;
        }
        this.clickBT(this.applet.menuBar.computeMenu);
        this.clickBT(this.applet.menuBar.getItemMethod("HLCI"));
    }

    public synchronized void clickMenuHLP() {
        if (this.applet.menuBar.getItemMethod("HLP").isSelected()) {
            return;
        }
        this.clickBT(this.applet.menuBar.computeMenu);
        this.clickBT(this.applet.menuBar.getItemMethod("HLP"));
    }

    public synchronized void moveToBT(Component button) {
        Point2D bt = ComponentsTools.getCenter(button);
        this.mouseMoveSlowly((int)bt.getX(), (int)bt.getY());
    }

    public synchronized void clickBT(Component button) {
        this.moveToBT(button);
        this.mouseLeftSimpleClick();
        TutorialCommands.syncAndDelay();
    }

    public synchronized void clickBT(JToggleButton button) {
        if (button.isSelected()) {
            return;
        }
        this.moveToBT(button);
        this.mouseLeftSimpleClick();
        TutorialCommands.syncAndDelay();
    }

    public void putAtom(PeriodicTable.Entry entry, int x, int y) {
        this.putAtom(entry, 0.0, false, x, y, 0, 0, false);
    }

    public void putAtom(PeriodicTable.Entry entry, double hX, int x, int y) {
        this.putAtom(entry, hX, true, x, y, 0, 0, false);
    }

    public void putAtom(PeriodicTable.Entry entry, int x, int y, int pX, int pY) {
        this.putAtom(entry, 0.0, false, x, y, pX, pY, true);
    }

    public void putAtom(PeriodicTable.Entry entry, double hX, int x, int y, int pX, int pY) {
        this.putAtom(entry, hX, true, x, y, pX, pY, true);
    }

    private synchronized void putAtom(PeriodicTable.Entry entry, double hX, boolean changeHX, int x, int y, int pX, int pY, boolean link) {
        StructureView structureView = this.applet.getCurrentMesomeryView().getCurrentStructureView();
        Point p = ComponentsTools.getLocationOnScreen(structureView);
        int x2 = (int)p.getX();
        int y2 = (int)p.getY();
        this.clickBTAdd();
        if (!link) {
            this.mouseMoveSlowly(x2 + x, y2 + y);
            this.mouseLeftSimpleClick();
            TutorialCommands.syncAndDelay();
        } else {
            this.link(pX, pY, x, y);
        }
        if (entry != PeriodicTable.Entry.C || changeHX) {
            this.changeAtom(x, y, entry, hX, changeHX);
        }
        TutorialCommands.syncAndDelay();
    }

    public synchronized void link(int x1, int y1, int x2, int y2) {
        this.clickBTAdd();
        StructureView structureView = this.applet.getCurrentMesomeryView().getCurrentStructureView();
        Point p = ComponentsTools.getLocationOnScreen(structureView);
        int xR = (int)p.getX();
        int yR = (int)p.getY();
        this.mouseMoveSlowly(xR + x1, yR + y1);
        TutorialCommands.syncAndDelay();
        this.mousePress(16);
        TutorialCommands.syncAndDelay();
        this.mouseMoveSlowly(xR + x2, yR + y2);
        TutorialCommands.syncAndDelay();
        this.mouseRelease(16);
        TutorialCommands.syncAndDelay();
    }

    public synchronized void selectRectangleBloc(int x1, int y1, int x2, int y2) {
        this.clickBTBloc();
        StructureView structureView = this.applet.getCurrentMesomeryView().getCurrentStructureView();
        Point p = ComponentsTools.getLocationOnScreen(structureView);
        int xR = (int)p.getX();
        int yR = (int)p.getY();
        this.mouseMoveSlowly(xR + x1, yR + y1);
        this.mousePress(16);
        this.mouseMoveSlowly(xR + x2, yR + y2);
        this.mouseRelease(16);
        TutorialCommands.syncAndDelay();
    }

    public void changeAtom(int x, int y, PeriodicTable.Entry element, double hX) {
        this.changeAtom(x, y, element, hX, true);
    }

    public void changeAtom(int x, int y, PeriodicTable.Entry element) {
        this.changeAtom(x, y, element, 0.0, false);
    }

    public void changeAtom(int x, int y, double hX) {
        this.changeAtom(x, y, null, hX, true);
    }

    private synchronized void changeAtom(int x, int y, PeriodicTable.Entry element, double hX, boolean changeHX) {
        StructureView structureView = this.applet.getCurrentMesomeryView().getCurrentStructureView();
        Point p = ComponentsTools.getLocationOnScreen(structureView);
        int x2 = (int)p.getX();
        int y2 = (int)p.getY();
        this.clickBTChange();
        this.mouseMoveSlowly(x2 + x, y2 + y);
        this.mouseLeftSimpleClick();
        TutorialCommands.syncAndDelay();
        DialogChangeAtom dialog = null;
        while (dialog == null) {
            dialog = this.getDialogChangeAtom();
            TutorialCommands.syncAndDelay();
        }
        if (element != null) {
            this.clickBT(dialog.getButton(element.toString()));
        }
        if (changeHX) {
            this.clickBT(dialog.txtHx);
            TutorialCommands.syncAndDelay();
            dialog.txtHx.selectAll();
            TutorialCommands.syncAndDelay();
            dialog.txtHx.setText(Double.toString(hX));
            TutorialCommands.syncAndDelay();
        }
        this.clickBT(dialog.btOK);
        TutorialCommands.syncAndDelay();
    }

    public synchronized void changeHXY(int atom1, int atom2, double hXY) {
        this.clickBTChange();
        StructureView structureView = this.applet.getCurrentMesomeryView().getCurrentStructureView();
        Point2D p = ComponentsTools.getLocationOnScreen(structureView);
        int x2 = (int)p.getX();
        int y2 = (int)p.getY();
        Structure s = structureView.getStructure();
        Bond b = s.getBond(s.getAtomBySeqNum(atom1), s.getAtomBySeqNum(atom2));
        p = structureView.getImagePoint(structureView.getPoint2D(b.getLocation()));
        this.mouseMoveSlowly((int)((double)x2 + p.getX()), (int)((double)y2 + p.getY()));
        this.mouseLeftSimpleClick();
        TutorialCommands.syncAndDelay();
        DialogChangeHuckelBond dialog = null;
        while (dialog == null) {
            dialog = this.getDialogChangeHuckelBond();
            TutorialCommands.syncAndDelay();
        }
        this.clickBT(dialog.txtHxy);
        TutorialCommands.syncAndDelay();
        dialog.txtHxy.selectAll();
        TutorialCommands.syncAndDelay();
        dialog.txtHxy.setText(Double.toString(hXY));
        TutorialCommands.syncAndDelay();
        this.clickBT(dialog.btOK);
        TutorialCommands.syncAndDelay();
    }

    public TutorialCommands(FrameApp applet) throws AWTException {
        super(applet);
    }

    @Override
    public abstract void go();
}

