/*
 * Decompiled with CFR 0.152.
 */
package sqlbridge;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Locale;
import sqlbridge.RegisterDisconnectApplet;
import sqlbridge.RegisterDuration;
import sqlbridge.RegisterNewUSer;
import util.Version;
import util.io.SwingIO;
import views.FrameApp;

public class ConnectSQL {
    public static final String PROBABLE_COUNTRY_URL = "http://www.hulis.free.fr/register/getPaysProbable.php";
    public static final String CONNECT_URL = "http://www.hulis.free.fr/register/connectapplet.php";
    public static final String CURRENT_VERSION = "http://www.hulis.free.fr/register/currentversion.php";
    public static final String DECONNECT_URL = "http://www.hulis.free.fr/register/deconnectapplet.php";
    public static final String DURATION = "http://www.hulis.free.fr/register/duree.php";
    public static final boolean STOP_DATABASE_CONNECTION = false;
    public static final String TEST_VERSION = "http://www.hulis.free.fr/register/testversion.php";
    public static final String USER_URL = "http://www.hulis.free.fr/register/getnewuser.php";
    private static ConnectSQL instance = null;

    public static void clear() {
        instance = null;
    }

    public static ConnectSQL getInstance() {
        if (instance == null) {
            instance = new ConnectSQL();
        }
        return instance;
    }

    public static String getProbableCountry() {
        try {
            URL u = new URL(PROBABLE_COUNTRY_URL);
            InputStream i2 = u.openStream();
            BufferedReader b = new BufferedReader(new InputStreamReader(i2));
            String s = null;
            while ((s = b.readLine()) != null) {
                if (s.trim().equals("")) continue;
                return s;
            }
        }
        catch (MalformedURLException e) {
            SwingIO.warning("ConnectSQL", "getProbableCountry", "maformed url", e);
        }
        catch (IOException e) {
            SwingIO.warning("ConnectSQL", "getProbableCountry", "network error", e);
        }
        return Locale.getDefault().getCountry();
    }

    public static Version getCurrentVersion() {
        try {
            URL u = new URL(CURRENT_VERSION);
            InputStream i2 = u.openStream();
            BufferedReader b = new BufferedReader(new InputStreamReader(i2));
            int maj = Integer.valueOf(b.readLine());
            int min = Integer.valueOf(b.readLine());
            int corr = Integer.valueOf(b.readLine());
            return new Version(maj, min, corr);
        }
        catch (NumberFormatException e) {
            SwingIO.warning("ConnectSQL", "getCurrrentVersion", "bad number format", e);
        }
        catch (MalformedURLException e) {
            SwingIO.warning("ConnectSQL", "getCurrrentVersion", "malformed url", e);
        }
        catch (IOException e) {
            SwingIO.warning("ConnectSQL", "getCurrrentVersion", "network error", e);
        }
        return null;
    }

    public static Version getMinimalVersion() {
        try {
            URL u = new URL(TEST_VERSION);
            InputStream i2 = u.openStream();
            BufferedReader b = new BufferedReader(new InputStreamReader(i2));
            int maj = Integer.valueOf(b.readLine());
            int min = Integer.valueOf(b.readLine());
            int corr = Integer.valueOf(b.readLine());
            return new Version(maj, min, corr);
        }
        catch (NumberFormatException e) {
            SwingIO.warning("ConnectSQL", "getMinimalVersion", "bad number format", e);
        }
        catch (MalformedURLException e) {
            SwingIO.warning("ConnectSQL", "getMinimalVersion", "malformed url", e);
        }
        catch (IOException e) {
            SwingIO.warning("ConnectSQL", "getMinimalVersion", "network error", e);
        }
        return null;
    }

    public static boolean isOutOfDateVersion(Version v) {
        Version version = ConnectSQL.getMinimalVersion();
        if (version == null) {
            return false;
        }
        return v.compareTo(version) < 0;
    }

    public boolean registerDisconnectApplet(FrameApp app) {
        boolean registerOK = false;
        RegisterDisconnectApplet t = new RegisterDisconnectApplet(app.getId());
        t.start();
        try {
            t.join();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        registerOK = true;
        return registerOK;
    }

    public boolean registerDuration(FrameApp app) {
        boolean registerOK = false;
        RegisterDuration t = new RegisterDuration(app.getId());
        t.start();
        registerOK = true;
        return registerOK;
    }

    public boolean registerDuration(FrameApp app, String lastCommand) {
        boolean registerOK = false;
        app.setLastAction(lastCommand);
        RegisterDuration t = new RegisterDuration(app.getId(), lastCommand);
        t.start();
        registerOK = true;
        return registerOK;
    }

    public boolean registerNewHulisUser(FrameApp app) {
        boolean registerOK = false;
        RegisterNewUSer t = new RegisterNewUSer(app);
        t.start();
        registerOK = true;
        return registerOK;
    }
}

