/*
 * Decompiled with CFR 0.152.
 */
package sun.plugin.util;

import com.sun.deploy.util.Trace;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.awt.LinearGradientPaint;
import java.awt.MediaTracker;
import java.awt.MultipleGradientPaint;
import java.awt.Paint;
import java.awt.Panel;
import java.awt.RadialGradientPaint;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Toolkit;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.image.BufferedImage;
import java.security.AccessController;
import java.security.PrivilegedAction;
import sun.plugin.util.AnimationPanelBase;
import sun.plugin.util.UIUtil;

public class AnimationPanel
extends AnimationPanelBase
implements Runnable {
    private static boolean DEBUG;
    private static final String IMAGE_EXT = ".png";
    private static final String LOGO_IMAGE = "javalogo";
    private static final String GLOW_IMAGE = "javaglow";
    private static final String JAVACOM_IMAGE = "javacom";
    private static final String DROPTEXT_IMAGE = "droptext";
    private static final int GLOW_CYCLE_TIME = 2000;
    private static final int ZIPPY_PULSE_TIME = 300;
    private static final long[] stateStops;
    private static final Color[] bgColors;
    private static final float[] bgStops;
    private static final boolean isOnJDK6;
    private static final GradientPaint[] bgGrads;
    private static final Color clrBgSolid;
    private static final Color clrProgBg;
    private static final Color clrProgBar;
    private static final Color clrProgGlow1;
    private static final Color clrProgGlow2;
    private static final Color clrCurve1;
    private static final Color clrCurve2;
    private static final Color clrGlowInnerHi;
    private static final Color clrGlowInnerLo;
    private static final Color clrGlowOuterHi;
    private static final Color clrGlowOuterLo;
    private static final float curveWidth = 0.18f;
    private static final float curveY1 = 0.4f;
    private static final float curveY2 = 0.5f;
    private Color[] shadowColors;
    private Paint gradProgGlowL;
    private Paint gradProgGlowR;
    private Paint bgGradient;
    private Shape fullBg;
    private Shape leftBgSolid;
    private Shape leftBgGrad;
    private Shape rightBgSolid;
    private Shape rightBgGrad;
    private Shape thinCurve;
    private BufferedImage leftImage;
    private BufferedImage rightImage;
    private float minGap;
    private float maxGap;
    private float shadowWidth;
    private float innerGlowWidth;
    private float cornerRadius;
    private int logoX;
    private int logoY;
    private int glowX;
    private int glowY;
    private int javaComX;
    private int javaComY;
    private int dropTextX;
    private int dropTextY;
    private int thinCurveX;
    private int progressWidth;
    private int progressHeight;
    private int progressX;
    private int progressY;
    private int progGlowRadius;
    private Image imgLogo;
    private Image imgGlow;
    private Image imgJavaCom;
    private Image imgDropText;
    private boolean preloadedImages = false;
    private Image backbuffer = null;
    private float loadingProgress;
    private float zippyProgress;
    private float zippyStartProgress;
    private long zippyStartTime;
    private int width;
    private int height;
    private long startTime;
    private int currentState = 1;
    private float stateProgress;
    private float pulseProgress;
    private boolean showText;
    private boolean showProgress;
    private boolean fadeAway;
    private boolean paused;
    private boolean preloadedBackground = false;
    private boolean preloadedAll = false;
    public static boolean animationThreadRunning;

    public AnimationPanel() {
        if (DEBUG) {
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent mouseEvent) {
                    AnimationPanel.this.paused = !AnimationPanel.this.paused;
                }
            });
        }
        UIUtil.disableBackgroundErase(this);
    }

    private Shape createFullShape(float f, float f2, float f3, float f4) {
        float f5 = this.cornerRadius;
        GeneralPath generalPath = new GeneralPath();
        generalPath.moveTo(f + f5, f2);
        generalPath.lineTo(f3 - f5, f2);
        generalPath.quadTo(f3, f2, f3, f2 + f5);
        generalPath.lineTo(f3, f4 - f5);
        generalPath.quadTo(f3, f4, f3 - f5, f4);
        generalPath.lineTo(f + f5, f4);
        generalPath.quadTo(f, f4, f, f4 - f5);
        generalPath.lineTo(f, f2 + f5);
        generalPath.quadTo(f, f2, f + f5, f2);
        generalPath.closePath();
        return generalPath;
    }

    private Shape createLeftShape(float f, float f2, float f3, float f4, float f5, float f6) {
        float f7 = 1.0f;
        float f8 = this.cornerRadius;
        float f9 = f5 * 0.18f;
        float f10 = f3 - f9;
        float f11 = f6 * 0.4f;
        float f12 = f3 + f9;
        float f13 = f6 * 0.5f;
        GeneralPath generalPath = new GeneralPath();
        generalPath.moveTo(f + f8, f2);
        generalPath.lineTo(f3 - f7, f2);
        generalPath.quadTo(f3, f2, f3, f2 + f7);
        generalPath.curveTo(f10, f11, f12, f13, f3, f4 - f7);
        generalPath.quadTo(f3, f4, f3 - f7, f4);
        generalPath.lineTo(f + f8, f4);
        generalPath.quadTo(f, f4, f, f4 - f8);
        generalPath.lineTo(f, f2 + f8);
        generalPath.quadTo(f, f2, f + f8, f2);
        generalPath.closePath();
        return generalPath;
    }

    private Shape createRightShape(float f, float f2, float f3, float f4, float f5, float f6) {
        float f7 = 1.0f;
        float f8 = this.cornerRadius;
        float f9 = f5 * 0.18f;
        float f10 = f - f9;
        float f11 = f6 * 0.4f;
        float f12 = f + f9;
        float f13 = f6 * 0.5f;
        GeneralPath generalPath = new GeneralPath();
        generalPath.moveTo(f - f7, f2 + f7);
        generalPath.quadTo(f, f2, f + f7, f2);
        generalPath.lineTo(f3 - f8, f2);
        generalPath.quadTo(f3, f2, f3, f2 + f8);
        generalPath.lineTo(f3, f4 - f8);
        generalPath.quadTo(f3, f4, f3 - f8, f4);
        generalPath.lineTo(f + f7, f4);
        generalPath.quadTo(f, f4, f, f4 - f7);
        generalPath.curveTo(f12, f13, f10, f11, f - f7, f2 + f7);
        generalPath.closePath();
        return generalPath;
    }

    private BufferedImage createTranslucentImage(int n, int n2) {
        GraphicsConfiguration graphicsConfiguration = this.getGraphicsConfiguration();
        if (null == graphicsConfiguration) {
            return null;
        }
        return graphicsConfiguration.createCompatibleImage(n, n2, 3);
    }

    private BufferedImage createGradientShapeImage(Shape shape, int n, int n2) {
        BufferedImage bufferedImage = this.createTranslucentImage(n, n2);
        if (null == bufferedImage) {
            return null;
        }
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        this.renderBorderShadow(graphics2D, shape);
        BufferedImage bufferedImage2 = this.createTranslucentImage(n, n2);
        if (null == bufferedImage2) {
            if (null != graphics2D) {
                graphics2D.dispose();
            }
            return null;
        }
        Graphics2D graphics2D2 = bufferedImage2.createGraphics();
        graphics2D2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D2.setComposite(AlphaComposite.Clear);
        graphics2D2.fillRect(0, 0, n, n2);
        graphics2D2.setComposite(AlphaComposite.SrcOver);
        this.renderGradientShape(graphics2D2, shape, n, n2);
        this.renderBorderGlow(graphics2D2, shape, n2);
        graphics2D2.dispose();
        graphics2D.drawImage((Image)bufferedImage2, 0, 0, null);
        graphics2D.dispose();
        return bufferedImage;
    }

    private void initMultiStopGradient(int n) {
        if (isOnJDK6) {
            this.bgGradient = new LinearGradientPaint(0.0f, 0.0f, 0.0f, n, bgStops, bgColors);
        } else {
            for (int j = 0; j < bgGrads.length; ++j) {
                float f = bgStops[j] * (float)n;
                float f2 = bgStops[j + 1] * (float)n;
                AnimationPanel.bgGrads[j] = new GradientPaint(0.0f, bgStops[j] * (float)n, bgColors[j], 0.0f, bgStops[j + 1] * (float)n, bgColors[j + 1]);
            }
        }
    }

    private void initBackground(int n, int n2) {
        if (this.preloadedBackground) {
            return;
        }
        this.initMultiStopGradient(n2);
        float f = this.shadowWidth;
        this.thinCurveX = (int)((float)n * 0.27f);
        float f2 = f * 2.0f + this.minGap;
        float f3 = f + f2;
        float f4 = f;
        float f5 = (float)n - f;
        float f6 = (float)n2 - f;
        this.fullBg = this.createFullShape(f3, f4, f5, f6);
        f3 = f;
        f4 = f;
        f5 = (float)this.thinCurveX - this.minGap / 2.0f - f;
        f6 = (float)n2 - f;
        this.leftBgSolid = this.createLeftShape(f3, f4, f5, f6, n, n2);
        float f7 = (float)this.thinCurveX - f * 2.0f - this.minGap / 2.0f;
        int n3 = (int)(f7 + f7 * 0.8f);
        int n4 = n2;
        this.leftBgGrad = this.createLeftShape(f3, f4, f5, f6, n, n2);
        this.leftImage = this.createGradientShapeImage(this.leftBgGrad, n3, n4);
        if (null == this.leftImage) {
            return;
        }
        f3 = (float)this.thinCurveX + this.minGap / 2.0f + f;
        f5 = (float)n - f;
        this.rightBgSolid = this.createRightShape(f3, f4, f5, f6, n, n2);
        f7 = (float)(n - this.thinCurveX) - f * 2.0f - this.minGap / 2.0f;
        if (!this.showText) {
            f7 -= 1.0f;
        }
        n3 = (int)(f7 + f7 * 0.3f);
        n4 = n2;
        f5 = (float)n3 - f;
        f3 = f5 - f7;
        this.rightBgGrad = this.createRightShape(f3, f4, f5, f6, n, n2);
        this.rightImage = this.createGradientShapeImage(this.rightBgGrad, n3, n4);
        if (null == this.rightImage) {
            return;
        }
        float f8 = (float)n * 0.18f;
        float f9 = (float)n2 * 0.4f;
        float f10 = (float)n2 * 0.5f;
        GeneralPath generalPath = new GeneralPath();
        generalPath.moveTo(0.0f, f4);
        generalPath.curveTo(-f8, f9, f8, f10, 0.0f, f6 - 1.0f);
        this.thinCurve = generalPath;
        this.preloadedBackground = true;
    }

    private Image loadImage(String string, String string2) {
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        String string3 = string + string2 + IMAGE_EXT;
        return toolkit.createImage(this.getClass().getResource(string3));
    }

    private static Color[] createShadowColors(int[] nArray) {
        Color[] colorArray = new Color[nArray.length];
        for (int j = 0; j < nArray.length; ++j) {
            int n = nArray[j];
            colorArray[j] = new Color(n, n, n);
        }
        return colorArray;
    }

    private void initImages(int n, int n2) {
        if (this.preloadedImages) {
            return;
        }
        String string = n < 100 ? "25" : (n < 170 ? "100" : (n < 300 ? "170" : "300"));
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        MediaTracker mediaTracker = new MediaTracker(this);
        this.imgLogo = this.loadImage(LOGO_IMAGE, string);
        mediaTracker.addImage(this.imgLogo, 0);
        this.imgGlow = this.loadImage(GLOW_IMAGE, string);
        mediaTracker.addImage(this.imgGlow, 1);
        if (this.showText) {
            this.imgJavaCom = this.loadImage(JAVACOM_IMAGE, string);
            mediaTracker.addImage(this.imgJavaCom, 2);
            this.imgDropText = this.loadImage(DROPTEXT_IMAGE, string);
            mediaTracker.addImage(this.imgDropText, 3);
        }
        try {
            mediaTracker.waitForAll();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        int n3 = (int)((double)n * 0.66);
        int n4 = this.showProgress ? (int)((double)n2 * 0.46) : (int)((double)n2 * 0.5);
        this.logoX = n3 - this.imgLogo.getWidth(null) / 2;
        this.logoY = n4 - this.imgLogo.getHeight(null) / 2;
        this.glowX = n3 - this.imgGlow.getWidth(null) / 2;
        this.glowY = n4 - this.imgGlow.getHeight(null) / 2;
        n4 = n2 / 2;
        if (n < 100) {
            this.progressWidth = 10;
            this.progressHeight = 1;
            this.progressY = this.logoY + this.imgLogo.getHeight(null) + 1;
            this.dropTextY = 0;
            this.shadowWidth = 0.0f;
            this.shadowColors = null;
            this.innerGlowWidth = 0.0f;
            this.cornerRadius = 3.0f;
            this.minGap = 1.0f;
            this.maxGap = 1.0f;
        } else if (n < 170) {
            this.progressWidth = 37;
            this.progressHeight = 1;
            this.progressY = n4 + 36;
            this.dropTextY = 5;
            this.shadowWidth = 2.0f;
            this.shadowColors = AnimationPanel.createShadowColors(new int[]{196, 255});
            this.innerGlowWidth = 3.0f;
            this.cornerRadius = 4.0f;
            this.minGap = 2.0f;
            this.maxGap = this.shadowWidth * 3.0f;
        } else if (n < 300) {
            this.progressWidth = 58;
            this.progressHeight = 2;
            this.progressY = n4 + 55;
            this.dropTextY = 7;
            this.shadowWidth = 3.0f;
            this.shadowColors = AnimationPanel.createShadowColors(new int[]{196, 237, 255});
            this.innerGlowWidth = 4.0f;
            this.cornerRadius = 5.0f;
            this.minGap = 2.0f;
            this.maxGap = this.shadowWidth * 3.0f;
        } else {
            this.progressWidth = 83;
            this.progressHeight = 2;
            this.progressY = n4 + 78;
            this.dropTextY = 10;
            this.shadowWidth = 5.0f;
            this.shadowColors = AnimationPanel.createShadowColors(new int[]{196, 224, 237, 246, 255});
            this.innerGlowWidth = 5.0f;
            this.cornerRadius = 6.0f;
            this.minGap = 1.0f;
            this.maxGap = this.shadowWidth * 3.0f;
        }
        this.progressX = n3 - this.progressWidth / 2;
        if (isOnJDK6) {
            this.progGlowRadius = this.progressHeight * 3;
            float[] fArray = new float[]{0.0f, 1.0f};
            Color[] colorArray = new Color[]{clrProgGlow1, clrProgGlow2};
            float f = this.progGlowRadius;
            float f2 = this.progressX + 1;
            float f3 = (float)this.progressY + (float)this.progressHeight / 2.0f;
            this.gradProgGlowR = new RadialGradientPaint(f2 + 0.5f, f3 - 0.5f, f, fArray, colorArray);
            this.gradProgGlowL = new LinearGradientPaint(f2, f3 - f * 2.0f - 0.5f, f2, f3 - f - 0.5f, fArray, colorArray, MultipleGradientPaint.CycleMethod.REFLECT);
        }
        if (this.showText) {
            int n5 = this.imgJavaCom.getHeight(null);
            int n6 = n < 170 ? 2 : 0;
            this.javaComX = this.logoX - n6;
            this.javaComY = this.logoY + this.imgLogo.getHeight(null) - n5;
            this.dropTextX = this.javaComX - this.imgDropText.getWidth(null) + n6;
            this.dropTextY = this.javaComY + n5 - this.dropTextY - this.imgDropText.getHeight(null);
        }
        this.preloadedImages = true;
    }

    public void preloadResources(int n, int n2) {
        if (null == this.backbuffer || n != this.width || n2 != this.height || !this.preloadedAll) {
            this.preloadedImages = false;
            this.preloadedBackground = false;
            this.preloadedAll = false;
        }
        if (this.preloadedAll) {
            return;
        }
        int n3 = AnimationPanel.getBoxSize(n, n2);
        this.backbuffer = this.createImage(n, n2);
        this.showText = n3 >= 100;
        this.showProgress = n3 >= 100;
        this.initImages(n3, n3);
        if (!this.preloadedImages) {
            return;
        }
        this.initBackground(n3, n3);
        if (!this.preloadedBackground) {
            return;
        }
        this.width = n;
        this.height = n2;
        this.preloadedAll = true;
    }

    private static int getBoxSize(int n, int n2) {
        int n3;
        int n4 = n3 = n > n2 ? n2 : n;
        if (n3 < 25) {
            return 0;
        }
        if (n3 < 100) {
            return 25;
        }
        if (n3 < 170) {
            return 100;
        }
        if (n3 < 300) {
            return 170;
        }
        return 300;
    }

    private static Rectangle getBoxBounds(int n, int n2) {
        int n3;
        int n4;
        int n5 = AnimationPanel.getBoxSize(n, n2);
        if (n < 600 && n2 < 600) {
            n4 = n / 2 - n5 / 2;
            n3 = n2 / 2 - n5 / 2;
        } else {
            n4 = 0;
            n3 = 0;
        }
        return new Rectangle(n4, n3, n5, n5);
    }

    public void doPaint(Graphics graphics) {
        int n;
        int n2 = this.getWidth();
        int n3 = AnimationPanel.getBoxSize(n2, n = this.getHeight());
        if (n3 <= 0) {
            return;
        }
        this.preloadResources(n2, n);
        if (!this.preloadedAll) {
            return;
        }
        Graphics2D graphics2D = (Graphics2D)this.backbuffer.getGraphics();
        graphics2D.setColor(Color.WHITE);
        graphics2D.fillRect(0, 0, n2, n);
        n2 = n = n3;
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        switch (this.currentState) {
            case 1: {
                this.renderState1(graphics2D, n2, n);
                break;
            }
            case 2: {
                this.renderState2(graphics2D, n2, n);
                break;
            }
            case 3: {
                this.renderState3(graphics2D, n2, n);
                break;
            }
            case 4: {
                this.renderState4(graphics2D, n2, n);
                break;
            }
            case 5: {
                this.renderState5(graphics2D, n2, n);
                break;
            }
            case 6: {
                this.renderState6(graphics2D, n2, n);
                break;
            }
            case 7: {
                this.renderState7(graphics2D, n2, n);
                break;
            }
        }
        graphics2D.dispose();
        graphics.drawImage(this.backbuffer, 0, 0, null);
    }

    private void renderState1(Graphics2D graphics2D, int n, int n2) {
        Composite composite = graphics2D.getComposite();
        graphics2D.setComposite(AlphaComposite.getInstance(3, this.stateProgress));
        this.renderSolidBackground(graphics2D);
        this.renderLogo(graphics2D);
        graphics2D.setComposite(composite);
    }

    private void renderState2(Graphics2D graphics2D, int n, int n2) {
        this.renderSolidBackground(graphics2D);
        this.renderLogo(graphics2D);
        if (this.stateProgress <= 0.5f) {
            float f = this.stateProgress / 0.5f;
            this.renderAnimCurve(graphics2D, this.thinCurveX, n2, f);
        } else {
            float f = (1.0f - this.stateProgress) / 0.5f;
            Composite composite = graphics2D.getComposite();
            graphics2D.setComposite(AlphaComposite.getInstance(3, f));
            graphics2D.setColor(clrCurve1);
            this.renderCurve(graphics2D, this.thinCurveX);
            graphics2D.setComposite(composite);
        }
    }

    private void renderState3(Graphics2D graphics2D, int n, int n2) {
        this.renderSplitBackground(graphics2D, n, n2, this.stateProgress, true);
        Composite composite = graphics2D.getComposite();
        graphics2D.setComposite(AlphaComposite.getInstance(3, 1.0f - this.stateProgress));
        this.renderSplitBackground(graphics2D, n, n2, this.stateProgress, false);
        graphics2D.setComposite(composite);
        this.renderLogo(graphics2D);
        graphics2D.setComposite(AlphaComposite.getInstance(3, this.getFlashAlpha()));
        graphics2D.setColor(Color.white);
        graphics2D.fillRect(-50, 0, n + 50, n2);
        graphics2D.setComposite(composite);
    }

    private void renderState4(Graphics2D graphics2D, int n, int n2) {
        this.renderSplitBackground(graphics2D, n, n2, 1.0f, true);
        this.renderLogo(graphics2D);
        Composite composite = graphics2D.getComposite();
        graphics2D.setComposite(AlphaComposite.getInstance(3, this.getPulseAlpha()));
        this.renderGlow(graphics2D);
        graphics2D.setComposite(composite);
        if (this.showProgress) {
            this.renderProgress(graphics2D);
        }
    }

    private void renderState5(Graphics2D graphics2D, int n, int n2) {
        Composite composite = graphics2D.getComposite();
        graphics2D.setComposite(AlphaComposite.getInstance(3, 1.0f - this.stateProgress));
        this.renderSplitBackground(graphics2D, n, n2, 1.0f, true);
        this.renderLogo(graphics2D);
        float f = this.getPulseAlpha() * (1.0f - this.stateProgress);
        graphics2D.setComposite(AlphaComposite.getInstance(3, f));
        this.renderGlow(graphics2D);
        if (this.showText) {
            graphics2D.setComposite(AlphaComposite.getInstance(3, this.stateProgress));
            this.renderVisitUsText(graphics2D);
            this.renderJavaText(graphics2D);
        }
        graphics2D.setComposite(composite);
    }

    private void renderState6(Graphics2D graphics2D, int n, int n2) {
        this.renderVisitUsText(graphics2D);
        this.renderJavaText(graphics2D);
    }

    private void renderState7(Graphics2D graphics2D, int n, int n2) {
        Composite composite = graphics2D.getComposite();
        graphics2D.setComposite(AlphaComposite.getInstance(3, 1.0f - this.stateProgress));
        this.renderVisitUsText(graphics2D);
        this.renderJavaText(graphics2D);
        graphics2D.setComposite(composite);
    }

    private void renderSolidShape(Graphics2D graphics2D, Shape shape) {
        graphics2D.setColor(clrBgSolid);
        graphics2D.fill(shape);
    }

    private void renderSolidBackground(Graphics2D graphics2D) {
        this.renderSolidShape(graphics2D, this.fullBg);
    }

    private void renderGradientShape(Graphics2D graphics2D, Shape shape, int n, int n2) {
        if (isOnJDK6) {
            graphics2D.setPaint(this.bgGradient);
            graphics2D.fill(shape);
        } else {
            Shape shape2 = graphics2D.getClip();
            for (int j = 0; j < bgGrads.length; ++j) {
                int n3 = (int)(bgStops[j] * (float)n2);
                int n4 = (int)(bgStops[j + 1] * (float)n2);
                graphics2D.setPaint(bgGrads[j]);
                graphics2D.clipRect(0, n3, n, n4 - n3 + 1);
                if (n2 > 25) {
                    // empty if block
                }
                graphics2D.fill(shape);
                graphics2D.setClip(shape2);
            }
        }
    }

    private void renderGradientBackground(Graphics2D graphics2D, int n, int n2) {
        this.renderGradientShape(graphics2D, this.fullBg, n, n2);
    }

    private void renderSplitBackground(Graphics2D graphics2D, int n, int n2, float f, boolean bl) {
        float f2 = f <= 0.6f ? this.shadowWidth * 2.0f + -this.maxGap * (f / 0.6f) : -this.shadowWidth + this.shadowWidth * ((f - 0.6f) / 0.4f);
        AffineTransform affineTransform = graphics2D.getTransform();
        graphics2D.translate(f2, 0.0);
        if (bl) {
            graphics2D.drawImage((Image)this.leftImage, 0, 0, null);
        } else {
            this.renderSolidShape(graphics2D, this.leftBgSolid);
        }
        graphics2D.setTransform(affineTransform);
        if (bl) {
            graphics2D.drawImage((Image)this.rightImage, n - this.rightImage.getWidth(), 0, null);
        } else {
            this.renderSolidShape(graphics2D, this.rightBgSolid);
        }
    }

    private Color getMixedColor(Color color, float f, Color color2, float f2) {
        float[] fArray = color.getComponents(null);
        float[] fArray2 = color2.getComponents(null);
        for (int j = 0; j < fArray.length; ++j) {
            fArray[j] = fArray[j] * f + fArray2[j] * f2;
        }
        return new Color(fArray[0], fArray[1], fArray[2], fArray[3]);
    }

    private void renderBorderShadow(Graphics2D graphics2D, Shape shape) {
        if (this.shadowColors == null) {
            return;
        }
        for (int j = this.shadowColors.length; j >= 1; --j) {
            Color color = this.shadowColors[j - 1];
            graphics2D.setStroke(new BasicStroke((float)j * 2.0f));
            graphics2D.setColor(color);
            graphics2D.draw(shape);
        }
    }

    private void renderBorderGlow(Graphics2D graphics2D, Shape shape, int n) {
        graphics2D = (Graphics2D)graphics2D.create();
        int n2 = (int)(this.innerGlowWidth * 2.0f);
        if (n2 == 0) {
            Color color = new Color(-152995);
            Color color2 = new Color(-232948);
            if (shape == this.leftBgGrad) {
                graphics2D.setColor(color);
                graphics2D.fillRect(2, 0, 3, 1);
                graphics2D.fillRect(1, 1, 1, 1);
                graphics2D.setPaint(new GradientPaint(0.0f, 0.0f, color, 0.0f, n, color2));
                graphics2D.fillRect(0, 2, 1, n - 4);
                graphics2D.setColor(color2);
                graphics2D.fillRect(1, n - 2, 1, 1);
                graphics2D.fillRect(2, n - 1, 3, 1);
            } else {
                graphics2D.setColor(color);
                graphics2D.fillRect(4, 0, 16, 1);
                graphics2D.fillRect(20, 1, 1, 1);
                graphics2D.setPaint(new GradientPaint(0.0f, 0.0f, color, 0.0f, n, color2));
                graphics2D.fillRect(21, 2, 1, n - 4);
                graphics2D.setColor(color2);
                graphics2D.fillRect(20, n - 2, 1, 1);
                graphics2D.fillRect(4, n - 1, 16, 1);
            }
            return;
        }
        for (int j = n2; j >= 2; j -= 2) {
            float f = (float)(n2 - j) / (float)(n2 - 1);
            Color color = this.getMixedColor(clrGlowInnerHi, f, clrGlowOuterHi, 1.0f - f);
            Color color3 = this.getMixedColor(clrGlowInnerLo, f, clrGlowOuterLo, 1.0f - f);
            graphics2D.setPaint(new GradientPaint(0.0f, (float)n * 0.5f, color, 0.0f, n - n2, color3));
            graphics2D.setComposite(AlphaComposite.getInstance(10, f));
            graphics2D.setStroke(new BasicStroke(j));
            graphics2D.draw(shape);
        }
        graphics2D.dispose();
    }

    private void renderLogo(Graphics2D graphics2D) {
        graphics2D.drawImage(this.imgLogo, this.logoX, this.logoY, null);
    }

    private void renderGlow(Graphics2D graphics2D) {
        graphics2D.drawImage(this.imgGlow, this.glowX, this.glowY, null);
    }

    private void renderJavaText(Graphics2D graphics2D) {
        graphics2D.drawImage(this.imgJavaCom, this.javaComX, this.javaComY, null);
    }

    private void renderVisitUsText(Graphics2D graphics2D) {
        graphics2D.drawImage(this.imgDropText, this.dropTextX, this.dropTextY, null);
    }

    private void renderProgress(Graphics2D graphics2D) {
        graphics2D.setColor(clrProgBg);
        graphics2D.fillRect(this.progressX, this.progressY, this.progressWidth, this.progressHeight);
        int n = (int)((float)this.progressWidth * this.zippyProgress);
        if (isOnJDK6) {
            AffineTransform affineTransform = graphics2D.getTransform();
            int n2 = this.progGlowRadius;
            int n3 = this.progressX;
            int n4 = this.progressY + 1 - n2;
            int n5 = n;
            int n6 = n2 * 2;
            graphics2D.setPaint(this.gradProgGlowR);
            graphics2D.fillRect(n3 + 1 - n2, n4, n2, n6);
            graphics2D.setPaint(this.gradProgGlowL);
            graphics2D.fillRect(n3 + 1, n4, n5 - 2, n6);
            graphics2D.translate(n5 - 3, 0);
            graphics2D.setPaint(this.gradProgGlowR);
            graphics2D.fillRect(n3 + 2, n4, n2, n6);
            graphics2D.setTransform(affineTransform);
        }
        graphics2D.setColor(clrProgBar);
        graphics2D.fillRect(this.progressX, this.progressY, n, this.progressHeight);
    }

    private void renderAnimCurve(Graphics2D graphics2D, int n, int n2, float f) {
        Shape shape = graphics2D.getClip();
        graphics2D.clipRect(n - 50, 0, 100, (int)((float)n2 * f));
        graphics2D.setPaint(new GradientPaint(0.0f, (float)n2 * f * 0.8f, clrCurve1, 0.0f, (float)n2 * f, clrCurve2));
        this.renderCurve(graphics2D, n);
        graphics2D.setClip(shape);
    }

    private void renderCurve(Graphics2D graphics2D, int n) {
        graphics2D.translate(n, 0);
        graphics2D.draw(this.thinCurve);
        graphics2D.translate(-n, 0);
    }

    private float getFlashAlpha() {
        return this.stateProgress <= 0.5f ? this.stateProgress / 0.5f * 0.3f : (1.0f - this.stateProgress) / 0.5f * 0.3f;
    }

    private float getPulseAlpha() {
        return this.pulseProgress <= 0.5f ? this.pulseProgress / 0.5f : (1.0f - this.pulseProgress) / 0.5f;
    }

    @Override
    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    @Override
    public void paint(Graphics graphics) {
        if (DEBUG || !animationThreadRunning) {
            try {
                this.doPaint(graphics);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void startAnimation() {
        AnimationPanel animationPanel = this;
        synchronized (animationPanel) {
            if (animationThreadRunning) {
                return;
            }
            animationThreadRunning = true;
        }
        new Thread(this).start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stopAnimation() {
        AnimationPanel animationPanel = this;
        synchronized (animationPanel) {
            animationThreadRunning = false;
        }
    }

    @Override
    public float getProgressValue() {
        return this.loadingProgress;
    }

    @Override
    public void setProgressValue(float f) {
        this.zippyStartTime = 0L;
        this.zippyStartProgress = this.zippyProgress;
        this.loadingProgress = f;
    }

    @Override
    public void fadeAway() {
        if (this.currentState == 4 && !this.fadeAway) {
            this.setProgressValue(1.0f);
            this.fadeAway = true;
        }
    }

    private static float convertToNonLinear(float f, float f2, float f3) {
        float f4 = 1.0f / (1.0f - f2 / 2.0f - f3 / 2.0f);
        if (f < f2) {
            float f5 = f4 * (f / f2) / 2.0f;
            f *= f5;
        } else if (f > 1.0f - f3) {
            float f6 = f - (1.0f - f3);
            float f7 = f6 / f3;
            f = f4 * (1.0f - f2 / 2.0f - f3 + f6 * (2.0f - f7) / 2.0f);
        } else {
            f = f4 * (f - f2 / 2.0f);
        }
        return f;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (true) {
            try {
                Thread.sleep(20L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            AnimationPanel animationPanel = this;
            synchronized (animationPanel) {
                if (!animationThreadRunning) {
                    break;
                }
            }
            if (this.startTime == 0L) {
                this.startTime = System.currentTimeMillis();
            }
            long l = System.currentTimeMillis();
            if (DEBUG && this.paused) {
                this.startTime = l - (long)(this.stateProgress * (float)stateStops[this.currentState]);
                continue;
            }
            if (this.isShowing()) {
                try {
                    this.doPaint(this.getGraphics());
                }
                catch (RuntimeException runtimeException) {
                    Trace.ignoredException((Exception)runtimeException);
                }
            }
            long l2 = l - this.startTime;
            if (this.currentState < stateStops.length) {
                if (l2 >= stateStops[this.currentState]) {
                    this.startTime = l;
                    this.stateProgress = 0.0f;
                    l2 = 0L;
                    ++this.currentState;
                } else {
                    this.stateProgress = (float)l2 / (float)stateStops[this.currentState];
                }
            }
            if (this.currentState == 4) {
                long l3;
                this.pulseProgress = (float)(l2 % 2000L) / 2000.0f;
                if (this.zippyStartTime == 0L) {
                    this.zippyStartTime = l;
                }
                if ((l3 = l - this.zippyStartTime) > 300L) {
                    this.zippyProgress = this.loadingProgress;
                } else {
                    float f = (float)l3 / 300.0f;
                    f = AnimationPanel.convertToNonLinear(f, 0.5f, 0.1f);
                    this.zippyProgress = this.zippyStartProgress + (this.loadingProgress - this.zippyStartProgress) * f;
                }
                if (!this.fadeAway || !(this.zippyProgress >= 1.0f)) continue;
                this.fadeAway = false;
                this.zippyProgress = 1.0f;
                this.loadingProgress = 1.0f;
                this.startTime = l;
                ++this.currentState;
                continue;
            }
            if (!DEBUG || (this.showText || this.currentState <= 5) && this.currentState <= 8) continue;
            this.loadingProgress = 0.0f;
            this.zippyStartProgress = 0.0f;
            this.zippyProgress = 0.0f;
            this.zippyStartTime = 0L;
            this.startTime = l;
            this.currentState = 1;
        }
    }

    public static void main(String[] stringArray) {
        DEBUG = true;
        final AnimationPanel animationPanel = new AnimationPanel();
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    animationPanel.setPreferredSize(new Dimension(400, 300));
                }
                catch (NoSuchMethodError noSuchMethodError) {
                    animationPanel.setSize(new Dimension(400, 300));
                }
                Frame frame = new Frame("Java Plugin Animation - 2006 Prototype");
                frame.addWindowListener(new WindowAdapter(){

                    @Override
                    public void windowClosing(WindowEvent windowEvent) {
                        System.exit(0);
                    }
                });
                frame.add(new Wrapper(animationPanel));
                frame.pack();
                frame.setLocationRelativeTo(null);
                frame.setVisible(true);
                animationPanel.preloadResources(400, 300);
                animationPanel.startAnimation();
            }
        });
        while (true) {
            try {
                Thread.sleep(1200L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            float f = animationPanel.getProgressValue();
            f += 0.15f;
            if (f >= 0.9f) {
                animationPanel.fadeAway();
                try {
                    Thread.sleep(3000L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                f = 0.0f;
            }
            animationPanel.setProgressValue(f);
        }
    }

    static {
        stateStops = new long[]{0L, 300L, 500L, 400L, 99999999L, 750L, 950L, 300L, 1000L};
        bgColors = new Color[]{new Color(255, 229, 203), new Color(247, 171, 103), new Color(255, 124, 15), new Color(255, 117, 0), new Color(255, 144, 0), new Color(255, 165, 0)};
        bgStops = new float[]{0.0f, 0.15f, 0.39f, 0.6f, 0.83f, 1.0f};
        String string = (String)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return System.getProperty("java.version");
            }
        });
        isOnJDK6 = string.compareTo("1.6") >= 0;
        bgGrads = new GradientPaint[bgStops.length - 1];
        clrBgSolid = new Color(231, 111, 0);
        clrProgBg = new Color(231, 111, 0);
        clrProgBar = Color.WHITE;
        clrProgGlow1 = new Color(1.0f, 1.0f, 1.0f, 0.5f);
        clrProgGlow2 = new Color(1.0f, 1.0f, 0.8f, 0.0f);
        clrCurve1 = new Color(201, 104, 0);
        clrCurve2 = Color.LIGHT_GRAY;
        clrGlowInnerHi = new Color(253, 239, 175, 48);
        clrGlowInnerLo = new Color(255, 209, 0);
        clrGlowOuterHi = new Color(253, 239, 175, 24);
        clrGlowOuterLo = new Color(255, 179, 0);
        animationThreadRunning = false;
    }

    static class Wrapper
    extends Panel {
        private AnimationPanel anim;

        Wrapper(AnimationPanel animationPanel) {
            this.anim = animationPanel;
            this.setLayout(null);
            this.setBackground(Color.WHITE);
            this.setSize(animationPanel.getPreferredSize());
            this.add(animationPanel);
            this.layoutAnimationPanel();
            this.addComponentListener(new ComponentAdapter(){

                @Override
                public void componentResized(ComponentEvent componentEvent) {
                    Wrapper.this.layoutAnimationPanel();
                }
            });
        }

        private void layoutAnimationPanel() {
            this.anim.setBounds(AnimationPanel.getBoxBounds(this.getWidth(), this.getHeight()));
        }
    }
}

