/*
 * Decompiled with CFR 0.152.
 */
package sun.plugin.util;

import com.sun.deploy.util.Trace;
import com.sun.deploy.util.URLUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Toolkit;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.StringTokenizer;
import sun.net.ProgressEvent;
import sun.net.ProgressListener;
import sun.plugin.util.ErrorDelegate;
import sun.plugin.util.GrayBoxPanel;
import sun.plugin.util.ProgressMonitor;

public class GrayBoxPainter {
    private Color boxBGColor = Color.white;
    private Color boxFGColor = Color.black;
    private boolean boxBorder = true;
    private String waitingMessage = null;
    private Image customImage;
    private URL customImageURL;
    private boolean customImageIsCentered;
    private URL codebaseURL;
    private URL[] jarURLs = new URL[0];
    private HashMap downloadInProgressMap = new HashMap();
    private boolean progressBarEnabled = true;
    private boolean usingProgressListener = true;
    private Container container;
    private ThreadGroup threadGroup;
    private MediaTracker tracker;
    private boolean appletErrorOccurred = false;
    private boolean animationReady = false;
    private boolean progressBarReady = false;
    private volatile boolean paintingSuspended = false;
    private volatile boolean paintingFinished = false;
    private GrayBoxPanel m_grayboxPanel = null;
    private ErrorDelegate errorDelegate;
    private int currentProgress = 0;
    private int maximumProgress = 10000;
    private int numJarTotal = 0;
    private int numberOfJarLoaded = 0;
    private ArrayList progressSourceFilterList = new ArrayList();
    private Object progressListener;

    public GrayBoxPainter(Container container) {
        this.container = container;
    }

    public synchronized void beginPainting(ThreadGroup threadGroup) {
        this.threadGroup = threadGroup;
        this.tracker = new MediaTracker(this.container);
        this.loadCustomImage();
        if (this.usingProgressListener) {
            this.installProgressListener();
        }
        final GrayBoxPainter grayBoxPainter = this;
        this.paintingSuspended = false;
        new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    Thread.sleep(1500L);
                }
                catch (Throwable throwable) {
                }
                finally {
                    grayBoxPainter.setAnimationReady();
                    grayBoxPainter.setProgressBarReady();
                    if (!GrayBoxPainter.this.paintingSuspended && !GrayBoxPainter.this.paintingFinished) {
                        grayBoxPainter.repaintGrayBox();
                    }
                }
            }
        }).start();
    }

    public synchronized void finishPainting() {
        try {
            if (this.m_grayboxPanel != null) {
                this.m_grayboxPanel.stop();
                this.container.remove(this.m_grayboxPanel);
                this.m_grayboxPanel = null;
            }
            this.removeProgressListener();
            this.paintingSuspended = false;
            this.paintingFinished = true;
        }
        catch (RuntimeException runtimeException) {
            Trace.ignoredException((Exception)runtimeException);
        }
    }

    public void showLoadingError() {
        this.appletErrorOccurred = true;
        this.repaintGrayBox();
    }

    private void loadCustomImage() {
        if (this.customImageURL != null) {
            try {
                this.customImage = Toolkit.getDefaultToolkit().getImage(this.customImageURL);
                this.tracker.addImage(this.customImage, 1);
                this.tracker.waitForID(1);
                this.setAnimationReady();
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
            catch (RuntimeException runtimeException) {
                Trace.ignoredException((Exception)runtimeException);
            }
        }
    }

    public void setUsingProgressListener(boolean bl) {
        this.usingProgressListener = bl;
    }

    public void setProgressFilter(URL uRL, String string) {
        this.codebaseURL = uRL;
        if (string != null) {
            Object object;
            ArrayList<Object> arrayList = new ArrayList<Object>();
            URL[] uRLArray = new URL[]{};
            StringTokenizer stringTokenizer = new StringTokenizer(string, ",", false);
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken().trim();
                try {
                    object = new URL(uRL, string2);
                    if (!URLUtil.checkTargetURL((URL)uRL, (URL)object)) {
                        throw new SecurityException("Permission denied: " + object);
                    }
                    arrayList.add(object);
                }
                catch (MalformedURLException malformedURLException) {
                    malformedURLException.printStackTrace();
                }
            }
            uRLArray = new URL[arrayList.size()];
            int n = 0;
            object = arrayList.iterator();
            while (object.hasNext()) {
                uRLArray[n] = (URL)object.next();
                ++n;
            }
            this.jarURLs = uRLArray;
            this.numJarTotal = uRLArray.length;
        }
    }

    public void setCustomImageURL(URL uRL, boolean bl) {
        this.progressBarEnabled = false;
        this.customImageURL = uRL;
        this.customImageIsCentered = bl;
    }

    public void setProgress(float f) {
        this.currentProgress = (int)(f * (float)this.maximumProgress);
        GrayBoxPanel grayBoxPanel = this.m_grayboxPanel;
        this.repaintGrayBox();
    }

    public void setBoxBGColor(Color color) {
        try {
            this.boxBGColor = color;
            if (this.m_grayboxPanel != null) {
                this.m_grayboxPanel.setBgColor(color);
            }
        }
        catch (RuntimeException runtimeException) {
            Trace.ignoredException((Exception)runtimeException);
        }
    }

    public Color getBoxBGColor() {
        return this.boxBGColor;
    }

    public void setBoxFGColor(Color color) {
        try {
            this.boxFGColor = color;
            if (this.m_grayboxPanel != null) {
                this.m_grayboxPanel.setFgColor(color);
            }
        }
        catch (RuntimeException runtimeException) {
            Trace.ignoredException((Exception)runtimeException);
        }
    }

    public Color getBoxFGColor() {
        return this.boxFGColor;
    }

    public void setBoxBorder(String string) {
        this.boxBorder = string == null ? true : Boolean.valueOf(string);
        if (this.m_grayboxPanel != null) {
            this.m_grayboxPanel.setBoxBorder(this.boxBorder);
        }
    }

    public void setWaitingMessage(String string) {
        this.waitingMessage = string;
    }

    public synchronized void suspendPainting() {
        try {
            if (!this.paintingSuspended) {
                if (this.m_grayboxPanel != null) {
                    this.m_grayboxPanel.stop();
                    this.container.remove(this.m_grayboxPanel);
                }
                this.paintingSuspended = true;
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        GrayBoxPainter.this.container.validate();
                    }
                });
            }
        }
        catch (RuntimeException runtimeException) {
            Trace.ignoredException((Exception)runtimeException);
        }
    }

    public synchronized void resumePainting() {
        try {
            if (this.paintingSuspended) {
                if (this.m_grayboxPanel != null) {
                    this.m_grayboxPanel.start();
                    this.container.add((Component)this.m_grayboxPanel, "Center");
                }
                this.paintingSuspended = false;
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        GrayBoxPainter.this.container.validate();
                    }
                });
            }
        }
        catch (RuntimeException runtimeException) {
            Trace.ignoredException((Exception)runtimeException);
        }
    }

    public void setAnimationReady() {
        this.animationReady = true;
    }

    public void setProgressBarReady() {
        this.progressBarReady = true;
    }

    private void repaintGrayBox() {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    GrayBoxPainter.this.paintGrayBox(GrayBoxPainter.this.container, GrayBoxPainter.this.container.getGraphics());
                }
                catch (RuntimeException runtimeException) {
                    Trace.ignoredException((Exception)runtimeException);
                }
            }
        });
    }

    private synchronized GrayBoxPanel getGrayBoxPanel() {
        if (this.m_grayboxPanel == null) {
            this.m_grayboxPanel = new GrayBoxPanel(this.container, this.boxBGColor, this.boxFGColor, this.errorDelegate);
            if (!this.paintingSuspended) {
                this.container.add((Component)this.m_grayboxPanel, "Center");
                if (!this.appletErrorOccurred) {
                    this.m_grayboxPanel.setBoxBorder(this.boxBorder);
                    if (this.customImage == null) {
                        this.m_grayboxPanel.setMaxProgressValue(this.maximumProgress);
                        this.m_grayboxPanel.start();
                    } else {
                        this.m_grayboxPanel.setCustomImage(this.customImage, this.customImageIsCentered);
                    }
                } else {
                    this.m_grayboxPanel.setError();
                }
                this.container.validate();
            }
        }
        return this.m_grayboxPanel;
    }

    public synchronized void paintGrayBox(Container container, Graphics graphics) {
        try {
            if (this.paintingSuspended || this.paintingFinished || graphics == null) {
                return;
            }
            Dimension dimension = this.container.getSize();
            if (!this.animationReady && !this.appletErrorOccurred) {
                if (dimension.width > 0 && dimension.height > 0) {
                    graphics.setColor(Color.white);
                    graphics.fillRect(0, 0, dimension.width, dimension.height);
                }
                return;
            }
            if (dimension.width > 0 && dimension.height > 0) {
                GrayBoxPanel grayBoxPanel = this.getGrayBoxPanel();
                if (this.appletErrorOccurred) {
                    grayBoxPanel.setError();
                    grayBoxPanel.paint(graphics);
                } else {
                    grayBoxPanel.progress(this.currentProgress);
                }
            }
        }
        catch (RuntimeException runtimeException) {
            Trace.ignoredException((Exception)runtimeException);
        }
    }

    public void setErrorDelegate(ErrorDelegate errorDelegate) {
        this.errorDelegate = errorDelegate;
    }

    private void installProgressListener() {
        try {
            if (this.progressBarEnabled && this.customImageURL == null) {
                this.progressListener = new GrayBoxProgressListener();
                ProgressMonitor progressMonitor = (ProgressMonitor)sun.net.ProgressMonitor.getDefault();
                progressMonitor.addProgressListener(this.threadGroup, (GrayBoxProgressListener)this.progressListener);
            }
        }
        catch (Throwable throwable) {
            this.progressBarEnabled = false;
        }
    }

    private void removeProgressListener() {
        try {
            if (this.progressBarEnabled) {
                ProgressMonitor progressMonitor = (ProgressMonitor)sun.net.ProgressMonitor.getDefault();
                progressMonitor.removeProgressListener(this.threadGroup, (GrayBoxProgressListener)this.progressListener);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    class GrayBoxProgressListener
    implements ProgressListener {
        GrayBoxProgressListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void progressStart(ProgressEvent progressEvent) {
            ArrayList arrayList = GrayBoxPainter.this.progressSourceFilterList;
            synchronized (arrayList) {
                if (GrayBoxPainter.this.progressSourceFilterList.contains(progressEvent.getSource())) {
                    return;
                }
                if (GrayBoxPainter.this.numJarTotal > 0) {
                    for (int j = 0; j < GrayBoxPainter.this.jarURLs.length; ++j) {
                        if (!progressEvent.getURL().equals(GrayBoxPainter.this.jarURLs[j])) continue;
                        GrayBoxPainter.this.progressSourceFilterList.add(progressEvent.getSource());
                        HashMap hashMap = GrayBoxPainter.this.downloadInProgressMap;
                        synchronized (hashMap) {
                            GrayBoxPainter.this.downloadInProgressMap.put(progressEvent.getURL(), progressEvent);
                            break;
                        }
                    }
                } else if (progressEvent.getURL().toString().startsWith(GrayBoxPainter.this.codebaseURL.toString())) {
                    GrayBoxPainter.this.progressSourceFilterList.add(progressEvent.getSource());
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void progressUpdate(ProgressEvent progressEvent) {
            Cloneable cloneable = GrayBoxPainter.this.progressSourceFilterList;
            synchronized (cloneable) {
                if (GrayBoxPainter.this.progressSourceFilterList.size() == 0) {
                    this.progressStart(progressEvent);
                }
                if (!GrayBoxPainter.this.progressSourceFilterList.contains(progressEvent.getSource())) {
                    return;
                }
            }
            if (GrayBoxPainter.this.numJarTotal > 0) {
                cloneable = GrayBoxPainter.this.downloadInProgressMap;
                synchronized (cloneable) {
                    GrayBoxPainter.this.downloadInProgressMap.put(progressEvent.getURL(), progressEvent);
                    GrayBoxPainter.this.currentProgress = this.getCurrentProgress();
                }
                GrayBoxPainter.this.repaintGrayBox();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void progressFinish(ProgressEvent progressEvent) {
            Cloneable cloneable = GrayBoxPainter.this.progressSourceFilterList;
            synchronized (cloneable) {
                if (!GrayBoxPainter.this.progressSourceFilterList.contains(progressEvent.getSource())) {
                    return;
                }
                GrayBoxPainter.this.progressSourceFilterList.remove(progressEvent.getSource());
            }
            if (ProgressMonitor.getProgress(progressEvent) == 0L) {
                GrayBoxPainter.this.downloadInProgressMap.remove(progressEvent.getURL());
                return;
            }
            if (GrayBoxPainter.this.numJarTotal > 0) {
                cloneable = GrayBoxPainter.this.downloadInProgressMap;
                synchronized (cloneable) {
                    GrayBoxPainter.this.downloadInProgressMap.remove(progressEvent.getURL());
                    GrayBoxPainter.this.numberOfJarLoaded++;
                    if (GrayBoxPainter.this.numJarTotal == GrayBoxPainter.this.numberOfJarLoaded) {
                        GrayBoxPainter.this.currentProgress = GrayBoxPainter.this.maximumProgress;
                    } else {
                        GrayBoxPainter.this.currentProgress = this.getCurrentProgress();
                    }
                }
            } else {
                int n = (GrayBoxPainter.this.maximumProgress - GrayBoxPainter.this.currentProgress) / 2;
                GrayBoxPainter.this.currentProgress = GrayBoxPainter.this.currentProgress + n;
            }
            GrayBoxPainter.this.repaintGrayBox();
        }

        private int getCurrentProgress() {
            int n = GrayBoxPainter.this.maximumProgress / GrayBoxPainter.this.numJarTotal;
            int n2 = n * GrayBoxPainter.this.numberOfJarLoaded;
            for (ProgressEvent progressEvent : GrayBoxPainter.this.downloadInProgressMap.values()) {
                if (ProgressMonitor.getExpected(progressEvent) != -1L) {
                    n2 = (int)((double)n2 + (double)n / (double)ProgressMonitor.getExpected(progressEvent) * (double)ProgressMonitor.getProgress(progressEvent));
                    continue;
                }
                n2 += n / 2;
            }
            return n2;
        }
    }
}

