/*
 * Decompiled with CFR 0.152.
 */
package sun.plugin2.ipc.unix;

import com.sun.deploy.net.socket.UnixDomainSocket;
import com.sun.deploy.net.socket.UnixDomainSocketException;
import com.sun.deploy.util.SystemUtils;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import sun.plugin2.ipc.NamedPipe;

public class DomainSocketNamedPipe
extends NamedPipe {
    private String sockServerName;
    private UnixDomainSocket sockServer;
    private boolean iAmServer;
    private Object connectionSync = new Object();
    private boolean connectFailed = false;
    private IOException connectException = null;
    private volatile UnixDomainSocket sockClient;
    private boolean connectionThreadDone = false;

    public DomainSocketNamedPipe(String string) {
        if (!UnixDomainSocket.isSupported()) {
            throw new RuntimeException("UnixDomainSocket not supported");
        }
        this.sockServerName = string;
        this.sockServer = null;
        this.iAmServer = null == string;
        this.sockClient = null;
        if (this.iAmServer) {
            try {
                this.sockServer = UnixDomainSocket.CreateServerBindListen((int)0, (int)1);
            }
            catch (UnixDomainSocketException unixDomainSocketException) {
                throw new RuntimeException("Error creating AF_UNIX: " + unixDomainSocketException.getMessage());
            }
        }
        this.startConnectThread();
    }

    private void startConnectThread() {
        new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    if (DomainSocketNamedPipe.this.iAmServer) {
                        DomainSocketNamedPipe.this.sockClient = DomainSocketNamedPipe.this.sockServer.accept();
                    } else {
                        DomainSocketNamedPipe.this.sockClient = UnixDomainSocket.CreateClientConnect((String)DomainSocketNamedPipe.this.sockServerName, (boolean)false, (int)0);
                        DomainSocketNamedPipe.this.sockClient.deleteFileOnClose();
                    }
                    Object object = DomainSocketNamedPipe.this.connectionSync;
                    synchronized (object) {
                        DomainSocketNamedPipe.this.connectionThreadDone = true;
                        DomainSocketNamedPipe.this.connectionSync.notifyAll();
                    }
                }
                catch (IOException iOException) {
                    Object object = DomainSocketNamedPipe.this.connectionSync;
                    synchronized (object) {
                        DomainSocketNamedPipe.this.connectException = iOException;
                        DomainSocketNamedPipe.this.connectFailed = true;
                        DomainSocketNamedPipe.this.connectionThreadDone = true;
                        DomainSocketNamedPipe.this.connectionSync.notifyAll();
                    }
                }
            }
        }, "Pipe Connector Thread").start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitForConnectionThread() throws IOException {
        if (!this.connectionThreadDone) {
            Object object = this.connectionSync;
            synchronized (object) {
                while (!this.connectionThreadDone) {
                    try {
                        this.connectionSync.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
        }
        if (this.connectFailed) {
            if (this.connectException != null) {
                throw this.connectException;
            }
            throw new IOException("Never received connection from client side");
        }
    }

    @Override
    public int read(ByteBuffer byteBuffer) throws IOException {
        int n;
        int n2;
        this.waitForConnectionThread();
        for (n = 0; n == 0; n += n2) {
            long l = SystemUtils.microTime();
            try {
                n2 = this.sockClient.read(byteBuffer);
                if (n2 != 0 || this.sockClient.isOpenAndValid()) continue;
                throw new IOException("Parent process died, socket no longer valid.");
            }
            catch (UnixDomainSocketException unixDomainSocketException) {
                long l2 = SystemUtils.microTime();
                throw new IOException("Error reading from AF_UNIX: " + unixDomainSocketException.getMessage() + ", read ts: " + l + ", now ts: " + l2 + ", dT " + (l2 - l));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                break;
            }
        }
        return n;
    }

    @Override
    public int write(ByteBuffer byteBuffer) throws IOException {
        this.waitForConnectionThread();
        int n = 0;
        while (byteBuffer.hasRemaining()) {
            int n2;
            long l = SystemUtils.microTime();
            try {
                n2 = this.sockClient.write(byteBuffer);
            }
            catch (UnixDomainSocketException unixDomainSocketException) {
                long l2 = SystemUtils.microTime();
                throw new IOException("Error writing to AF_UNIX: " + unixDomainSocketException.getMessage() + ", write ts: " + l + ", now ts: " + l2 + ", dT " + (l2 - l));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                break;
            }
            n += n2;
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        if (null != this.sockClient) {
            this.sockClient.close();
        }
        if (null != this.sockServer) {
            this.sockServer.close();
        }
        Object object = this.connectionSync;
        synchronized (object) {
            this.connectFailed = true;
            this.connectionThreadDone = true;
            this.connectionSync.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            this.close();
        }
        finally {
            super.finalize();
        }
    }

    @Override
    public boolean isOpen() {
        return null != this.sockClient && this.sockClient.isOpen();
    }

    @Override
    public String toString() {
        if (this.iAmServer) {
            return "UnixNamedPipe: serverSocket: " + this.sockServer + ", clientSocket: " + this.sockClient;
        }
        return "UnixNamedPipe: clientSocket: " + this.sockClient;
    }

    @Override
    public Map getChildProcessParameters() {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("write_pipe_name", this.sockServer.getFilename());
        return hashMap;
    }
}

