/*
 * Decompiled with CFR 0.152.
 */
package sun.plugin2.ipc.windows;

import java.util.Map;
import sun.plugin2.ipc.Event;
import sun.plugin2.ipc.IPCFactory;
import sun.plugin2.ipc.NamedPipe;
import sun.plugin2.ipc.windows.WindowsEvent;
import sun.plugin2.ipc.windows.WindowsNamedPipe;
import sun.plugin2.os.windows.SECURITY_ATTRIBUTES;
import sun.plugin2.os.windows.Windows;

public class WindowsIPCFactory
extends IPCFactory {
    private static final String PIPE_NAME_PREFIX = "\\\\.\\pipe\\";
    private static final int TIMEOUT = 5000;
    private SECURITY_ATTRIBUTES securityAttributes = SECURITY_ATTRIBUTES.create();
    private static int currentHandleID;

    public WindowsIPCFactory() {
        this.securityAttributes.nLength(SECURITY_ATTRIBUTES.size());
        this.securityAttributes.bInheritHandle(1);
    }

    @Override
    public Event createEvent(Map map) {
        String string = null;
        long l = 0L;
        if (map == null || map.get("evt_name") == null) {
            string = this.nextHandleName("evt");
            l = Windows.CreateEventA(this.securityAttributes, false, false, string);
            if (l == 0L) {
                throw new RuntimeException("Error creating Event object");
            }
        } else {
            string = (String)map.get("evt_name");
            l = Windows.OpenEventA(2031619, true, string);
            if (l == 0L) {
                throw new RuntimeException("Error opening Event object \"" + string + "\"");
            }
        }
        return new WindowsEvent(l, string);
    }

    @Override
    public NamedPipe createNamedPipe(Map map) {
        String string = null;
        String string2 = null;
        long l = 0L;
        long l2 = 0L;
        boolean bl = false;
        if (map == null || map.get("write_pipe_name") == null || map.get("read_pipe_name") == null) {
            string = this.nextHandleName("pipe");
            l = Windows.CreateNamedPipeA(PIPE_NAME_PREFIX + string, 2, 0, 255, 4096, 4096, 5000, null);
            if (l == 0L) {
                throw new RuntimeException("Error creating named pipe for writing");
            }
            string2 = this.nextHandleName("pipe");
            l2 = Windows.CreateNamedPipeA(PIPE_NAME_PREFIX + string2, 1, 0, 255, 4096, 4096, 5000, null);
            if (l2 == 0L) {
                throw new RuntimeException("Error creating named pipe for reading");
            }
            bl = true;
        } else {
            string = (String)map.get("write_pipe_name");
            l = Windows.CreateFileA(PIPE_NAME_PREFIX + string, 0x40000000, 0, null, 3, 128, 0L);
            if (l == 0L) {
                throw new RuntimeException("Error opening named pipe \"\\\\.\\pipe\\" + string + "\"  for writing");
            }
            string2 = (String)map.get("read_pipe_name");
            l2 = Windows.CreateFileA(PIPE_NAME_PREFIX + string2, Integer.MIN_VALUE, 0, null, 3, 128, 0L);
            if (l2 == 0L) {
                throw new RuntimeException("Error opening named pipe \"\\\\.\\pipe\\" + string2 + "\" for reading");
            }
        }
        return new WindowsNamedPipe(l, l2, string, string2, bl);
    }

    private String nextHandleName(String string) {
        return "jpi2_pid" + Windows.GetCurrentProcessId() + "_" + string + WindowsIPCFactory.nextHandleID();
    }

    private static synchronized int nextHandleID() {
        return ++currentHandleID;
    }
}

