/*
 * Decompiled with CFR 0.152.
 */
package sun.plugin2.main.client;

import apple.awt.ProcessUI;
import com.apple.eawt.Application;
import com.sun.deploy.security.MacOSXKeyHandler;
import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.AWTEventListener;
import java.awt.event.WindowEvent;
import java.lang.ref.WeakReference;
import java.security.AccessController;
import java.security.PrivilegedAction;
import javax.swing.SwingUtilities;
import sun.plugin2.main.client.DetachedAppletController;
import sun.plugin2.main.client.PluginEmbeddedFrame;

public class Plugin2EventListener
implements AWTEventListener {
    static Plugin2EventListener INSTANCE = new Plugin2EventListener();
    boolean dockIconInflated = false;
    WeakReference<PluginEmbeddedFrame> activeAppletFrame;

    private Plugin2EventListener() {
        Toolkit.getDefaultToolkit().addAWTEventListener(this, 120L);
    }

    public static Plugin2EventListener getInstance() {
        return INSTANCE;
    }

    public void dispatchWindowEvent(WindowEvent windowEvent) {
        Window window = (Window)windowEvent.getSource();
        switch (windowEvent.getID()) {
            case 200: 
            case 205: {
                if (this.shouldInflateDockIcon(window)) {
                    Plugin2EventListener.inflateDockIcon();
                }
                if (this.affectsApplicationLevel(window)) {
                    Plugin2EventListener.activateAppletProcess();
                }
                if (!(window instanceof PluginEmbeddedFrame)) {
                    return;
                }
                if (this.activeAppletFrame != null && window == this.activeAppletFrame.get()) {
                    return;
                }
                this.activeAppletFrame = new WeakReference<PluginEmbeddedFrame>((PluginEmbeddedFrame)window);
            }
        }
    }

    @Override
    public void eventDispatched(AWTEvent aWTEvent) {
        if (aWTEvent instanceof WindowEvent) {
            this.dispatchWindowEvent((WindowEvent)aWTEvent);
            return;
        }
        switch (aWTEvent.getID()) {
            case 401: 
            case 402: 
            case 503: 
            case 504: {
                Object object = aWTEvent.getSource();
                if (!(object instanceof Component)) {
                    return;
                }
                Window window = SwingUtilities.getWindowAncestor((Component)object);
                if (!(window instanceof PluginEmbeddedFrame)) {
                    return;
                }
                this.activeAppletFrame = new WeakReference<PluginEmbeddedFrame>((PluginEmbeddedFrame)window);
                this.updateAppletDetachFrame();
            }
        }
    }

    private boolean isOrdinaryWindow(Window window) {
        if (window == null) {
            return false;
        }
        if (window instanceof PluginEmbeddedFrame || window instanceof DetachedAppletController.DetachFrame) {
            return false;
        }
        String string = window.getName();
        if ("###overrideRedirect###".equals(string)) {
            return false;
        }
        if ("###focusableSwingPopup###".equals(string)) {
            window.setAlwaysOnTop(true);
            return false;
        }
        return true;
    }

    private boolean shouldInflateDockIcon(Window window) {
        if (this.dockIconInflated) {
            return false;
        }
        if (window instanceof Dialog && ((Dialog)window).isModal()) {
            return false;
        }
        return this.isOrdinaryWindow(window);
    }

    private boolean affectsApplicationLevel(Window window) {
        return this.isOrdinaryWindow(window);
    }

    static void inflateDockIcon() {
        if (Plugin2EventListener.INSTANCE.dockIconInflated) {
            return;
        }
        Plugin2EventListener.INSTANCE.dockIconInflated = true;
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                ProcessUI processUI = ProcessUI.getInstance();
                if (processUI.isInflated()) {
                    return null;
                }
                Application application = Application.getApplication();
                processUI.inflateDockIcon();
                application.setDockIconImage(application.getDockIconImage());
                return null;
            }
        });
    }

    static void activateAppletProcess() {
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                Application.getApplication().requestForeground(true);
                return null;
            }
        });
    }

    private void updateAppletDetachFrame() {
        MacOSXKeyHandler macOSXKeyHandler = MacOSXKeyHandler.getInstance();
        DetachedAppletController detachedAppletController = this.getDetachedAppletController();
        if (detachedAppletController == null) {
            return;
        }
        if (macOSXKeyHandler.isKeyDown(4) && macOSXKeyHandler.isKeyDown(1)) {
            detachedAppletController.showFrame();
        } else {
            detachedAppletController.hideFrame();
        }
    }

    private DetachedAppletController getDetachedAppletController() {
        if (this.activeAppletFrame == null || this.activeAppletFrame.get() == null) {
            return null;
        }
        return ((PluginEmbeddedFrame)this.activeAppletFrame.get()).getDetachedAppletController();
    }
}

