/*
 * Decompiled with CFR 0.152.
 */
package sun.plugin2.message;

import java.util.LinkedList;
import sun.plugin2.message.Conversation;
import sun.plugin2.message.Message;

class Queue {
    private LinkedList messages = new LinkedList();
    private Thread waiter;

    Queue() {
    }

    public synchronized void put(Message message) {
        this.messages.add(message);
        this.notifyAll();
    }

    public synchronized Message get() {
        if (this.messages.size() == 0) {
            return null;
        }
        return (Message)this.messages.removeFirst();
    }

    public synchronized Message get(int n, Conversation conversation) {
        for (int j = 0; j < this.messages.size(); ++j) {
            Message message = (Message)this.messages.get(j);
            if (n >= 0 && message.getID() != n || conversation != null && !conversation.equals(message.getConversation())) continue;
            this.messages.remove(j);
            return message;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Message waitForMessage(long l) throws InterruptedException {
        if (this.messages.size() == 0) {
            this.waiter = Thread.currentThread();
            try {
                this.wait(l);
            }
            finally {
                this.waiter = null;
            }
        }
        return this.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Message waitForMessage(long l, int n, Conversation conversation) throws InterruptedException {
        Message message = this.get(n, conversation);
        if (message != null) {
            return message;
        }
        boolean bl = l == 0L;
        do {
            long l2 = System.currentTimeMillis();
            this.waiter = Thread.currentThread();
            try {
                this.wait(l);
            }
            finally {
                this.waiter = null;
            }
            long l3 = System.currentTimeMillis();
            if (bl) continue;
            l -= Math.max(0L, l3 - l2);
        } while ((message = this.get(n, conversation)) == null && (bl || l > 0L));
        return message;
    }

    public synchronized void interrupt() {
        if (this.waiter != null) {
            this.waiter.interrupt();
        }
    }
}

