/*
 * Decompiled with CFR 0.152.
 */
package sun.plugin2.message.transport;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import sun.plugin2.ipc.NamedPipe;
import sun.plugin2.message.AbstractSerializer;
import sun.plugin2.message.Serializer;
import sun.plugin2.message.transport.SerializingTransport;

public class NamedPipeTransport
extends SerializingTransport {
    private static final int BUFFER_SIZE = 8192;
    private volatile NamedPipe namedPipe;
    private ByteBuffer input;
    private ByteBuffer output;
    private SerializerImpl serializer;

    public NamedPipeTransport(NamedPipe namedPipe) throws IOException {
        this.namedPipe = namedPipe;
        this.input = ByteBuffer.allocateDirect(8192);
        this.input.order(ByteOrder.nativeOrder());
        this.input.limit(0);
        this.output = ByteBuffer.allocateDirect(8192);
        this.output.order(ByteOrder.nativeOrder());
        this.serializer = new SerializerImpl();
    }

    public synchronized void shutdown() {
        try {
            if (this.namedPipe != null) {
                this.namedPipe.close();
                this.namedPipe = null;
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    @Override
    public void waitForData(long l) throws IOException {
        this.serializer.waitForData();
    }

    @Override
    protected void signalDataWritten() throws IOException {
        this.getSerializer().flush();
    }

    @Override
    protected void signalDataRead() {
    }

    @Override
    protected boolean isDataAvailable() throws IOException {
        return true;
    }

    @Override
    protected Serializer getSerializer() {
        return this.serializer;
    }

    @Override
    public String toString() {
        if (null == this.namedPipe) {
            return "NamedPipe[shutdown]";
        }
        return this.namedPipe.toString();
    }

    class SerializerImpl
    extends AbstractSerializer {
        SerializerImpl() {
        }

        void waitForData() throws IOException {
            if (NamedPipeTransport.this.input.remaining() > 0) {
                return;
            }
            this.read();
        }

        void read() throws IOException {
            NamedPipeTransport.this.input.rewind();
            NamedPipeTransport.this.input.limit(NamedPipeTransport.this.input.capacity());
            if (null == NamedPipeTransport.this.namedPipe) {
                throw new IOException("namedPipe shutdown");
            }
            NamedPipeTransport.this.namedPipe.read(NamedPipeTransport.this.input);
            NamedPipeTransport.this.input.flip();
        }

        @Override
        public void writeByte(byte by) throws IOException {
            if (NamedPipeTransport.this.output.remaining() < 1) {
                this.flush();
            }
            NamedPipeTransport.this.output.put(by);
        }

        @Override
        public void flush() throws IOException {
            if (NamedPipeTransport.this.output.position() == 0) {
                return;
            }
            NamedPipeTransport.this.output.flip();
            if (null == NamedPipeTransport.this.namedPipe) {
                throw new IOException("namedPipe shutdown");
            }
            NamedPipeTransport.this.namedPipe.write(NamedPipeTransport.this.output);
            NamedPipeTransport.this.output.rewind();
            NamedPipeTransport.this.output.limit(NamedPipeTransport.this.output.capacity());
        }

        @Override
        public byte readByte() throws IOException {
            if (NamedPipeTransport.this.input.remaining() > 0) {
                return NamedPipeTransport.this.input.get();
            }
            this.read();
            return NamedPipeTransport.this.input.get();
        }
    }
}

