/*
 * Decompiled with CFR 0.152.
 */
package util;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontFormatException;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.geom.Point2D;
import java.io.IOException;
import java.io.InputStream;
import javax.swing.JFrame;

public class ComponentsTools {
    public static Point2D getCenter(Component component) {
        Point p = ComponentsTools.getLocationOnScreen(component);
        double width = component.getWidth();
        double height = component.getHeight();
        if (width == 0.0) {
            width = component.getPreferredSize().getHeight();
        }
        if (height == 0.0) {
            height = component.getPreferredSize().getHeight();
        }
        return new Point2D.Double(p.getX() + width / 2.0, p.getY() + height / 2.0);
    }

    public static JFrame getParent(Component component) {
        JFrame frame = null;
        Container container = component.getParent();
        while (container != null) {
            if (container instanceof JFrame) {
                frame = (JFrame)container;
                break;
            }
            container = container.getParent();
        }
        return frame;
    }

    public static void setExternalFont(Component c, String res) {
        try {
            InputStream in = c.getClass().getResourceAsStream(res);
            Font font = null;
            font = Font.createFont(0, in);
            font = font.deriveFont(0, c.getFont().getSize());
            c.setFont(font);
        }
        catch (FontFormatException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static Point2D getScreenCenter() {
        boolean forceCenterRelativeToFirstScreen = false;
        double screenCenterX = 0.0;
        double screenCenterY = 0.0;
        if (forceCenterRelativeToFirstScreen) {
            GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
            GraphicsDevice[] gd = ge.getScreenDevices();
            GraphicsDevice screen = gd[0];
            Rectangle bounds = screen.getDefaultConfiguration().getBounds();
            screenCenterX = bounds.x + bounds.width / 2;
            screenCenterY = bounds.y + bounds.height / 2;
        } else {
            Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
            screenCenterX = screenSize.width / 2;
            screenCenterY = screenSize.height / 2;
        }
        return new Point2D.Double(screenCenterX, screenCenterY);
    }

    public static Point getLocationOnScreen(Component component) {
        Point p = component.getLocationOnScreen();
        return p;
    }

    public static void center(Component compToCenter, Component inOther) {
        compToCenter.setLocation((int)ComponentsTools.getLocationOnScreen(inOther).getX() + inOther.getWidth() / 2 - compToCenter.getWidth() / 2, (int)ComponentsTools.getLocationOnScreen(inOther).getY() + inOther.getHeight() / 2 - compToCenter.getHeight() / 2);
    }

    public static void centerToScreen(Component component) {
        Point2D screenCenter = ComponentsTools.getScreenCenter();
        component.setLocation((int)screenCenter.getX() - component.getWidth() / 2, (int)screenCenter.getY() - component.getHeight() / 2);
    }
}

