/*
 * Decompiled with CFR 0.152.
 */
package util;

import java.applet.Applet;
import java.util.Calendar;
import java.util.HashMap;
import netscape.javascript.JSObject;
import util.io.SwingIO;

public class CookieManager {
    private Applet applet;
    private boolean useCookieCache = true;
    private HashMap<String, String> cookieCache = new HashMap();

    public CookieManager(Applet applet) {
        this.applet = applet;
    }

    public void setUseCache(boolean useCache) {
        this.useCookieCache = useCache;
    }

    public boolean isUseCache() {
        return this.useCookieCache;
    }

    public void writeCookie(String name, String value) {
        Calendar c = Calendar.getInstance();
        c.add(2, 1);
        this.writeCookie(name, value, c);
    }

    public void writeCookie(String name, String value, Calendar expire) {
        if (this.useCookieCache) {
            this.cookieCache.put(name, value);
        }
        String expires = "; expires=" + expire.getTime().toGMTString();
        String s1 = String.valueOf(name) + "=" + value + expires;
        JSObject myBrowser = JSObject.getWindow(this.applet);
        JSObject myDocument = (JSObject)myBrowser.getMember("document");
        myDocument.setMember("cookie", s1);
    }

    public void deleteCookie(String name) {
        if (this.useCookieCache) {
            this.cookieCache.remove(name);
        }
        Calendar c = Calendar.getInstance();
        c.add(2, -1);
        this.writeCookie(name, "null", c);
    }

    public String getCookies() {
        try {
            JSObject myBrowser = JSObject.getWindow(this.applet);
            JSObject myDocument = (JSObject)myBrowser.getMember("document");
            String myCookie = (String)myDocument.getMember("cookie");
            if (myCookie.length() > 0) {
                return myCookie;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return "";
    }

    public String getCookie(String name) {
        if (this.useCookieCache && this.cookieCache.containsKey(name)) {
            return this.cookieCache.get(name);
        }
        String myCookie = this.getCookies();
        String search = String.valueOf(name) + "=";
        if (myCookie.length() > 0) {
            int offset = myCookie.indexOf(search);
            if (offset != -1) {
                int end = myCookie.indexOf(";", offset += search.length());
                if (end == -1) {
                    end = myCookie.length();
                }
                String value = myCookie.substring(offset, end);
                if (this.useCookieCache) {
                    this.cookieCache.put(name, value);
                }
                return value;
            }
            SwingIO.log(this.getClass().getName(), "getCookie(name)", "getCookie(name) Did not find cookie: ");
        }
        if (this.useCookieCache) {
            this.cookieCache.put(name, null);
        }
        return null;
    }

    public void clear() {
        String[] kvPairs;
        if (this.useCookieCache) {
            this.cookieCache.clear();
        }
        String pairs = this.getCookies();
        String[] stringArray = kvPairs = pairs.split(";");
        int n = kvPairs.length;
        int n2 = 0;
        while (n2 < n) {
            String kvPair = stringArray[n2];
            String[] kv = kvPair.split("=");
            String key = kv[0].trim();
            this.deleteCookie(key);
            ++n2;
        }
    }

    public void printCookies() {
        String[] kvPairs;
        String pairs = this.getCookies();
        if (pairs.length() == 0) {
            return;
        }
        String[] stringArray = kvPairs = pairs.split(";");
        int n = kvPairs.length;
        int n2 = 0;
        while (n2 < n) {
            String kvPair = stringArray[n2];
            String[] kv = kvPair.split("=");
            String key = kv[0].trim();
            String value = kv[1].trim();
            if (this.useCookieCache) {
                this.cookieCache.put(key, value);
            }
            System.out.println(String.valueOf(key) + " = " + value);
            ++n2;
        }
    }
}

