/*
 * Decompiled with CFR 0.152.
 */
package util;

import javax.swing.JSlider;

public class DoubleJSlider
extends JSlider {
    private String mName = "";
    private double mPrecision = 2.0;

    public DoubleJSlider() {
        this.setName("");
        this.setDoubleMinimum(0.0);
        this.setDoubleMaximum(100.0);
        this.setDoubleValue(50.0);
    }

    public DoubleJSlider(String name, double val, double min, double max) {
        this.setName(name);
        this.setDoubleMinimum(min);
        this.setDoubleMaximum(max);
        this.setDoubleValue(val);
    }

    public DoubleJSlider(int orientation, double min, double max, double val) {
        super(orientation);
        this.setName("");
        this.setDoubleMinimum(min);
        this.setDoubleMaximum(max);
        this.setDoubleValue(val);
    }

    public double getDoubleMaximum() {
        return (double)this.getMaximum() / Math.pow(10.0, this.mPrecision);
    }

    public double getDoubleMinimum() {
        return (double)this.getMinimum() / Math.pow(10.0, this.mPrecision);
    }

    public double getDoubleValue() {
        return (double)this.getValue() / Math.pow(10.0, this.mPrecision);
    }

    @Override
    public String getName() {
        return this.mName;
    }

    public double getPrecision() {
        return this.mPrecision;
    }

    public void setDoubleMajorTickSpacing(double val) {
        this.setMajorTickSpacing((int)(val * Math.pow(10.0, this.mPrecision)));
    }

    public void setDoubleMaximum(double max) {
        this.setMaximum((int)(max * Math.pow(10.0, this.mPrecision)));
    }

    public void setDoubleMinimum(double min) {
        this.setMinimum((int)(min * Math.pow(10.0, this.mPrecision)));
    }

    public void setDoubleMinorTickSpacing(double val) {
        this.setMinorTickSpacing((int)(val * Math.pow(10.0, this.mPrecision)));
    }

    public void setDoubleValue(double val) {
        this.setValue((int)(val * Math.pow(10.0, this.mPrecision)));
        this.setToolTipText(Double.toString(val));
    }

    @Override
    public void setName(String name) {
        this.mName = name;
    }

    public void setPrecision(double prec) {
        this.mPrecision = prec;
    }
}

