/*
 * Decompiled with CFR 0.152.
 */
package util;

import java.awt.Cursor;
import java.io.IOException;
import java.net.URL;
import javax.swing.JEditorPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import util.io.SwingIO;
import views.Explorer;

public class FollowLink
implements HyperlinkListener {
    private static final Cursor DEFAULT_CURSOR = new Cursor(0);
    private static final Cursor HAND_CURSOR = new Cursor(12);
    private JEditorPane panneau;

    public static void OpenExplorer(URL url) throws IOException {
        try {
            String os = System.getProperty("os.name");
            Runtime r = Runtime.getRuntime();
            try {
                if (os.endsWith("NT") || os.endsWith("2000") || os.endsWith("XP")) {
                    r.exec("cmd /c start " + url);
                } else if (os.startsWith("Mac OS")) {
                    System.out.println(os);
                    r.exec("open " + url);
                } else {
                    System.out.println(os);
                    r.exec("start " + url);
                }
            }
            catch (Exception e1) {
                try {
                    SwingIO.warning("FollowLink", "OpenExplorer", e1.getMessage(), e1);
                    new Explorer(url);
                }
                catch (IOException ex) {
                    SwingIO.warning("FollowLink", "OpenExplorer", ex.getMessage(), ex);
                    throw ex;
                }
            }
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
        }
    }

    public FollowLink() {
    }

    public FollowLink(JEditorPane panneau) {
        this.panneau = panneau;
    }

    public JEditorPane getPanneau() {
        return this.panneau;
    }

    @Override
    public void hyperlinkUpdate(HyperlinkEvent evt) {
        if (evt.getEventType() == HyperlinkEvent.EventType.ENTERED) {
            this.panneau.setCursor(HAND_CURSOR);
        } else {
            this.panneau.setCursor(DEFAULT_CURSOR);
        }
        if (evt.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
            try {
                if (evt.getDescription().startsWith("class:")) {
                    String className = evt.getDescription().substring(6);
                    Class.forName(className).newInstance();
                } else {
                    FollowLink.OpenExplorer(evt.getURL());
                }
            }
            catch (IOException e) {
                SwingIO.warning(this.getClass().getName(), "hyperlinkUpdate", e.getMessage(), e);
            }
            catch (InstantiationException e) {
                SwingIO.warning(this.getClass().getName(), "hyperlinkUpdate", e.getMessage(), e);
            }
            catch (IllegalAccessException e) {
                SwingIO.warning(this.getClass().getName(), "hyperlinkUpdate", e.getMessage(), e);
            }
            catch (ClassNotFoundException e) {
                SwingIO.warning(this.getClass().getName(), "hyperlinkUpdate", e.getMessage(), e);
            }
        }
    }

    public void setPanneau(JEditorPane panneau) {
        this.panneau = panneau;
    }
}

