/*
 * Decompiled with CFR 0.152.
 */
package util;

import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.DocumentFilter;
import javax.swing.text.PlainDocument;

public class IntegerSpinner {
    public static JSpinner makeIntegerSpinner(int value, int minimum, int maximum, int stepSize) {
        JSpinner spinner = new JSpinner(new SpinnerNumberModel(value, minimum, maximum, stepSize));
        JSpinner.NumberEditor jsEditor = (JSpinner.NumberEditor)spinner.getEditor();
        Document jsDoc = jsEditor.getTextField().getDocument();
        if (jsDoc instanceof PlainDocument) {
            PlainDocument doc = new PlainDocument(){

                @Override
                public void setDocumentFilter(DocumentFilter filter) {
                    if (filter instanceof MyDocumentFilter) {
                        super.setDocumentFilter(filter);
                    }
                }
            };
            doc.setDocumentFilter(new MyDocumentFilter());
            jsEditor.getTextField().setDocument(doc);
        }
        jsEditor.getTextField().setValue(value);
        return spinner;
    }

    private static class MyDocumentFilter
    extends DocumentFilter {
        private MyDocumentFilter() {
        }

        @Override
        public void insertString(DocumentFilter.FilterBypass fb, int offset, String string, AttributeSet attr) throws BadLocationException {
            if (this.stringContainsOnlyDigits(string)) {
                super.insertString(fb, offset, string, attr);
            }
        }

        @Override
        public void remove(DocumentFilter.FilterBypass fb, int offset, int length) throws BadLocationException {
            super.remove(fb, offset, length);
        }

        @Override
        public void replace(DocumentFilter.FilterBypass fb, int offset, int length, String text, AttributeSet attrs) throws BadLocationException {
            if (this.stringContainsOnlyDigits(text)) {
                super.replace(fb, offset, length, text, attrs);
            }
        }

        private boolean stringContainsOnlyDigits(String text) {
            int i2 = 0;
            while (i2 < text.length()) {
                if (!Character.isDigit(text.charAt(i2))) {
                    return false;
                }
                ++i2;
            }
            return true;
        }
    }
}

