/*
 * Decompiled with CFR 0.152.
 */
package util;

import java.util.Locale;

public class MyLocale {
    Locale locale;

    public static Locale getDefault() {
        return new MyLocale(Locale.getDefault().getLanguage(), Locale.getDefault().getCountry()).getLocale();
    }

    public static String getOSToVariant() {
        String os = System.getProperty("os.name");
        if (os.endsWith("NT") || os.endsWith("2000") || os.endsWith("XP")) {
            return "WIN";
        }
        if (os.startsWith("Windows")) {
            return "WIN";
        }
        if (os.startsWith("Mac OS")) {
            return "MAC";
        }
        return "LINUX";
    }

    public static String getOSName() {
        return System.getProperty("os.name");
    }

    public static String getJavaVersion() {
        return System.getProperty("java.version");
    }

    public MyLocale(String language, String country) {
        this.locale = new Locale(language, country, MyLocale.getOSToVariant());
    }

    public String getLanguage() {
        return this.locale.getLanguage();
    }

    public String getCountry() {
        return this.locale.getCountry();
    }

    public String getVariant() {
        return this.locale.getVariant();
    }

    public Locale getLocale() {
        return this.locale;
    }
}

