/*
 * Decompiled with CFR 0.152.
 */
package util.io;

import controller.globalCommands.ICommand;
import controller.globalCommands.ReadGaussianCommand;
import controller.globalCommands.ReadNRTSTRCommand;
import controller.globalCommands.ReadXYZCommand;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.io.StreamTokenizer;
import java.io.StringReader;
import javax.swing.JOptionPane;
import org.ctom.hulis.files.gamess.GamessReadXYZ;
import org.ctom.hulis.files.gaussian.Gaussian03ReadXYZ;
import org.ctom.hulis.files.gaussian.NRTSTRreader;
import org.ctom.hulis.files.gaussian.ReadGaussian;
import org.ctom.hulis.files.xyz.ReadCoordinatesxyz;
import org.ctom.hulis.files.xyz.Readxyz;
import util.io.SwingIO;
import views.FrameApp;

public class IOClipBoard
implements ActionListener,
ClipboardOwner {
    FrameApp app;
    String failMessage;

    public IOClipBoard(FrameApp app) {
        this.app = app;
        this.failMessage = "";
    }

    public boolean tryCommand(String format, ICommand command) {
        try {
            SwingIO.log(this.getClass().getName(), "tryCommand", "try to interpret format : " + format);
            command.execute();
            if (!command.isSucceed()) {
                this.failMessage = String.valueOf(this.failMessage) + "\n Not " + format + " format : " + command.getFailReason();
                return false;
            }
        }
        catch (NullPointerException e1) {
            SwingIO.warning(this.getClass().getName(), "actionPerformed", "paste an empty clipboard !", e1);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return true;
    }

    @Override
    public void actionPerformed(ActionEvent arg0) {
        SwingIO.log(this.getClass().getName(), "actionPerformed", "try to read clipboard content : \n" + this.getClipboardContents());
        if (!(this.tryCommand("NRT string for NBO", new ReadNRTSTRCommand(this.app, new NRTSTRreader(this.getClipboardContents()))) || this.tryCommand("xyz", new ReadXYZCommand(this.app, new Readxyz(new StreamTokenizer(new StringReader(this.getClipboardContents()))))) || this.tryCommand("Gaussian03 xyz", new ReadXYZCommand(this.app, new Gaussian03ReadXYZ(this.getClipboardContents()))) || this.tryCommand("Gamess xyz", new ReadXYZCommand(this.app, new GamessReadXYZ(this.getClipboardContents()))) || this.tryCommand("xyz coordinates", new ReadXYZCommand(this.app, new ReadCoordinatesxyz(this.getClipboardContents()))) || this.tryCommand("Gaussian", new ReadGaussianCommand(this.app, new ReadGaussian(this.getClipboardContents()))))) {
            JOptionPane.showMessageDialog(this.app, "Not recognized format." + this.failMessage, "Clipboard paste", 1);
        }
        this.failMessage = "";
    }

    public String getClipboardContents() {
        boolean hasTransferableText;
        String result = "";
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        Transferable contents = clipboard.getContents(null);
        boolean bl = hasTransferableText = contents != null && contents.isDataFlavorSupported(DataFlavor.stringFlavor);
        if (hasTransferableText) {
            try {
                result = (String)contents.getTransferData(DataFlavor.stringFlavor);
            }
            catch (UnsupportedFlavorException ex) {
                SwingIO.PrintIf(ex);
                ex.printStackTrace();
            }
            catch (IOException ex) {
                SwingIO.PrintIf(ex);
                ex.printStackTrace();
            }
        }
        return result;
    }

    @Override
    public void lostOwnership(Clipboard arg0, Transferable arg1) {
    }
}

