/*
 * Decompiled with CFR 0.152.
 */
package util.io;

import controller.globalCommands.ActionStopConsumingProcess;
import controller.globalCommands.Center;
import controller.globalCommands.ReadGaussianCommand;
import controller.globalCommands.ReadXMLCommand;
import controller.globalCommands.ReadXYZCommand;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.ObjectInputStream;
import java.io.StreamTokenizer;
import java.security.AccessControlException;
import java.util.List;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import org.ctom.hulis.files.gaussian.ReadGaussian;
import org.ctom.hulis.files.gaussian.test.ReadGaussianTest;
import org.ctom.hulis.files.xml.Readxml;
import org.ctom.hulis.files.xyz.Readxyz;
import org.ctom.hulis.huckel.Mesomery;
import org.ctom.hulis.huckel.exception.CoupleException;
import org.ctom.hulis.huckel.exception.IMethodException;
import org.ctom.hulis.huckel.exception.IncorrectNumberPiElectronsException;
import org.ctom.hulis.huckel.exception.MesomeryNoStructureLocalizedException;
import org.ctom.hulis.huckel.methods.IMethod;
import org.ctom.hulis.huckel.structures.Structure;
import org.ctom.hulis.util.io.HuckelIO;
import util.MyJOptionPane;
import util.MyResourceBundle;
import util.io.FilesUtil;
import util.io.GaussianFilter;
import util.io.GaussianTestFilter;
import util.io.HasDefaultExtension;
import util.io.HulisFilter;
import util.io.ImagePNGFilter;
import util.io.ImageSVGFilter;
import util.io.SaveFile;
import util.io.SwingIO;
import util.io.TXmlFilter;
import util.io.XmlFilter;
import util.io.XyzFilter;
import util.languages.LanguageManager;
import views.FrameApp;
import views.prefs.PreferencesGUI;

public class IOFichier
implements ActionListener {
    FrameApp app;
    public static File DEFAULT_DIRECTORY = null;

    public IOFichier(FrameApp app) {
        this.app = app;
    }

    @Override
    public void actionPerformed(ActionEvent arg0) {
        block29: {
            MyResourceBundle bundle = LanguageManager.getInstance().getResource("ActionsApp");
            try {
                final JFileChooser choix = new JFileChooser();
                HulisFilter hulisFileFilter = new HulisFilter();
                XyzFilter xyzFileFilter = new XyzFilter();
                GaussianFilter gaussianFilter = new GaussianFilter();
                GaussianTestFilter gaussianTestFilter = new GaussianTestFilter();
                choix.addChoosableFileFilter(new GaussianTestFilter());
                if (DEFAULT_DIRECTORY != null) {
                    choix.setCurrentDirectory(DEFAULT_DIRECTORY);
                }
                choix.addPropertyChangeListener(new PropertyChangeListener(){

                    @Override
                    public void propertyChange(PropertyChangeEvent evt) {
                        DEFAULT_DIRECTORY = choix.getCurrentDirectory();
                    }
                });
                if (arg0.getActionCommand() == "23") {
                    choix.addChoosableFileFilter(hulisFileFilter);
                    choix.addChoosableFileFilter(xyzFileFilter);
                    choix.addChoosableFileFilter(gaussianFilter);
                    choix.addChoosableFileFilter(new XmlFilter());
                    choix.setFileFilter(gaussianFilter);
                    int option = choix.showOpenDialog(this.app);
                    if (option == 0) {
                        File file = choix.getSelectedFile();
                        HuckelIO.log(this.getClass().getName(), "actionPerformed", "try to read file : \n" + FilesUtil.fileToString(file));
                        String type = FilesUtil.getExtension(file).toLowerCase();
                        HuckelIO.log(this.getClass().getName(), "actionPerformed", "file extension=|" + type + "|");
                        if (type.equals("xyz")) {
                            ReadXYZCommand ReadXYZCommand2 = new ReadXYZCommand(this.app, new Readxyz(new StreamTokenizer(new FileReader(file))));
                            ReadXYZCommand2.execute();
                            if (!ReadXYZCommand2.isSucceed()) {
                                MyJOptionPane.showMessageDialog(this.app, ReadXYZCommand2.getFailReason(), "Read XYZ error", 1);
                            }
                        } else if (type.equals("com")) {
                            ReadGaussianCommand readGaussianCommand = new ReadGaussianCommand(this.app, new ReadGaussian(file));
                            readGaussianCommand.execute();
                            if (!readGaussianCommand.isSucceed()) {
                                MyJOptionPane.showMessageDialog(this.app, readGaussianCommand.getFailReason(), "Read Gaussian error", 1);
                            }
                        } else if (type.equals("tcom")) {
                            ReadGaussianCommand readGaussianCommand = new ReadGaussianCommand(this.app, new ReadGaussianTest(file));
                            readGaussianCommand.execute();
                            if (!readGaussianCommand.isSucceed()) {
                                MyJOptionPane.showMessageDialog(this.app, readGaussianCommand.getFailReason(), "Read Gaussian error", 1);
                            }
                        } else if (type.equals("hulis")) {
                            System.out.println("DESERIALISATION");
                            FileInputStream fis = new FileInputStream(file);
                            ObjectInputStream ois = new ObjectInputStream(fis);
                            final Mesomery mesomery = (Mesomery)ois.readObject();
                            System.out.println("NB ATOMES= " + mesomery.getDelocalizedStructure().countAtoms());
                            List<IMethod> lstCurrentSelectedMethods = this.app.getListSelectedMethods();
                            this.app.getStateManager().initNewState();
                            this.app.setMesomery(mesomery, "", "");
                            this.app.getCurrentMesomeryView().rebuild();
                            for (IMethod method : lstCurrentSelectedMethods) {
                                this.app.selectMethod(method.getName(), true);
                            }
                            mesomery.setSelectionTreshold(mesomery.getStructureSelector().getMaximalValue());
                            mesomery.setSelectionTreshold(mesomery.getStructureSelector().getMaximalValue());
                            for (Structure s : mesomery.getAllStructures()) {
                                if (s.isCloneResultsCacheWhenCloneStructure()) continue;
                                s.calculate();
                            }
                            Thread stop = ActionStopConsumingProcess.stopCalculateWeights(this.app);
                            stop.join();
                            new Thread(new Runnable(){

                                @Override
                                public void run() {
                                    try {
                                        mesomery.calculate();
                                    }
                                    catch (IncorrectNumberPiElectronsException e) {
                                        e.printStackTrace();
                                    }
                                    catch (IMethodException e) {
                                        e.printStackTrace();
                                    }
                                    catch (MesomeryNoStructureLocalizedException e) {
                                        e.printStackTrace();
                                    }
                                    catch (CoupleException e) {
                                        e.printStackTrace();
                                    }
                                    catch (Exception e) {
                                        e.printStackTrace();
                                        mesomery.stopConsumingProcess();
                                        mesomery.forceAutoGenerating(false);
                                        mesomery.forceCalculatingWeights(false);
                                        SwingIO.error(this.getClass().getName(), "restoreState", "mesomery compute error when restore state", e);
                                        MyJOptionPane.showMessageDialog(IOFichier.this.app, "Unexpected compute error during undo/redo operation", "Error", 0);
                                    }
                                }
                            }).start();
                            new Center(this.app.getCurrentMesomeryView()).execute();
                            this.app.getStateManager().saveState();
                            ois.close();
                        } else if (type.equals("xml")) {
                            new ReadXMLCommand(this.app, new Readxml(file)).execute();
                        } else {
                            System.out.println("Extension not recognized |" + type + "|");
                        }
                    }
                    break block29;
                }
                if (arg0.getActionCommand() == "29") {
                    choix.addChoosableFileFilter(hulisFileFilter);
                    choix.addChoosableFileFilter(xyzFileFilter);
                    choix.addChoosableFileFilter(gaussianFilter);
                    choix.addChoosableFileFilter(new ImagePNGFilter());
                    choix.addChoosableFileFilter(new ImageSVGFilter());
                    choix.addChoosableFileFilter(new TXmlFilter());
                    choix.setFileFilter(gaussianFilter);
                    int option = choix.showSaveDialog(this.app);
                    if (option == 0) {
                        String ext = "." + ((HasDefaultExtension)((Object)choix.getFileFilter())).getDefaultExtension().toLowerCase();
                        if (!choix.getSelectedFile().getPath().toLowerCase().endsWith(ext)) {
                            JOptionPane.showMessageDialog(this.app, String.valueOf(bundle.getString("krenamefile")) + " " + choix.getSelectedFile().getName() + ext);
                            choix.setSelectedFile(new File(String.valueOf(choix.getSelectedFile().getPath()) + ext));
                        }
                        HuckelIO.log(this.getClass().getName(), "actionPerformed", "Save file " + choix.getSelectedFile());
                        new SaveFile(this.app, choix.getSelectedFile());
                    }
                    break block29;
                }
                if (arg0.getActionCommand() == "38") {
                    choix.addChoosableFileFilter(new ImagePNGFilter());
                    choix.addChoosableFileFilter(new ImageSVGFilter());
                    int option = choix.showSaveDialog(this.app);
                    if (option == 0) {
                        String ext = "";
                        if (choix.getSelectedFile().getName().endsWith(".png")) {
                            ext = "png";
                        }
                        if (choix.getSelectedFile().getName().endsWith(".svg")) {
                            ext = "svg";
                        }
                        PreferencesGUI.setPrinting(choix.getSelectedFile().getAbsolutePath(), choix.getSelectedFile().getName(), ext);
                    }
                    break block29;
                }
                throw new Exception("command not found");
            }
            catch (FileNotFoundException e) {
                MyJOptionPane.showMessageDialog(this.app, e.getMessage(), bundle.getString("kfilenotfound"), 1);
                e.printStackTrace();
                HuckelIO.error(this.getClass().getName(), "actionPerformed", "Save file FileNotFoundException");
            }
            catch (AccessControlException e) {
                MyJOptionPane.showMessageDialog(this.app, bundle.getString("kinaccess"), bundle.getString("knotavalaible"), 1);
                e.printStackTrace();
                HuckelIO.error(this.getClass().getName(), "actionPerformed", "Save file AccessControlException");
            }
            catch (Exception e) {
                MyJOptionPane.showMessageDialog(this.app, e.getMessage(), "read file error", 2);
                e.printStackTrace();
                HuckelIO.error(this.getClass().getName(), "actionPerformed", "Save file unknown exception");
            }
        }
    }
}

