/*
 * Decompiled with CFR 0.152.
 */
package util.io;

import controller.globalCommands.SaveMesomeryToXML;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.text.DateFormat;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import javax.imageio.ImageIO;
import javax.swing.JOptionPane;
import org.apache.batik.dom.GenericDOMImplementation;
import org.apache.batik.svggen.SVGGraphics2D;
import org.ctom.hulis.files.gaussian.WriteGaussian;
import org.ctom.hulis.files.gaussian.test.WriteGaussianTest;
import org.ctom.hulis.files.xyz.Writexyz;
import org.ctom.hulis.files.xyz.WritexyzException;
import org.ctom.hulis.huckel.Atom;
import org.ctom.hulis.huckel.HuckelBond;
import org.ctom.hulis.huckel.structures.Structure;
import org.ctom.hulis.util.io.HuckelIO;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import util.MyDecimalFormat;
import util.MyJOptionPane;
import util.MyResourceBundle;
import util.SwingNumberFormater;
import util.languages.LanguageManager;
import views.FrameApp;
import views.StructureView;
import views.prefs.PreferencesGUI;

public class SaveFile {
    private FrameApp app;
    String messageHeader;
    MyResourceBundle bundle;

    public SaveFile(FrameApp app, File file) throws Exception {
        DateFormat f = DateFormat.getDateTimeInstance(0, 0, LanguageManager.getInstance().getLocale());
        this.messageHeader = "File generated by the HuLiS " + app.getVersion() + " code - " + f.format(new Date());
        this.app = app;
        this.bundle = LanguageManager.getInstance().getResource("ActionsApp");
        String type = file.getName().substring(file.getName().lastIndexOf(46) + 1).toLowerCase();
        System.out.println("type " + type);
        HuckelIO.log(this.getClass().getName(), "SaveFile", "file type = " + type);
        if (type.equals("png")) {
            HuckelIO.log(this.getClass().getName(), "SaveFile", "Save png...");
            ImageIO.write((RenderedImage)this.capture(), type, file);
            HuckelIO.log(this.getClass().getName(), "SaveFile", "Save png ok");
        } else if (type.equals("svg")) {
            this.saveSVG(type, file);
        } else if (type.equals("xyz")) {
            this.saveXYZ(type, file);
        } else if (type.equals("com")) {
            this.saveGaussian(type, file);
        } else if (type.equals("tcom")) {
            PrintWriter writer = new PrintWriter(file);
            new WriteGaussianTest(app.getCurrentMesomery()).writeAll(writer);
            writer.close();
        } else if (type.equals("hulis")) {
            this.saveSeralizedFormat(type, file);
        } else if (type.equals("txml")) {
            new SaveMesomeryToXML(app.getCurrentMesomery(), file).execute();
        } else {
            MyJOptionPane.showMessageDialog(null, "Format nnot found", "Error", 0);
        }
    }

    public void saveSeralizedFormat(String type, File file) {
        try {
            FileOutputStream fs = new FileOutputStream(file);
            ObjectOutputStream os = new ObjectOutputStream(fs);
            os.writeObject(this.app.getCurrentMesomery().clone());
            os.close();
        }
        catch (IOException e) {
            e.printStackTrace();
            MyJOptionPane.showMessageDialog(null, e.getMessage(), "Error", 0);
        }
    }

    public void saveXYZ(String type, File file) {
        HuckelIO.log(this.getClass().getName(), "SaveFile", "Save file .xyz");
        try {
            PrintWriter writer = new PrintWriter(file);
            Writexyz ioWritexyz = new Writexyz(this.app.getCurrentMesomery().getDelocalizedStructure());
            ioWritexyz.setMessageHeader(this.messageHeader);
            if (this.app.getCurrentMesomery().getDelocalizedStructure().isGeometryChanged()) {
                ioWritexyz.setWriteInitialOrientation(false);
                JOptionPane.showMessageDialog(this.app, "Cannot restore the initial orientation, the molecule has changed. The molecule will be saved with the new orientation.", "save XYZ", 1);
            } else {
                ioWritexyz.setWriteInitialOrientation(JOptionPane.showConfirmDialog(this.app, this.bundle.getString("kinitialorientation"), "XYZ save file", 0) == 0);
            }
            List<HuckelBond> covRadii = this.app.getCurrentMesomery().getDelocalizedStructure().checkBondsCovalentRaii();
            if (covRadii.size() > 0) {
                JOptionPane.showMessageDialog(this.app, "The geometry is not optimized. Some bonds may have been missed after reading the file in HuLiS : " + covRadii.stream().map(Object::toString).collect(Collectors.joining(", ")), "save XYZ", 1);
            }
            ioWritexyz.writeAll(writer);
            writer.close();
            HuckelIO.log(this.getClass().getName(), "Save " + type, "Save " + type + " ok");
        }
        catch (FileNotFoundException | WritexyzException e) {
            e.printStackTrace();
            MyJOptionPane.showMessageDialog(null, e.getMessage(), "Save" + type, 0);
        }
    }

    public void saveGaussian(String type, File file) {
        HuckelIO.log(this.getClass().getName(), "Save Gaussian", "Save file .com");
        try {
            PrintWriter writer = new PrintWriter(file);
            WriteGaussian ioWriteGaussian = new WriteGaussian(this.app.getCurrentMesomery());
            ioWriteGaussian.setMessageHeader(this.messageHeader);
            if (this.app.getCurrentMesomery().getDelocalizedStructure().isGeometryChanged()) {
                ioWriteGaussian.setWriteInitialOrientation(false);
                JOptionPane.showMessageDialog(this.app, "Cannot restore the initial orientation, the molecule has changed. The molecule will be saved with the new orientation.", this.messageHeader, 1);
            } else {
                ioWriteGaussian.setWriteInitialOrientation(JOptionPane.showConfirmDialog(this.app, this.bundle.getString("kinitialorientation"), "NBO save file", 0) == 0);
            }
            List<HuckelBond> covRadii = this.app.getCurrentMesomery().getDelocalizedStructure().checkBondsCovalentRaii();
            if (covRadii.size() > 0) {
                JOptionPane.showMessageDialog(this.app, "The geometry is not optimized. Some bonds may have been missed after reading the file in HuLiS : " + covRadii.stream().map(Object::toString).collect(Collectors.joining(", ")), this.messageHeader, 1);
            }
            ioWriteGaussian.setNumberFormater(new SwingNumberFormater(new MyDecimalFormat(PreferencesGUI.getInstance().getResultsPrecisionMO())));
            ioWriteGaussian.writeAll(writer);
            writer.close();
            HuckelIO.log(this.getClass().getName(), "Save " + type, "Save " + type + " ok");
        }
        catch (FileNotFoundException | WritexyzException e) {
            e.printStackTrace();
            MyJOptionPane.showMessageDialog(null, e.getMessage(), "Save" + type, 0);
        }
    }

    public void saveSVG(String type, File file) {
        try {
            HuckelIO.log(this.getClass().getName(), "SaveFile", "Save" + type);
            DOMImplementation domImpl = GenericDOMImplementation.getDOMImplementation();
            Document document = domImpl.createDocument(null, "svg", null);
            SVGGraphics2D svgGenerator = new SVGGraphics2D(document);
            Structure s = this.app.getCurrentMesomeryView().getCurrentStructure();
            StructureView sw = this.app.getCurrentMesomeryView().getStructureView(s);
            sw.paint(svgGenerator);
            svgGenerator.setSVGCanvasSize(sw.getPreferredSize());
            String useCssStr = System.getProperty("useCss", "true");
            boolean useCss = useCssStr.equalsIgnoreCase("true");
            FileOutputStream fos = new FileOutputStream(file);
            OutputStreamWriter outWriter = new OutputStreamWriter((OutputStream)fos, "UTF-8");
            svgGenerator.stream(outWriter, useCss);
            fos.flush();
            fos.close();
            ((Writer)outWriter).flush();
            ((Writer)outWriter).close();
            System.out.println(String.valueOf(s.getName()) + " has been saved in SVG");
            HuckelIO.log(this.getClass().getName(), "SaveFile", "Save" + type + "ok");
        }
        catch (Exception exc) {
            exc.printStackTrace();
            MyJOptionPane.showMessageDialog(null, exc.getMessage(), "Error", 0);
        }
    }

    private BufferedImage capture() {
        Structure s = this.app.getCurrentMesomeryView().getCurrentStructure();
        StructureView c = this.app.getCurrentMesomeryView().getStructureView(s);
        BufferedImage tampon = new BufferedImage(c.getWidth(), c.getHeight(), 1);
        Graphics2D g = tampon.createGraphics();
        c.paint(g);
        return tampon;
    }

    private int[] getWindow() {
        int[] Extrema = new int[]{-1, -1, 9999, 9999};
        for (Atom atom : this.app.getCurrentMesomeryView().getCurrentStructure().getAtoms()) {
            Extrema[0] = Math.max((int)atom.getX(), Extrema[0]);
            Extrema[1] = Math.max((int)atom.getY(), Extrema[1]);
            Extrema[2] = Math.min((int)atom.getX(), Extrema[2]);
            Extrema[3] = Math.min((int)atom.getY(), Extrema[3]);
        }
        return Extrema;
    }
}

