/*
 * Decompiled with CFR 0.152.
 */
package util.polyCalculator;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Hashtable;
import org.ctom.hulis.polynomes.Polynomial;
import org.ctom.hulis.polynomes.PolynomialSolver;
import org.ctom.hulis.util.math.Complex;
import util.io.SwingIO;
import util.polyCalculator.PolyCalculatorListener;
import util.polyCalculator.view.elements.PolyType;
import util.polyCalculator.view.main.PolyCalculatorView;
import util.polyCalculator.view.main.PolyCalculatorViewListener;

public class PolyCalculator
implements PolyCalculatorViewListener {
    private ArrayList<Polynomial> listPoly = new ArrayList();
    private Hashtable<Polynomial, Double> coeffs = new Hashtable();
    private PolyCalculatorView gui;
    private ArrayList<PolyCalculatorListener> listener = new ArrayList();
    private int nelec = 0;

    public PolyCalculator(int nelec) {
        this.gui = new PolyCalculatorView();
        this.gui.addlistener(this);
        this.addListener(this.gui);
        this.setNelec(nelec);
    }

    private void addListener(PolyCalculatorListener l) {
        this.listener.add(l);
    }

    public void add(double c, Polynomial polynomial) {
        Polynomial pf = this.normalizePoly(polynomial);
        this.listPoly.add(pf);
        this.coeffs.put(pf, c);
        this.addPolyToGui(pf, PolyType.NORMAL);
        this.updateResult();
    }

    private Polynomial normalizePoly(Polynomial polynomial) {
        double aMax = polynomial.getCoefficients()[polynomial.getDegree()];
        Polynomial pf = polynomial.multiply(new Polynomial(new double[]{1.0 / aMax}));
        return pf;
    }

    public void remove(Polynomial pf) {
        this.listPoly.remove(pf);
        this.coeffs.remove(pf);
        this.updateResult();
    }

    private void addPolyToGui(Polynomial pf, PolyType pt) {
        this.gui.add(pf, PolyCalculator.getRoots(pf), pt);
    }

    private void removePolyFromGui(Polynomial pf) {
        this.gui.remove(pf);
    }

    public static Complex[] getRoots(Polynomial pf) {
        PolynomialSolver solver = new PolynomialSolver(pf);
        Object[] array = null;
        try {
            array = solver.getRoots().toArray();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        Complex[] roots = new Complex[array.length];
        int i2 = 0;
        while (i2 < array.length) {
            Complex z = (Complex)array[i2];
            roots[i2] = new Complex(z);
            ++i2;
        }
        return PolyCalculator.sortRoots(roots);
    }

    private static Complex[] sortRoots(Complex[] roots) {
        int n = roots.length;
        double[] realParts = new double[n];
        int i2 = 0;
        Complex[] complexArray = roots;
        int n2 = roots.length;
        int n3 = 0;
        while (n3 < n2) {
            Complex z = complexArray[n3];
            if (z.getImag() != 0.0) {
                SwingIO.PrintIf("At least one root is complex : no ordering possible");
                return roots;
            }
            realParts[i2++] = z.getReal();
            ++n3;
        }
        Arrays.sort(realParts);
        i2 = 0;
        while (i2 < realParts.length) {
            roots[i2] = new Complex(realParts[n - 1 - i2], 0.0);
            ++i2;
        }
        return roots;
    }

    public static void main(String[] args) {
        PolyCalculator pc = new PolyCalculator(4);
        pc.add(1.0, new Polynomial(new double[]{1.0, 0.0, 1.0}));
        pc.add(1.0, new Polynomial(new double[]{2.0, -1.0, 1.0, 0.0, 1.0}));
    }

    @Override
    public void CoeffModifiedinGUI(Polynomial pf, double coeff) {
        this.coeffs.remove(pf);
        this.coeffs.put(pf, coeff);
        this.updateResult();
    }

    private void updateResult() {
        if (this.listPoly.size() == 0) {
            return;
        }
        Polynomial res = new Polynomial(new double[]{0.0});
        for (Polynomial pf : this.listPoly) {
            res = res.add(pf.multiply(new Polynomial(new double[]{this.coeffs.get(pf)})));
        }
        res = this.normalizePoly(res);
        Complex[] roots = PolyCalculator.getRoots(res);
        for (PolyCalculatorListener l : this.listener) {
            l.resultModified(res, roots);
        }
        double tre = this.computeTRE(roots);
        for (PolyCalculatorListener l : this.listener) {
            l.treModified(this.nelec, tre);
        }
    }

    private boolean areAllReal(Complex[] roots) {
        Complex[] complexArray = roots;
        int n = roots.length;
        int n2 = 0;
        while (n2 < n) {
            Complex r = complexArray[n2];
            if (r.getImag() != 0.0) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    private double computeTRE(Complex[] roots) {
        if (!this.areAllReal(roots)) {
            return Double.NaN;
        }
        double tre = 0.0;
        int nPair = this.nelec / 2;
        int nSing = this.nelec % 2;
        int i2 = 0;
        while (i2 < nPair) {
            tre += 2.0 * roots[i2].getReal();
            ++i2;
        }
        return tre += (double)nSing * roots[nPair].getReal();
    }

    public int getNelec() {
        return this.nelec;
    }

    private void setNelec(int nelec) {
        this.nelec = nelec;
        if (this.listPoly.size() > 0) {
            this.updateResult();
        }
    }

    @Override
    public void removePoly(Polynomial pf) {
        this.remove(pf);
    }
}

