/*
 * Decompiled with CFR 0.152.
 */
package util.polyCalculator.view.elements;

import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import javax.swing.AbstractAction;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTextField;
import org.ctom.hulis.polynomes.Polynomial;
import util.polyCalculator.view.elements.PolyTextFieldListener;

public class PolyTextField
extends JTextField {
    private Polynomial pf;
    private ArrayList<PolyTextFieldListener> listeners = new ArrayList();

    public PolyTextField(Polynomial pf) {
        this.setPf(pf);
        this.setEditable(false);
        PolyTextFieldMouseListener ml = new PolyTextFieldMouseListener();
        this.addMouseListener(ml);
    }

    public Polynomial getPf() {
        return this.pf;
    }

    protected void setPf(Polynomial pf) {
        this.pf = pf;
        this.setText(pf.toString());
    }

    public void addlistener(PolyTextFieldListener l) {
        this.listeners.add(l);
    }

    public void removePoly() {
        for (PolyTextFieldListener l : this.listeners) {
            l.removePoly(this.getPf());
        }
    }

    private class PolyTextFieldMouseListener
    implements MouseListener {
        private PolyTextFieldMouseListener() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            this.maybeShowPopup(e);
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            this.maybeShowPopup(e);
        }

        private void maybeShowPopup(MouseEvent e) {
            if (e.isPopupTrigger()) {
                Object o = e.getSource();
                JPopupMenu popup = new JPopupMenu();
                JMenuItem menu = new JMenuItem();
                menu.setAction(new AbstractAction(){

                    @Override
                    public void actionPerformed(ActionEvent arg0) {
                        PolyTextField.this.removePoly();
                    }
                });
                menu.setText("Remove Poly");
                popup.add(menu);
                popup.show(e.getComponent(), e.getX(), e.getY());
            }
        }

        @Override
        public void mouseEntered(MouseEvent arg0) {
        }

        @Override
        public void mouseExited(MouseEvent arg0) {
        }
    }
}

