/*
 * Decompiled with CFR 0.152.
 */
package util.polyCalculator.view.elements;

import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.util.ArrayList;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import org.ctom.hulis.polynomes.Polynomial;
import org.ctom.hulis.util.math.Complex;
import util.polyCalculator.view.elements.CheckBoxPoly;
import util.polyCalculator.view.elements.CheckBoxPolyListener;
import util.polyCalculator.view.elements.CoeffPolySpinner;
import util.polyCalculator.view.elements.CoeffPolySpinnerListener;
import util.polyCalculator.view.elements.PolyTextField;
import util.polyCalculator.view.elements.PolyTextFieldListener;
import util.polyCalculator.view.elements.PolyType;
import util.polyCalculator.view.elements.PolyViewListener;
import util.polyCalculator.view.main.PolyCalculatorView;

public class PolyView
extends JPanel
implements CoeffPolySpinnerListener,
CheckBoxPolyListener,
PolyTextFieldListener {
    public static final int ROOT_WIDTH = 500;
    public static final int POLY_WIDTH = 300;
    public static final int STANDARD_HEIGHT = 60;
    private Polynomial pf;
    double coeff = 1.0;
    private PolyTextField textPoly;
    private JTextField textRoots;
    private CheckBoxPoly checkBoxPoly;
    private JCheckBox cb;
    private Container affichage_coeff;
    private Box box;
    private ArrayList<PolyViewListener> listener = new ArrayList();

    public PolyView(Polynomial pf, Complex[] roots, PolyType pt) {
        this.box = Box.createHorizontalBox();
        this.textPoly = new PolyTextField(pf);
        this.textPoly.addlistener(this);
        this.textRoots = new JTextField();
        this.textRoots.setEditable(false);
        this.cb = new JCheckBox();
        this.checkBoxPoly = new CheckBoxPoly(pf, this.cb);
        this.checkBoxPoly.setListener(this);
        this.setPoly(pf, roots);
        JSpinner sp = new JSpinner(new SpinnerNumberModel(this.coeff, -99.0, 99.0, 0.1));
        Dimension dim = sp.getPreferredSize();
        int h = dim.height;
        int w = dim.width;
        Dimension dim1 = new Dimension(w, 60);
        switch (pt) {
            case NORMAL: {
                this.affichage_coeff = sp;
                sp.setPreferredSize(dim1);
                sp.setMaximumSize(dim1);
                sp.setMinimumSize(dim1);
                new CoeffPolySpinner(pf, sp).setListener(this);
                break;
            }
            case RESULT: {
                this.affichage_coeff = new JTextField("Total");
                this.affichage_coeff.setPreferredSize(dim1);
                ((JTextField)this.affichage_coeff).setEditable(false);
                this.affichage_coeff.setMaximumSize(dim1);
                this.affichage_coeff.setMinimumSize(dim1);
            }
        }
        this.box.add(this.affichage_coeff);
        Dimension dimPoly = new Dimension(300, 60);
        JScrollPane jsp = new JScrollPane();
        jsp.setVerticalScrollBarPolicy(21);
        jsp.setMaximumSize(dimPoly);
        jsp.setMinimumSize(dimPoly);
        jsp.setPreferredSize(dimPoly);
        jsp.setViewportView(this.textPoly);
        this.box.add(jsp);
        Dimension dimRoot = new Dimension(500, 60);
        jsp = new JScrollPane();
        jsp.setVerticalScrollBarPolicy(21);
        jsp.setMaximumSize(dimRoot);
        jsp.setMinimumSize(dimRoot);
        jsp.setPreferredSize(dimRoot);
        jsp.setViewportView(this.textRoots);
        this.box.add(jsp);
        this.box.add(this.cb);
        this.box.add(Box.createHorizontalGlue());
        this.setLayout(new GridLayout(1, 1));
        this.add(this.box);
    }

    public void addlistener(PolyViewListener l) {
        this.listener.add(l);
    }

    public void setPoly(Polynomial pf, Complex[] roots) {
        this.pf = pf;
        this.textPoly.setPf(pf);
        String str = "";
        Complex[] complexArray = roots;
        int n = roots.length;
        int n2 = 0;
        while (n2 < n) {
            Complex r = complexArray[n2];
            str = String.valueOf(str) + PolyCalculatorView.complexFormat.format(r) + " ; ";
            ++n2;
        }
        this.textRoots.setText(str);
    }

    @Override
    public void switchPlot() {
        for (PolyViewListener l : this.listener) {
            l.switchPlot(this.pf);
        }
    }

    @Override
    public void CoeffModified(double coeff) {
        this.coeff = coeff;
        for (PolyViewListener l : this.listener) {
            l.CoeffModified(this.pf, coeff);
        }
    }

    public Polynomial getPolynomial() {
        return this.pf;
    }

    @Override
    public void removePoly(Polynomial pf) {
        for (PolyViewListener pvl : this.listener) {
            pvl.removePoly(pf);
        }
    }
}

