/*
 * Decompiled with CFR 0.152.
 */
package util.polyCalculator.view.main;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.IllegalFormatConversionException;
import javax.swing.Box;
import javax.swing.JFrame;
import javax.swing.JTextField;
import org.ctom.hulis.polynomes.Polynomial;
import org.ctom.hulis.util.math.Complex;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.labels.StandardXYToolTipGenerator;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.StandardXYItemRenderer;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;
import util.polyCalculator.PolyCalculatorListener;
import util.polyCalculator.view.elements.PolyType;
import util.polyCalculator.view.elements.PolyView;
import util.polyCalculator.view.elements.PolyViewListener;
import util.polyCalculator.view.main.ComplexFormat;
import util.polyCalculator.view.main.PolyCalculatorViewListener;

public class PolyCalculatorView
implements PolyCalculatorListener,
PolyViewListener {
    public static final DecimalFormat decimalFormat = new DecimalFormat("0.0000");
    public static final ComplexFormat complexFormat = new ComplexFormat(decimalFormat);
    private Box col;
    private Box lig_poly;
    private Box lig_result;
    private Box lig_TRE;
    private ArrayList<Boolean> plot_tab = new ArrayList();
    private ArrayList<Polynomial> poly_tab = new ArrayList();
    private ArrayList<PolyCalculatorViewListener> listener = new ArrayList();
    private JFrame mainFrame = new JFrame("Poly Calculator");
    private JFrame plotFrame;
    private JTextField treLabel;
    private XYSeriesCollection xyDataset;
    private PolyView polyGuiResult;
    private boolean PLOT_RESULT = false;

    public PolyCalculatorView() {
        this.init();
        this.plotFrame = new JFrame("Plot");
        this.setplotframe();
        this.plotFrame.pack();
        this.add(new Polynomial(new double[]{0.0}), new Complex[]{new Complex(0.0, 0.0)}, PolyType.RESULT);
        this.mainFrame.setVisible(true);
    }

    public void add(Polynomial pf, Complex[] roots, PolyType pt) {
        PolyView pg = new PolyView(pf, roots, pt);
        if (pt == PolyType.RESULT) {
            this.polyGuiResult = pg;
            this.lig_result.add(pg);
        } else {
            this.lig_poly.add(pg);
            this.plot_tab.add(false);
            this.poly_tab.add(pf);
        }
        pg.addlistener(this);
        this.col.setPreferredSize(new Dimension(950, 60 * (this.poly_tab.size() + 1) + 50));
        this.mainFrame.pack();
    }

    public void remove(Polynomial pf) {
        int i2 = 0;
        Component[] componentArray = this.lig_poly.getComponents();
        int n = componentArray.length;
        int n2 = 0;
        while (n2 < n) {
            Component o = componentArray[n2];
            if (o instanceof PolyView) {
                PolyView pv = (PolyView)o;
                if (pv.getPolynomial() == pf) {
                    this.lig_poly.remove(pv);
                    this.poly_tab.remove(pf);
                    this.plot_tab.remove(i2);
                    pv = null;
                    this.updateData2Plot();
                    this.mainFrame.pack();
                }
                ++i2;
            }
            ++n2;
        }
        for (PolyCalculatorViewListener l : this.listener) {
            l.removePoly(pf);
        }
    }

    public void addlistener(PolyCalculatorViewListener gl) {
        this.listener.add(gl);
    }

    @Override
    public void CoeffModified(Polynomial pf, double coeff) {
        for (PolyCalculatorViewListener gl : this.listener) {
            gl.CoeffModifiedinGUI(pf, coeff);
        }
    }

    @Override
    public void switchPlot(Polynomial pf) {
        int i2 = this.poly_tab.indexOf(pf);
        if (i2 == -1) {
            this.PLOT_RESULT = !this.PLOT_RESULT;
        } else {
            this.plot_tab.set(i2, this.plot_tab.get(i2) == false);
        }
        this.updateData2Plot();
    }

    private void updateData2Plot() {
        double x;
        XYSeries series;
        this.xyDataset.removeAllSeries();
        this.plotFrame.setVisible(false);
        int i2 = 0;
        while (i2 < this.poly_tab.size()) {
            if (this.plot_tab.get(i2).booleanValue()) {
                this.plotFrame.setVisible(true);
                series = new XYSeries(Integer.valueOf(i2));
                this.xyDataset.addSeries(series);
                x = -10.0;
                while (x <= 10.0) {
                    series.add(x, this.poly_tab.get(i2).eval(x));
                    x += 0.01;
                }
            }
            ++i2;
        }
        if (this.PLOT_RESULT) {
            this.plotFrame.setVisible(true);
            Polynomial pf = this.polyGuiResult.getPolynomial();
            series = new XYSeries(Integer.valueOf(this.poly_tab.size()));
            this.xyDataset.addSeries(series);
            x = -10.0;
            while (x <= 10.0) {
                series.add(x, pf.eval(x));
                x += 0.01;
            }
        }
    }

    private void init() {
        Container conteneur = this.mainFrame.getContentPane();
        conteneur.removeAll();
        this.lig_poly = Box.createVerticalBox();
        this.lig_result = Box.createVerticalBox();
        this.lig_TRE = Box.createVerticalBox();
        this.treLabel = new JTextField("");
        this.treLabel.setEditable(false);
        this.treLabel.setBorder(null);
        this.lig_TRE.add(this.treLabel);
        this.col = Box.createVerticalBox();
        this.col.setPreferredSize(new Dimension(1000, 400));
        conteneur.add(this.col);
        this.col.add(this.lig_poly);
        this.col.add(this.lig_result);
        this.col.add(this.lig_TRE);
        this.mainFrame.pack();
    }

    private void setplotframe() {
        NumberAxis xaxis = new NumberAxis("x");
        NumberAxis yaxis = new NumberAxis("P(x)");
        StandardXYToolTipGenerator ttg = new StandardXYToolTipGenerator("({1} ; {2})", NumberFormat.getInstance(), NumberFormat.getInstance());
        StandardXYItemRenderer renderer = new StandardXYItemRenderer(2, ttg, null);
        this.xyDataset = new XYSeriesCollection();
        XYPlot plot = new XYPlot(this.xyDataset, xaxis, yaxis, renderer);
        xaxis.setRange(-5.0, 5.0);
        yaxis.setRange(-10.0, 10.0);
        ChartPanel chartpanel = new ChartPanel(new JFreeChart("Polynomes", plot));
        chartpanel.setPreferredSize(new Dimension(600, 400));
        this.plotFrame.add(chartpanel);
    }

    @Override
    public void resultModified(Polynomial pf, Complex[] roots) {
        this.polyGuiResult.setPoly(pf, roots);
        this.updateData2Plot();
    }

    @Override
    public void treModified(int nElec, double tre) {
        try {
            DecimalFormat formatter = new DecimalFormat(".00");
            this.treLabel.setText("Energy for " + nElec + " electrons is " + formatter.format(tre));
        }
        catch (IllegalFormatConversionException e) {
            System.out.println(String.valueOf(nElec) + " " + tre);
            this.treLabel.setText("Impossible to compute TRE : no electron or imaginary roots.");
        }
    }

    @Override
    public void removePoly(Polynomial pf) {
        this.remove(pf);
    }
}

