/*
 * Decompiled with CFR 0.152.
 */
package views;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import util.MyResourceBundle;
import util.io.SwingIO;
import util.languages.LanguageManager;
import views.AboutPanel;
import views.FrameApp;
import views.MyJDialog;
import views.SimpleDialogScrollText;

public class AboutBox
extends MyJDialog
implements ActionListener {
    private static ArrayList<AboutBox> opened = new ArrayList();
    MyResourceBundle bundle;
    private FrameApp app;

    public static List<AboutBox> getOpened() {
        return opened;
    }

    public AboutBox(final FrameApp app) {
        super(JOptionPane.getFrameForComponent(app));
        this.app = app;
        this.bundle = LanguageManager.getInstance().getResource("About");
        int aboutWidth = (Integer)this.bundle.getObject("kaboutWidth");
        int aboutHeight = (Integer)this.bundle.getObject("kaboutHeight");
        this.setLayout(new BorderLayout(15, 15));
        this.setTitle(this.bundle.getString("kabouttitle"));
        this.setResizable(false);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent event) {
                AboutBox.this.setVisible(false);
                AboutBox.this.dispose();
            }
        });
        this.setLayout(new BorderLayout(15, 15));
        AboutPanel bigPanel = new AboutPanel(app, this);
        Container contenu = this.getContentPane();
        JPanel panelButtons = new JPanel();
        panelButtons.setLayout(new FlowLayout());
        JButton btLicence = new JButton(this.bundle.getString("licence"));
        JButton btCredits = new JButton(this.bundle.getString("credits"));
        JButton btClose = new JButton(this.bundle.getString("close"));
        panelButtons.add(btLicence);
        panelButtons.add(btCredits);
        panelButtons.add(btClose);
        btLicence.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MyResourceBundle bdl = LanguageManager.getInstance().getResource("LicenseFrame");
                new SimpleDialogScrollText((JFrame)JOptionPane.getFrameForComponent(app), AboutBox.this.bundle.getString("licencetitle"), (URL)bdl.getObject("license"));
            }
        });
        btCredits.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                new SimpleDialogScrollText((JFrame)JOptionPane.getFrameForComponent(app), AboutBox.this.bundle.getString("creditstitle"), (URL)AboutBox.this.bundle.getObject("creditsfile"));
            }
        });
        btClose.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AboutBox.this.setVisible(false);
                AboutBox.this.dispose();
            }
        });
        contenu.setLayout(new BorderLayout());
        contenu.add((Component)bigPanel, "Center");
        contenu.add((Component)panelButtons, "South");
        this.pack();
        this.setSize(new Dimension(aboutWidth, aboutHeight));
        this.setLocationRelativeTo(app);
        opened.add(this);
    }

    @Override
    public void actionPerformed(ActionEvent newEvent) {
        this.dispose();
    }

    @Override
    public void dispose() {
        SwingIO.log(this.getClass().getName(), "dispose", "close about box");
        opened.remove(this);
        super.dispose();
    }
}

