/*
 * Decompiled with CFR 0.152.
 */
package views;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.Window;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextPane;
import javax.swing.border.LineBorder;
import util.FollowLink;
import util.MyResourceBundle;
import util.languages.LanguageManager;
import views.FrameApp;

public class AboutPanel
extends JPanel {
    protected JTextPane aboutLabel;
    protected JLabel imgLabel;
    MyResourceBundle bundle;
    FrameApp app;

    public AboutPanel(FrameApp app, Window win) {
        this.setLayout(new BorderLayout());
        this.app = app;
        this.bundle = LanguageManager.getInstance().getResource("About");
        String IMG_PATH = this.bundle.getString("kimgpath");
        this.aboutLabel = new JTextPane();
        this.aboutLabel.setContentType("text/html; charset=UTF-8");
        this.aboutLabel.setText(this.getDefaultLabel());
        this.aboutLabel.setEditable(false);
        this.aboutLabel.setAlignmentX(0.0f);
        this.aboutLabel.addHyperlinkListener(new FollowLink(this.aboutLabel));
        ImageIcon im = new ImageIcon(this.getClass().getClassLoader().getResource(IMG_PATH));
        this.imgLabel = new JLabel(im);
        this.imgLabel.setOpaque(false);
        JPanel imgPanel = new JPanel(new GridLayout(1, 1, 0, 0));
        imgPanel.setBackground(Color.WHITE);
        imgPanel.add(this.imgLabel);
        JPanel textPanel = new JPanel(new GridLayout(1, 1, 0, 0));
        textPanel.add(this.aboutLabel);
        this.setBorder(new LineBorder(Color.black));
        this.add((Component)imgPanel, "North");
        this.add((Component)textPanel, "Center");
    }

    public String getDefaultLabel() {
        String HEAD_HTML = this.bundle.getString("kheadhtml");
        String SOFT_NAME = "HuLiS";
        String JDK = String.valueOf(this.bundle.getString("kjdk")) + " " + System.getProperty("java.version");
        String AUTHORS = String.valueOf(this.bundle.getString("kauthors")) + " " + "<a href=\"http://ism2.univ-amu.fr/permanents/GOUDARD.php\" target=\"new\">Nicolas Goudard</a>, <a href=\"http://ism2.univ-amu.fr/permanents/CARISSAN.php\" target=\"new\">Yannick Carissan</a>, <a href=\"http://ism2.univ-amu.fr/permanents/HAGEBAUM-REIGNIER.php\" target=\"new\">Denis Hagebaum-Reignier</a>, <a href=\"http://ism2.univ-amu.fr/permanents/HUMBEL.php\" target=\"new\">St&eacute;phane Humbel</a>";
        String COPYRIGHT = this.bundle.getString("kcopyright");
        String VERSION = this.app.getVersion().toString();
        String VERSION_WARMIGS = "";
        String txtCheckVersion = this.app.getCheckVersionTxt();
        if (!txtCheckVersion.equals("")) {
            VERSION_WARMIGS = String.valueOf(VERSION_WARMIGS) + ". " + txtCheckVersion;
        }
        if (!this.app.getRights().isValidUser()) {
            VERSION_WARMIGS = String.valueOf(VERSION_WARMIGS) + "<br>" + this.bundle.getString("kstarterror2") + " " + (Object)((Object)this.app.getRights().getRejectReason());
            VERSION_WARMIGS = String.valueOf(VERSION_WARMIGS) + "</span>";
        }
        return "<html>" + HEAD_HTML + "<body><br><span class='couleur'>" + SOFT_NAME + " " + VERSION + "</span>" + VERSION_WARMIGS + "<span class='couleur'><br><br>" + this.bundle.getString("kwarmings") + "<br><br>" + AUTHORS + "<br><br>" + JDK + "<br><br></span>" + COPYRIGHT + "</body></html>";
    }
}

