/*
 * Decompiled with CFR 0.152.
 */
package views;

import access.IRightsTest;
import controller.globalCommands.ChangeLanguage;
import java.awt.Font;
import java.awt.Toolkit;
import java.util.Arrays;
import java.util.HashMap;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;
import org.ctom.hulis.huckel.comparators.MethodNameComparator;
import org.ctom.hulis.huckel.methods.IMethod;
import util.MyResourceBundle;
import util.languages.InitResources;
import util.languages.Language;
import util.languages.LanguageManager;
import views.FrameApp;
import views.prefs.PreferencesGUI;

public class AppMenuBar
extends JMenuBar {
    public FrameApp app;
    public JMenu editMenu;
    public JMenu fileMenu;
    public JMenu helpMenu;
    public JMenu languageMenu;
    public JMenu displayMenu;
    private HashMap<String, JMenuItem> itemsMethods;
    public JMenuItem menuAbout;
    public JMenuItem menuLog;
    public JCheckBoxMenuItem menuExp;
    public JMenuItem menuGuide;
    public JMenuItem menuNew;
    public JMenuItem menuOpen;
    public JMenuItem menuPaste;
    public JMenuItem menuPreferences;
    public JMenuItem menuPrintCurrentView;
    public JMenuItem menuQuit;
    public JMenuItem menuRedo;
    public JMenuItem menuSave;
    public JMenuItem menuTutorial0;
    public JMenuItem menuUndo;
    public JMenuItem menuZoomD;
    public JMenuItem menuSinguletTriplet;
    public JMenuItem superMario;
    public JCheckBoxMenuItem menuSwitchNaturalCanonical;
    public JCheckBoxMenuItem menuSwitchDensity;
    public JCheckBoxMenuItem menuOptGeom;
    public JMenuItem menuSinguletCO;
    public JMenuItem menuExcitations;
    public JMenuItem menuBlocs;
    public JMenuItem menuDisplayPolynomes;
    public JMenuItem menuAddPolynome;
    public JMenuItem menuZoomM;
    public JMenuItem menuZoomP;
    public JMenu computeMenu;
    public JMenu tutorialMenu;
    MyResourceBundle bundle;

    public void updateLanguage() {
        this.bundle = LanguageManager.getInstance().getResource("Menu");
        this.fileMenu.setText(this.bundle.getString("mnfile"));
        this.menuOpen.setText(this.bundle.getString("mnopen"));
        this.menuSave.setText(this.bundle.getString("mnsave"));
        this.menuPreferences.setText(this.bundle.getString("mnPreferences"));
        this.menuPrintCurrentView.setText("Print...");
        this.menuQuit.setText(this.bundle.getString("mnquit"));
        this.editMenu.setText(this.bundle.getString("mnedit"));
        this.menuUndo.setText(this.bundle.getString("mnundo"));
        this.menuRedo.setText(this.bundle.getString("mnredo"));
        this.menuPaste.setText(this.bundle.getString("mnpaste"));
        this.displayMenu.setText(this.bundle.getString("mndisplay"));
        this.menuExp.setText(this.bundle.getString("mnexp"));
        this.menuSinguletTriplet.setText(this.bundle.getString("mnmanipspin"));
        this.menuSwitchNaturalCanonical.setText("Nat");
        this.menuSwitchDensity.setText("Density");
        this.menuSinguletCO.setText(this.bundle.getString("mnmanipspinCO"));
        this.menuOptGeom.setText(this.bundle.getString("mnoptgeom"));
        this.menuDisplayPolynomes.setText(this.bundle.getString("mnpolynomes"));
        this.menuExcitations.setText(this.bundle.getString("mnExcitations"));
        this.menuBlocs.setText(this.bundle.getString("mnBlocs"));
        this.menuZoomD.setText(this.bundle.getString("mnzoomd"));
        this.menuZoomP.setText(this.bundle.getString("mnzoomp"));
        this.menuZoomM.setText(this.bundle.getString("mnzoomm"));
        this.computeMenu.setText(this.bundle.getString("mncompute"));
        this.menuAddPolynome.setText(this.bundle.getString("mnaddpolynome"));
        this.tutorialMenu.setText(this.bundle.getString("mntutorials"));
        this.menuTutorial0.setText(this.bundle.getString("mntuto0"));
        this.helpMenu.setText(this.bundle.getString("mnhelp"));
        this.menuGuide.setText(this.bundle.getString("mnguide"));
        this.menuAbout.setText(this.bundle.getString("mnabout"));
        this.menuLog.setText(this.bundle.getString("mnlog"));
        Font btFont = (Font)this.bundle.getObject("mnfont");
        this.fileMenu.setFont(btFont);
        this.menuOpen.setFont(btFont);
        this.menuOpen.setFont(btFont);
        this.menuSave.setFont(btFont);
        this.menuPreferences.setFont(btFont);
        this.menuPrintCurrentView.setFont(btFont);
        this.menuQuit.setFont(btFont);
        this.editMenu.setFont(btFont);
        this.menuUndo.setFont(btFont);
        this.menuRedo.setFont(btFont);
        this.menuPaste.setFont(btFont);
        this.displayMenu.setFont(btFont);
        this.menuExp.setFont(btFont);
        this.menuSinguletTriplet.setFont(btFont);
        this.menuSwitchNaturalCanonical.setFont(btFont);
        this.menuSwitchDensity.setFont(btFont);
        this.menuSinguletCO.setFont(btFont);
        this.menuOptGeom.setFont(btFont);
        this.menuDisplayPolynomes.setFont(btFont);
        this.menuExcitations.setFont(btFont);
        this.menuBlocs.setFont(btFont);
        this.menuZoomD.setFont(btFont);
        this.menuZoomP.setFont(btFont);
        this.menuZoomM.setFont(btFont);
        this.computeMenu.setFont(btFont);
        this.menuAddPolynome.setFont(btFont);
        this.tutorialMenu.setFont(btFont);
        this.menuTutorial0.setFont(btFont);
        this.helpMenu.setFont(btFont);
        this.menuGuide.setFont(btFont);
        this.menuAbout.setFont(btFont);
        this.menuLog.setFont(btFont);
        JMenuItem[] jMenuItemArray = this.getItemsdMethods();
        int n = jMenuItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            JMenuItem item = jMenuItemArray[n2];
            item.setFont(btFont);
            ++n2;
        }
    }

    public AppMenuBar(FrameApp app) {
        this.app = app;
        this.itemsMethods = new HashMap();
        this.bundle = LanguageManager.getInstance().getResource("Menu");
        int defaultShortcutKeyMask = Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();
        this.fileMenu = new JMenu(this.bundle.getString("mnfile"));
        this.menuOpen = new JMenuItem(this.bundle.getString("mnopen"));
        this.menuOpen.setMnemonic(79);
        this.menuOpen.setAccelerator(KeyStroke.getKeyStroke(79, defaultShortcutKeyMask));
        this.menuOpen.setActionCommand("23");
        this.menuSave = new JMenuItem(this.bundle.getString("mnsave"));
        this.menuSave.setMnemonic(83);
        this.menuSave.setAccelerator(KeyStroke.getKeyStroke(83, defaultShortcutKeyMask));
        this.menuSave.setActionCommand("29");
        this.menuPreferences = new JMenuItem(this.bundle.getString("mnPreferences"));
        this.menuPrintCurrentView = new JMenuItem("print");
        this.menuPrintCurrentView.setMnemonic(67);
        this.menuPrintCurrentView.setAccelerator(KeyStroke.getKeyStroke(67, defaultShortcutKeyMask));
        this.menuPrintCurrentView.setActionCommand("38");
        this.menuQuit = new JMenuItem(this.bundle.getString("mnquit"));
        this.menuQuit.setMnemonic(81);
        this.menuQuit.setAccelerator(KeyStroke.getKeyStroke(81, defaultShortcutKeyMask));
        this.editMenu = new JMenu(this.bundle.getString("mnedit"));
        this.menuUndo = new JMenuItem(this.bundle.getString("mnundo"));
        this.menuUndo.setMnemonic(90);
        this.menuUndo.setAccelerator(KeyStroke.getKeyStroke(90, defaultShortcutKeyMask));
        this.menuRedo = new JMenuItem(this.bundle.getString("mnredo"));
        this.menuRedo.setMnemonic(89);
        this.menuRedo.setAccelerator(KeyStroke.getKeyStroke(89, defaultShortcutKeyMask));
        this.menuPaste = new JMenuItem(this.bundle.getString("mnpaste"));
        this.menuPaste.setMnemonic(86);
        this.menuPaste.setAccelerator(KeyStroke.getKeyStroke(86, defaultShortcutKeyMask));
        this.displayMenu = new JMenu(this.bundle.getString("mndisplay"));
        this.menuSinguletTriplet = new JMenuItem(this.bundle.getString("mnmanipspin"));
        this.menuSinguletTriplet.setMnemonic(84);
        this.menuSinguletTriplet.setAccelerator(KeyStroke.getKeyStroke(84, defaultShortcutKeyMask));
        this.superMario = new JMenuItem("Super Mario");
        this.superMario.setMnemonic(44);
        this.superMario.setAccelerator(KeyStroke.getKeyStroke(44, defaultShortcutKeyMask));
        this.menuSwitchNaturalCanonical = new JCheckBoxMenuItem("Nat");
        this.menuSwitchNaturalCanonical.setMnemonic(78);
        this.menuSwitchNaturalCanonical.setAccelerator(KeyStroke.getKeyStroke(78, defaultShortcutKeyMask));
        this.menuSwitchDensity = new JCheckBoxMenuItem("Density");
        this.menuSwitchDensity.setMnemonic(66);
        this.menuSwitchDensity.setAccelerator(KeyStroke.getKeyStroke(66, defaultShortcutKeyMask));
        this.menuOptGeom = new JCheckBoxMenuItem(this.bundle.getString("mnoptgeom"));
        this.menuOptGeom.setMnemonic(87);
        this.menuOptGeom.setAccelerator(KeyStroke.getKeyStroke(87, defaultShortcutKeyMask));
        this.menuOptGeom.setVisible(false);
        this.menuSinguletCO = new JMenuItem(this.bundle.getString("mnmanipspinCO"));
        this.menuSinguletCO.setMnemonic(82);
        this.menuSinguletCO.setAccelerator(KeyStroke.getKeyStroke(82, defaultShortcutKeyMask));
        this.menuDisplayPolynomes = new JCheckBoxMenuItem(this.bundle.getString("mnpolynomes"));
        this.menuExcitations = new JMenuItem(this.bundle.getString("mnExcitations"));
        this.menuBlocs = new JMenuItem(this.bundle.getString("mnBlocs"));
        this.menuZoomD = new JMenuItem(this.bundle.getString("mnzoomd"));
        this.menuZoomD.setMnemonic(68);
        this.menuZoomD.setAccelerator(KeyStroke.getKeyStroke(68, defaultShortcutKeyMask));
        this.menuZoomP = new JMenuItem(this.bundle.getString("mnzoomp"));
        this.menuZoomP.setMnemonic(80);
        this.menuZoomP.setAccelerator(KeyStroke.getKeyStroke(80, defaultShortcutKeyMask));
        this.menuZoomM = new JMenuItem(this.bundle.getString("mnzoomm"));
        this.menuZoomM.setMnemonic(77);
        this.menuZoomM.setAccelerator(KeyStroke.getKeyStroke(77, defaultShortcutKeyMask));
        this.computeMenu = new JMenu(this.bundle.getString("mncompute"));
        this.menuExp = new JCheckBoxMenuItem(this.bundle.getString("mnexp"));
        this.menuAddPolynome = new JMenuItem(this.bundle.getString("mnaddpolynome"));
        this.menuAddPolynome.setMnemonic(82);
        this.menuAddPolynome.setAccelerator(KeyStroke.getKeyStroke(82, 8));
        IMethod[] methods = FrameApp.getImplementedMethods();
        Arrays.sort(methods, new MethodNameComparator());
        IMethod[] iMethodArray = methods;
        int n = methods.length;
        int n2 = 0;
        while (n2 < n) {
            IMethod method = iMethodArray[n2];
            JCheckBoxMenuItem item = new JCheckBoxMenuItem(method.getName());
            this.itemsMethods.put(method.getName(), item);
            ++n2;
        }
        this.tutorialMenu = new JMenu(this.bundle.getString("mntutorials"));
        this.menuTutorial0 = new JMenuItem(this.bundle.getString("mntuto0"));
        this.helpMenu = new JMenu(this.bundle.getString("mnhelp"));
        this.menuGuide = new JMenuItem(this.bundle.getString("mnguide"));
        this.menuAbout = new JMenuItem(this.bundle.getString("mnabout"));
        this.menuLog = new JMenuItem(this.bundle.getString("mnlog"));
        Language language = (Language)this.bundle.getObject("mdefaultlocale");
        this.languageMenu = new JMenu();
        this.languageMenu.setIcon(language.getFlag());
        this.fileMenu.add(this.menuOpen);
        if (app.isExecutedOnInternet()) {
            this.menuOpen.setVisible(false);
        }
        this.fileMenu.add(this.menuSave);
        if (app.isExecutedOnInternet()) {
            this.menuOpen.setVisible(false);
        }
        this.fileMenu.addSeparator();
        this.fileMenu.add(this.menuPreferences);
        this.fileMenu.add(this.menuPrintCurrentView);
        this.fileMenu.add(this.menuQuit);
        this.add(this.fileMenu);
        this.editMenu.add(this.menuUndo);
        this.editMenu.add(this.menuRedo);
        if (!app.isExecutedOnInternet()) {
            this.editMenu.addSeparator();
        }
        this.editMenu.add(this.menuPaste);
        if (app.isExecutedOnInternet()) {
            this.menuPaste.setVisible(false);
        }
        this.add(this.editMenu);
        this.displayMenu.add(this.menuSinguletTriplet);
        this.displayMenu.add(this.menuSwitchNaturalCanonical);
        this.displayMenu.add(this.menuSwitchDensity);
        this.displayMenu.add(this.menuOptGeom);
        this.displayMenu.add(this.menuSinguletCO);
        this.displayMenu.add(this.superMario);
        try {
            PreferencesGUI.setSuperMario(System.getProperty("user.name").equals("yannick"));
            PreferencesGUI.setSuperMario(app.getRights() instanceof IRightsTest || System.getenv("SUPERMARIO").equals("bump"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.superMario.setVisible(PreferencesGUI.getSuperMario());
        this.displayMenu.add(this.menuDisplayPolynomes);
        this.menuDisplayPolynomes.setVisible(false);
        this.menuSinguletTriplet.setVisible(false);
        this.menuSinguletCO.setVisible(false);
        this.displayMenu.add(this.menuExcitations);
        this.menuExcitations.setVisible(false);
        this.displayMenu.add(this.menuBlocs);
        this.displayMenu.addSeparator();
        this.displayMenu.add(this.menuZoomD);
        this.displayMenu.add(this.menuZoomP);
        this.displayMenu.add(this.menuZoomM);
        this.add(this.displayMenu);
        this.computeMenu.add(this.menuExp);
        this.computeMenu.addSeparator();
        this.computeMenu.add(this.menuAddPolynome);
        this.menuAddPolynome.setVisible(false);
        Object[] objectArray = methods;
        int n3 = methods.length;
        n = 0;
        while (n < n3) {
            IMethod method = objectArray[n];
            this.computeMenu.add(this.itemsMethods.get(method.getName()));
            ++n;
        }
        this.add(this.computeMenu);
        this.tutorialMenu.add(this.menuTutorial0);
        this.add(this.tutorialMenu);
        this.helpMenu.add(this.menuGuide);
        this.helpMenu.addSeparator();
        this.helpMenu.add(this.menuLog);
        this.helpMenu.add(this.menuAbout);
        this.add(this.helpMenu);
        objectArray = InitResources.languages;
        n3 = InitResources.languages.length;
        n = 0;
        while (n < n3) {
            Object l = objectArray[n];
            JMenuItem languageItem = new JMenuItem(((Language)l).toString(), ((Language)l).getFlag());
            if (((Language)l).getLocale().getLanguage().equals("ar")) {
                languageItem.setFont((Font)this.bundle.getObject("mnfontAr"));
            } else {
                languageItem.setFont((Font)this.bundle.getObject("mnfont"));
            }
            languageItem.addActionListener(new ChangeLanguage(this.app, (Language)l));
            this.languageMenu.add(languageItem);
            ++n;
        }
        this.add(this.languageMenu);
        this.menuExcitations.setVisible(this.app.isExpertMode());
        this.menuBlocs.setVisible(this.app.isExpertMode());
        this.updateLanguage();
    }

    public JMenuItem getItemMethod(String methodName) {
        return this.itemsMethods.get(methodName);
    }

    public String getMethodNameByItem(JMenuItem item) {
        for (String o : this.itemsMethods.keySet()) {
            if (!this.itemsMethods.get(o).equals(item)) continue;
            return o;
        }
        return null;
    }

    public JMenuItem[] getItemsdMethods() {
        return this.itemsMethods.values().toArray(new JMenuItem[this.itemsMethods.size()]);
    }
}

