/*
 * Decompiled with CFR 0.152.
 */
package views;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.MultipleGradientPaint;
import java.awt.Paint;
import java.awt.RadialGradientPaint;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import org.ctom.hulis.huckel.Atom;
import org.ctom.hulis.huckel.HuckelAtom;
import org.ctom.hulis.huckel.structures.symmetry.Symmetry;
import views.AtomColor;
import views.FrameApp;
import views.StructureView;
import views.prefs.PreferencesGUI;

public class AtomDrawer {
    public static final boolean DISPLAY_INDEX = true;
    public static final Color ATOM_TEXT_NUM_COLOR = Color.MAGENTA;
    public static final Color ATOM_TEXT_HX_COLOR = Color.BLACK;
    public static final Color ATOM_TEXT_CHARGE_COLOR = new Color(0, 128, 0);
    public static final String DELTA_SYMBOL = "\u03b4";
    public static final Color ATOM_NEGATIVE_CHARGE_COLOR = Color.RED;
    public static final Color ATOM_POSITIVE_CHARGE_COLOR = Color.BLUE;
    public static final Color ATOM_RADICAL_R_COLOR = Color.BLACK;
    public static final int DEFAULT_ATOM_RADIUS = 12;
    public static final double DIAMETRE_CHARGE = 12.0;
    public static final double DistXCercleValCharge = 7.0;
    public static final int H_ATOM_RADIUS = 8;
    public static final double ProjXCercleCharge = 2.08;
    public static final double ProjXradR = -1.5;
    public static final double ProjXValCharge = 1.3;
    static final double ProjYCercleCharge = -1.2;
    public static final double ProjYradR = -0.4;
    public static final double ProjYValCharge = -0.4;
    static final double RADR_RADIUS = 3.0;
    public static final String FONT_FAMILY = "Helvetica";
    public static final int FONT_STYLE = 0;
    public static final int FONT_SIZE_INFOS = 14;
    public static final int FONT_SIZE_CHARGE = 14;
    public static final int FONT_SIZE_DELTA = 16;
    public static final double SpaceCercleCharge = 3.0;
    public static final double ProjXAtomSymbol = -6.0;
    public static final double ProjYAtomSymbol = 6.0;
    public static final Stroke STROKE_ATOM_SYMBOL = new BasicStroke(1.0f);
    private static final Color COLOR_ATOM_SYMBOL = Color.BLACK;
    private static final double FONT_SIZE_ATOM_SYMBOL = 18.0;
    protected Atom atom;
    protected double ProjAtomXInfo = 1.3;
    protected double ProjAtomYInfo = 1.2;
    private final StructureView structureView;
    private Shape atomShape = null;
    private Shape lightShape = null;
    Color atomBorderColor = null;
    Color atomFillColor = null;
    AtomColor atomColor;
    double atomRadius = 0.0;
    String symbol;
    private boolean toHighlight;
    static String[] ColourValues = new String[]{"FF0000", "00FF00", "0000FF", "FFFF00", "FF00FF", "00FFFF", "000000", "800000", "008000", "000080", "808000", "800080", "008080", "808080", "C00000", "00C000", "0000C0", "C0C000", "C000C0", "00C0C0", "C0C0C0", "400000", "004000", "000040", "404000", "400040", "004040", "404040", "200000", "002000", "000020", "202000", "200020", "002020", "202020", "600000", "006000", "000060", "606000", "600060", "006060", "606060", "A00000", "00A000", "0000A0", "A0A000", "A000A0", "00A0A0", "A0A0A0", "E00000", "00E000", "0000E0", "E0E000", "E000E0", "00E0E0", "E0E0E0"};

    protected AtomDrawer(StructureView structureView, Atom atom) {
        this.structureView = structureView;
        this.atom = atom;
        PreferencesGUI.setSHOWSYMMETRY(PreferencesGUI.getSuperMario());
        if (PreferencesGUI.isSHOWSYMMETRY() && atom instanceof HuckelAtom) {
            int num = ((HuckelAtom)atom).getSeqNum() - 1;
            if (structureView.getAtomsToHighlight().contains(num)) {
                this.toHighlight = true;
            }
        }
        try {
            this.atomColor = AtomColor.valueOf(this.atom.getSigle());
            this.atomRadius = this.atomColor.getRadius();
            this.atomBorderColor = this.atomColor.getBorderColor();
            if (this.toHighlight) {
                this.atomBorderColor = new Color(255, 255, 0);
                this.atomRadius = 1.5 * (double)this.atomColor.getRadius();
            }
            this.atomFillColor = this.atomColor.getFillcolor();
            this.symbol = this.atom.getElement() == null ? this.atom.getSigle() : this.atom.getElement().toString();
        }
        catch (IllegalArgumentException e) {
            this.atomColor = AtomColor.Xx;
            this.atomRadius = this.atomColor.getRadius();
            this.atomBorderColor = this.atomColor.getBorderColor();
            this.atomFillColor = this.atomColor.getFillcolor();
            this.symbol = this.atom.getSigle();
        }
    }

    protected void draw(Graphics2D g2d) {
        HuckelAtom hAt;
        Font fontI;
        double yTemp;
        double xTemp;
        double zoom = this.structureView.getZoom();
        double decalageSymbol = 0.0;
        if (this.symbol.length() > 2) {
            decalageSymbol = (double)((this.symbol.length() - 1) * 8) * zoom;
        }
        double projXAtomSymbol = -6.0 * zoom;
        double projYAtomSymbol = 6.0 * zoom;
        double projYradR = -0.4 * zoom * this.atomRadius;
        double projXradR = -1.5 * zoom * this.atomRadius;
        double radR_RADIUS = 3.0 * zoom;
        double projXValCharge = 1.3 * zoom * this.atomRadius + decalageSymbol;
        double projYValCharge = -0.4 * zoom * this.atomRadius;
        double projXCercleCharge = 2.08 * zoom * this.atomRadius + decalageSymbol;
        double projYCercleCharge = -1.2 * zoom * this.atomRadius;
        double diametreCharge = 12.0 * zoom;
        double spaceCercleCharge = 3.0 * zoom;
        double distXCercleValCharge = 7.0;
        boolean isAtomInOverFlightBloc = false;
        boolean isAtomInSelectedBloc = false;
        if (this.atom instanceof HuckelAtom) {
            HuckelAtom huckelAtom = (HuckelAtom)this.atom;
            if (huckelAtom.getBlocDelocalizedParent() == StructureView.getSelectedBlocDelocalized() && StructureView.getSelectedBlocDelocalized() != null) {
                isAtomInSelectedBloc = true;
            } else if (huckelAtom.getBlocDelocalizedParent() == this.structureView.getOverflightBlocDelocalized() && this.structureView.getOverflightBlocDelocalized() != null) {
                isAtomInOverFlightBloc = true;
            }
        }
        g2d.setStroke(new BasicStroke(1.0f));
        if (isAtomInOverFlightBloc) {
            g2d.setColor(StructureView.OVERFLIGHT_BLOC_DELOCALIZED_COLOR);
        } else if (PreferencesGUI.getInstance().isDisplayAtomsCircles()) {
            g2d.setColor(this.atomBorderColor);
        } else {
            g2d.setColor(this.structureView.getBackground());
        }
        g2d.draw(this.getForm());
        if (isAtomInOverFlightBloc) {
            g2d.setColor(StructureView.OVERFLIGHT_BLOC_DELOCALIZED_COLOR);
        } else if (PreferencesGUI.getInstance().isDisplayAtomsCircles()) {
            g2d.setColor(this.atomFillColor);
        } else {
            g2d.setColor(this.structureView.getBackground());
        }
        g2d.fill(this.getForm());
        if (PreferencesGUI.getSuperMario()) {
            this.draw3d(g2d);
        }
        Point2D atomLocation = this.structureView.getImagePoint(this.structureView.getPoint2D(this.atom.getLocation()));
        if (PreferencesGUI.getInstance().isDisplayAtomsSymbols()) {
            xTemp = atomLocation.getX() + projXAtomSymbol - (double)this.symbol.length() * zoom / 2.0;
            yTemp = atomLocation.getY() + projYAtomSymbol - (double)this.symbol.length() * zoom / 2.0;
            Font fontAtom = new Font(FONT_FAMILY, 0, (int)(18.0 * (this.structureView.getZoom() % 5.0)));
            g2d.setFont(fontAtom);
            g2d.setStroke(STROKE_ATOM_SYMBOL);
            g2d.setColor(COLOR_ATOM_SYMBOL);
            g2d.drawString(this.symbol, (int)xTemp, (int)yTemp);
        }
        if (isAtomInSelectedBloc) {
            g2d.setStroke(new BasicStroke(2.0f));
            g2d.setColor(StructureView.SELECTED_BLOC_DELOCALIZED_COLOR);
            Point2D location = this.structureView.getImagePoint(new Point2D.Double(this.atom.getX() - this.atomRadius, this.atom.getY() - this.atomRadius));
            g2d.draw(new Rectangle2D.Double(location.getX(), location.getY(), 2.0 * this.atomRadius * zoom, 2.0 * this.atomRadius * zoom));
        }
        int charge = this.atom.getCharge();
        int absCharge = Math.abs(charge);
        String txtCharge = Integer.toString(absCharge);
        boolean isDisplayDelta = false;
        if (this.atom instanceof HuckelAtom && ((HuckelAtom)this.atom).getBlocDelocalizedParent() != null) {
            isDisplayDelta = true;
        }
        g2d.setStroke(new BasicStroke(1.0f));
        if (isDisplayDelta) {
            xTemp = atomLocation.getX() + projXValCharge;
            yTemp = atomLocation.getY() + projYValCharge;
            g2d.setColor(StructureView.SELECTED_BLOC_DELOCALIZED_COLOR);
            fontI = new Font(FONT_FAMILY, 0, (int)(16.0 * (this.structureView.getZoom() % 5.0)));
            g2d.setFont(fontI);
            g2d.drawString(DELTA_SYMBOL, (int)xTemp, (int)yTemp);
        } else if (charge != 0) {
            xTemp = absCharge != 1 ? atomLocation.getX() + projXCercleCharge + distXCercleValCharge * (double)(txtCharge.length() - 1) : atomLocation.getX() + projXValCharge;
            yTemp = atomLocation.getY() + projYCercleCharge;
            g2d.setStroke(new BasicStroke(1.0f));
            if (charge > 0) {
                g2d.setColor(ATOM_POSITIVE_CHARGE_COLOR);
                g2d.draw(new Line2D.Double(xTemp + diametreCharge / 2.0, yTemp + spaceCercleCharge, xTemp + diametreCharge / 2.0, yTemp + diametreCharge - spaceCercleCharge));
            } else {
                g2d.setColor(ATOM_NEGATIVE_CHARGE_COLOR);
            }
            g2d.draw(new Line2D.Double(xTemp + spaceCercleCharge, yTemp + diametreCharge / 2.0, xTemp + diametreCharge - spaceCercleCharge, yTemp + diametreCharge / 2.0));
            g2d.draw(new Ellipse2D.Double(xTemp, yTemp, diametreCharge, diametreCharge));
            if (absCharge != 1) {
                xTemp = atomLocation.getX() + projXValCharge;
                yTemp = atomLocation.getY() + projYValCharge;
                fontI = new Font(FONT_FAMILY, 0, (int)(14.0 * (this.structureView.getZoom() % 5.0)));
                g2d.setFont(fontI);
                g2d.drawString(txtCharge, (int)xTemp, (int)yTemp);
            }
        }
        g2d.setColor(ATOM_RADICAL_R_COLOR);
        if (this.atom instanceof HuckelAtom && (hAt = (HuckelAtom)this.atom).countRadR() > 0) {
            Ellipse2D.Double rad1 = new Ellipse2D.Double(atomLocation.getX() - radR_RADIUS + projXradR, atomLocation.getY() - radR_RADIUS + projYradR, 2.0 * radR_RADIUS, 2.0 * radR_RADIUS);
            g2d.fill(rad1);
            if (hAt.countRadR() == 2) {
                Ellipse2D.Double rad2 = new Ellipse2D.Double(atomLocation.getX() - radR_RADIUS + projXradR, atomLocation.getY() - radR_RADIUS - projYradR, 2.0 * radR_RADIUS, 2.0 * radR_RADIUS);
                g2d.fill(rad2);
            }
        }
    }

    protected Shape getForm() {
        if (this.atomShape != null) {
            return this.atomShape;
        }
        double radius = this.structureView.getZoom() * this.atomRadius;
        Point2D p = this.structureView.getImagePoint(new Point2D.Double(this.atom.getX(), this.atom.getY()));
        this.atomShape = new Ellipse2D.Double(p.getX() - radius, p.getY() - radius, 2.0 * radius, 2.0 * radius);
        return this.atomShape;
    }

    protected Shape getLightShape() {
        if (this.lightShape != null) {
            return this.lightShape;
        }
        double radius = this.structureView.getZoom() * this.atomRadius;
        Point2D p = this.structureView.getImagePoint(new Point2D.Double(this.atom.getX(), this.atom.getY()));
        this.lightShape = new Ellipse2D.Double(p.getX() - (radius *= 0.9), p.getY() - radius, 2.0 * radius, 2.0 * radius);
        return this.lightShape;
    }

    private void draw3d(Graphics2D g2d) {
        Color fillColor = this.getColorSymmetry();
        Paint paintInit = g2d.getPaint();
        Composite compInit = g2d.getComposite();
        Color backgroundColor = this.structureView.getBackground();
        g2d.setColor(backgroundColor);
        g2d.setStroke(new BasicStroke(1.0f));
        g2d.draw(this.getForm());
        g2d.fill(this.getForm());
        Graphics2D g2 = g2d;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.setColor(fillColor);
        g2d.fill(this.getForm());
        double radius = this.structureView.getZoom() * this.atomRadius;
        Point2D pt = this.structureView.getImagePoint(new Point2D.Double(this.atom.getX(), this.atom.getY()));
        GradientPaint gp = new GradientPaint((float)(pt.getX() - radius), (float)(pt.getY() - radius), new Color(0.0f, 0.0f, 0.0f, 0.4f), (float)(pt.getX() + radius), (float)(pt.getY() + radius), new Color(0.0f, 0.0f, 0.0f, 0.0f));
        g2.setPaint(gp);
        g2d.fill(this.getForm());
        gp = new GradientPaint((float)(pt.getX() - radius), (float)(pt.getY() - radius), new Color(1.0f, 1.0f, 1.0f, 0.0f), (float)(pt.getX() + radius), (float)(pt.getY() + radius), new Color(1.0f, 1.0f, 1.0f, 0.4f));
        g2.setPaint(gp);
        g2d.fill(this.getForm());
        RadialGradientPaint rgp = new RadialGradientPaint(pt, (float)(2.0 * radius), new float[]{0.0f, 1.0f}, new Color[]{new Color(6, 76, 160, 127), new Color(0.0f, 0.0f, 0.0f, 0.8f)});
        g2.setPaint(rgp);
        g2d.fill(this.getForm());
        rgp = new RadialGradientPaint(new Point2D.Double(pt.getX(), pt.getY() + radius * 0.5), (float)radius / 2.3f, new Point2D.Double(pt.getX(), pt.getY() + 0.75 * radius + 0.0), new float[]{0.0f, 0.8f}, new Color[]{new Color(fillColor.getRed(), fillColor.getGreen(), fillColor.getBlue(), 255), new Color(fillColor.getRed(), fillColor.getGreen(), fillColor.getBlue(), 0)}, MultipleGradientPaint.CycleMethod.NO_CYCLE, MultipleGradientPaint.ColorSpaceType.SRGB, AffineTransform.getScaleInstance(1.0, 1.0));
        g2.setPaint(rgp);
        g2d.fill(this.getForm());
        rgp = new RadialGradientPaint(new Point2D.Double(pt.getX(), pt.getY()), (float)radius / 1.4f, new Point2D.Double(45.0, 25.0), new float[]{0.0f, 0.5f}, new Color[]{new Color(1.0f, 1.0f, 1.0f, 0.4f), new Color(1.0f, 1.0f, 1.0f, 0.0f)}, MultipleGradientPaint.CycleMethod.NO_CYCLE);
        g2.setPaint(rgp);
        g2d.fill(this.getForm());
        g2d.setComposite(compInit);
        g2d.setPaint(paintInit);
    }

    private Color getColorSymmetry() {
        Symmetry sym = this.structureView.getSymmetry();
        int num = sym.getAtomGroupNumber(this.atom);
        Color color = Color.decode("#" + ColourValues[num]);
        return color;
    }

    private void applySymmetry(Graphics2D g2d) {
        Symmetry sym = this.structureView.getSymmetry();
        int num = sym.getAtomGroupNumber(this.atom);
        int tot = sym.getTotalNumberOfGroups();
        if (num != 0) {
            g2d.setColor(Color.blue);
            g2d.setComposite(AlphaComposite.getInstance(3, (float)num * 1.0f / (float)tot));
        }
    }

    private GradientPaint getLight() {
        double radius = this.structureView.getZoom() * this.atomRadius;
        Point2D p = this.structureView.getImagePoint(new Point2D.Double(this.atom.getX(), this.atom.getY()));
        GradientPaint gp = new GradientPaint((float)(p.getX() - radius), (float)(p.getY() - radius), Color.white, (float)(p.getX() + radius), (float)(p.getY() + radius), Color.yellow);
        return gp;
    }

    public boolean isContained(Point2D p) {
        return this.getForm().contains(p);
    }

    public void writeInfos(Graphics2D g2d) {
        g2d.setStroke(new BasicStroke(1.0f));
        Font fontI = new Font(FONT_FAMILY, 0, (int)(14.0 * (this.structureView.getZoom() % 5.0)));
        g2d.setFont(fontI);
        double projXInfo = this.structureView.getZoom() * this.atomRadius * this.ProjAtomXInfo;
        double projYInfo = this.structureView.getZoom() * this.atomRadius * this.ProjAtomYInfo;
        Point2D infoLocation = this.structureView.getImagePoint(this.structureView.getPoint2D(this.atom.getLocation()));
        int x = (int)(infoLocation.getX() + projXInfo);
        int y = (int)(infoLocation.getY() + projYInfo);
        String txtNum = "";
        String txtSigle = "";
        String txtHx = "";
        String txtChargeDensity = "";
        if (this.atom instanceof HuckelAtom) {
            HuckelAtom hAt = (HuckelAtom)this.atom;
            if (this.structureView.isDisplayNum() || !this.structureView.getStructure().areCorrectAtomsSeqNum()) {
                txtNum = String.valueOf(Integer.toString(hAt.getSeqNum())) + " ";
            }
            if (this.structureView.isDisplayHxHxy()) {
                txtSigle = hAt.getSigle();
                txtHx = ": hX=" + hAt.getHx();
            }
            if (this.structureView.isDisplayCharges()) {
                if (txtHx != "") {
                    txtChargeDensity = String.valueOf(txtChargeDensity) + " ; ";
                } else {
                    txtHx = String.valueOf(txtHx) + this.atom.getSigle() + ": ";
                }
                txtChargeDensity = String.valueOf(txtChargeDensity) + "q=" + FrameApp.form.format(hAt.getDensity());
            }
        }
        FontMetrics metrics = this.structureView.getFontMetrics(g2d.getFont());
        g2d.setColor(Color.BLACK);
        String txtIndex = String.valueOf(Integer.toString(this.atom.getIndex())) + " ";
        g2d.drawString(txtIndex, x, y);
        g2d.setColor(ATOM_TEXT_NUM_COLOR);
        g2d.drawString(String.valueOf(txtNum) + txtSigle, x += metrics.stringWidth(txtIndex), y);
        g2d.setColor(ATOM_TEXT_HX_COLOR);
        g2d.drawString(txtHx, x += metrics.stringWidth(String.valueOf(txtNum) + txtSigle), y);
        g2d.setColor(ATOM_TEXT_CHARGE_COLOR);
        g2d.drawString(txtChargeDensity, x += metrics.stringWidth(txtHx), y);
    }
}

