/*
 * Decompiled with CFR 0.152.
 */
package views;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.RadialGradientPaint;
import java.awt.Shape;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import org.ctom.hulis.huckel.Bond;
import org.ctom.hulis.huckel.HuckelBond;
import org.ctom.hulis.huckel.structures.Structure;
import org.ctom.hulis.huckel.structures.StructureDelocalized;
import org.ctom.hulis.huckel.structures.StructureLocalized;
import views.FrameApp;
import views.StructureView;
import views.prefs.PreferencesGUI;

public class BondDrawer {
    public static final Color BOND_COLOR = Color.LIGHT_GRAY;
    public static final Color BOND_TEXT_HXY_COLOR = Color.BLACK;
    public static final Color BOND_TEXT_BOND_ORDER_COLOR = new Color(0, 128, 0);
    public static final Color BOND_INFOS_COLOR2 = new Color(150, 75, 0);
    public static final float BOND_LINE_STROKE = 3.0f;
    public static final int BOND_MOUSE_SENSIBILITY = 16;
    public static final String FONT_FAMILY = "Helvetica";
    public static final int FONT_STYLE = 0;
    public static final int FONT_SIZE_INFOS = 14;
    float MAX_TAILLE_POINTILLES = 6.5f;
    private Bond bond;
    private Shape form;
    private Line2D line1;
    private Line2D line2;
    private BondForm bondForm;
    private final StructureView structureView;

    protected BondDrawer(StructureView structureView, Bond bond) {
        this.structureView = structureView;
        this.bond = bond;
        this.form = this.getForm();
    }

    protected void draw(Graphics2D g2d) {
        float bondLineStroke = 3.0f * (float)this.structureView.getZoom();
        if (this.bond instanceof HuckelBond) {
            HuckelBond huckelBond = (HuckelBond)this.bond;
            if (huckelBond.getBlocDelocalizedParent() == StructureView.getSelectedBlocDelocalized() && StructureView.getSelectedBlocDelocalized() != null) {
                g2d.setColor(StructureView.SELECTED_BLOC_DELOCALIZED_COLOR);
            } else if (huckelBond.getBlocDelocalizedParent() == this.structureView.getOverflightBlocDelocalized() && this.structureView.getOverflightBlocDelocalized() != null) {
                g2d.setColor(StructureView.OVERFLIGHT_BLOC_DELOCALIZED_COLOR);
            } else {
                g2d.setColor(BOND_COLOR);
            }
        } else {
            g2d.setColor(BOND_COLOR);
        }
        switch (this.bondForm) {
            case BROKEN_DOUBLE_LINE: {
                RadialGradientPaint rgp;
                Color[] colors;
                float[] dist;
                float radius;
                Point2D.Float center;
                float taille_pointille = 0.0f;
                if (this.bond instanceof HuckelBond && ((Structure)this.bond.getMoleculeContainer()).isEnabledFlyCalculate()) {
                    double bondorder = Math.abs(((HuckelBond)this.bond).getBondOrder());
                    taille_pointille = (float)bondorder * this.MAX_TAILLE_POINTILLES;
                } else {
                    taille_pointille = this.MAX_TAILLE_POINTILLES / 2.0f;
                }
                if (taille_pointille > this.MAX_TAILLE_POINTILLES) {
                    taille_pointille = this.MAX_TAILLE_POINTILLES;
                }
                float[] style = new float[]{taille_pointille, this.MAX_TAILLE_POINTILLES - taille_pointille};
                g2d.setStroke(new BasicStroke(bondLineStroke));
                Paint p = g2d.getPaint();
                if (PreferencesGUI.getSuperMario()) {
                    center = new Point2D.Float((float)this.line1.getBounds().getCenterX(), (float)this.line1.getBounds().getCenterY());
                    radius = (float)(this.line1.getP1().distance(this.line1.getP2()) * 0.5);
                    dist = new float[]{0.0f, 1.0f};
                    colors = new Color[]{Color.yellow, Color.lightGray};
                    rgp = new RadialGradientPaint(center, radius, dist, colors);
                    g2d.setPaint(rgp);
                }
                g2d.draw(this.line1);
                g2d.setPaint(p);
                g2d.setStroke(new BasicStroke(bondLineStroke, 0, 0, 10.0f, style, 0.0f));
                if (PreferencesGUI.getSuperMario()) {
                    center = new Point2D.Float((float)this.line1.getBounds().getCenterX(), (float)this.line1.getBounds().getCenterY());
                    radius = (float)(this.line1.getP1().distance(this.line1.getP2()) * 0.5);
                    dist = new float[]{0.0f, 1.0f};
                    colors = new Color[]{Color.lightGray, Color.yellow};
                    rgp = new RadialGradientPaint(center, radius, dist, colors);
                    g2d.setPaint(rgp);
                }
                g2d.draw(this.line2);
                g2d.setPaint(p);
                break;
            }
            case FULL_SIMPLE_LINE: {
                g2d.setStroke(new BasicStroke(bondLineStroke));
                g2d.draw(this.line1);
                break;
            }
            case FULL_DOUBLE_LINE: {
                g2d.setStroke(new BasicStroke(bondLineStroke));
                g2d.draw(this.line1);
                g2d.draw(this.line2);
            }
        }
    }

    protected Shape getForm() {
        double dX = this.bond.getAtom2().getX() - this.bond.getAtom1().getX();
        double dY = this.bond.getAtom2().getY() - this.bond.getAtom1().getY();
        double hyp = Math.sqrt(dX * dX + dY * dY);
        double ecartCentreAtome = 1.0;
        if (this.bond instanceof HuckelBond) {
            switch (((HuckelBond)this.bond).getBondType()) {
                case 1: {
                    if (this.bond.getMoleculeContainer() instanceof StructureDelocalized) {
                        ecartCentreAtome = 4.0 * this.structureView.getZoom();
                        break;
                    }
                }
                case 2: {
                    ecartCentreAtome = 4.0 * this.structureView.getZoom();
                }
            }
        }
        double projX = 0.0;
        double projY = 0.0;
        if (hyp != 0.0) {
            projX = ecartCentreAtome * (dX / hyp * Math.cos(1.5707963267948966) + dY / hyp * Math.sin(1.5707963267948966));
            projY = ecartCentreAtome * (dY / hyp * Math.cos(1.5707963267948966) - dX / hyp * Math.sin(1.5707963267948966));
        }
        Point2D atom1Location = this.structureView.getImagePoint(this.structureView.getPoint2D(this.bond.getAtom1().getLocation()));
        Point2D atom2Location = this.structureView.getImagePoint(this.structureView.getPoint2D(this.bond.getAtom2().getLocation()));
        Point2D.Double a11 = new Point2D.Double((int)(atom1Location.getX() + projX), (int)(atom1Location.getY() + projY));
        Point2D.Double a12 = new Point2D.Double((int)(atom2Location.getX() + projX), (int)(atom2Location.getY() + projY));
        if (hyp != 0.0) {
            projX = ecartCentreAtome * (dX / hyp * Math.cos(1.5707963267948966) - dY / hyp * Math.sin(1.5707963267948966));
            projY = ecartCentreAtome * (dY / hyp * Math.cos(1.5707963267948966) + dX / hyp * Math.sin(1.5707963267948966));
        }
        Point2D.Double a21 = new Point2D.Double((int)(atom1Location.getX() + projX), (int)(atom1Location.getY() + projY));
        Point2D.Double a22 = new Point2D.Double((int)(atom2Location.getX() + projX), (int)(atom2Location.getY() + projY));
        GeneralPath path = new GeneralPath();
        if (this.bond instanceof HuckelBond) {
            switch (((HuckelBond)this.bond).getBondType()) {
                case 1: {
                    boolean isHuckelBondinBlocDelocalized = false;
                    if (this.bond instanceof HuckelBond && ((HuckelBond)this.bond).getBlocDelocalizedParent() != null) {
                        isHuckelBondinBlocDelocalized = true;
                    }
                    if (this.bond.getMoleculeContainer() instanceof StructureLocalized && !isHuckelBondinBlocDelocalized) {
                        this.line1 = new Line2D.Double(atom1Location.getX(), atom1Location.getY(), atom2Location.getX(), atom2Location.getY());
                        path.append(this.line1, false);
                        this.line2 = null;
                        this.bondForm = BondForm.FULL_SIMPLE_LINE;
                        break;
                    }
                    this.line1 = new Line2D.Double(a11, a12);
                    path.append(this.line1, false);
                    this.line2 = new Line2D.Double(a21, a22);
                    path.append(this.line2, false);
                    this.bondForm = BondForm.BROKEN_DOUBLE_LINE;
                    break;
                }
                case 2: {
                    this.line1 = new Line2D.Double(a11, a12);
                    path.append(this.line1, false);
                    this.line2 = new Line2D.Double(a21, a22);
                    path.append(this.line2, false);
                    this.bondForm = BondForm.FULL_DOUBLE_LINE;
                }
            }
        } else {
            this.line1 = new Line2D.Double(atom1Location.getX(), atom1Location.getY(), atom2Location.getX(), atom2Location.getY());
            path.append(this.line1, false);
            this.line2 = null;
            this.bondForm = BondForm.FULL_SIMPLE_LINE;
        }
        path.closePath();
        return path;
    }

    protected Line2D getLine1() {
        return this.line1;
    }

    protected Line2D getLine2() {
        return this.line2;
    }

    public boolean isContained(Point2D p) {
        if (p == null) {
            return false;
        }
        double bondSensibility = 16.0 * this.structureView.getZoom();
        Rectangle2D.Double r = new Rectangle2D.Double(p.getX() - bondSensibility / 2.0, p.getY() - bondSensibility / 2.0, bondSensibility, bondSensibility);
        return this.form.intersects(r);
    }

    public void writeInfos(Graphics2D g2d) {
        double zoom = this.structureView.getZoom();
        double x = 0.0;
        double y = 0.0;
        String txtHxy = "";
        String txtCharge = "";
        Font fontI = new Font(FONT_FAMILY, 0, (int)(14.0 * (zoom % 5.0)));
        g2d.setFont(fontI);
        double bondLineSroke = 3.0 * this.structureView.getZoom();
        HuckelBond bond2 = null;
        if (this.bond instanceof HuckelBond) {
            bond2 = (HuckelBond)this.bond;
            Point2D infoLocation = this.structureView.getImagePoint(new Point2D.Double((this.bond.getAtom1().getX() + this.bond.getAtom2().getX()) / 2.0, (this.bond.getAtom1().getY() + this.bond.getAtom2().getY()) / 2.0));
            x = infoLocation.getX() + bondLineSroke;
            y = infoLocation.getY() - bondLineSroke;
            if (this.structureView.isDisplayHxHxy()) {
                g2d.setColor(BOND_TEXT_HXY_COLOR);
                txtHxy = "hXY=" + bond2.getHxy();
            }
            g2d.drawString(txtHxy, (int)x, (int)y);
            if (this.structureView.isDisplayCharges()) {
                g2d.setColor(BOND_TEXT_BOND_ORDER_COLOR);
                txtCharge = "I=" + FrameApp.form.format(bond2.getBondOrder());
            }
            FontMetrics metrics = this.structureView.getFontMetrics(g2d.getFont());
            g2d.drawString(txtCharge, (int)(x += (double)metrics.stringWidth(String.valueOf(txtHxy) + " ")), (int)y);
        }
    }

    static enum BondForm {
        BROKEN_DOUBLE_LINE,
        FULL_SIMPLE_LINE,
        FULL_DOUBLE_LINE;

    }
}

