/*
 * Decompiled with CFR 0.152.
 */
package views;

import java.applet.AppletStub;
import java.awt.Component;
import java.awt.Container;
import java.net.URL;
import javax.jnlp.DownloadServiceListener;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import netscape.javascript.JSObject;

public class CustomProgress
implements DownloadServiceListener {
    Container surfaceContainer = null;
    AppletStub appletStub = null;
    JProgressBar progressBar = null;
    JLabel statusLabel = null;
    boolean uiCreated = false;

    public CustomProgress(Object surface) {
        this.init(surface, null);
    }

    public CustomProgress(Object surface, Object stub) {
        this.init(surface, stub);
    }

    public void init(Object surface, Object stub) {
        try {
            this.surfaceContainer = (Container)surface;
            this.appletStub = (AppletStub)stub;
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
    }

    @Override
    public void downloadFailed(URL url, String version) {
    }

    @Override
    public void progress(URL url, String version, long readSoFar, long total, int overallPercent) {
        this.updateProgressUI(overallPercent);
    }

    @Override
    public void upgradingArchive(URL url, String version, int patchPercent, int overallPercent) {
        this.updateProgressUI(overallPercent);
    }

    @Override
    public void validating(URL url, String version, long entry, long total, int overallPercent) {
        this.updateProgressUI(overallPercent);
    }

    private void updateProgressUI(int overallPercent) {
        if (!this.uiCreated && overallPercent > 0 && overallPercent < 100) {
            this.create();
            this.uiCreated = true;
        }
        if (this.uiCreated) {
            this.progressBar.setValue(overallPercent);
        }
    }

    private void create() {
        JPanel top = this.createComponents();
        if (this.surfaceContainer != null) {
            this.surfaceContainer.add((Component)top, "North");
            this.surfaceContainer.invalidate();
            this.surfaceContainer.validate();
        }
    }

    private JPanel createComponents() {
        JPanel top = new JPanel();
        String tagLine = "";
        if (this.appletStub != null) {
            tagLine = this.appletStub.getParameter("tagLine");
        }
        String lblText = "<html><font color=red size=+2>JDK Documentation</font><br/>" + tagLine + " <br/></html>";
        JLabel lbl = new JLabel(lblText);
        top.add((Component)lbl, "North");
        String displayLogo = "false";
        JSObject window = JSObject.getWindow(null);
        if (window != null) {
            displayLogo = (String)window.getMember("displayLogo");
        }
        if (displayLogo.equals("true")) {
            lbl = new JLabel();
            ImageIcon logo = CustomProgress.createImageIcon("images/DukeWave.gif", "logo");
            lbl.setIcon(logo);
            top.add((Component)lbl, "East");
        }
        this.statusLabel = new JLabel("html><font color=green size=-2>Loading applet...</font></html>");
        top.add((Component)this.statusLabel, "Center");
        this.progressBar = new JProgressBar(0, 100);
        this.progressBar.setValue(0);
        this.progressBar.setStringPainted(true);
        top.add((Component)this.progressBar, "South");
        return top;
    }

    protected static ImageIcon createImageIcon(String path, String description) {
        URL imgURL = CustomProgress.class.getResource(path);
        if (imgURL != null) {
            return new ImageIcon(imgURL, description);
        }
        System.err.println("Couldn't find file: " + path);
        return null;
    }
}

