/*
 * Decompiled with CFR 0.152.
 */
package views;

import controller.globalCommands.ReplaceAtom;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import org.ctom.hulis.huckel.Atom;
import org.ctom.hulis.huckel.HuckelAtom;
import org.ctom.hulis.huckel.PeriodicTable;
import org.ctom.hulis.huckel.exception.BondException;
import org.ctom.hulis.huckel.exception.HuckelBondException;
import org.ctom.hulis.huckel.exception.MoleculeAtomNullException;
import org.ctom.hulis.huckel.exception.MoleculeBondExistsException;
import org.ctom.hulis.huckel.exception.MoleculeCoherenceException;
import org.ctom.hulis.huckel.exception.MoleculeTooManyNeighboursException;
import org.ctom.hulis.huckel.structures.Structure;
import org.ctom.util.common.Convert;
import util.MyJOptionPane;
import util.MyResourceBundle;
import util.io.SwingIO;
import util.languages.LanguageManager;
import views.AtomColor;
import views.FrameApp;
import views.MyJDialog;
import views.StructureView;

public class DialogChangeAtom
extends MyJDialog
implements ActionListener {
    public static String XX_ATOM_TEXT = "Xx";
    FrameApp app;
    Atom atomSelect;
    Atom atomToChange;
    private String BT_OK;
    private String BT_UNDO;
    public JButton btCancel;
    public JButton btOK;
    MyResourceBundle bundle;
    private HashMap<String, JToggleButton> buttons = new HashMap();
    private String FRAME_TITLE_ATOM_TYPE;
    public JTextField txtHx;
    private JLabel lblXXNeighbours;
    private JTextField txtXXNbNeighbours;
    private JLabel lblXXbNbElecPi;
    private JTextField txtXXNbElecPi;
    private JLabel lblXXSymbol;
    private JTextField txtXXSymbol;

    public DialogChangeAtom(FrameApp frame, Point p, Atom atomToChange) throws Exception {
        super(JOptionPane.getFrameForComponent(frame));
        this.app = frame;
        this.bundle = LanguageManager.getInstance().getResource("DialogChangeAtom");
        Font btFont = (Font)this.bundle.getObject("font1");
        Font btFont2 = new Font("Helvetica", 0, 11);
        this.FRAME_TITLE_ATOM_TYPE = this.bundle.getString("kTitleAtomType");
        this.BT_OK = this.bundle.getString("kOK");
        this.BT_UNDO = this.bundle.getString("kundo");
        if (p == null) {
            throw new Exception("point must be intialized");
        }
        if (atomToChange == null) {
            throw new Exception("atom must be initialized");
        }
        this.txtHx = new JTextField(4);
        this.lblXXNeighbours = new JLabel("<html>n<sub>neighb</sub> = </html>");
        this.lblXXbNbElecPi = new JLabel("<html>n<sub>e-\u03c0</sub> = </html>");
        this.lblXXSymbol = new JLabel("<html>Symbol = </html>");
        this.txtXXNbNeighbours = new JTextField(3);
        this.txtXXNbElecPi = new JTextField(3);
        this.txtXXSymbol = new JTextField(3);
        this.lblXXNeighbours.setVisible(false);
        this.lblXXbNbElecPi.setVisible(false);
        this.lblXXSymbol.setVisible(false);
        this.txtXXNbNeighbours.setVisible(false);
        this.txtXXNbElecPi.setVisible(false);
        this.txtXXSymbol.setVisible(false);
        String title = String.valueOf(this.FRAME_TITLE_ATOM_TYPE) + " " + atomToChange.getSigle();
        this.txtXXNbNeighbours.setText(Integer.toString(atomToChange.getNbNeighboursMax()));
        if (atomToChange.getElement() == null) {
            this.txtXXSymbol.setText(atomToChange.getSigle());
        } else {
            this.txtXXSymbol.setText(XX_ATOM_TEXT);
        }
        if (atomToChange instanceof HuckelAtom) {
            HuckelAtom huckelAtomToChange = (HuckelAtom)atomToChange;
            title = String.valueOf(title) + ", " + huckelAtomToChange.getSeqNum();
            this.txtHx.setText(Double.toString(huckelAtomToChange.getHx()));
            this.txtXXNbElecPi.setText(Integer.toString(huckelAtomToChange.getNbElecPi()));
        }
        this.setTitle(title);
        JPanel panneauBouton = new JPanel();
        panneauBouton.setLayout(new GridLayout(4, 4));
        this.atomToChange = atomToChange;
        this.atomSelect = null;
        ArrayList<String> tmp = new ArrayList<String>(Arrays.asList(Convert.enumNameToStringArray((Enum[])PeriodicTable.Entry.values())));
        tmp.add(XX_ATOM_TEXT);
        String[] listeAtomes = new String[tmp.size()];
        tmp.toArray(listeAtomes);
        ButtonGroup buttonGroup = new ButtonGroup();
        int i2 = 0;
        while (i2 < listeAtomes.length) {
            if (!listeAtomes[i2].toString().equals("H")) {
                JToggleButton boutonTypeAtome = new JToggleButton(listeAtomes[i2].toString());
                boutonTypeAtome.setActionCommand(listeAtomes[i2].toString());
                boutonTypeAtome.setText("<html>" + AtomColor.valueOf(listeAtomes[i2].toString()).getDevForm() + "</html>");
                if (!listeAtomes[i2].equals(XX_ATOM_TEXT) && PeriodicTable.getNewAtom(PeriodicTable.Entry.valueOf(listeAtomes[i2])).getNbNeighboursMax() < atomToChange.countNeighboursExcludingH()) {
                    boutonTypeAtome.setEnabled(false);
                }
                buttonGroup.add(boutonTypeAtome);
                boutonTypeAtome.addActionListener(this);
                boutonTypeAtome.setFont(btFont2);
                panneauBouton.add(boutonTypeAtome);
                this.buttons.put(listeAtomes[i2], boutonTypeAtome);
                if (atomToChange instanceof HuckelAtom) {
                    if (!listeAtomes[i2].equals(XX_ATOM_TEXT) && ((HuckelAtom)atomToChange).getEntry() == PeriodicTable.Entry.valueOf(listeAtomes[i2])) {
                        boutonTypeAtome.setSelected(true);
                        this.atomSelect = PeriodicTable.getNewAtom(PeriodicTable.Entry.valueOf(listeAtomes[i2]));
                    } else if (atomToChange.getElement() == null && listeAtomes[i2] == XX_ATOM_TEXT) {
                        boutonTypeAtome.setSelected(true);
                        this.atomSelect = new HuckelAtom(0, null, null, XX_ATOM_TEXT, XX_ATOM_TEXT, 0, 0, 0, 0.0, 0);
                        this.lblXXNeighbours.setVisible(true);
                        this.txtXXNbNeighbours.setVisible(true);
                        this.lblXXbNbElecPi.setVisible(true);
                        this.txtXXNbElecPi.setVisible(true);
                        this.lblXXSymbol.setVisible(true);
                        this.txtXXSymbol.setVisible(true);
                    }
                }
            }
            ++i2;
        }
        JPanel panneauChamps = new JPanel();
        JLabel lblHx = new JLabel("Hx =");
        lblHx.setFont(btFont2);
        this.txtHx.setFont(btFont2);
        panneauChamps.setLayout(new FlowLayout(0));
        panneauChamps.add(lblHx);
        panneauChamps.add(this.txtHx);
        this.lblXXNeighbours.setFont(btFont2);
        panneauChamps.add(this.lblXXNeighbours);
        this.txtXXNbNeighbours.setFont(btFont2);
        panneauChamps.add(this.txtXXNbNeighbours);
        this.lblXXbNbElecPi.setFont(btFont2);
        panneauChamps.add(this.lblXXbNbElecPi);
        this.txtXXNbElecPi.setFont(btFont2);
        panneauChamps.add(this.txtXXNbElecPi);
        this.lblXXSymbol.setFont(btFont2);
        panneauChamps.add(this.lblXXSymbol);
        this.txtXXSymbol.setFont(btFont2);
        panneauChamps.add(this.txtXXSymbol);
        JPanel panneauOKAnnuler = new JPanel();
        panneauOKAnnuler.setLayout(new FlowLayout());
        this.btOK = new JButton(this.BT_OK);
        this.btOK.setFont(btFont);
        this.btOK.addActionListener(this);
        panneauOKAnnuler.add(this.btOK);
        this.btCancel = new JButton(this.BT_UNDO);
        this.btCancel.addActionListener(this);
        this.btCancel.setFont(btFont);
        panneauOKAnnuler.add(this.btCancel);
        JPanel panneauBas = new JPanel();
        panneauBas.setLayout(new GridLayout(2, 1));
        panneauBas.add(panneauChamps);
        panneauBas.add(panneauOKAnnuler);
        Container contenu = this.getContentPane();
        contenu.setLayout(new BorderLayout());
        contenu.add((Component)panneauBouton, "Center");
        contenu.add((Component)panneauBas, "South");
        this.pack();
        this.setPreferredSize(new Dimension(380, 200));
        this.setSize(new Dimension(380, 200));
        this.setLocation(p);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Structure structure = (Structure)this.atomToChange.getMoleculeContainer();
        try {
            if (e.getActionCommand() == this.BT_OK) {
                if (this.atomSelect == null) {
                    MyJOptionPane.showMessageDialog(this, this.bundle.getString("katomnull"), this.bundle.getString("kTitleAtomType"), 1);
                    return;
                }
                double valHx = Double.valueOf(this.txtHx.getText());
                this.app.getStateManager().initNewState();
                if (this.atomToChange.getEntry() == null || this.atomSelect.getEntry() != this.atomToChange.getEntry()) {
                    boolean savCalcFly = structure.isEnabledFlyCalculate();
                    structure.stopFlyCalculate();
                    structure.setEnabledNotify(false);
                    if (this.atomSelect instanceof HuckelAtom) {
                        HuckelAtom huckelAtom = (HuckelAtom)this.atomSelect;
                        huckelAtom.setHx(valHx);
                        if (this.atomSelect.getSigle().equals(XX_ATOM_TEXT)) {
                            huckelAtom.setNbNeighboursMax(Integer.valueOf(this.txtXXNbNeighbours.getText()));
                            huckelAtom.setNbElecPi(Integer.valueOf(this.txtXXNbElecPi.getText()));
                            huckelAtom.setSigle(this.txtXXSymbol.getText());
                        }
                    }
                    if (savCalcFly) {
                        structure.startFlyCalculate();
                        structure.calculate();
                    }
                    structure.setEnabledNotify(true);
                    SwingIO.log(this.getClass().getName(), "actionPerformed", "replace " + this.atomToChange + " by " + this.atomSelect);
                    StructureView sv = this.app.getCurrentMesomeryView().getCurrentStructureView();
                    new ReplaceAtom(structure, this.atomToChange, this.atomSelect);
                } else if (this.atomToChange instanceof HuckelAtom) {
                    SwingIO.log(this.getClass().getName(), "actionPerformed", "set HX " + valHx + " to " + this.atomToChange);
                    ((HuckelAtom)this.atomToChange).setHx(valHx);
                }
                this.app.getStateManager().saveState();
                this.dispose();
            } else if (e.getActionCommand() == this.BT_UNDO) {
                this.dispose();
            } else {
                String sigle = e.getActionCommand();
                if (sigle.equals(XX_ATOM_TEXT)) {
                    SwingIO.log(this.getClass().getName(), "actionPerformed", "XX atom selected");
                    this.atomSelect = new HuckelAtom(0, null, null, XX_ATOM_TEXT, XX_ATOM_TEXT, 0, 0, 0, 0.0, 0);
                    this.lblXXNeighbours.setVisible(true);
                    this.txtXXNbNeighbours.setVisible(true);
                    this.lblXXbNbElecPi.setVisible(true);
                    this.txtXXNbElecPi.setVisible(true);
                    this.lblXXSymbol.setVisible(true);
                    this.txtXXSymbol.setVisible(true);
                } else {
                    SwingIO.log(this.getClass().getName(), "actionPerformed", String.valueOf(sigle) + " atom selected");
                    this.atomSelect = PeriodicTable.getNewAtom(PeriodicTable.Entry.valueOf(sigle));
                    this.lblXXNeighbours.setVisible(false);
                    this.txtXXNbNeighbours.setVisible(false);
                    this.lblXXbNbElecPi.setVisible(false);
                    this.txtXXNbElecPi.setVisible(false);
                    this.lblXXSymbol.setVisible(false);
                    this.txtXXSymbol.setVisible(false);
                }
                if (this.atomSelect instanceof HuckelAtom) {
                    this.txtHx.setText(Double.toString(((HuckelAtom)this.atomSelect).getHx()));
                }
            }
        }
        catch (NumberFormatException e1) {
            structure.setEnabledNotify(true);
            MyJOptionPane.showMessageDialog(this, this.bundle.getString("knumeric"), this.bundle.getString("kTitleAtomType"), 1);
            this.txtHx.selectAll();
            SwingIO.warning(this.getClass().getName(), "actionPerformed", e1.getMessage(), e1);
        }
        catch (HuckelBondException e1) {
            structure.setEnabledNotify(true);
            SwingIO.error(this.getClass().getName(), "actionPerformed", e1.getMessage(), e1);
            SwingIO.reportError(this.app);
        }
        catch (BondException e1) {
            structure.setEnabledNotify(true);
            SwingIO.error(this.getClass().getName(), "actionPerformed", e1.getMessage(), e1);
            SwingIO.reportError(this.app);
        }
        catch (MoleculeAtomNullException e1) {
            structure.setEnabledNotify(true);
            SwingIO.error(this.getClass().getName(), "actionPerformed", e1.getMessage(), e1);
            SwingIO.reportError(this.app);
        }
        catch (MoleculeTooManyNeighboursException e1) {
            structure.setEnabledNotify(true);
            JOptionPane.showMessageDialog(this.app, this.bundle.getString("cannotReduceValence"), this.bundle.getString("kTitleAtomType"), 1);
        }
        catch (MoleculeCoherenceException e1) {
            structure.setEnabledNotify(true);
            SwingIO.error(this.getClass().getName(), "actionPerformed", e1.getMessage(), e1);
            SwingIO.reportError(this.app);
        }
        catch (MoleculeBondExistsException e1) {
            structure.setEnabledNotify(true);
            SwingIO.error(this.getClass().getName(), "actionPerformed", e1.getMessage(), e1);
            SwingIO.reportError(this.app);
        }
    }

    @Override
    public void dispose() {
        super.dispose();
    }

    public JToggleButton getButton(String entry) {
        return this.buttons.get(entry);
    }
}

