/*
 * Decompiled with CFR 0.152.
 */
package views;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.ctom.hulis.huckel.HuckelBond;
import org.ctom.hulis.huckel.PeriodicTable;
import org.ctom.hulis.huckel.exception.HuckelBondException;
import util.MyJOptionPane;
import util.MyResourceBundle;
import util.io.SwingIO;
import util.languages.LanguageManager;
import views.FrameApp;
import views.MyJDialog;

public class DialogChangeHuckelBond
extends MyJDialog
implements ActionListener {
    FrameApp app;
    HuckelBond bondToChange;
    public JButton btOK;
    private String BT_DEFAULT;
    private String BT_OK;
    private String BT_UNDO;
    MyResourceBundle bundle;
    private String FRAME_TITLE_BOND_TYPE;
    public JTextField txtHxy;

    public DialogChangeHuckelBond(FrameApp frame, Point p, HuckelBond bondToChange) throws Exception {
        super(JOptionPane.getFrameForComponent(frame));
        this.app = frame;
        this.bundle = LanguageManager.getInstance().getResource("DialogChangeHuckelBond");
        Font btFont = (Font)this.bundle.getObject("font1");
        Font btFont2 = new Font("Helvetica", 0, 11);
        this.FRAME_TITLE_BOND_TYPE = this.bundle.getString("kTitleChangeBonds");
        this.BT_DEFAULT = this.bundle.getString("kdefault");
        this.BT_OK = this.bundle.getString("kOK");
        this.BT_UNDO = this.bundle.getString("kundo");
        if (p == null) {
            throw new Exception("point must be intialized");
        }
        if (bondToChange == null) {
            throw new Exception("bond must be initialized");
        }
        JLabel lblLiaison = new JLabel();
        this.setTitle(this.FRAME_TITLE_BOND_TYPE);
        lblLiaison.setText(bondToChange.toString());
        lblLiaison.setFont(btFont2);
        this.bondToChange = bondToChange;
        JPanel panneauLabel = new JPanel();
        panneauLabel.add(lblLiaison);
        JPanel panneauChamps = new JPanel();
        JLabel lblHxy = new JLabel("Hxy =");
        lblHxy.setFont(btFont2);
        this.txtHxy = new JTextField(5);
        this.txtHxy.setFont(btFont2);
        panneauChamps.setLayout(new FlowLayout());
        panneauChamps.add(lblHxy);
        panneauChamps.add(this.txtHxy);
        JButton boutonDefaut = new JButton(this.BT_DEFAULT);
        boutonDefaut.setFont(btFont);
        boutonDefaut.addActionListener(this);
        panneauChamps.add(boutonDefaut);
        JPanel panneauOKAnnuler = new JPanel();
        panneauOKAnnuler.setLayout(new FlowLayout());
        JPanel panneauHaut = new JPanel();
        panneauHaut.setLayout(new GridLayout(2, 1));
        panneauHaut.add(panneauLabel);
        panneauHaut.add(panneauChamps);
        this.btOK = new JButton(this.BT_OK);
        this.btOK.setFont(btFont);
        this.btOK.addActionListener(this);
        panneauOKAnnuler.add(this.btOK);
        JButton boutonAnnuler = new JButton(this.BT_UNDO);
        boutonAnnuler.addActionListener(this);
        boutonAnnuler.setFont(btFont);
        panneauOKAnnuler.add(boutonAnnuler);
        Container contenu = this.getContentPane();
        contenu.setLayout(new BorderLayout());
        contenu.add((Component)panneauHaut, "Center");
        contenu.add((Component)panneauOKAnnuler, "South");
        this.txtHxy.setText(Double.toString(bondToChange.getHxy()));
        this.pack();
        this.setLocation(p);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            double valHxy = Double.valueOf(this.txtHxy.getText());
            if (e.getActionCommand() == this.BT_OK) {
                SwingIO.log(this.getClass().getName(), "actionPerformed", "set hxy=" + valHxy + " on bond " + this.bondToChange);
                this.app.getStateManager().initNewState();
                this.bondToChange.setHxy(valHxy);
                this.app.getStateManager().saveState();
                this.dispose();
            } else if (e.getActionCommand() == this.BT_DEFAULT) {
                double defaultValue = 0.0;
                PeriodicTable.Entry entry1 = this.bondToChange.getAtom1().getEntry();
                PeriodicTable.Entry entry2 = this.bondToChange.getAtom2().getEntry();
                if (entry1 != null && entry2 != null) {
                    defaultValue = HuckelBond.getHxy(entry1, entry2);
                }
                SwingIO.log(this.getClass().getName(), "actionPerformed", "set default value hxy=" + defaultValue);
                this.txtHxy.setText(Double.toString(defaultValue));
            }
            if (e.getActionCommand() == this.BT_UNDO) {
                SwingIO.log(this.getClass().getName(), "actionPerformed", "cancel dialog box");
                this.dispose();
            }
        }
        catch (NumberFormatException e1) {
            MyJOptionPane.showMessageDialog(this, this.bundle.getString("knumeric"), this.bundle.getString("kTitleChangeBonds"), 1);
            this.txtHxy.selectAll();
            SwingIO.warning(this.getClass().getName(), "actionPerformed", e1.getMessage(), e1);
        }
        catch (HuckelBondException e1) {
            SwingIO.error(this.getClass().getName(), "actionPerformed", e1.getMessage(), e1);
            SwingIO.reportError(this.app);
        }
    }

    @Override
    public void dispose() {
        SwingIO.log(this.getClass().getName(), "dispose", "dispose dialog box");
        super.dispose();
    }
}

