/*
 * Decompiled with CFR 0.152.
 */
package views;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.QuadCurve2D;
import java.text.DecimalFormat;
import org.ctom.hulis.huckel.Spin;
import org.ctom.hulis.huckel.SpinOrbitaleMoleculaire;
import views.GraphOM;
import views.OrbitalControl;

public class EnergyControl
extends OrbitalControl {
    public static final float ARROW_STROKE = 1.9f;
    public static final int VMARGIN_ARROW = 2;
    public static final int VDECALAGE_ARROW = 2;
    public static final float DEFAULT_STROKE = 0.0f;
    public static final double HEIGHT = 15.0;
    public static final float LINE_STROKE = 1.52f;
    public static final double WIDTH = 13.0;
    public final Color COLOR_ARROW = Color.RED;
    public final Color COLOR_EXCITATION = Color.ORANGE;
    DecimalFormat FORMATTER = new DecimalFormat("#.##");

    public EnergyControl(GraphOM graphOM, SpinOrbitaleMoleculaire som, Point2D p) {
        super(graphOM, som, p);
    }

    @Override
    public void draw(Graphics2D g2d) {
        super.draw(g2d);
        g2d.setStroke(new BasicStroke(1.9f));
        g2d.setColor(this.COLOR_ARROW);
        if (this.getSOM().getSpin() == Spin.DEMI_ELECTRON) {
            g2d.drawString(this.FORMATTER.format(this.getSOM().getNbElectrons()), (int)(this.p.getX() - 3.25), (int)this.p.getY());
        } else {
            if (this.getSOM().getSpin() == Spin.ALPHA) {
                g2d.draw(new Line2D.Double(this.p.getX() - 3.25, this.p.getY() - 7.5 + 2.0 - 2.0, this.p.getX() - 3.25, this.p.getY() + 7.5 - 2.0 - 2.0));
                g2d.draw(new Line2D.Double(this.p.getX() - 4.875, this.p.getY() - 1.875 - 2.0, this.p.getX() - 3.25, this.p.getY() - 7.5 - 2.0));
            }
            if (this.getSOM().getSpin() == Spin.BETA) {
                g2d.draw(new Line2D.Double(this.p.getX() + 3.25, this.p.getY() - 7.5 + 2.0 + 2.0, this.p.getX() + 3.25, this.p.getY() + 7.5 - 2.0 + 2.0));
                g2d.draw(new Line2D.Double(this.p.getX() + 4.875, this.p.getY() + 1.875 + 2.0, this.p.getX() + 3.25, this.p.getY() + 7.5 + 2.0));
            }
        }
        if (this.gom.isDrawingExcitation() && this.gom.getPointFrom() != null) {
            g2d.setStroke(new BasicStroke(1.9f));
            g2d.setColor(this.COLOR_EXCITATION);
            Point pointTo = this.gom.getCurrentPointDragged();
            QuadCurve2D.Float q = new QuadCurve2D.Float();
            double x1 = this.gom.getPointFrom().getX();
            double y1 = this.gom.getPointFrom().getY();
            double x2 = pointTo.getX();
            double y2 = pointTo.getY();
            double ctrlx = x1 * 0.7;
            double ctrly = y2 * 0.9;
            ((QuadCurve2D)q).setCurve(x1, y1, ctrlx, ctrly, x2, y2);
            g2d.draw(q);
        }
        g2d.setStroke(new BasicStroke(0.0f));
    }

    public Spin getSpin() {
        return ((SpinOrbitaleMoleculaire)this.om).getSpin();
    }

    public SpinOrbitaleMoleculaire getSOM() {
        return (SpinOrbitaleMoleculaire)super.getOM();
    }
}

