/*
 * Decompiled with CFR 0.152.
 */
package views;

import controller.globalCommands.PopUp;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import util.FollowLink;
import util.MyResourceBundle;
import util.languages.LanguageManager;

public class ErrorReport
extends JDialog {
    String error;
    protected static boolean isErrorReported = false;

    public static boolean isErrorReported() {
        return isErrorReported;
    }

    public static void clear() {
        isErrorReported = false;
    }

    public ErrorReport(String error) {
        this(error, true);
    }

    public ErrorReport(String error, boolean fatal) {
        super((Frame)null, true);
        if (fatal) {
            isErrorReported = true;
        }
        MyResourceBundle bundle = LanguageManager.getInstance().getResource("ErrorReport");
        this.error = error;
        this.setTitle(bundle.getString("title"));
        this.setPreferredSize(new Dimension(500, 600));
        this.setSize(new Dimension(100, 100));
        Container contenu = this.getContentPane();
        contenu.setLayout(new BorderLayout(5, 5));
        JTextPane txtResult = new JTextPane();
        txtResult.setContentType("charset=UTF-8");
        txtResult.setPreferredSize(this.getPreferredSize());
        txtResult.setEditable(false);
        txtResult.setText(error);
        PopUp.pop(txtResult);
        txtResult.setFont(new Font("Monaco", 0, 12));
        JScrollPane ascTxtResult = new JScrollPane(txtResult, 20, 32);
        ascTxtResult.setHorizontalScrollBarPolicy(32);
        ascTxtResult.setVerticalScrollBarPolicy(22);
        ascTxtResult.setPreferredSize(new Dimension(800, 600));
        Font btFont = (Font)bundle.getObject("font2");
        JPanel panneauBoutons = new JPanel();
        final JTextPane txtResult2 = txtResult;
        JButton jbCopy = new JButton(bundle.getString("kcopy"));
        jbCopy.setFont(btFont);
        jbCopy.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                txtResult2.selectAll();
                txtResult2.copy();
            }
        });
        panneauBoutons.add(jbCopy);
        JButton jbFermer = fatal ? new JButton(bundle.getString("kquit")) : new JButton(bundle.getString("kclose"));
        jbFermer.setFont(btFont);
        jbFermer.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ErrorReport.this.dispose();
            }
        });
        panneauBoutons.add(jbFermer);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                ErrorReport.this.dispose();
            }
        });
        JTextPane label = new JTextPane();
        label.setContentType("text/html; charset=UTF-8");
        label.setEditable(false);
        label.setSize(100, 20);
        if (fatal) {
            label.setText("<html>" + bundle.getString("kerrtxt") + "</html>");
            label.addHyperlinkListener(new FollowLink(label));
        }
        contenu.add((Component)label, "North");
        contenu.add((Component)ascTxtResult, "Center");
        contenu.add((Component)panneauBoutons, "South");
        this.pack();
        this.setLocationRelativeTo(null);
    }
}

