/*
 * Decompiled with CFR 0.152.
 */
package views;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.net.URL;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import util.io.SwingIO;

public class Explorer
extends JFrame
implements HyperlinkListener {
    protected JEditorPane txtResult;

    public Explorer(URL url) throws IOException {
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                Explorer.this.dispose();
            }
        });
        this.setPreferredSize(new Dimension(800, 600));
        Container contenu = this.getContentPane();
        contenu.setLayout(new BorderLayout(5, 5));
        this.txtResult = new JEditorPane(url);
        this.txtResult.addHyperlinkListener(this);
        this.txtResult.setPreferredSize(this.getPreferredSize());
        this.txtResult.setEditable(false);
        this.pop(this.txtResult);
        JScrollPane ascTxtResult = new JScrollPane(this.txtResult, 20, 30);
        ascTxtResult.setVerticalScrollBarPolicy(22);
        ascTxtResult.setPreferredSize(new Dimension(800, 600));
        contenu.add((Component)ascTxtResult, "Center");
        this.pack();
        this.setVisible(true);
    }

    @Override
    public void hyperlinkUpdate(HyperlinkEvent event) {
        if (event.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
            try {
                this.txtResult.setPage(event.getURL());
            }
            catch (IOException ioe) {
                SwingIO.warning(this.getClass().getName(), "hyperlinkUpdate", "Can't follow link to " + event.getURL().toExternalForm() + ": " + ioe, ioe);
            }
        }
    }

    public void pop(final JEditorPane t1) {
        final JPopupMenu x = new JPopupMenu();
        JMenuItem i1 = new JMenuItem("cut");
        JMenuItem i2 = new JMenuItem("copy");
        JMenuItem i3 = new JMenuItem("paste");
        JMenuItem i4 = new JMenuItem("select all");
        i1.setAccelerator(KeyStroke.getKeyStroke(88, 2));
        i2.setAccelerator(KeyStroke.getKeyStroke(67, 2));
        i3.setAccelerator(KeyStroke.getKeyStroke(86, 2));
        i4.setAccelerator(KeyStroke.getKeyStroke(65, 2));
        x.add(i2);
        x.addSeparator();
        x.add(i4);
        i1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                t1.cut();
            }
        });
        i2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                t1.copy();
            }
        });
        i3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                t1.paste();
            }
        });
        i4.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                t1.selectAll();
            }
        });
        t1.addMouseListener(new MouseAdapter(){

            private void checkForTriggerEvent(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    x.show(e.getComponent(), e.getX(), e.getY());
                }
            }

            @Override
            public void mousePressed(MouseEvent e) {
                this.checkForTriggerEvent(e);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                this.checkForTriggerEvent(e);
            }
        });
    }
}

