/*
 * Decompiled with CFR 0.152.
 */
package views;

import access.Rights;
import controller.globalCommands.ActionAtomsRenum;
import controller.globalCommands.ActionAutoGenStruct;
import controller.globalCommands.ActionChangeMode;
import controller.globalCommands.ActionCommandRegistry;
import controller.globalCommands.ActionDisplayCharges;
import controller.globalCommands.ActionDisplayHxHxy;
import controller.globalCommands.ActionDisplayNum;
import controller.globalCommands.ActionDisplayPolynomes;
import controller.globalCommands.ActionDuplicate;
import controller.globalCommands.ActionEndBloc;
import controller.globalCommands.ActionErase1;
import controller.globalCommands.ActionEraseAll;
import controller.globalCommands.ActionEraseMesomery;
import controller.globalCommands.ActionMenuMethod;
import controller.globalCommands.ActionModeBloc;
import controller.globalCommands.ActionMoleculeAddElecCharge;
import controller.globalCommands.ActionMoleculeRemoveElecCharge;
import controller.globalCommands.ActionOpenAbout;
import controller.globalCommands.ActionOpenLog;
import controller.globalCommands.ActionOptimizeGeometry;
import controller.globalCommands.ActionQuit;
import controller.globalCommands.ActionSavePolynomes;
import controller.globalCommands.ActionShowResultMesomery;
import controller.globalCommands.ActionShowResultStruct;
import controller.globalCommands.ActionStopAutoGenStruct;
import controller.globalCommands.Center;
import controller.globalCommands.ChooseMenuExp;
import controller.globalCommands.EnableActionManager;
import controller.globalCommands.IGlobalCommands;
import controller.globalCommands.OpenPreferences;
import controller.globalCommands.PrintCurrentView;
import controller.globalCommands.Redo;
import controller.globalCommands.ShowListBlocs;
import controller.globalCommands.ShowListExcitations;
import controller.globalCommands.StateManager;
import controller.globalCommands.SuperMario;
import controller.globalCommands.SwitchCanonicalNatural;
import controller.globalCommands.SwitchDensity;
import controller.globalCommands.SwitchSinguletCouchesOuvertes;
import controller.globalCommands.SwitchSinguletTriplet;
import controller.globalCommands.Undo;
import controller.globalCommands.ZoomD;
import controller.globalCommands.ZoomM;
import controller.globalCommands.ZoomP;
import controller.structureViewController.AddState;
import controller.structureViewController.BlocState;
import controller.structureViewController.ChangeElectronsState;
import controller.structureViewController.ChangeState;
import controller.structureViewController.CoupleState;
import controller.structureViewController.IStructureViewControllerState;
import controller.structureViewController.MoveState;
import controller.structureViewController.RemoveState;
import controller.structureViewController.RenumState;
import controller.structureViewController.RotateState;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JApplet;
import javax.swing.JFrame;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.ToolTipManager;
import javax.swing.UIManager;
import javax.swing.text.html.parser.ParserDelegator;
import org.ctom.hulis.huckel.Energy;
import org.ctom.hulis.huckel.Mesomery;
import org.ctom.hulis.huckel.exception.CoupleException;
import org.ctom.hulis.huckel.exception.IMethodException;
import org.ctom.hulis.huckel.exception.MesomeryDelocalizedStructureExistsException;
import org.ctom.hulis.huckel.exception.MesomeryNoStructureLocalizedException;
import org.ctom.hulis.huckel.methods.HLCIMethod;
import org.ctom.hulis.huckel.methods.HLPMethod;
import org.ctom.hulis.huckel.methods.IMethod;
import org.ctom.hulis.huckel.selectors.MesomeryHLPOverlapStructuresSelector;
import org.ctom.hulis.huckel.structures.Structure;
import org.ctom.hulis.huckel.structures.StructureDelocalized;
import sqlbridge.ConnectSQL;
import util.CookieManager;
import util.MessageWithLink;
import util.MyResourceBundle;
import util.PreferencesCookies;
import util.PreferencesStd;
import util.ThreadUtils;
import util.Version;
import util.io.IOClipBoard;
import util.io.IOFichier;
import util.io.SwingIO;
import util.languages.InitResources;
import util.languages.LanguageManager;
import util.polyCalculator.PolyCalculator;
import views.AppMenuBar;
import views.AppletToFrame;
import views.ErrorReport;
import views.FrameResult;
import views.FrameResultMesomery;
import views.IMesomeryReference;
import views.IStructureReference;
import views.LicenseFrame;
import views.MesomeryView;
import views.SplashWindow;
import views.StatusBar;
import views.SwingEnergyFormater;
import views.ToolBarHuckel;
import views.ToolBarMesomery;
import views.prefs.PreferencesGUI;

public class FrameApp
extends JApplet
implements IGlobalCommands {
    private URL codebase = null;
    private static String PREFERENCES_NODE_NAME = "org.ctom.hulis.hulisSwingGui.PreferencesGUI";
    public static final DecimalFormat form = new DecimalFormat("#.##");
    public static final DecimalFormat energyAlphaFormat = new DecimalFormat("#.##");
    public static final DecimalFormat energyBetaFormat = new DecimalFormat("0.00");
    public static final SwingEnergyFormater DEFAULT_ENERGY_FORMATER = new SwingEnergyFormater(energyAlphaFormat, energyBetaFormat);
    public static final DecimalFormat form2 = new DecimalFormat("#.###");
    public static final Color HUCKEL_VIEWS_BACK_COLOR = new Color(102, 204, 255);
    public static final int TIMER_HIT_USE_TIME_DURATION = 30000;
    public static final String kauthors = "<a href=\"http://ism2.univ-amu.fr/permanents/GOUDARD.php\" target=\"new\">Nicolas Goudard</a>, <a href=\"http://ism2.univ-amu.fr/permanents/CARISSAN.php\" target=\"new\">Yannick Carissan</a>, <a href=\"http://ism2.univ-amu.fr/permanents/HAGEBAUM-REIGNIER.php\" target=\"new\">Denis Hagebaum-Reignier</a>, <a href=\"http://ism2.univ-amu.fr/permanents/HUMBEL.php\" target=\"new\">St&eacute;phane Humbel</a>";
    public static final String ksoftname = "HuLiS";
    private static HashMap<String, IMethod> lstImplementedMethods = new HashMap();
    public static final float majorJavaVersion = FrameApp.getMajorJavaVersion(System.getProperty("java.version"));
    public static final Color MESOMERY_VIEWS_BACK_COLOR = new Color(255, 204, 102);
    public static float MINIMAL_REQUIRED_JAVA_VERSION = 1.5f;
    protected Rights rights = null;
    private long timeBeginUse;
    private long timeToReady;
    private long timeToStart;
    public String currentCommand;
    public long id;
    private static boolean isAlreadyRegisterDeconnect;
    public static final int splashtime = 6000;
    public static final int PRECISION = 2;
    public static final boolean CLONE_RESULTS_WHEN_CLONE_MESOMERY = false;
    private Thread registerDurationThread;
    IStructureViewControllerState structureViewControllerState;
    StateManager stateManager;
    final Version version = new Version(3, 4, 0, "Clar");
    public ButtonGroup buttonGroup = new ButtonGroup();
    private boolean isExpertMode = true;
    public AppMenuBar menuBar;
    private MesomeryView mesomeryView;
    MyResourceBundle rb;
    public StatusBar statusBar;
    public ToolBarHuckel toolBarHuckel;
    public ToolBarMesomery toolBarMesomery;
    private PolyCalculator polyCalc;
    private boolean ownedToFrame = false;
    private HashMap<String, String> parameters = new HashMap();
    private String lastAction;
    private CookieManager cookieManager;

    static {
        lstImplementedMethods.put("HLCI", new HLCIMethod());
        lstImplementedMethods.put("HLP", new HLPMethod());
    }

    public static void checkJavaVersion() {
        if (majorJavaVersion < MINIMAL_REQUIRED_JAVA_VERSION) {
            System.out.println("Java version too low. Please downlaod and install the last version of Java on http://www.java.com");
            System.exit(1);
        }
    }

    public boolean isExecutedOnInternet() {
        URL url = this.getCodeBase();
        if (url == null) {
            return false;
        }
        String sUrl = url.toString();
        return sUrl.startsWith("http://") || sUrl.startsWith("https://");
    }

    @Override
    public URL getCodeBase() {
        try {
            if (this.codebase == null) {
                this.codebase = super.getCodeBase();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.codebase;
    }

    public int getTypeOfUse() {
        int typeOfUse = this.isExecutedOnInternet() ? 1 : 4;
        return typeOfUse;
    }

    public void setCodeBase(URL codebase) {
        this.codebase = codebase;
    }

    public StateManager getStateManager() {
        return this.stateManager;
    }

    public String getCurrentEnabledCommand() {
        Enumeration<AbstractButton> e = this.buttonGroup.getElements();
        while (e.hasMoreElements()) {
            AbstractButton b = e.nextElement();
            if (!b.isEnabled() || !b.getActionCommand().equals(this.currentCommand)) continue;
            return this.currentCommand;
        }
        return "";
    }

    public boolean isEnabledCurrentCommand() {
        Enumeration<AbstractButton> e = this.buttonGroup.getElements();
        while (e.hasMoreElements()) {
            AbstractButton b = e.nextElement();
            if (!b.isEnabled() || !b.getActionCommand().equals(this.currentCommand)) continue;
            return true;
        }
        return false;
    }

    public IStructureViewControllerState getCurrentStructureViewControllerState() {
        if (this.isEnabledCurrentCommand()) {
            return this.structureViewControllerState;
        }
        return null;
    }

    public void setStructureViewControllerState(String currentCommand) {
        this.currentCommand = currentCommand;
        if (currentCommand.equals("2")) {
            this.structureViewControllerState = new AddState();
        } else if (currentCommand.equals("6")) {
            this.structureViewControllerState = new ChangeState();
        } else if (currentCommand.equals("26")) {
            this.structureViewControllerState = new RemoveState();
        } else if (currentCommand.equals("21")) {
            this.structureViewControllerState = new MoveState();
        } else if (currentCommand.equals("28")) {
            this.structureViewControllerState = new RotateState();
        } else if (currentCommand.equals("27")) {
            this.structureViewControllerState = new RenumState();
        } else if (currentCommand.equals("7")) {
            this.structureViewControllerState = new ChangeElectronsState();
        } else if (currentCommand.equals("8")) {
            this.structureViewControllerState = new CoupleState();
        } else if (currentCommand.equals("9")) {
            this.structureViewControllerState = new BlocState();
        }
        this.getStatusBar().setTxtState(ActionCommandRegistry.getInstance().get(currentCommand).getLongDescription());
    }

    public void clickButtonCommand(String currentCommand) {
        Enumeration<AbstractButton> e = this.buttonGroup.getElements();
        while (e.hasMoreElements()) {
            AbstractButton b = e.nextElement();
            if (!b.getActionCommand().equals(currentCommand)) continue;
            if (b.isEnabled()) {
                b.doClick();
                this.setStructureViewControllerState(currentCommand);
                break;
            }
            SwingIO.warning(this.getClass().getName(), "clickButtonCommand", "cannot click on the disabled command  '" + currentCommand + "'");
            break;
        }
    }

    public FrameApp() {
        isAlreadyRegisterDeconnect = false;
        this.timeBeginUse = 0L;
        this.timeToReady = 0L;
        this.timeToStart = 0L;
        this.registerDurationThread = null;
        this.lastAction = "";
    }

    public String getBrowser() {
        try {
            return this.getParameter("browser");
        }
        catch (Exception e1) {
            return "?";
        }
    }

    public long getTimeToStart() {
        return this.timeToStart;
    }

    public long getTimeToReady() {
        return this.timeToReady;
    }

    public static IMethod getImplementedMethod(String methodName) {
        return lstImplementedMethods.get(methodName);
    }

    public static IMethod[] getImplementedMethods() {
        return lstImplementedMethods.values().toArray(new IMethod[lstImplementedMethods.size()]);
    }

    static final float getMajorJavaVersion(String javaVersion) {
        try {
            String x = "0";
            String y = "0";
            int p = javaVersion.indexOf(46);
            if (p <= 0) {
                return Float.valueOf(javaVersion).floatValue();
            }
            x = javaVersion.substring(0, p);
            int p2 = javaVersion.indexOf(46, p + 1);
            y = p2 > p ? javaVersion.substring(p + 1, p2) : javaVersion.substring(p + 1);
            return Float.valueOf(String.valueOf(x) + "." + y).floatValue();
        }
        catch (NumberFormatException e) {
            return MINIMAL_REQUIRED_JAVA_VERSION;
        }
    }

    public static void main(String[] argv) {
        ThreadUtils.invokeAsSoonAsPossible(new Runnable(){

            @Override
            public void run() {
                AppletToFrame.createAndShowGUI(true);
            }
        });
    }

    public List<IMethod> getListSelectedMethods() {
        ArrayList<IMethod> lstMethods = new ArrayList<IMethod>();
        JMenuItem[] jMenuItemArray = this.menuBar.getItemsdMethods();
        int n = jMenuItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            JMenuItem item = jMenuItemArray[n2];
            if (item.isSelected()) {
                lstMethods.add(FrameApp.getImplementedMethod(this.menuBar.getMethodNameByItem(item)));
            }
            ++n2;
        }
        return lstMethods;
    }

    public boolean isMethodSelected(String name) {
        for (IMethod method : this.getListSelectedMethods()) {
            if (!method.getName().equals(name)) continue;
            return true;
        }
        return false;
    }

    public void selectAllMethods() {
        JMenuItem[] jMenuItemArray = this.menuBar.getItemsdMethods();
        int n = jMenuItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            JMenuItem item = jMenuItemArray[n2];
            item.setSelected(true);
            new ActionMenuMethod(item, this).execute();
            ++n2;
        }
    }

    public void deselectAllMethods() {
        JMenuItem[] jMenuItemArray = this.menuBar.getItemsdMethods();
        int n = jMenuItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            JMenuItem item = jMenuItemArray[n2];
            item.setSelected(false);
            new ActionMenuMethod(item, this).execute();
            ++n2;
        }
    }

    public void selectMethod(String method, boolean select) {
        JMenuItem item = this.menuBar.getItemMethod(method);
        item.setSelected(select);
        new ActionMenuMethod(item, this).execute();
    }

    public void startNewMesomery() {
        try {
            Mesomery mesomery = this.mesomeryView.getMesomery();
            mesomery.deleteAllStructures();
            if (this.rights.isValidUser()) {
                mesomery.addDelocalizedStruct(new StructureDelocalized());
                this.selectMethod("HLP", true);
                EnableActionManager.getInstance().updateActionsToEnable(this);
                this.getStateManager().initNewState();
                this.getStateManager().saveState();
                this.clickButtonCommand("2");
            }
        }
        catch (MesomeryDelocalizedStructureExistsException e) {
            SwingIO.error(this.getClass().getName(), "startNewMesomery", e.getMessage(), e);
            SwingIO.reportError(this);
        }
        catch (CoupleException e) {
            SwingIO.error(this.getClass().getName(), "startNewMesomery", e.getMessage(), e);
            SwingIO.reportError(this);
        }
        catch (IMethodException e) {
            SwingIO.error(this.getClass().getName(), "startNewMesomery", e.getMessage(), e);
            SwingIO.reportError(this);
        }
        catch (MesomeryNoStructureLocalizedException e) {
            SwingIO.error(this.getClass().getName(), "startNewMesomery", e.getMessage(), e);
            SwingIO.reportError(this);
        }
        catch (Exception e) {
            SwingIO.error(this.getClass().getName(), "startNewMesomery", e.getMessage(), e);
            SwingIO.reportError(this);
        }
    }

    public void registerNewUser() {
        if (PreferencesGUI.getInstance().isSendInformation()) {
            ConnectSQL.getInstance().registerNewHulisUser(this);
        }
    }

    public void registerAction(String action) {
        if (PreferencesGUI.getInstance().isSendInformation()) {
            ConnectSQL.getInstance().registerDuration(this, action);
        }
    }

    public void registerDuration() {
        if (PreferencesGUI.getInstance().isSendInformation()) {
            ConnectSQL.getInstance().registerDuration(this);
        }
    }

    public void registerDisconnect() {
        if (PreferencesGUI.getInstance().isSendInformation()) {
            ConnectSQL.getInstance().registerDisconnectApplet(this);
        }
    }

    public void construct() {
        this.currentCommand = "";
        try {
            Energy.setDefaultEnergyFormater(DEFAULT_ENERGY_FORMATER);
            Mesomery mesomery = new Mesomery();
            mesomery.setStructureSelector(new MesomeryHLPOverlapStructuresSelector());
            mesomery.setCloneResultsCacheWhenCloneMesomery(false);
            this.stateManager = new StateManager(this);
            this.statusBar = new StatusBar();
            this.toolBarHuckel = new ToolBarHuckel(this);
            this.toolBarMesomery = new ToolBarMesomery(this, mesomery);
            this.mesomeryView = new MesomeryView(mesomery, this);
            this.menuBar = new AppMenuBar(this);
            this.menuBar.menuExp.setSelected(this.isExpertMode);
            this.setJMenuBar(this.menuBar);
            this.updateLanguage();
            this.setSizes();
            UIManager.getDefaults().put("ToolTip.background", Color.YELLOW);
            ToolTipManager.sharedInstance().setDismissDelay(60000);
            ToolTipManager.sharedInstance().setInitialDelay(500);
            this.setBackground(HUCKEL_VIEWS_BACK_COLOR);
            this.toolBarHuckel.setBackgroundColor(HUCKEL_VIEWS_BACK_COLOR);
            mesomery.addListener(this.toolBarHuckel);
            mesomery.addListener(this.getStateManager());
            this.toolBarMesomery.setBackgroundColor(MESOMERY_VIEWS_BACK_COLOR);
            this.mesomeryView.setBackground(Color.WHITE);
            this.statusBar.setBackground(new Color(254, 254, 254));
            this.menuBar.setBackground(new Color(254, 254, 254));
            this.buttonGroup.add(this.toolBarHuckel.btAdd);
            this.buttonGroup.add(this.toolBarHuckel.btChange);
            this.buttonGroup.add(this.toolBarHuckel.btRemove);
            this.buttonGroup.add(this.toolBarHuckel.btMove);
            this.buttonGroup.add(this.toolBarHuckel.btRotate);
            this.buttonGroup.add(this.toolBarHuckel.btRenum);
            this.buttonGroup.add(this.toolBarMesomery.btCouple);
            this.buttonGroup.add(this.toolBarMesomery.btBloc);
            this.buttonGroup.add(this.toolBarMesomery.btChangeElectrons);
            Container contenu = this.getContentPane();
            contenu.setLayout(new BorderLayout(0, 0));
            contenu.add((Component)this.toolBarHuckel, "West");
            contenu.add((Component)this.mesomeryView, "Center");
            contenu.add((Component)this.toolBarMesomery, "East");
            contenu.add((Component)this.statusBar, "South");
            this.toolBarHuckel.btDisplayHxHxy.setSelected(this.mesomeryView.isDisplayHxHxy());
            this.toolBarHuckel.btDisplayCharges.setSelected(this.mesomeryView.isDisplayCharges());
            this.toolBarHuckel.btDisplayNum.setSelected(this.mesomeryView.isDisplayNum());
            ActionCommandRegistry actionCommandRegistry = ActionCommandRegistry.getInstance();
            actionCommandRegistry.add(new ActionChangeMode(this, "2"));
            actionCommandRegistry.add(new ActionChangeMode(this, "6"));
            actionCommandRegistry.add(new ActionChangeMode(this, "26"));
            actionCommandRegistry.add(new ActionChangeMode(this, "21"));
            actionCommandRegistry.add(new ActionChangeMode(this, "28"));
            actionCommandRegistry.add(new ActionAtomsRenum(this));
            actionCommandRegistry.add(new ActionShowResultStruct(this));
            actionCommandRegistry.add(new ActionDuplicate(this));
            actionCommandRegistry.add(new ActionEraseAll(this));
            actionCommandRegistry.add(new ActionOptimizeGeometry(this));
            actionCommandRegistry.add(new Center(this.getCurrentMesomeryView()));
            actionCommandRegistry.add(new ActionErase1(this));
            actionCommandRegistry.add(new ActionEraseMesomery(this));
            actionCommandRegistry.add(new ActionShowResultMesomery(this));
            actionCommandRegistry.add(new ActionDisplayHxHxy(this));
            actionCommandRegistry.add(new ActionDisplayCharges(this));
            actionCommandRegistry.add(new ActionDisplayNum(this));
            actionCommandRegistry.add(new ActionChangeMode(this, "8"));
            actionCommandRegistry.add(new ActionModeBloc(this));
            actionCommandRegistry.add(new ActionEndBloc(this));
            actionCommandRegistry.add(new ActionChangeMode(this, "7"));
            actionCommandRegistry.add(new ActionMoleculeAddElecCharge(this));
            actionCommandRegistry.add(new ActionMoleculeRemoveElecCharge(this));
            actionCommandRegistry.add(new ActionAutoGenStruct(this));
            actionCommandRegistry.add(new ActionStopAutoGenStruct(this));
            actionCommandRegistry.add(new ActionQuit(this));
            this.toolBarHuckel.btAdd.setAction(actionCommandRegistry.get("2"));
            this.toolBarHuckel.btChange.setAction(actionCommandRegistry.get("6"));
            this.toolBarHuckel.btRemove.setAction(actionCommandRegistry.get("26"));
            this.toolBarHuckel.btMove.setAction(actionCommandRegistry.get("21"));
            this.toolBarHuckel.btRotate.setAction(actionCommandRegistry.get("28"));
            this.toolBarHuckel.btOptimize.setAction(actionCommandRegistry.get("35"));
            this.toolBarHuckel.btCenter.setAction(actionCommandRegistry.get("36"));
            this.toolBarHuckel.btRenum.setAction(actionCommandRegistry.get("27"));
            this.toolBarHuckel.btErase.setAction(actionCommandRegistry.get("17"));
            this.toolBarHuckel.btShowResults.setAction(actionCommandRegistry.get("30"));
            this.toolBarMesomery.btShowResultsMesomery.setAction(actionCommandRegistry.get("31"));
            this.toolBarMesomery.btDuplicate.setAction(actionCommandRegistry.get("14"));
            this.toolBarMesomery.btAutoGenStruct.setAction(actionCommandRegistry.get("5"));
            this.toolBarMesomery.btStopAutoGenStruct.setAction(actionCommandRegistry.get("37"));
            this.toolBarMesomery.btErase1.setAction(actionCommandRegistry.get("16"));
            this.toolBarMesomery.btEraseMesomery.setAction(actionCommandRegistry.get("18"));
            this.toolBarMesomery.btCouple.setAction(actionCommandRegistry.get("8"));
            this.toolBarMesomery.btBloc.setAction(actionCommandRegistry.get("9"));
            this.toolBarMesomery.btEndBloc.setAction(actionCommandRegistry.get("10"));
            this.toolBarMesomery.btChangeElectrons.setAction(actionCommandRegistry.get("7"));
            this.toolBarHuckel.btDisplayHxHxy.setAction(actionCommandRegistry.get("12"));
            this.toolBarHuckel.btDisplayCharges.setAction(actionCommandRegistry.get("11"));
            this.toolBarHuckel.btDisplayNum.setAction(actionCommandRegistry.get("13"));
            this.toolBarHuckel.btMoleculeAddElecCharge.setAction(actionCommandRegistry.get("19"));
            this.toolBarHuckel.btMoleculeRemoveElecCharge.setAction(actionCommandRegistry.get("20"));
            this.toolBarHuckel.btQuit.setAction(actionCommandRegistry.get("25"));
            this.menuBar.menuPreferences.addActionListener(new OpenPreferences(this));
            this.menuBar.menuPrintCurrentView.addActionListener(new PrintCurrentView(this));
            this.menuBar.menuQuit.setAction(actionCommandRegistry.get("25"));
            this.menuBar.menuUndo.addActionListener(new Undo(this));
            this.menuBar.menuRedo.addActionListener(new Redo(this));
            this.menuBar.menuPaste.addActionListener(new IOClipBoard(this));
            this.menuBar.superMario.addActionListener(new SuperMario(this));
            this.menuBar.menuExp.addActionListener(new ChooseMenuExp(this));
            this.menuBar.menuDisplayPolynomes.addActionListener(new ActionDisplayPolynomes(this));
            this.menuBar.menuExcitations.addActionListener(new ShowListExcitations(this));
            this.menuBar.menuBlocs.addActionListener(new ShowListBlocs(this));
            this.menuBar.menuSinguletTriplet.addActionListener(new SwitchSinguletTriplet(this));
            this.menuBar.menuSwitchNaturalCanonical.addActionListener(new SwitchCanonicalNatural(this));
            this.menuBar.menuSwitchDensity.addActionListener(new SwitchDensity(this));
            this.menuBar.menuOptGeom.addActionListener(new ActionOptimizeGeometry(this));
            this.menuBar.menuSinguletCO.addActionListener(new SwitchSinguletCouchesOuvertes(this));
            this.menuBar.menuZoomD.addActionListener(new ZoomD(this));
            this.menuBar.menuZoomP.addActionListener(new ZoomP(this));
            this.menuBar.menuZoomM.addActionListener(new ZoomM(this));
            this.menuBar.menuAddPolynome.addActionListener(new ActionSavePolynomes(this));
            JMenuItem[] jMenuItemArray = this.menuBar.getItemsdMethods();
            int n = jMenuItemArray.length;
            int n2 = 0;
            while (n2 < n) {
                JMenuItem item = jMenuItemArray[n2];
                item.addActionListener(new ActionMenuMethod(item, this));
                ++n2;
            }
            this.menuBar.menuLog.addActionListener(new ActionOpenLog(this));
            this.menuBar.menuAbout.addActionListener(new ActionOpenAbout(this));
            this.toolBarHuckel.btAdd.doClick();
            this.rights = new Rights(this);
            if (!this.isExecutedOnInternet()) {
                this.menuBar.menuSave.addActionListener(new IOFichier(this));
                this.menuBar.menuOpen.addActionListener(new IOFichier(this));
                this.menuBar.menuPrintCurrentView.addActionListener(new IOFichier(this));
                this.menuBar.menuTutorial0.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        JOptionPane.showMessageDialog(null, new MessageWithLink("Look the tutorial and follow HuLiS on Youtube : <a href=\"http://youtube.com/@hulis.univ-amu\">http://youtube.com/@hulis.univ-amu</a>"));
                    }
                });
            }
            PreferencesGUI.getInstance().setTotalUse(PreferencesGUI.getInstance().getTotalUse() + 1);
            this.menuBar.menuOpen.setEnabled(this.rights.isValidUser());
            this.menuBar.menuPaste.setEnabled(this.rights.isValidUser());
            actionCommandRegistry.get("17").setEnabled(this.rights.isValidUser());
            EnableActionManager.getInstance().updateActionsToEnable(this);
        }
        catch (Exception e) {
            SwingIO.error(this.getClass().getName(), "FrameApp", e.getMessage(), e);
            SwingIO.reportError(this);
        }
    }

    public Mesomery getCurrentMesomery() {
        return this.mesomeryView.getMesomery();
    }

    public MesomeryView getCurrentMesomeryView() {
        return this.mesomeryView;
    }

    public ToolBarMesomery getEnergiesSlider() {
        return this.toolBarMesomery;
    }

    public Rights getRights() {
        return this.rights;
    }

    public StatusBar getStatusBar() {
        return this.statusBar;
    }

    public MesomeryView getTabs() {
        return this.mesomeryView;
    }

    public ToolBarHuckel getToolBarHuckel() {
        return this.toolBarHuckel;
    }

    public ToolBarMesomery getToolBarMesomery() {
        return this.toolBarMesomery;
    }

    public Version getVersion() {
        return this.version;
    }

    @Override
    public void start() {
        System.out.println("start");
        super.start();
        new ParserDelegator();
        SwingIO.log(this.getClass().getName(), "start", "applet is started");
    }

    @Override
    public void stop() {
        System.out.println("stop");
        this.registerDisconnect();
        super.stop();
    }

    @Override
    public String getParameter(String name) {
        if (this.parameters.containsKey(name)) {
            return this.parameters.get(name);
        }
        try {
            return super.getParameter(name);
        }
        catch (Exception e) {
            SwingIO.log(this.getClass().getName(), "getParameter()", "stub is null, return null for parameter " + name);
            return null;
        }
    }

    public void setParameter(String name, String value) {
        this.parameters.put(name, value);
    }

    @Override
    public void init() {
        SwingIO.log(this.getClass().getName(), "init", "start applet HuLiS " + this.getVersion());
        super.init();
        this.setVisible(true);
        try {
            Runtime.getRuntime().runFinalization();
            Runtime.getRuntime().gc();
            if (!this.isExecutedOnInternet()) {
                PreferencesGUI.getInstance().setPreferencesManager(new PreferencesStd(PREFERENCES_NODE_NAME));
            } else {
                PreferencesGUI.getInstance().setPreferencesManager(new PreferencesCookies(this.cookieManager));
            }
            LanguageManager langageManager = LanguageManager.getInstance();
            langageManager.setLanguage(PreferencesGUI.getInstance().getLanguage());
            langageManager.setResource(new InitResources());
            String mess = "";
            String sTime = "";
            this.timeBeginUse = 0L;
            Long internalTime = 0L;
            try {
                sTime = this.getParameter("time");
                mess = "read external time : " + sTime + " ms";
                SwingIO.log(this.getClass().getName(), "init", mess);
            }
            catch (Exception e1) {
                sTime = "";
                mess = "No time in applet parameter";
                SwingIO.warning(this.getClass().getName(), "init", mess);
            }
            try {
                this.timeBeginUse = sTime != "" && sTime != null ? Long.valueOf(sTime).longValue() : new Date().getTime();
                internalTime = new Date().getTime();
                this.timeToStart = internalTime - this.timeBeginUse;
            }
            catch (NumberFormatException e1) {
                mess = "time error number format : " + sTime;
                SwingIO.warning(this.getClass().getName(), "init", mess);
            }
            mess = "time to start : " + this.timeToStart + " ms";
            SwingIO.log(this.getClass().getName(), "init", mess);
            System.out.println("internal time : " + internalTime + " ms");
            FrameApp.checkJavaVersion();
            SwingIO.log(this.getClass().getName(), "init", "Browser " + this.getParameter("browser"));
            SwingIO.log(this.getClass().getName(), "init", "OS Name : " + System.getProperty("os.name"));
            SwingIO.log(this.getClass().getName(), "init", "OS Version : " + System.getProperty("os.version"));
            SwingIO.log(this.getClass().getName(), "init", "JDK version : " + System.getProperty("java.version"));
            SwingIO.log(this.getClass().getName(), "init", "JDK from : " + System.getProperty("java.vendor"));
            SwingIO.log(this.getClass().getName(), "init", "JVM version : " + System.getProperty("java.vm.version"));
            SwingIO.log(this.getClass().getName(), "init", "JVM from : " + System.getProperty("java.vm.vendor"));
            SwingIO.log(this.getClass().getName(), "init", "construct views HuLiS " + this.getVersion());
            this.construct();
            SwingIO.log(this.getClass().getName(), "init", "end construct views ");
            if (!this.isOwnedToFrame()) {
                this.startNewMesomery();
                this.displaySplashscreen();
            }
        }
        catch (Exception e) {
            SwingIO.error(this.getClass().getName(), "Applet", e.getMessage(), e);
            SwingIO.reportError(this);
        }
    }

    public void displayLicenseToAccept() {
        if (PreferencesGUI.getInstance().isLicenseAlreadyAccepted()) {
            SwingIO.warning(this.getClass().getName(), "displayLicenseToAccept", "License is already accepted !");
        } else {
            new LicenseFrame(this).setVisible(true);
        }
    }

    public void displaySplashscreen() {
        new SplashWindow(this, 6000).setVisible(true);
    }

    public boolean isExpertMode() {
        return this.isExpertMode;
    }

    public void setExpertMode(boolean isExpertMode) {
        this.isExpertMode = isExpertMode;
    }

    public void updateLanguage() {
        this.rb = LanguageManager.getInstance().getResource("FrameApp");
    }

    public AppMenuBar getMenuBar() {
        return this.menuBar;
    }

    public void setSizes() {
        int FRAME_WIDTH = (Integer)this.rb.getObject("kframew");
        int FRAME_HEIGTH = (Integer)this.rb.getObject("kframeh");
        int PANEL_MOLECULE_WIDTH = (Integer)this.rb.getObject("kpanelmolw");
        int TOOLBAR_WIDTH = (Integer)this.rb.getObject("ktoolbarw");
        int STATUSBAR_HEIGTH = (Integer)this.rb.getObject("kstatusbarh");
        int TOOLBAR_MES_WIDTH = (Integer)this.rb.getObject("ktoolbarmw");
        this.toolBarHuckel.setPreferredSize(new Dimension(TOOLBAR_WIDTH, FRAME_HEIGTH));
        this.toolBarHuckel.setMinimumSize(new Dimension(TOOLBAR_WIDTH, FRAME_HEIGTH));
        this.toolBarMesomery.setPreferredSize(new Dimension(TOOLBAR_MES_WIDTH, FRAME_HEIGTH));
        this.toolBarMesomery.setMinimumSize(new Dimension(TOOLBAR_MES_WIDTH, FRAME_HEIGTH));
        this.mesomeryView.setPreferredSize(new Dimension(PANEL_MOLECULE_WIDTH, FRAME_HEIGTH));
        this.mesomeryView.setMinimumSize(new Dimension(PANEL_MOLECULE_WIDTH, FRAME_HEIGTH));
        this.statusBar.setPreferredSize(new Dimension(FRAME_WIDTH, STATUSBAR_HEIGTH));
        this.statusBar.setMinimumSize(new Dimension(FRAME_WIDTH, STATUSBAR_HEIGTH));
        this.setSize(new Dimension(FRAME_WIDTH, FRAME_HEIGTH));
        this.setPreferredSize(new Dimension(FRAME_WIDTH, FRAME_HEIGTH));
        this.setMinimumSize(new Dimension(FRAME_WIDTH, FRAME_HEIGTH));
    }

    @Override
    public void destroy() {
        System.out.println("destroy");
        try {
            try {
                Window[] windowArray = Frame.getWindows();
                int n = windowArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Window w = windowArray[n2];
                    if (w instanceof FrameResult) {
                        w.dispose();
                    }
                    ++n2;
                }
                ActionCommandRegistry.clear();
                if (this.registerDurationThread != null && this.registerDurationThread.isAlive()) {
                    this.registerDurationThread.interrupt();
                }
            }
            catch (Exception exception) {
                ErrorReport.clear();
                ConnectSQL.clear();
                super.destroy();
            }
        }
        finally {
            ErrorReport.clear();
            ConnectSQL.clear();
            super.destroy();
        }
    }

    public synchronized void terminate(int errcode) {
        try {
            ThreadUtils.invokeAsSoonAsPossible(new Runnable(){

                @Override
                public void run() {
                    FrameApp.this.setVisible(false);
                }
            });
            this.registerDisconnect();
            this.stop();
            this.destroy();
            Frame frame = JOptionPane.getFrameForComponent(this);
            if (frame != null) {
                frame.dispose();
            }
            if (!this.isExecutedOnInternet()) {
                System.exit(errcode);
            }
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
    }

    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public PolyCalculator getPolyCalc() {
        int nelec = this.getCurrentMesomery().getDelocalizedStructure().getSumOfPiElec();
        if (this.polyCalc == null) {
            this.polyCalc = new PolyCalculator(nelec);
        }
        return this.polyCalc;
    }

    public void setOwnedToFrame(boolean ownedToFrame) {
        this.ownedToFrame = ownedToFrame;
    }

    public boolean isOwnedToFrame() {
        return this.ownedToFrame;
    }

    public String getCheckVersionTxt() {
        MyResourceBundle bundle = LanguageManager.getInstance().getResource("About");
        if (this.isExecutedOnInternet()) {
            return "";
        }
        String txt = "";
        if (!PreferencesGUI.getInstance().isCheckVersion()) {
            return "";
        }
        Version avalaibleVersion = ConnectSQL.getCurrentVersion();
        if (avalaibleVersion != null && avalaibleVersion.compareTo(this.getVersion()) > 0) {
            if (!txt.equals("")) {
                txt = String.valueOf(txt) + ". ";
            }
            txt = String.valueOf(txt) + bundle.getString("avalaibleversion") + " " + avalaibleVersion;
        }
        return txt;
    }

    public long getTimeBeginUse() {
        return this.timeBeginUse;
    }

    public String getLastAction() {
        return this.lastAction;
    }

    public void setLastAction(String lastAction) {
        this.lastAction = lastAction;
    }

    public void setCookieManager(CookieManager cookieManager) {
        this.cookieManager = cookieManager;
    }

    public void setMesomery(Mesomery m, String currentStructureName, String selectedCommand) {
        if (currentStructureName == "") {
            currentStructureName = "tot";
        }
        if (selectedCommand == "") {
            selectedCommand = this.getCurrentEnabledCommand();
        }
        this.getCurrentMesomeryView().setMesomery(m);
        m.addListener(this.getToolBarHuckel());
        m.addListener(this.getStateManager());
        this.getToolBarMesomery().setMesomery(m);
        ArrayList<JFrame> toClose = new ArrayList<JFrame>();
        Window[] windowArray = JFrame.getWindows();
        int n = windowArray.length;
        int n2 = 0;
        while (n2 < n) {
            Window r = windowArray[n2];
            if (r instanceof IStructureReference) {
                IStructureReference sr = (IStructureReference)((Object)r);
                Structure s = sr.getStructure();
                String name = s.getName();
                Structure searched = m.getStructureByName(name);
                if (searched != null) {
                    sr.setStructure(searched);
                } else {
                    toClose.add((JFrame)((Object)sr));
                }
            } else if (r instanceof IMesomeryReference) {
                FrameResultMesomery mr = (FrameResultMesomery)r;
                mr.setMesomery(m);
            }
            ++n2;
        }
        for (JFrame fr : toClose) {
            fr.dispose();
        }
        Structure current = m.getStructureByName(currentStructureName);
        if (current == null) {
            SwingIO.warning(this.getClass().getName(), "restoreState", "structure Psi" + currentStructureName + " was not found in the restored mesomery, try to get the delocalized structure");
            current = m.getDelocalizedStructure();
            if (current == null) {
                SwingIO.warning(this.getClass().getName(), "restoreState", "structure Psitot was not found anymore in the restored mesomery");
            }
        }
        this.getCurrentMesomeryView().setCurrentStructure(current);
        ActionCommandRegistry.getInstance().enableAll();
        this.clickButtonCommand(selectedCommand);
        EnableActionManager.getInstance().updateActionsToEnable(this);
        this.getToolBarHuckel().refresh();
        this.getToolBarMesomery().refresh();
    }
}

