/*
 * Decompiled with CFR 0.152.
 */
package views;

import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.HashMap;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.ctom.hulis.huckel.BlocDelocalized;
import org.ctom.hulis.huckel.events.BlocDelocalizedEvent;
import org.ctom.hulis.huckel.events.HuckelAtomEvent;
import org.ctom.hulis.huckel.events.HuckelBondEvent;
import org.ctom.hulis.huckel.events.MoleculeEvent;
import org.ctom.hulis.huckel.events.MonoExcitationEvent;
import org.ctom.hulis.huckel.events.StructureDelocalizedEvent;
import org.ctom.hulis.huckel.events.StructureEvent;
import org.ctom.hulis.huckel.events.StructureLocalizedEvent;
import org.ctom.hulis.huckel.listeners.IStructureDelocalizedListener;
import org.ctom.hulis.huckel.listeners.IStructureListener;
import org.ctom.hulis.huckel.listeners.IStructureLocalizedListener;
import org.ctom.hulis.huckel.structures.Structure;
import org.ctom.hulis.huckel.structures.StructureLocalized;
import util.MyResourceBundle;
import util.ThreadUtils;
import util.io.SwingIO;
import views.IStructureReference;
import views.StructureView;

public class FrameBlocs
extends JFrame
implements IStructureListener,
IStructureLocalizedListener,
IStructureDelocalizedListener,
ActionListener,
ListSelectionListener,
IStructureReference,
FocusListener {
    private static HashMap<StructureView, FrameBlocs> instances = new HashMap();
    public static int SPACE_TABS = 10;
    public static int X_MIN_TABS = 20;
    protected MyResourceBundle bundle2;
    protected JButton btAjouter;
    protected JButton btSupprimer;
    protected JButton btSave;
    protected JButton btOk;
    protected JLabel lblTotal;
    protected JTextField txtNbElec;
    JList lstBlocs;
    StructureView structureView;
    StructureLocalized structure;
    Mode mode;

    public static FrameBlocs getInstance(StructureView sw) {
        FrameBlocs frame = instances.get(sw);
        if (frame == null) {
            try {
                frame = new FrameBlocs(sw);
                instances.put(sw, frame);
            }
            catch (Exception e) {
                SwingIO.warning("FrameBlocs", "getInstance", e.getMessage(), e);
            }
        }
        return frame;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.btAjouter) {
            if (this.structure.getMesomeryParent().countAllSructs() > 1) {
                return;
            }
            if (this.mode == Mode.ADD) {
                return;
            }
            this.txtNbElec.setText("");
            DefaultListModel model = (DefaultListModel)this.lstBlocs.getModel();
            model.addElement("new");
            this.lstBlocs.setSelectedIndex(model.getSize() - 1);
            this.mode = Mode.ADD;
        } else if (e.getSource() == this.btSupprimer) {
            if (this.structure.getMesomeryParent().countAllSructs() > 1) {
                return;
            }
            if (this.mode == Mode.ADD) {
                DefaultListModel model = (DefaultListModel)this.lstBlocs.getModel();
                model.remove(model.getSize() - 1);
                this.mode = Mode.CHANGE;
                return;
            }
            BlocDelocalized bloc = this.getSelectedBloc();
            if (bloc == null) {
                JOptionPane.showMessageDialog(this, "Please select a bloc");
                return;
            }
            this.structure.removeBlocDelocalized(bloc);
            bloc.clear();
            bloc = null;
            StructureView.setSelectedBlocDelocalized(null);
            this.mode = Mode.CHANGE;
        } else if (e.getSource() == this.btSave) {
            BlocDelocalized bloc;
            if (this.structure.getMesomeryParent().countAllSructs() > 1) {
                return;
            }
            if (this.mode == Mode.ADD) {
                bloc = new BlocDelocalized();
                this.structure.addBlocDelocalized(bloc);
            } else {
                bloc = this.getSelectedBloc();
            }
            if (bloc == null) {
                JOptionPane.showMessageDialog(this, "Please select a bloc");
                return;
            }
            try {
                bloc.setNbElectron(Integer.valueOf(this.txtNbElec.getText()));
                this.mode = Mode.CHANGE;
            }
            catch (NumberFormatException e1) {
                e1.printStackTrace();
                JOptionPane.showMessageDialog(this, "The value must be a number");
            }
        } else if (e.getSource() == this.btOk) {
            StructureView.setSelectedBlocDelocalized(null);
            this.structureView.repaint();
            this.dispose();
        }
    }

    protected FrameBlocs(StructureView structureView) throws Exception {
        if (structureView == null) {
            throw new Exception("structureView must be initialized");
        }
        this.structureView = structureView;
        this.structure = (StructureLocalized)structureView.getStructure();
        this.structure.addListener(this);
        this.txtNbElec = new JTextField(5);
        this.lblTotal = new JLabel();
        this.btAjouter = new JButton("+");
        this.btSupprimer = new JButton("-");
        this.btSave = new JButton("Save");
        this.btOk = new JButton("Ok");
        this.btAjouter.addActionListener(this);
        this.btSupprimer.addActionListener(this);
        this.btSave.addActionListener(this);
        this.btOk.addActionListener(this);
        this.setTitle("\u03c8" + this.structure.getName() + " blocs");
        this.lstBlocs = new JList();
        this.lstBlocs.setSelectionMode(0);
        this.lstBlocs.addListSelectionListener(this);
        Container pane = this.getContentPane();
        JScrollPane scrollPane = new JScrollPane(this.lstBlocs);
        scrollPane.getViewport().setView(this.lstBlocs);
        pane.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.insets = new Insets(5, 5, 0, 0);
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.ipadx = 0;
        c.ipady = 0;
        c.fill = 0;
        c.anchor = 10;
        pane.add((Component)new JLabel("Blocs list :"), c);
        c.gridx = 2;
        c.gridy = 0;
        c.insets = new Insets(5, 0, 5, 0);
        c.gridwidth = 2;
        c.gridheight = 1;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.ipadx = 0;
        c.ipady = 0;
        c.fill = 0;
        c.anchor = 10;
        pane.add((Component)new JLabel("Selected bloc :"), c);
        c.gridx = 0;
        c.gridy = 1;
        c.insets = new Insets(5, 5, 0, 0);
        c.gridwidth = 2;
        c.gridheight = 2;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.ipadx = 0;
        c.ipady = 0;
        c.fill = 1;
        c.anchor = 10;
        pane.add((Component)scrollPane, c);
        c.gridx = 2;
        c.gridy = 1;
        c.insets = new Insets(5, 10, 0, 0);
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.ipadx = 0;
        c.ipady = 0;
        c.fill = 0;
        c.anchor = 24;
        pane.add((Component)new JLabel("Nb e- :"), c);
        c.gridx = 3;
        c.gridy = 1;
        c.insets = new Insets(5, 5, 0, 5);
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.ipadx = 0;
        c.ipady = 0;
        c.fill = 2;
        c.anchor = 23;
        pane.add((Component)this.txtNbElec, c);
        c.gridx = 3;
        c.gridy = 2;
        c.insets = new Insets(5, 5, 0, 5);
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 0.0;
        c.weighty = 1.0;
        c.ipadx = 0;
        c.ipady = 0;
        c.fill = 2;
        c.anchor = 23;
        pane.add((Component)this.btSave, c);
        c.gridx = 0;
        c.gridy = 3;
        c.insets = new Insets(5, 5, 0, 0);
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.ipadx = 0;
        c.ipady = 0;
        c.fill = 2;
        c.anchor = 23;
        pane.add((Component)this.lblTotal, c);
        c.gridx = 0;
        c.gridy = 4;
        c.insets = new Insets(5, 5, 0, 0);
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.ipadx = 0;
        c.ipady = 0;
        c.fill = 0;
        c.anchor = 23;
        pane.add((Component)this.btAjouter, c);
        this.btAjouter.setEnabled(false);
        c.gridx = 1;
        c.gridy = 4;
        c.insets = new Insets(5, 0, 0, 0);
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.ipadx = 0;
        c.ipady = 0;
        c.fill = 0;
        c.anchor = 23;
        pane.add((Component)this.btSupprimer, c);
        c.gridx = 3;
        c.gridy = 5;
        c.insets = new Insets(5, 0, 5, 5);
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.ipadx = 0;
        c.ipady = 0;
        c.fill = 0;
        c.anchor = 24;
        pane.add((Component)this.btOk, c);
        this.setSize(320, 250);
        final FrameBlocs frameExcitations = this;
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                frameExcitations.dispose();
            }
        });
        this.showBlocs();
        this.addFocusListener(this);
    }

    public void showBlocs() {
        DefaultListModel<String> model = new DefaultListModel<String>();
        int i2 = 0;
        for (BlocDelocalized bloc : this.structure.getListBlocDelocalized()) {
            String s = "bloc " + i2;
            ++i2;
            model.addElement(s);
        }
        this.lstBlocs.setModel(model);
        this.lblTotal.setText("Total : " + this.structure.getListBlocDelocalized().size());
        this.mode = Mode.CHANGE;
    }

    @Override
    public void dispose() {
        instances.remove(this.structure);
        this.structure.removeListener(this);
        super.dispose();
    }

    @Override
    public Structure getStructure() {
        return this.structure;
    }

    @Override
    public void moleculeDeleted(MoleculeEvent e) {
        final FrameBlocs frame = this;
        ThreadUtils.invokeAsSoonAsPossible(new Runnable(){

            @Override
            public void run() {
                FrameBlocs.this.structure.removeListener(frame);
                FrameBlocs.this.dispose();
            }
        });
    }

    @Override
    public void setStructure(Structure s) {
        this.structure.removeListener(this);
        this.structure = (StructureLocalized)s;
        this.structure.addListener(this);
        this.showBlocs();
    }

    @Override
    public void moleculeAtomAdded(MoleculeEvent e) {
        ThreadUtils.invokeAsSoonAsPossible(new Runnable(){

            @Override
            public void run() {
                FrameBlocs.this.showBlocs();
            }
        });
    }

    @Override
    public void moleculeAtomRemoved(MoleculeEvent e) {
        ThreadUtils.invokeAsSoonAsPossible(new Runnable(){

            @Override
            public void run() {
                FrameBlocs.this.showBlocs();
            }
        });
    }

    @Override
    public void moleculeAtomReplaced(MoleculeEvent e) {
    }

    @Override
    public void moleculeBondAdded(MoleculeEvent e) {
        ThreadUtils.invokeAsSoonAsPossible(new Runnable(){

            @Override
            public void run() {
                FrameBlocs.this.showBlocs();
            }
        });
    }

    @Override
    public void moleculeBondRemoved(MoleculeEvent e) {
        ThreadUtils.invokeAsSoonAsPossible(new Runnable(){

            @Override
            public void run() {
                FrameBlocs.this.showBlocs();
            }
        });
    }

    @Override
    public void moleculeChargeChanged(MoleculeEvent event) {
    }

    @Override
    public void moleculeListHuckelAtomSeqNumAutoSetted(MoleculeEvent event) {
    }

    @Override
    public void moleculeListHuckelAtomSeqNumReset(MoleculeEvent event) {
    }

    @Override
    public void huckelAtomHxChanged(HuckelAtomEvent e) {
    }

    @Override
    public void huckelAtomRadRChanged(HuckelAtomEvent e) {
    }

    @Override
    public void huckelAtomSeqNumChanged(HuckelAtomEvent e) {
    }

    @Override
    public void huckelBondBondTypeChanged(HuckelBondEvent e) {
    }

    @Override
    public void huckelBondHxyChanged(HuckelBondEvent e) {
    }

    @Override
    public void structureNameChanged(StructureEvent event) {
    }

    @Override
    public void monoExcitationTriggered(MonoExcitationEvent e) {
    }

    @Override
    public void structureLocalizedCoupleRemoved(StructureLocalizedEvent event) {
    }

    @Override
    public void structureLocalizedWeightChanged(StructureLocalizedEvent event) {
    }

    @Override
    public void structureLocalizedCoupleChanged(StructureLocalizedEvent event) {
    }

    @Override
    public void structureDelocalizedSpinChanged(StructureDelocalizedEvent event) {
    }

    @Override
    public void moleculeBlocDelocalizedAdded(MoleculeEvent event) {
        ThreadUtils.invokeAsSoonAsPossible(new Runnable(){

            @Override
            public void run() {
                FrameBlocs.this.showBlocs();
            }
        });
    }

    @Override
    public void moleculeBlocDelocalizedRemoved(MoleculeEvent event) {
        ThreadUtils.invokeAsSoonAsPossible(new Runnable(){

            @Override
            public void run() {
                FrameBlocs.this.showBlocs();
            }
        });
    }

    @Override
    public void blocDelocalizedHuckelObjectAdded(BlocDelocalizedEvent e) {
        ThreadUtils.invokeAsSoonAsPossible(new Runnable(){

            @Override
            public void run() {
                FrameBlocs.this.showBlocs();
            }
        });
    }

    @Override
    public void blocDelocalizedHuckelObjectRemoved(BlocDelocalizedEvent e) {
        ThreadUtils.invokeAsSoonAsPossible(new Runnable(){

            @Override
            public void run() {
                FrameBlocs.this.showBlocs();
            }
        });
    }

    @Override
    public void blocDelocalizedNbElectronsChanged(BlocDelocalizedEvent e) {
        ThreadUtils.invokeAsSoonAsPossible(new Runnable(){

            @Override
            public void run() {
                FrameBlocs.this.showBlocs();
            }
        });
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        BlocDelocalized bloc;
        if (!listSelectionEvent.getValueIsAdjusting()) {
            return;
        }
        if (this.mode == Mode.ADD) {
            DefaultListModel model = (DefaultListModel)this.lstBlocs.getModel();
            model.remove(model.getSize() - 1);
        }
        if ((bloc = this.getSelectedBloc()) != null) {
            this.txtNbElec.setText(Integer.toString(bloc.getNbElectron()));
            StructureView.setSelectedBlocDelocalized(bloc);
            this.structureView.repaint();
        }
        this.mode = Mode.CHANGE;
    }

    private BlocDelocalized getSelectedBloc() {
        if (this.lstBlocs.getSelectedIndex() < 0) {
            return null;
        }
        return this.structure.getListBlocDelocalized().get(this.lstBlocs.getSelectedIndex());
    }

    @Override
    public void focusGained(FocusEvent arg0) {
        BlocDelocalized bloc = this.getSelectedBloc();
        System.out.println("focus gained");
        if (bloc != null) {
            StructureView.setSelectedBlocDelocalized(bloc);
            this.structureView.repaint();
        }
    }

    @Override
    public void focusLost(FocusEvent arg0) {
        StructureView.setSelectedBlocDelocalized(null);
        System.out.println("focus lost");
        this.structureView.repaint();
    }

    static enum Mode {
        ADD,
        CHANGE;

    }
}

