/*
 * Decompiled with CFR 0.152.
 */
package views;

import controller.globalCommands.PopUp;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;
import javax.swing.text.StyledEditorKit;
import javax.swing.text.TabSet;
import javax.swing.text.TabStop;
import org.ctom.hulis.huckel.Energy;
import util.MyDecimalFormat;
import util.MyResourceBundle;
import util.ThreadUtils;
import util.io.SwingIO;
import util.languages.LanguageManager;
import views.FrameApp;
import views.SwingEnergyFormater;

public abstract class FrameResult
extends JFrame
implements ActionListener {
    public static String BT_CLOSE;
    public static String BT_REFRESH;
    protected MyDecimalFormat decimalFormatMO = new MyDecimalFormat("0.00");
    MyDecimalFormat decimalEnergyAlpha = new MyDecimalFormat("#.##");
    MyDecimalFormat decimalEnergyBeta = new MyDecimalFormat("0.00");
    protected Energy.EnergyFormater energyFormater = new SwingEnergyFormater(this.decimalEnergyAlpha, this.decimalEnergyBeta);
    protected MyResourceBundle bundle;
    DefaultStyledDocument docTXT;
    JButton jbFermer;
    JButton jbRefresh;
    protected int offset;
    private StringBuffer stringResult;
    protected JTextPane txtResult;
    protected FrameApp app;
    protected volatile boolean isRefreshing;
    protected volatile boolean stopCurrentRefresh;

    public MyDecimalFormat getMyDecimalFormatMO() {
        return this.decimalFormatMO;
    }

    public Energy.EnergyFormater getEnergyformater() {
        return this.energyFormater;
    }

    public void setMyDecimalFormat(MyDecimalFormat decimalFormatMO, MyDecimalFormat decimalFormatEnergies) {
        this.decimalFormatMO = decimalFormatMO;
        this.energyFormater = new SwingEnergyFormater(this.decimalEnergyAlpha, decimalFormatEnergies);
    }

    protected FrameResult(FrameApp app) {
        this.app = app;
        final FrameResult frameResult = this;
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                frameResult.dispose();
            }
        });
        this.setPreferredSize(new Dimension(500, 600));
        this.setSize(new Dimension(100, 100));
        Container contenu = this.getContentPane();
        contenu.setLayout(new BorderLayout(5, 5));
        this.txtResult = new JTextPane();
        this.txtResult.setContentType("text/html; charset=UTF-8");
        this.txtResult.setPreferredSize(this.getPreferredSize());
        this.txtResult.setEditable(false);
        PopUp.pop(this.txtResult);
        JScrollPane ascTxtResult = new JScrollPane(this.txtResult, 20, 32);
        ascTxtResult.setHorizontalScrollBarPolicy(32);
        ascTxtResult.setVerticalScrollBarPolicy(22);
        ascTxtResult.setPreferredSize(new Dimension(800, 600));
        JPanel panneauBoutons = new JPanel();
        JPanel panneauBoutons2 = new JPanel();
        this.jbFermer = new JButton(BT_CLOSE);
        this.jbFermer.addActionListener(this);
        this.jbRefresh = new JButton(BT_REFRESH);
        this.jbRefresh.setVisible(false);
        this.jbRefresh.addActionListener(this);
        this.constructPanelButton(panneauBoutons2);
        panneauBoutons.add((Component)panneauBoutons2, "East");
        contenu.add((Component)ascTxtResult, "Center");
        contenu.add((Component)panneauBoutons, "South");
        this.setLang();
        this.pack();
    }

    protected void constructPanelButton(JPanel pannelButton) {
        pannelButton.add(this.jbFermer);
        pannelButton.add(this.jbRefresh);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand() == BT_CLOSE) {
            this.dispose();
        } else {
            this.refresh();
        }
    }

    @Override
    public void dispose() {
        super.dispose();
    }

    protected Color getBgTextColor() {
        return Color.white;
    }

    protected void insertHTML(String s) {
        this.stringResult.append(s);
    }

    protected void insertTXT(String s, int size, int align) {
        try {
            this.docTXT.insertString(this.offset, s, null);
        }
        catch (BadLocationException e) {
            SwingIO.error(this.getClass().getName(), "insertTXT", e.getMessage(), e);
        }
        int current = this.offset;
        this.offset += s.length();
        SimpleAttributeSet aSet = new SimpleAttributeSet();
        StyleConstants.setForeground(aSet, Color.black);
        StyleConstants.setBackground(aSet, this.getBgTextColor());
        StyleConstants.setFontFamily(aSet, "San Serif");
        StyleConstants.setFontSize(aSet, size);
        StyledDocument doc = this.txtResult.getStyledDocument();
        doc.setCharacterAttributes(current, this.offset, aSet, false);
        SimpleAttributeSet bSet = new SimpleAttributeSet();
        StyleConstants.setForeground(bSet, Color.black);
        StyleConstants.setBackground(bSet, this.getBgTextColor());
        StyleConstants.setFontFamily(bSet, "San Serif");
        StyleConstants.setAlignment(bSet, align);
        StyleConstants.setFontSize(bSet, size);
        doc.setParagraphAttributes(current, this.offset, bSet, false);
        if (this.stopCurrentRefresh) {
            this.isRefreshing = false;
        }
    }

    public abstract void putResultTXT();

    public void refresh() {
        new Thread(new Runnable(){

            @Override
            public void run() {
                FrameResult.this.stopCurrentRefresh = true;
                while (FrameResult.this.isRefreshing) {
                    try {
                        Thread.sleep(500L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
                FrameResult.this.stopCurrentRefresh = false;
                FrameResult.this.showResults();
            }
        }).start();
    }

    @Override
    public void setVisible(boolean visible) {
        super.setVisible(visible);
        this.refresh();
    }

    private void showResults() {
        ThreadUtils.invokeAsSoonAsPossible(new Runnable(){

            @Override
            public void run() {
                FrameResult.this.offset = 0;
                FrameResult.this.stringResult = new StringBuffer();
                FrameResult.this.docTXT = new DefaultStyledDocument();
                FrameResult.this.txtResult.setEditorKit(new StyledEditorKit());
                FrameResult.this.txtResult.setContentType("text/plain; charset=UTF-8");
                FrameResult.this.txtResult.setDocument(FrameResult.this.docTXT);
                FrameResult.this.txtResult.setBackground(FrameResult.this.getBgTextColor());
                FrameResult.this.txtResult.setComponentOrientation((ComponentOrientation)FrameResult.this.bundle.getObject("orientation"));
                FrameResult.this.putResultTXT();
                FrameResult.this.txtResult.setCaretPosition(0);
            }
        });
    }

    public void tabule(int deb, int fin, int xmintabs, int width, int ntabs) {
        int align;
        float pos;
        ArrayList<TabStop> list = new ArrayList<TabStop>();
        if (this.txtResult.getComponentOrientation().equals(ComponentOrientation.LEFT_TO_RIGHT)) {
            pos = 0.0f;
            align = 0;
        } else {
            pos = this.txtResult.getWidth();
            align = 1;
        }
        int leader = 0;
        TabStop tstop = new TabStop(pos, align, leader);
        list.add(tstop);
        int j = 0;
        while (j < ntabs) {
            pos = this.txtResult.getComponentOrientation().equals(ComponentOrientation.LEFT_TO_RIGHT) ? (float)(xmintabs + width + j * width) : (float)(this.txtResult.getWidth() - xmintabs - width - j * width);
            align = 4;
            leader = 0;
            tstop = new TabStop(pos, align, leader);
            list.add(tstop);
            ++j;
        }
        TabStop[] tstops = list.toArray(new TabStop[0]);
        TabSet tabs = new TabSet(tstops);
        SimpleAttributeSet attributes = new SimpleAttributeSet();
        StyleConstants.setTabSet(attributes, tabs);
        this.txtResult.getStyledDocument().setParagraphAttributes(deb, fin, attributes, false);
    }

    public void setLang() {
        this.bundle = LanguageManager.getInstance().getResource("FrameResult");
        Font btFont = (Font)this.bundle.getObject("font");
        this.jbFermer.setFont(btFont);
        this.jbRefresh.setFont(btFont);
        BT_CLOSE = this.bundle.getString("kclose");
        BT_REFRESH = this.bundle.getString("krefresh");
        this.jbFermer.setText(BT_CLOSE);
        this.jbRefresh.setText(BT_REFRESH);
    }

    public void updateLanguage() {
        this.setLang();
        this.refresh();
    }
}

