/*
 * Decompiled with CFR 0.152.
 */
package views;

import java.awt.Color;
import java.awt.FontMetrics;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.DateFormat;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.ctom.hulis.files.gaussian.WriteGaussian;
import org.ctom.hulis.files.xyz.WritexyzException;
import org.ctom.hulis.huckel.Energy;
import org.ctom.hulis.huckel.HuckelBond;
import org.ctom.hulis.huckel.Mesomery;
import org.ctom.hulis.huckel.adapters.MoleculeAdapter;
import org.ctom.hulis.huckel.comparators.MethodNameComparator;
import org.ctom.hulis.huckel.events.BlocDelocalizedEvent;
import org.ctom.hulis.huckel.events.GeometryEvent;
import org.ctom.hulis.huckel.events.HuckelAtomEvent;
import org.ctom.hulis.huckel.events.HuckelBondEvent;
import org.ctom.hulis.huckel.events.MesomeryEvent;
import org.ctom.hulis.huckel.events.MoleculeEvent;
import org.ctom.hulis.huckel.events.MonoExcitationEvent;
import org.ctom.hulis.huckel.events.StructureDelocalizedEvent;
import org.ctom.hulis.huckel.events.StructureEvent;
import org.ctom.hulis.huckel.events.StructureLocalizedEvent;
import org.ctom.hulis.huckel.exception.HLPOverlapException;
import org.ctom.hulis.huckel.exception.NoElectronException;
import org.ctom.hulis.huckel.exception.NullOvlMatrixException;
import org.ctom.hulis.huckel.exception.OrbitaleMoleculaireException;
import org.ctom.hulis.huckel.exception.RedundanceException;
import org.ctom.hulis.huckel.listeners.IMesomeryListener;
import org.ctom.hulis.huckel.listeners.IMoleculeListener;
import org.ctom.hulis.huckel.methods.HLPMethod;
import org.ctom.hulis.huckel.methods.IMethod;
import org.ctom.hulis.huckel.structures.Structure;
import org.ctom.hulis.huckel.structures.StructureDelocalized;
import org.ctom.hulis.huckel.structures.StructureLocalized;
import util.MyResourceBundle;
import util.SwingNumberFormater;
import util.ThreadUtils;
import util.io.SwingIO;
import util.languages.LanguageManager;
import views.FrameApp;
import views.FrameResult;
import views.IMesomeryReference;

public class FrameResultMesomery
extends FrameResult
implements IMesomeryReference,
IMesomeryListener {
    public static String FORMAT_DECIMAL2 = "#.#";
    private static HashMap<Mesomery, FrameResultMesomery> instances = new HashMap();
    public static String NOTHING;
    public static int SPACE_TABS;
    public static int X_MIN_TABS;
    protected MyResourceBundle bundle2;
    private Mesomery mesomery;
    int size;
    int size2;
    int align1;
    int align2;
    private JCheckBox initialOrientationCheckBox;
    public JCheckBox nboCheckBox;
    private MoleculeAdapter moleculeAdapter;

    static {
        SPACE_TABS = 10;
        X_MIN_TABS = 20;
    }

    public static FrameResultMesomery getInstance(FrameApp app) {
        Mesomery m = app.getCurrentMesomery();
        FrameResultMesomery fres = instances.get(m);
        if (fres == null) {
            try {
                fres = new FrameResultMesomery(app);
            }
            catch (Exception e) {
                SwingIO.warning("FrameResultMesomery'", "getInstance", e.getMessage(), e);
            }
            instances.put(m, fres);
            return fres;
        }
        return fres;
    }

    protected FrameResultMesomery(FrameApp app) throws Exception {
        super(app);
        this.mesomery = app.getCurrentMesomery();
        if (this.mesomery == null) {
            throw new Exception("mesomery must be intitalized");
        }
        this.mesomery = app.getCurrentMesomery();
        this.mesomery.addListener(this);
        this.moleculeAdapter = new FrameMoleculeAdapter();
        StructureDelocalized structureDelocalized = this.mesomery.getDelocalizedStructure();
        if (structureDelocalized != null) {
            structureDelocalized.addListener((IMoleculeListener)this.moleculeAdapter);
        }
        this.updateLanguage();
        super.refresh();
    }

    @Override
    protected void constructPanelButton(JPanel pannelButton) {
        pannelButton.add(this.jbFermer);
        this.nboCheckBox = new JCheckBox("NBO");
        this.nboCheckBox.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                FrameResultMesomery.this.initialOrientationCheckBox.setSelected(FrameResultMesomery.this.nboCheckBox.isSelected());
                FrameResultMesomery.this.refresh();
            }
        });
        this.initialOrientationCheckBox = new JCheckBox("initial orientation");
        this.initialOrientationCheckBox.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                FrameResultMesomery.this.refresh();
            }
        });
        pannelButton.add(this.nboCheckBox);
        pannelButton.add(this.initialOrientationCheckBox);
        pannelButton.add(this.jbRefresh);
    }

    @Override
    public void dispose() {
        instances.remove(this.mesomery);
        this.mesomery.removeListener(this);
        StructureDelocalized structureDelocalized = this.mesomery.getDelocalizedStructure();
        if (structureDelocalized != null) {
            structureDelocalized.removeListener((IMoleculeListener)this.moleculeAdapter);
        }
        super.dispose();
    }

    @Override
    protected Color getBgTextColor() {
        return new Color(255, 240, 216);
    }

    @Override
    public Mesomery getMesomery() {
        return this.mesomery;
    }

    @Override
    public void updateLanguage() {
        this.bundle2 = LanguageManager.getInstance().getResource("FrameResultMesomery");
        this.setTitle(this.bundle2.getString("ktitleresultsmesomery"));
        super.updateLanguage();
    }

    @Override
    public void putResultTXT() {
        int j;
        int i2;
        this.size = Integer.valueOf(this.bundle.getString("fontsize2"));
        this.size2 = 12;
        this.align1 = (Integer)this.bundle.getObject("align1");
        this.align2 = (Integer)this.bundle.getObject("align2");
        NOTHING = this.bundle2.getString("nothingmesomery");
        String RESULT_PHI_TOT = this.bundle2.getString("resmes1");
        DateFormat f = DateFormat.getDateTimeInstance(0, 0, LanguageManager.getInstance().getLocale());
        this.insertTXT("------------------------------------------------------------------\n", this.size, this.align1);
        this.insertTXT("HuLiS " + this.app.getVersion() + " - " + f.format(new Date()) + "\n", this.size, this.align1);
        this.insertTXT("------------------------------------------------------------------\n", this.size, this.align1);
        this.insertTXT("\n", this.size, this.align1);
        this.insertTXT(String.valueOf(RESULT_PHI_TOT) + "\n\n", this.size, this.align1);
        if (this.mesomery.isAutoGenerating()) {
            this.insertTXT(String.valueOf(this.bundle2.getString("waitweights")) + "\n", this.size, this.align1);
            return;
        }
        if (this.mesomery.isCalculatingWeights()) {
            this.insertTXT(String.valueOf(this.bundle2.getString("waitweights2")) + "\n", this.size, this.align1);
            return;
        }
        if (this.mesomery.getDelocalizedStructure() == null) {
            this.insertTXT(String.valueOf(NOTHING) + "\n", this.size, this.align1);
            return;
        }
        if (this.mesomery.getDelocalizedStructure().getNbElecCharge() > 0) {
            this.insertTXT(String.valueOf(this.bundle.getString("kWarNegCharge")) + "\n\n", this.size, this.align1);
        }
        if (this.mesomery.countSelectedLocalizedStructs() == 0) {
            this.insertTXT(String.valueOf(NOTHING) + "\n", this.size, this.align1);
            this.writeNBOString();
            return;
        }
        List<StructureLocalized> errStruct = this.mesomery.listIncorrectStructPiElecNumber();
        if (errStruct != null && errStruct.size() > 0) {
            for (StructureLocalized s : errStruct) {
                if (this.stopCurrentRefresh) {
                    this.isRefreshing = false;
                    return;
                }
                switch (s.getError()) {
                    case ERROR_TOO_MUCH_SINGLE_ELECTRONS: {
                        this.insertTXT("\u03c8" + s.getName() + " : " + this.bundle2.getString("tooMuchSingleElec") + "\n", this.size2, this.align2);
                        break;
                    }
                    case ERROR_INCORRECT_NB_PI_ELEC: {
                        Object[] args = new Object[]{"\u03c8" + s.getName(), new Integer(s.getSumOfPiElec()), new Integer(s.getMesomeryParent().getDelocalizedStructure().getSumOfPiElec())};
                        this.insertTXT(String.valueOf(MessageFormat.format(this.bundle2.getString("kelecerror"), args)) + "\n", this.size, this.align1);
                    }
                }
            }
            this.writeNBOString();
            return;
        }
        if (this.mesomery.countSelectedLocalizedStructs() <= 0) {
            this.insertTXT(NOTHING, this.size, this.align1);
            return;
        }
        this.insertTXT(String.valueOf(this.bundle2.getString("resmesnbgen")) + " " + this.mesomery.countLocalizedStructs() + "\n", this.size, this.align1);
        this.insertTXT(String.valueOf(this.bundle2.getString("resmesnbdisp")) + " " + this.mesomery.countSelectedLocalizedStructs() + "\n", this.size, this.align1);
        double[][] matC2 = new double[0][0];
        this.insertTXT("\n", this.size, this.align1);
        this.insertTXT(String.valueOf(this.bundle2.getString("resmes7")) + "\n", this.size, this.align1);
        IMethod[] mmethods = this.mesomery.getMethods();
        Arrays.sort(mmethods, new MethodNameComparator());
        IMethod[] iMethodArray = mmethods;
        int n = mmethods.length;
        int n2 = 0;
        while (n2 < n) {
            IMethod mmethod = iMethodArray[n2];
            if (mmethod.isImplementedHamiltonian()) {
                this.insertTXT("\n", this.size, this.align1);
                this.insertTXT(String.valueOf(mmethod.getName()) + " : \n", this.size2, this.align2);
                this.insertTXT("\t", this.size, this.align2);
                matC2 = this.mesomery.getMethod(mmethod.getName()).getHamiltonian();
                if (matC2 != null) {
                    i2 = 0;
                    while (i2 < matC2.length) {
                        if (this.stopCurrentRefresh) {
                            this.isRefreshing = false;
                            return;
                        }
                        this.insertTXT("\u03c8" + (i2 + 1) + " \t", this.size2, this.align2);
                        ++i2;
                    }
                    if (matC2.length > 0) {
                        this.insertTXT("\n", this.size, this.align2);
                    }
                    i2 = 0;
                    while (i2 < matC2.length) {
                        if (this.stopCurrentRefresh) {
                            this.isRefreshing = false;
                            return;
                        }
                        this.insertTXT("\u03c8" + (i2 + 1) + " \t ", this.size2, this.align2);
                        j = 0;
                        while (j < matC2[i2].length) {
                            if (this.stopCurrentRefresh) {
                                this.isRefreshing = false;
                                return;
                            }
                            if (i2 == j) {
                                this.insertTXT(" " + new Energy(this.mesomery.getDelocalizedStructure().getTotalEnergy().getAlpha(), matC2[i2][j], this.getEnergyformater()) + " \t", this.size2, this.align2);
                            } else {
                                this.insertTXT(" " + new Energy(0.0, matC2[i2][j], this.getEnergyformater()) + " \t", this.size2, this.align2);
                            }
                            ++j;
                        }
                        this.insertTXT("\n", this.size, this.align2);
                        ++i2;
                    }
                }
            }
            ++n2;
        }
        this.insertTXT("\n", this.size, this.align1);
        HLPMethod hlpMethod = (HLPMethod)this.mesomery.getMethod("HLP");
        double[][] overlaptab = new double[0][0];
        if (hlpMethod != null) {
            List<Structure> selectedStructures = this.mesomery.getSelectedStructures();
            this.insertTXT(String.valueOf(this.bundle2.getString("hlpOverlap")) + "\n", this.size, this.align1);
            try {
                try {
                    overlaptab = hlpMethod.getOverlapTabAll();
                }
                catch (ArithmeticException e) {
                    this.insertTXT("Cannot compute weight : Exceed valence\n", this.size, this.align1);
                    return;
                }
                catch (NullOvlMatrixException e) {
                    this.insertTXT("Cannot compute weight : unexpected error " + e.getClass().getName() + " - " + e.getMessage(), this.size, this.align1);
                    SwingIO.error(this.getClass().getName(), "putResultTXT", e.getClass().getName(), e);
                }
                catch (OrbitaleMoleculaireException e) {
                    this.insertTXT("Cannot compute weight : unexpected error " + e.getClass().getName() + " - " + e.getMessage(), this.size, this.align1);
                    SwingIO.error(this.getClass().getName(), "putResultTXT", e.getClass().getName(), e);
                }
                catch (HLPOverlapException e) {
                    this.insertTXT("Cannot compute weight : unexpected error " + e.getClass().getName() + " - " + e.getMessage(), this.size, this.align1);
                    SwingIO.error(this.getClass().getName(), "putResultTXT", e.getClass().getName(), e);
                }
                this.insertTXT("\t", this.size, this.align2);
                i2 = 0;
                while (i2 < overlaptab.length) {
                    this.insertTXT("\u03c8" + selectedStructures.get(i2).getName() + " \t", this.size2, this.align2);
                    ++i2;
                }
                if (overlaptab.length > 0) {
                    this.insertTXT("\n", this.size, this.align2);
                }
                i2 = 0;
                while (i2 < overlaptab.length) {
                    if (this.stopCurrentRefresh) {
                        this.isRefreshing = false;
                        return;
                    }
                    this.insertTXT("\u03c8" + selectedStructures.get(i2).getName() + " \t ", this.size2, this.align2);
                    j = 0;
                    while (j < overlaptab[i2].length) {
                        if (this.stopCurrentRefresh) {
                            this.isRefreshing = false;
                            return;
                        }
                        this.insertTXT(" " + this.getMyDecimalFormatMO().format(overlaptab[i2][j]) + " \t", this.size2, this.align2);
                        ++j;
                    }
                    this.insertTXT("\n", this.size, this.align2);
                    ++i2;
                }
            }
            catch (NoElectronException e) {
                this.insertTXT("Cannot compute weight : unexpected error " + e.getClass().getName() + " - " + e.getMessage(), this.size, this.align1);
                SwingIO.error(this.getClass().getName(), "putResultTXT", e.getClass().getName(), e);
            }
            catch (Exception e) {
                this.insertTXT("Cannot compute weight : unexpected error " + e.getClass().getName() + " - " + e.getMessage(), this.size, this.align1);
                SwingIO.error(this.getClass().getName(), "putResultTXT", e.getClass().getName(), e);
            }
        }
        this.insertTXT("\n", this.size, this.align1);
        this.insertTXT(String.valueOf(this.bundle2.getString("resmes10")) + "\n", this.size, this.align1);
        this.insertTXT(String.valueOf(this.bundle2.getString("resmes11")) + "\n", this.size, this.align1);
        List<Structure> lstStructuresHaveDemiElectrons = this.mesomery.getStructuresHaveDemiElectrons();
        if (this.getMesomery().getMethod("HLP") != null && lstStructuresHaveDemiElectrons.size() > 0) {
            String comma = "";
            String structuresNames = "";
            for (Structure s : lstStructuresHaveDemiElectrons) {
                structuresNames = String.valueOf(structuresNames) + comma + "\u03c8" + s.getName();
                comma = ", ";
            }
            Object[] args = new Object[]{structuresNames};
            this.insertTXT(String.valueOf(MessageFormat.format(this.bundle2.getString("kdemielectrons"), args)) + "\n", this.size, this.align1);
        }
        this.insertTXT(String.valueOf(this.bundle2.getString("methods")) + "\t", this.size2, this.align2);
        IMethod[] iMethodArray2 = mmethods;
        int args = mmethods.length;
        int structuresNames = 0;
        while (structuresNames < args) {
            IMethod method = iMethodArray2[structuresNames];
            this.insertTXT("\t\t" + method.getName(), this.size2, this.align2);
            ++structuresNames;
        }
        this.insertTXT("\n", this.size2, this.align2);
        String stau = "";
        boolean thereIsTau = false;
        IMethod[] iMethodArray3 = mmethods;
        int n3 = mmethods.length;
        int n4 = 0;
        while (n4 < n3) {
            IMethod method = iMethodArray3[n4];
            if (method.isImplementedTau() && method.getError() == null) {
                String tau = SwingNumberFormater.doubleToString(this.mesomery.getMethod(method.getName()).getTau() * 100.0, this.getMyDecimalFormatMO(), "%");
                stau = String.valueOf(stau) + "\t\t" + tau;
                thereIsTau = true;
            } else {
                stau = String.valueOf(stau) + "\t";
            }
            ++n4;
        }
        if (thereIsTau) {
            this.insertTXT(String.valueOf(this.bundle2.getString("tau")) + stau + "\n", this.size2, this.align2);
        }
        this.insertTXT("\u03c8i\tEi ", this.size2, this.align2);
        iMethodArray3 = mmethods;
        n3 = mmethods.length;
        n4 = 0;
        while (n4 < n3) {
            IMethod method = iMethodArray3[n4];
            this.insertTXT("\tCi\tWi" + method.getName(), this.size2, this.align2);
            ++n4;
        }
        this.insertTXT("\n", this.size2, this.align2);
        i2 = 0;
        for (StructureLocalized s : this.mesomery.getSelectedLocalizedStructures()) {
            if (this.stopCurrentRefresh) {
                this.isRefreshing = false;
                return;
            }
            double w = 0.0;
            double ci = 0.0;
            this.insertTXT("\u03c8" + s.getName() + " \t " + Energy.format(s.getTotalEnergy(), this.getEnergyformater()), this.size2, this.align2);
            IMethod[] iMethodArray4 = mmethods;
            int n5 = mmethods.length;
            int n6 = 0;
            while (n6 < n5) {
                IMethod method = iMethodArray4[n6];
                if (method.getCI() != null && method.getCI().length > 0 && method.getError() == null) {
                    ci = method.getCI()[i2];
                    this.insertTXT("\t" + SwingNumberFormater.doubleToString(ci, this.getMyDecimalFormatMO()), this.size2, this.align2);
                } else {
                    this.insertTXT("\t", this.size2, this.align2);
                }
                if (this.mesomery.getMethod(method.getName()) != null && i2 < method.getWeights().length) {
                    w = s.getWeight(method.getName());
                    this.insertTXT("\t" + SwingNumberFormater.doubleToString(w * 100.0, this.getMyDecimalFormatMO(), "%"), this.size2, this.align2);
                } else {
                    this.insertTXT("\t", this.size2, this.align2);
                }
                ++n6;
            }
            if (s.getError() == StructureLocalized.Error.ERROR_ALREADY_EXIST) {
                this.insertTXT(" (\u03c8" + s.getIdenticalStruct().getName() + " " + this.bundle2.getString("kelecerror4") + ")", this.size2, this.align2);
            }
            this.insertTXT("\n", this.size, this.align2);
            ++i2;
        }
        this.insertTXT("\n", this.size, this.align2);
        this.insertTXT("\n", this.size, this.align2);
        iMethodArray3 = mmethods;
        int w = mmethods.length;
        int n7 = 0;
        while (n7 < w) {
            IMethod method = iMethodArray3[n7];
            if (method.getError() != null) {
                if (method.getError() instanceof RedundanceException) {
                    this.insertTXT(String.valueOf(this.bundle2.getString("methoderrorRedundance")) + "\n", this.size, this.align1);
                } else {
                    Object[] args2 = new Object[]{method.getName(), method.getError().getMessage()};
                    this.insertTXT(String.valueOf(MessageFormat.format(this.bundle2.getString("methoderror"), args2)) + "\n", this.size, this.align1);
                }
            }
            ++n7;
        }
        this.writeNBOString();
        this.insertTXT("\n", this.size, this.align2);
        this.insertTXT(this.bundle2.getString("publications"), this.size, this.align2);
        int nb = 6;
        if (matC2.length > nb) {
            nb = matC2.length;
        }
        if (overlaptab.length > nb) {
            nb = overlaptab.length;
        }
        FontMetrics metrics = this.getFontMetrics(this.txtResult.getFont());
        int width = SPACE_TABS + metrics.stringWidth(Energy.format(this.mesomery.getDelocalizedStructure().getTotalEnergy(), this.getEnergyformater()));
        this.tabule(0, this.txtResult.getStyledDocument().getLength() - 1, X_MIN_TABS, width, nb);
    }

    public void writeNBOString() {
        if (this.nboCheckBox.isSelected()) {
            this.insertTXT("\n", this.size, this.align1);
            this.insertTXT(String.valueOf(this.bundle2.getString("knbostring")) + "\n", this.size, this.align1);
            this.insertTXT("\n", this.size, this.align1);
            StringWriter stringWriter = new StringWriter();
            PrintWriter printWriter = new PrintWriter(stringWriter);
            DateFormat f = DateFormat.getDateTimeInstance(0, 0, LanguageManager.getInstance().getLocale());
            String messageHeader = "File generated by the HuLiS " + this.app.getVersion() + " code - " + f.format(new Date());
            try {
                WriteGaussian ioWriteGaussian = new WriteGaussian(this.mesomery);
                ioWriteGaussian.setMessageHeader(messageHeader);
                if (this.app.getCurrentMesomery().getDelocalizedStructure().isGeometryChanged()) {
                    ioWriteGaussian.setWriteInitialOrientation(false);
                    this.insertTXT("Cannot restore the initial orientation, the molecule has changed\n\n", this.size2, this.align2);
                } else {
                    ioWriteGaussian.setWriteInitialOrientation(this.initialOrientationCheckBox.isSelected());
                }
                List<HuckelBond> covRadii = this.app.getCurrentMesomery().getDelocalizedStructure().checkBondsCovalentRaii();
                if (covRadii.size() > 0) {
                    this.insertTXT("The geometry is not optimized. Some bonds may have been missed after reading the file in HuLiS : " + covRadii.stream().map(Object::toString).collect(Collectors.joining(", ")) + "\n\n", this.size2, this.align2);
                }
                ioWriteGaussian.setNumberFormater(new SwingNumberFormater(this.getMyDecimalFormatMO()));
                ioWriteGaussian.writeAll(printWriter);
                printWriter.flush();
                printWriter.close();
                this.insertTXT(stringWriter.toString(), this.size2, this.align2);
            }
            catch (WritexyzException e) {
                printWriter.close();
                this.insertTXT("Problem to write NBO string : " + e.getMessage(), this.size2, this.align2);
                e.printStackTrace();
            }
        }
    }

    @Override
    public void setMesomery(Mesomery mesomery) {
        instances.remove(this.mesomery);
        this.mesomery.removeListener(this);
        this.mesomery = mesomery;
        instances.put(mesomery, this);
        this.mesomery.addListener(this);
        this.refresh();
    }

    @Override
    public void mesomeryStructuresSelectionTresholdChanged(MesomeryEvent e) {
        this.refresh();
    }

    @Override
    public void mesomeryListWeightCalculated(MesomeryEvent e) {
        this.refresh();
    }

    @Override
    public void mesomeryMethodAdded(MesomeryEvent e) {
        this.refresh();
    }

    @Override
    public void mesomeryMethodRemoved(MesomeryEvent e) {
        this.refresh();
    }

    @Override
    public void mesomeryStructureAdded(MesomeryEvent e) {
        this.refresh();
    }

    @Override
    public void mesomeryStructureRemoved(MesomeryEvent e) {
        if (e.getOldValue() instanceof StructureDelocalized) {
            ThreadUtils.invokeAsSoonAsPossible(new Runnable(){

                @Override
                public void run() {
                    FrameResultMesomery.this.dispose();
                }
            });
        } else {
            this.refresh();
        }
    }

    @Override
    public void structureDelocalizedSpinChanged(StructureDelocalizedEvent event) {
    }

    @Override
    public void structureNameChanged(StructureEvent event) {
    }

    @Override
    public void moleculeAtomAdded(MoleculeEvent e) {
        if (this.nboCheckBox.isSelected()) {
            this.refresh();
        }
    }

    @Override
    public void moleculeAtomRemoved(MoleculeEvent e) {
        if (this.nboCheckBox.isSelected()) {
            this.refresh();
        }
    }

    @Override
    public void moleculeAtomReplaced(MoleculeEvent e) {
        if (this.nboCheckBox.isSelected()) {
            this.refresh();
        }
    }

    @Override
    public void moleculeBondAdded(MoleculeEvent e) {
        if (this.nboCheckBox.isSelected()) {
            this.refresh();
        }
    }

    @Override
    public void moleculeBondRemoved(MoleculeEvent e) {
        if (this.nboCheckBox.isSelected()) {
            this.refresh();
        }
    }

    @Override
    public void moleculeChargeChanged(MoleculeEvent event) {
        this.refresh();
    }

    @Override
    public void moleculeDeleted(MoleculeEvent e) {
    }

    @Override
    public void moleculeListHuckelAtomSeqNumAutoSetted(MoleculeEvent event) {
    }

    @Override
    public void moleculeListHuckelAtomSeqNumReset(MoleculeEvent event) {
    }

    @Override
    public void huckelAtomHxChanged(HuckelAtomEvent e) {
    }

    @Override
    public void huckelAtomRadRChanged(HuckelAtomEvent e) {
        this.refresh();
    }

    @Override
    public void huckelAtomSeqNumChanged(HuckelAtomEvent e) {
    }

    @Override
    public void huckelBondBondTypeChanged(HuckelBondEvent e) {
        this.refresh();
    }

    @Override
    public void huckelBondHxyChanged(HuckelBondEvent e) {
    }

    @Override
    public void monoExcitationTriggered(MonoExcitationEvent e) {
    }

    @Override
    public void structureLocalizedCoupleRemoved(StructureLocalizedEvent event) {
    }

    @Override
    public void structureLocalizedWeightChanged(StructureLocalizedEvent event) {
    }

    @Override
    public void structureLocalizedCoupleChanged(StructureLocalizedEvent event) {
    }

    @Override
    public void moleculeBlocDelocalizedAdded(MoleculeEvent event) {
    }

    @Override
    public void moleculeBlocDelocalizedRemoved(MoleculeEvent event) {
        this.refresh();
    }

    @Override
    public void blocDelocalizedHuckelObjectAdded(BlocDelocalizedEvent e) {
    }

    @Override
    public void blocDelocalizedHuckelObjectRemoved(BlocDelocalizedEvent e) {
    }

    @Override
    public void blocDelocalizedNbElectronsChanged(BlocDelocalizedEvent e) {
        this.refresh();
    }

    @Override
    public void mesomeryExceptionOccured(MesomeryEvent e, Exception exception) {
    }

    @Override
    public void mesomeryStartComputeWeights(MesomeryEvent event) {
        this.refresh();
    }

    @Override
    public void mesomeryStructuresSelectorChanged(MesomeryEvent event) {
    }

    private class FrameMoleculeAdapter
    extends MoleculeAdapter {
        private FrameMoleculeAdapter() {
        }

        @Override
        public void geometryHasChanged(GeometryEvent event) {
            if (FrameResultMesomery.this.nboCheckBox.isSelected()) {
                FrameResultMesomery.this.refresh();
            }
        }
    }
}

