/*
 * Decompiled with CFR 0.152.
 */
package views;

import Jama.Matrix;
import java.awt.Color;
import java.awt.FontMetrics;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import org.ctom.hulis.huckel.Bond;
import org.ctom.hulis.huckel.Energy;
import org.ctom.hulis.huckel.events.BlocDelocalizedEvent;
import org.ctom.hulis.huckel.events.HuckelAtomEvent;
import org.ctom.hulis.huckel.events.HuckelBondEvent;
import org.ctom.hulis.huckel.events.MoleculeEvent;
import org.ctom.hulis.huckel.events.MonoExcitationEvent;
import org.ctom.hulis.huckel.events.StructureDelocalizedEvent;
import org.ctom.hulis.huckel.events.StructureEvent;
import org.ctom.hulis.huckel.events.StructureLocalizedEvent;
import org.ctom.hulis.huckel.listeners.IStructureDelocalizedListener;
import org.ctom.hulis.huckel.listeners.IStructureListener;
import org.ctom.hulis.huckel.listeners.IStructureLocalizedListener;
import org.ctom.hulis.huckel.structures.Structure;
import org.ctom.hulis.huckel.structures.StructureDelocalized;
import org.ctom.hulis.huckel.structures.symmetry.Symmetry;
import org.ctom.hulis.util.io.HuckelIO;
import util.MyResourceBundle;
import util.ThreadUtils;
import util.io.SwingIO;
import util.languages.LanguageManager;
import views.FrameApp;
import views.FrameResult;
import views.FrameResultMesomery;
import views.IStructureReference;
import views.prefs.PreferencesGUI;

public class FrameResultStruct
extends FrameResult
implements IStructureListener,
IStructureLocalizedListener,
IStructureDelocalizedListener,
IStructureReference {
    private static HashMap<Structure, FrameResultStruct> instances = new HashMap();
    public static int SPACE_TABS = 10;
    public static int X_MIN_TABS = 20;
    protected MyResourceBundle bundle2;
    Structure structure;
    private Symmetry symmetry;

    public static FrameResultStruct getInstance(FrameApp app) {
        Structure s = app.getCurrentMesomeryView().getCurrentStructure();
        FrameResultStruct fres = instances.get(s);
        if (fres == null) {
            try {
                fres = new FrameResultStruct(app);
                instances.put(s, fres);
            }
            catch (Exception e) {
                SwingIO.warning("FrameResultStruct", "getInstance", e.getMessage(), e);
            }
        }
        return fres;
    }

    protected FrameResultStruct(FrameApp app) throws Exception {
        super(app);
        Structure structure = app.getCurrentMesomeryView().getCurrentStructure();
        if (structure == null) {
            throw new Exception("structure must be initialized");
        }
        this.structure = structure;
        this.symmetry = null;
        structure.addListener(this);
        this.updateLanguage();
    }

    @Override
    public void dispose() {
        instances.remove(this.structure);
        this.structure.removeListener(this);
        super.dispose();
    }

    @Override
    protected Color getBgTextColor() {
        return new Color(240, 255, 255);
    }

    @Override
    public Structure getStructure() {
        return this.structure;
    }

    @Override
    public void moleculeDeleted(MoleculeEvent e) {
        final FrameResultStruct frame = this;
        ThreadUtils.invokeAsSoonAsPossible(new Runnable(){

            @Override
            public void run() {
                FrameResultStruct.this.structure.removeListener(frame);
                FrameResultStruct.this.dispose();
            }
        });
    }

    @Override
    public void updateLanguage() {
        this.bundle2 = LanguageManager.getInstance().getResource("FrameResultStruct");
        this.setTitle("\u03c8" + this.structure.getName() + " - " + this.bundle2.getString("ktitleresultstruct"));
        super.updateLanguage();
    }

    @Override
    public void putResultTXT() {
        int size = Integer.valueOf(this.bundle.getString("fontsize2"));
        int size2 = 12;
        int align1 = (Integer)this.bundle.getObject("align1");
        int align2 = (Integer)this.bundle.getObject("align2");
        String RESULT_NO_ATOM = this.bundle2.getString("resh0");
        String RESULT_METHOD = this.bundle2.getString("resh1");
        String RESULT_ATOM_NB = this.bundle2.getString("resh2");
        String RESULT_HUCKEL_ATOM_NB = this.bundle2.getString("resh2a");
        String RESULT_PI_ELEC_NB = this.bundle2.getString("resh3");
        String RESULT_NET_CHARGE = this.bundle2.getString("resh4");
        String RESULT_HAMILT = this.bundle2.getString("resh5");
        String RESULT_ORB = this.bundle2.getString("resh6");
        String RESULT_ENERGY = this.bundle2.getString("resh7");
        String RESULT_TOTAL_ENERGY = this.bundle2.getString("resh8");
        String RESULT_BOND_ORDER = this.bundle2.getString("resh9");
        String RESULT_CHARGES = this.bundle2.getString("resh10");
        String RESULT_TOTAL_CHARGE = this.bundle2.getString("resh11");
        String RESULT_ELEC_DISTRIB = this.bundle2.getString("resh12");
        String RESULT_ATOM_CHARGE = this.bundle2.getString("resh13");
        DateFormat f = DateFormat.getDateTimeInstance(0, 0, LanguageManager.getInstance().getLocale());
        this.insertTXT("------------------------------------------------------------------\n", size, align1);
        this.insertTXT("HuLiS " + this.app.getVersion() + " - " + f.format(new Date()) + "\n", size, align1);
        this.insertTXT("------------------------------------------------------------------\n", size, align1);
        this.insertTXT("\n", size, align1);
        if (this.structure.countAtoms() == 0) {
            this.insertTXT("\u03c8" + this.structure.getName() + " : " + RESULT_NO_ATOM, size, align1);
            return;
        }
        double[][] hamiltonien = this.structure.getHamiltonianArray();
        try {
            int j;
            int i2;
            this.insertTXT("\u03c8" + this.structure.getName() + "\n", size, align1);
            if (hamiltonien == null) {
                return;
            }
            this.insertTXT(RESULT_METHOD, size, align1);
            if (this.structure instanceof StructureDelocalized) {
                this.insertTXT(this.bundle2.getString("kdeloc"), size, align1);
            } else {
                this.insertTXT(this.bundle2.getString("kloc"), size, align1);
            }
            this.insertTXT("\n", size, align1);
            this.insertTXT(String.valueOf(RESULT_ATOM_NB) + this.structure.countAtoms() + "\n", size, align1);
            this.insertTXT(String.valueOf(RESULT_HUCKEL_ATOM_NB) + this.structure.countHuckelAtoms() + "\n", size, align1);
            this.insertTXT(String.valueOf(RESULT_PI_ELEC_NB) + this.structure.getSumOfPiElec() + "\n", size, align1);
            this.insertTXT(String.valueOf(RESULT_NET_CHARGE) + -this.structure.getNbElecCharge() + "\n", size, align1);
            this.insertTXT("\n", size, align1);
            this.insertTXT(String.valueOf(RESULT_HAMILT) + "\n", size, align1);
            this.insertTXT("\t", size, align1);
            if (this.structure.areCorrectAtomsSeqNum()) {
                i2 = 0;
                while (i2 < hamiltonien.length) {
                    if (this.stopCurrentRefresh) {
                        this.isRefreshing = false;
                        return;
                    }
                    this.insertTXT(String.valueOf(i2 + 1) + "  ", size2, align2);
                    this.insertTXT(String.valueOf(this.structure.getHuckelAtomBySeqNum(i2 + 1).getSigle()) + "\t", size2, align2);
                    ++i2;
                }
            }
            this.insertTXT("\n", size, align2);
            if (this.structure.areCorrectAtomsSeqNum()) {
                i2 = 0;
                while (i2 < hamiltonien.length) {
                    if (this.stopCurrentRefresh) {
                        this.isRefreshing = false;
                        return;
                    }
                    this.insertTXT(String.valueOf(i2 + 1) + "  ", size2, align2);
                    this.insertTXT(String.valueOf(this.structure.getHuckelAtomBySeqNum(i2 + 1).getSigle()) + "\t", size2, align2);
                    j = 0;
                    while (j < hamiltonien[i2].length) {
                        if (this.stopCurrentRefresh) {
                            this.isRefreshing = false;
                            return;
                        }
                        if (i2 == j) {
                            this.insertTXT(new Energy(1.0, hamiltonien[i2][j], this.getEnergyformater()) + "\t", size2, align2);
                        } else {
                            this.insertTXT(new Energy(0.0, hamiltonien[i2][j], this.getEnergyformater()) + "\t", size2, align2);
                        }
                        ++j;
                    }
                    this.insertTXT("\n", size, align2);
                    ++i2;
                }
            }
            this.insertTXT("\n", size, align2);
            this.insertTXT(String.valueOf(RESULT_ORB) + "\n", size, align1);
            this.insertTXT(String.valueOf(RESULT_ENERGY) + "\t", size, align1);
            double[] energies = this.structure.getEnergiesArray();
            i2 = 0;
            while (i2 < energies.length) {
                if (this.stopCurrentRefresh) {
                    this.isRefreshing = false;
                    return;
                }
                this.insertTXT(new Energy(1.0, energies[i2], this.getEnergyformater()) + "\t", size2, align2);
                ++i2;
            }
            this.insertTXT("\n", size, align2);
            double[] repartElec = this.structure.getDistributionElecPiArray();
            this.insertTXT(String.valueOf(RESULT_ELEC_DISTRIB) + "\t", size, align2);
            i2 = 0;
            while (i2 < repartElec.length) {
                if (this.stopCurrentRefresh) {
                    this.isRefreshing = false;
                    return;
                }
                this.insertTXT(String.valueOf(this.getMyDecimalFormatMO().format(repartElec[i2])) + "\t", size2, align2);
                ++i2;
            }
            double[][] orbitales = this.structure.getOrbitalsCoeffArray();
            HuckelIO.PrintMatrix(new Matrix(orbitales), "orbitals results window");
            this.insertTXT("\n", size, align2);
            if (this.structure.areCorrectAtomsSeqNum()) {
                i2 = 0;
                while (i2 < orbitales.length) {
                    if (this.stopCurrentRefresh) {
                        this.isRefreshing = false;
                        return;
                    }
                    this.insertTXT(String.valueOf(i2 + 1) + "  ", size2, align2);
                    this.insertTXT(String.valueOf(this.structure.getHuckelAtomBySeqNum(i2 + 1).getSigle()) + "\t", size2, align2);
                    j = 0;
                    while (j < orbitales[i2].length) {
                        if (this.stopCurrentRefresh) {
                            this.isRefreshing = false;
                            return;
                        }
                        this.insertTXT(String.valueOf(this.getMyDecimalFormatMO().format(orbitales[i2][j])) + "\t", size2, align2);
                        ++j;
                    }
                    this.insertTXT("\n", size2, align2);
                    ++i2;
                }
            }
            this.insertTXT("\n", size, align2);
            Energy totalEnergy = new Energy(this.structure.getTotalEnergy().getAlpha(), this.structure.getTotalEnergy().getBeta(), this.getEnergyformater());
            this.insertTXT(String.valueOf(RESULT_TOTAL_ENERGY) + totalEnergy + "\n\n", size, align1);
            this.insertTXT(RESULT_BOND_ORDER, size, align1);
            double[][] bondOrders = this.structure.getBondOrdersArray();
            this.insertTXT("\n", size, align1);
            this.insertTXT("\t", size, align1);
            if (this.structure.areCorrectAtomsSeqNum()) {
                i2 = 0;
                while (i2 < bondOrders.length) {
                    if (this.stopCurrentRefresh) {
                        this.isRefreshing = false;
                        return;
                    }
                    this.insertTXT(String.valueOf(i2 + 1) + "  ", size2, align2);
                    this.insertTXT(String.valueOf(this.structure.getHuckelAtomBySeqNum(i2 + 1).getSigle()) + "\t", size2, align2);
                    ++i2;
                }
            }
            this.insertTXT("\n", size, align2);
            if (this.structure.areCorrectAtomsSeqNum()) {
                i2 = 0;
                while (i2 < bondOrders.length) {
                    if (this.stopCurrentRefresh) {
                        this.isRefreshing = false;
                        return;
                    }
                    this.insertTXT(String.valueOf(i2 + 1) + "  ", size2, align2);
                    this.insertTXT(String.valueOf(this.structure.getHuckelAtomBySeqNum(i2 + 1).getSigle()) + "\t", size2, align2);
                    j = 0;
                    while (j < bondOrders[i2].length) {
                        if (this.stopCurrentRefresh) {
                            this.isRefreshing = false;
                            return;
                        }
                        this.insertTXT(this.getMyDecimalFormatMO().format(bondOrders[i2][j]) + "\t", size2, align2);
                        ++j;
                    }
                    this.insertTXT("\n", size, align2);
                    ++i2;
                }
            }
            this.insertTXT("\n", size, align1);
            this.insertTXT(String.valueOf(RESULT_CHARGES) + "\n", size, align1);
            this.insertTXT(String.valueOf(RESULT_ATOM_CHARGE) + "\n", size, align2);
            Object tblCharges = this.structure.getChargeDensitiesArray();
            if (this.structure.areCorrectAtomsSeqNum()) {
                i2 = 0;
                while (i2 < ((Object)tblCharges).length) {
                    if (this.stopCurrentRefresh) {
                        this.isRefreshing = false;
                        return;
                    }
                    this.insertTXT(String.valueOf(i2 + 1) + "  " + this.structure.getHuckelAtomBySeqNum(i2 + 1).getSigle() + "\t", size2, align2);
                    this.insertTXT(String.valueOf(this.getMyDecimalFormatMO().format((double)tblCharges[i2])) + "\n", size2, align2);
                    ++i2;
                }
            }
            this.insertTXT("\n", size, align2);
            this.insertTXT(String.valueOf(RESULT_TOTAL_CHARGE) + this.getMyDecimalFormatMO().format(this.structure.getSumOFChargeDensities()) + "\n\n", size, align1);
            FontMetrics metrics = this.getFontMetrics(this.txtResult.getFont());
            int width = FrameResultMesomery.SPACE_TABS + metrics.stringWidth(Energy.format(this.structure.getTotalEnergy(), this.getEnergyformater()));
            if (hamiltonien.length > 0) {
                this.tabule(0, this.txtResult.getStyledDocument().getLength() - 1, X_MIN_TABS, width, hamiltonien[0].length);
            }
        }
        catch (Exception e) {
            SwingIO.warning(this.getClass().getName(), "putResultTXT", e.getMessage(), e);
        }
        if (PreferencesGUI.getSuperMario()) {
            Structure struct = this.structure;
            String str = struct.getCharacteristicPolynomial().toString();
            this.insertTXT(String.valueOf(str) + "\n", size, align1);
            Symmetry sym = this.getSymmetry();
            HashMap<String, ArrayList<Integer>> uniqueAtoms = sym.getUniqueAtoms();
            for (ArrayList<Integer> list : uniqueAtoms.values()) {
                this.insertTXT(list.toString(), size, align1);
            }
            this.insertTXT("\n", size, align1);
            HashMap<String, ArrayList<Bond>> uniqueBonds = sym.getUniqueBonds();
            for (ArrayList<Bond> list : uniqueBonds.values()) {
                this.insertTXT(list.toString(), size, align1);
            }
            this.insertTXT("\n", size, align1);
        }
    }

    private Symmetry getSymmetry() {
        if (this.symmetry == null) {
            this.createSymmetry();
        }
        return this.symmetry;
    }

    private void createSymmetry() {
        this.symmetry = new Symmetry(this.getStructure());
    }

    @Override
    public void setStructure(Structure s) {
        instances.remove(this.structure);
        this.structure.removeListener(this);
        this.structure = s;
        instances.put(this.structure, this);
        this.structure.addListener(this);
        this.refresh();
    }

    @Override
    public void moleculeAtomAdded(MoleculeEvent e) {
        this.createSymmetry();
        this.refresh();
    }

    @Override
    public void moleculeAtomRemoved(MoleculeEvent e) {
        this.createSymmetry();
        this.refresh();
    }

    @Override
    public void moleculeAtomReplaced(MoleculeEvent e) {
        this.createSymmetry();
        this.refresh();
    }

    @Override
    public void moleculeBondAdded(MoleculeEvent e) {
        this.createSymmetry();
        this.refresh();
    }

    @Override
    public void moleculeBondRemoved(MoleculeEvent e) {
        this.createSymmetry();
        this.refresh();
    }

    @Override
    public void moleculeChargeChanged(MoleculeEvent event) {
        this.refresh();
    }

    @Override
    public void moleculeListHuckelAtomSeqNumAutoSetted(MoleculeEvent event) {
        this.refresh();
    }

    @Override
    public void moleculeListHuckelAtomSeqNumReset(MoleculeEvent event) {
        this.refresh();
    }

    @Override
    public void huckelAtomHxChanged(HuckelAtomEvent e) {
        this.createSymmetry();
        this.refresh();
    }

    @Override
    public void huckelAtomRadRChanged(HuckelAtomEvent e) {
        this.refresh();
    }

    @Override
    public void huckelAtomSeqNumChanged(HuckelAtomEvent e) {
        this.refresh();
    }

    @Override
    public void huckelBondBondTypeChanged(HuckelBondEvent e) {
        this.refresh();
    }

    @Override
    public void huckelBondHxyChanged(HuckelBondEvent e) {
        this.createSymmetry();
        this.refresh();
    }

    @Override
    public void structureNameChanged(StructureEvent event) {
    }

    @Override
    public void monoExcitationTriggered(MonoExcitationEvent e) {
        this.refresh();
    }

    @Override
    public void structureLocalizedCoupleRemoved(StructureLocalizedEvent event) {
        this.refresh();
    }

    @Override
    public void structureLocalizedWeightChanged(StructureLocalizedEvent event) {
    }

    @Override
    public void structureLocalizedCoupleChanged(StructureLocalizedEvent event) {
    }

    @Override
    public void structureDelocalizedSpinChanged(StructureDelocalizedEvent event) {
        this.refresh();
    }

    @Override
    public void moleculeBlocDelocalizedAdded(MoleculeEvent event) {
        this.refresh();
    }

    @Override
    public void moleculeBlocDelocalizedRemoved(MoleculeEvent event) {
        this.refresh();
    }

    @Override
    public void blocDelocalizedHuckelObjectAdded(BlocDelocalizedEvent e) {
    }

    @Override
    public void blocDelocalizedHuckelObjectRemoved(BlocDelocalizedEvent e) {
    }

    @Override
    public void blocDelocalizedNbElectronsChanged(BlocDelocalizedEvent e) {
    }
}

