/*
 * Decompiled with CFR 0.152.
 */
package views;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.Ellipse2D;
import org.ctom.hulis.huckel.Atom;
import views.AtomColor;
import views.StructureView;
import views.prefs.PreferencesGUI;

public class GhostAtomDrawer {
    protected Atom atom;
    private final StructureView structureView;
    private Shape atomShape = null;
    Color atomBorderColor = null;
    Color atomFillColor = null;
    AtomColor atomColor;
    double atomRadius = 0.0;
    String symbol;

    protected GhostAtomDrawer(StructureView structureView, Atom atom) {
        this.structureView = structureView;
        this.atom = atom;
        try {
            this.atomColor = AtomColor.valueOf(this.atom.getSigle());
            this.atomRadius = this.atomColor.getRadius();
            this.atomBorderColor = this.atomColor.getBorderColor();
            this.atomFillColor = this.atomColor.getFillcolor();
            this.symbol = this.atom.getElement() == null ? this.atom.getSigle() : this.atom.getElement().toString();
        }
        catch (IllegalArgumentException e) {
            this.atomColor = AtomColor.Xx;
            this.atomRadius = this.atomColor.getRadius();
            this.atomBorderColor = this.atomColor.getBorderColor();
            this.atomFillColor = this.atomColor.getFillcolor();
            this.symbol = this.atom.getSigle();
        }
    }

    protected void draw(Graphics2D g2d) {
        g2d.setStroke(new BasicStroke(1.0f));
        if (PreferencesGUI.getInstance().isDisplayAtomsCircles()) {
            g2d.setColor(this.atomBorderColor);
        } else {
            g2d.setColor(this.structureView.getBackground());
        }
        g2d.draw(this.getForm());
        if (PreferencesGUI.getInstance().isDisplayAtomsCircles()) {
            g2d.setColor(this.atomFillColor);
        } else {
            g2d.setColor(this.structureView.getBackground());
        }
        g2d.fill(this.getForm());
    }

    protected Shape getForm() {
        if (this.atomShape != null) {
            return this.atomShape;
        }
        this.atomShape = new Ellipse2D.Double(this.atom.getX() - this.atomRadius, this.atom.getY() - this.atomRadius, 2.0 * this.atomRadius, 2.0 * this.atomRadius);
        return this.atomShape;
    }
}

