/*
 * Decompiled with CFR 0.152.
 */
package views;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import org.ctom.hulis.huckel.Bond;
import org.ctom.hulis.huckel.HuckelBond;
import org.ctom.hulis.huckel.structures.StructureLocalized;
import views.StructureView;

public class GhostBondDrawer {
    public static final Color BOND_COLOR = Color.LIGHT_GRAY;
    public static final Color BOND_TEXT_HXY_COLOR = Color.BLACK;
    public static final Color BOND_TEXT_BOND_ORDER_COLOR = new Color(0, 128, 0);
    public static final Color BOND_INFOS_COLOR2 = new Color(150, 75, 0);
    public static final float BOND_LINE_STROKE = 3.0f;
    public static final int BOND_MOUSE_SENSIBILITY = 10;
    public static final String FONT_FAMILY = "Helvetica";
    public static final int FONT_STYLE = 0;
    public static final int FONT_SIZE_INFOS = 14;
    float MAX_TAILLE_POINTILLES = 6.5f;
    private Bond bond;
    private Shape form;
    private Line2D line1;
    private final StructureView structureView;

    protected GhostBondDrawer(StructureView structureView, Bond bond) {
        this.structureView = structureView;
        this.bond = bond;
        this.form = this.getForm();
    }

    protected void draw(Graphics2D g2d) {
        float bondLineStroke = 3.0f;
        g2d.setColor(BOND_COLOR);
        g2d.setStroke(new BasicStroke(bondLineStroke));
        g2d.draw(this.line1);
    }

    protected Shape getForm() {
        double dX = this.bond.getAtom2().getX() - this.bond.getAtom1().getX();
        double dY = this.bond.getAtom2().getY() - this.bond.getAtom1().getY();
        double hyp = Math.sqrt(dX * dX + dY * dY);
        double projX = 0.0;
        double projY = 0.0;
        if (hyp != 0.0) {
            projX = dX / hyp * Math.cos(1.5707963267948966) + dY / hyp * Math.sin(1.5707963267948966);
            projY = dY / hyp * Math.cos(1.5707963267948966) - dX / hyp * Math.sin(1.5707963267948966);
        }
        Point2D.Double a11 = new Point2D.Double((int)(this.bond.getAtom1().getX() + projX), (int)(this.bond.getAtom1().getY() + projY));
        Point2D.Double a12 = new Point2D.Double((int)(this.bond.getAtom2().getX() + projX), (int)(this.bond.getAtom2().getY() + projY));
        if (hyp != 0.0) {
            projX = dX / hyp * Math.cos(1.5707963267948966) - dY / hyp * Math.sin(1.5707963267948966);
            projY = dY / hyp * Math.cos(1.5707963267948966) + dX / hyp * Math.sin(1.5707963267948966);
        }
        GeneralPath path = new GeneralPath();
        if (this.bond instanceof HuckelBond) {
            switch (((HuckelBond)this.bond).getBondType()) {
                case 1: {
                    boolean isHuckelBondinBlocDelocalized = false;
                    if (this.bond instanceof HuckelBond && ((HuckelBond)this.bond).getBlocDelocalizedParent() != null) {
                        isHuckelBondinBlocDelocalized = true;
                    }
                    if (this.bond.getMoleculeContainer() instanceof StructureLocalized && !isHuckelBondinBlocDelocalized) {
                        this.line1 = new Line2D.Double(this.bond.getAtom1().getX(), this.bond.getAtom1().getY(), this.bond.getAtom2().getX(), this.bond.getAtom2().getY());
                        path.append(this.line1, false);
                        break;
                    }
                    this.line1 = new Line2D.Double(a11, a12);
                    path.append(this.line1, false);
                    break;
                }
                case 2: {
                    this.line1 = new Line2D.Double(a11, a12);
                    path.append(this.line1, false);
                }
            }
        } else {
            this.line1 = new Line2D.Double(this.bond.getAtom1().getX(), this.bond.getAtom1().getY(), this.bond.getAtom2().getX(), this.bond.getAtom2().getY());
            path.append(this.line1, false);
        }
        path.closePath();
        return path;
    }

    protected Line2D getLine1() {
        return this.line1;
    }

    static enum BondForm {
        BROKEN_DOUBLE_LINE,
        FULL_SIMPLE_LINE,
        FULL_DOUBLE_LINE;

    }
}

