/*
 * Decompiled with CFR 0.152.
 */
package views;

import controller.graphOM.GraphOMController;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import javax.swing.JPanel;
import org.ctom.hulis.huckel.NatOrbitaleMoleculaire;
import org.ctom.hulis.huckel.OrbitaleMoleculaire;
import org.ctom.hulis.huckel.Spin;
import org.ctom.hulis.huckel.SpinOrbitaleMoleculaire;
import org.ctom.hulis.huckel.events.BlocDelocalizedEvent;
import org.ctom.hulis.huckel.events.HuckelAtomEvent;
import org.ctom.hulis.huckel.events.HuckelBondEvent;
import org.ctom.hulis.huckel.events.MoleculeEvent;
import org.ctom.hulis.huckel.events.MonoExcitationEvent;
import org.ctom.hulis.huckel.events.StructureDelocalizedEvent;
import org.ctom.hulis.huckel.events.StructureEvent;
import org.ctom.hulis.huckel.events.StructureLocalizedEvent;
import org.ctom.hulis.huckel.exception.NoSOMAvailableException;
import org.ctom.hulis.huckel.exception.UnavailableSOMException;
import org.ctom.hulis.huckel.listeners.IStructureDelocalizedListener;
import org.ctom.hulis.huckel.listeners.IStructureListener;
import org.ctom.hulis.huckel.listeners.IStructureLocalizedListener;
import org.ctom.hulis.huckel.structures.Structure;
import org.ctom.hulis.prefs.Preferences;
import util.ThreadUtils;
import util.io.SwingIO;
import views.EnergyControl;
import views.OccupationControl;
import views.OrbitalControl;
import views.StructureView;

public class GraphOM
extends JPanel
implements IStructureListener,
IStructureDelocalizedListener,
IStructureLocalizedListener {
    public static final int DEFAULT_BETA_MAX = 5;
    static final boolean DRAW_ARROW_HEAD_PART1 = true;
    static final boolean DRAW_ARROW_HEAD_PART2 = false;
    public static final int MAX_ITER_ORGANIZE_GRAPH = 1000;
    public static final int X_MARGIN = 15;
    public static final int Y_MARGIN = 10;
    public static Dimension optimal_size = null;
    private double betaMax;
    private Point currentPointDragged;
    private boolean drawingExcitation = false;
    private ArrayList<OrbitalControl> orbitalControls;
    private OrbitaleMoleculaire sOMSelected;
    private Point2D pointFrom = null;
    private Structure structure;
    private StructureView structureView;
    private GraphOMController graphOMController;

    public GraphOM(Structure structure, StructureView structureView) {
        this.structure = structure;
        this.structureView = structureView;
        this.betaMax = 5.0;
        this.orbitalControls = new ArrayList();
        this.graphOMController = new GraphOMController(this);
        this.addMouseListener(this.graphOMController);
        this.addMouseMotionListener(this.graphOMController);
        this.structure.addListener(this);
        this.currentPointDragged = new Point();
    }

    private EnergyControl getPartner(OrbitalControl ec1) {
        SpinOrbitaleMoleculaire partner = ((EnergyControl)ec1).getSOM().getPartner();
        for (OrbitalControl oc : this.getOrbitalControls()) {
            EnergyControl current = (EnergyControl)oc;
            if (partner != current.getSOM()) continue;
            return current;
        }
        return null;
    }

    public void erase() {
        this.removeMouseListener(this.graphOMController);
        this.removeMouseMotionListener(this.graphOMController);
        this.graphOMController = null;
    }

    public StructureView getStructureView() {
        return this.structureView;
    }

    public double getBetaMAx() {
        return this.betaMax;
    }

    public ArrayList<OrbitalControl> getOrbitalControls() {
        return this.orbitalControls;
    }

    @Override
    public Insets getInsets() {
        return new Insets(4, 4, 4, 4);
    }

    @Override
    public void moleculeDeleted(MoleculeEvent e) {
        this.structureView.setShownOrbital(null);
        this.repaint();
    }

    public ArrayList<EnergyControl> getVirtualEnergyControlAt(Point2D p) {
        ArrayList<EnergyControl> list = new ArrayList<EnergyControl>(2);
        for (OrbitalControl ec : this.getOrbitalControlAt(p)) {
            if (((EnergyControl)ec).getSpin() != Spin.NOSPIN_ALPHA && ((EnergyControl)ec).getSpin() != Spin.NOSPIN_BETA) continue;
            list.add((EnergyControl)ec);
        }
        return list;
    }

    public ArrayList<EnergyControl> getOccupiedEnergyControlAt(Point2D p) {
        ArrayList<EnergyControl> list = new ArrayList<EnergyControl>(2);
        for (OrbitalControl ec : this.getOrbitalControlAt(p)) {
            SpinOrbitaleMoleculaire som = ((EnergyControl)ec).getSOM();
            Spin spin = som.getSpin();
            if (spin != Spin.ALPHA && spin != Spin.BETA) continue;
            list.add((EnergyControl)ec);
        }
        return list;
    }

    private ArrayList<OrbitalControl> getOrbitalControlAt(Point2D p) {
        ArrayList<OrbitalControl> list = new ArrayList<OrbitalControl>(2);
        for (OrbitalControl ec : this.getOrbitalControls()) {
            if (!ec.contains(p)) continue;
            list.add(ec);
        }
        return list;
    }

    @Override
    public synchronized void paint(Graphics g) {
        double x;
        int nSOM;
        super.paint(g);
        Graphics2D g2d = (Graphics2D)g;
        g2d.setColor(Color.BLACK);
        g2d.setFont(new Font("Helvetica", 0, 12));
        double height = 0.0;
        int max = 5;
        if (optimal_size == null) {
            optimal_size = this.getSize();
        }
        if ((double)this.getHeight() <= optimal_size.getHeight()) {
            height = this.getHeight() - 20;
        } else {
            height = optimal_size.getHeight() - 20.0;
            max = (int)((double)(this.getHeight() - 20) * (5.0 / height));
        }
        double yScale = height / 10.0;
        double y0 = this.getHeight() / 2;
        double x0 = this.getWidth() / 2;
        g2d.drawLine((int)x0, 10, (int)x0, this.getHeight() - 10);
        int y = -max;
        while (y <= max) {
            g2d.drawString(Integer.toString(-y), 0, (int)(y0 - (double)y * yScale));
            g2d.drawLine(15, (int)(y0 - (double)y * yScale), this.getWidth() - 15, (int)(y0 - (double)y * yScale));
            ++y;
        }
        try {
            nSOM = this.structure.countSpinOM();
        }
        catch (NullPointerException e1) {
            return;
        }
        if (nSOM == 0) {
            return;
        }
        double y2 = 0.0;
        this.orbitalControls = new ArrayList(nSOM);
        switch (Preferences.DISPLAY_ORBITAL) {
            case CANONICAL: {
                try {
                    int i2 = 0;
                    while (i2 < nSOM) {
                        SpinOrbitaleMoleculaire som = this.structure.getSpinOM(i2);
                        y2 = y0 + som.getEnergy().getBeta() * yScale;
                        x = x0;
                        this.orbitalControls.add(new EnergyControl(this, som, (Point2D)new Point2D.Double(x, y2)));
                        ++i2;
                    }
                }
                catch (NoSOMAvailableException e1) {
                    e1.printStackTrace();
                    SwingIO.error(this.getClass().getName(), "EnergiesOrbView.paint", "No SOM available");
                }
                catch (UnavailableSOMException e1) {
                    e1.printStackTrace();
                    SwingIO.error(this.getClass().getName(), "EnergiesOrbView.paint", "Specified SOM available");
                }
                Collections.sort(this.orbitalControls, new Comparator(){

                    public int compare(Object o1, Object o2) {
                        SpinOrbitaleMoleculaire som2;
                        SpinOrbitaleMoleculaire som1;
                        block10: {
                            block9: {
                                block8: {
                                    block7: {
                                        try {
                                            som1 = ((EnergyControl)o1).getSOM();
                                            som2 = ((EnergyControl)o2).getSOM();
                                            if (som1.getPartner() != som2) break block7;
                                            return 0;
                                        }
                                        catch (Exception e1) {
                                            e1.printStackTrace();
                                            return 0;
                                        }
                                    }
                                    if (!som1.getEnergy().isGreaterThan(som2.getEnergy(), 2)) break block8;
                                    return 1;
                                }
                                if (!som2.getEnergy().isGreaterThan(som1.getEnergy(), 2)) break block9;
                                return -1;
                            }
                            if (som1.getSpin() != Spin.ALPHA || som2.getSpin() != Spin.BETA && som2.getSpin() != Spin.NOSPIN_BETA && som2.getSpin() != Spin.NOSPIN_ALPHA) break block10;
                            return -1;
                        }
                        if (som2.getSpin() == Spin.ALPHA && (som1.getSpin() == Spin.BETA || som1.getSpin() == Spin.NOSPIN_BETA || som1.getSpin() == Spin.NOSPIN_ALPHA)) {
                            return 1;
                        }
                        return 0;
                    }
                });
                break;
            }
            case NATURAL: {
                int nNO = this.structure.getNaturalOrbitals().size();
                int i3 = 0;
                while (i3 < nNO) {
                    NatOrbitaleMoleculaire om = this.structure.getNatOM(i3);
                    y2 = y0 + om.getOcc() * yScale;
                    x = x0;
                    this.orbitalControls.add(new OccupationControl(this, om, new Point2D.Double(x, y2)));
                    ++i3;
                }
                break;
            }
        }
        boolean ok = false;
        int iter = 0;
        block16: while (!ok) {
            ok = true;
            if (iter == 1000) break;
            ++iter;
            switch (Preferences.DISPLAY_ORBITAL) {
                case CANONICAL: {
                    OrbitalControl ec2;
                    OrbitalControl ec1;
                    int j;
                    int i4 = 0;
                    while (i4 < this.orbitalControls.size()) {
                        j = 0;
                        while (j < this.orbitalControls.size()) {
                            ec1 = this.orbitalControls.get(i4);
                            ec2 = this.orbitalControls.get(j);
                            if (((EnergyControl)ec1).getSOM().getPartner() != ((EnergyControl)ec2).getSOM() && ec1.intersects(ec2) && i4 != j) {
                                x = ec1.getPoint().getX();
                                y2 = ec1.getPoint().getY();
                                ec1.setLocation(new Point2D.Double(x -= 19.5, y2));
                                this.getPartner(ec1).setLocation(new Point2D.Double(x, y2));
                                x = ec2.getPoint().getX();
                                y2 = ec2.getPoint().getY();
                                ec2.setLocation(new Point2D.Double(x += 19.5, y2));
                                this.getPartner(ec2).setLocation(new Point2D.Double(x, y2));
                                ok = false;
                            }
                            ++j;
                        }
                        ++i4;
                    }
                    continue block16;
                }
                case NATURAL: {
                    OrbitalControl ec2;
                    OrbitalControl ec1;
                    int j;
                    int i5 = 0;
                    while (i5 < this.orbitalControls.size()) {
                        j = 0;
                        while (j < this.orbitalControls.size()) {
                            ec1 = this.orbitalControls.get(i5);
                            if (ec1.intersects(ec2 = this.orbitalControls.get(j)) && i5 != j) {
                                x = ec1.getPoint().getX();
                                y2 = ec1.getPoint().getY();
                                ec1.setLocation(new Point2D.Double(x += 19.5, y2));
                                this.getPartner(ec1).setLocation(new Point2D.Double(x, y2));
                                x = ec2.getPoint().getX();
                                y2 = ec2.getPoint().getY();
                                ec2.setLocation(new Point2D.Double(x -= 19.5, y2));
                                this.getPartner(ec2).setLocation(new Point2D.Double(x, y2));
                                ok = false;
                            }
                            ++j;
                        }
                        ++i5;
                    }
                    continue block16;
                }
            }
        }
        int i6 = 0;
        while (i6 < this.orbitalControls.size()) {
            this.orbitalControls.get(i6).draw(g2d);
            ++i6;
        }
    }

    public void setBetaMax(double betaMax) {
        this.betaMax = betaMax;
    }

    public void setEOrbSelected(OrbitaleMoleculaire spinOrbitaleMoleculaire) {
        this.setOMSelected(spinOrbitaleMoleculaire);
    }

    protected void handleMoleculeChanged() {
        this.structureView.setShownOrbital(null);
        this.repaint();
    }

    @Override
    public void structureNameChanged(StructureEvent event) {
        ThreadUtils.invokeAsSoonAsPossible(new Runnable(){

            @Override
            public void run() {
                GraphOM.this.handleMoleculeChanged();
            }
        });
    }

    @Override
    public void moleculeAtomAdded(MoleculeEvent e) {
        ThreadUtils.invokeAsSoonAsPossible(new Runnable(){

            @Override
            public void run() {
                GraphOM.this.handleMoleculeChanged();
            }
        });
    }

    @Override
    public void moleculeAtomRemoved(MoleculeEvent e) {
        ThreadUtils.invokeAsSoonAsPossible(new Runnable(){

            @Override
            public void run() {
                GraphOM.this.handleMoleculeChanged();
            }
        });
    }

    @Override
    public void moleculeAtomReplaced(MoleculeEvent e) {
        ThreadUtils.invokeAsSoonAsPossible(new Runnable(){

            @Override
            public void run() {
                GraphOM.this.handleMoleculeChanged();
            }
        });
    }

    @Override
    public void moleculeBondAdded(MoleculeEvent e) {
        ThreadUtils.invokeAsSoonAsPossible(new Runnable(){

            @Override
            public void run() {
                GraphOM.this.handleMoleculeChanged();
            }
        });
    }

    @Override
    public void moleculeBondRemoved(MoleculeEvent e) {
        ThreadUtils.invokeAsSoonAsPossible(new Runnable(){

            @Override
            public void run() {
                GraphOM.this.handleMoleculeChanged();
            }
        });
    }

    @Override
    public void moleculeChargeChanged(MoleculeEvent event) {
        ThreadUtils.invokeAsSoonAsPossible(new Runnable(){

            @Override
            public void run() {
                GraphOM.this.handleMoleculeChanged();
            }
        });
    }

    @Override
    public void moleculeListHuckelAtomSeqNumAutoSetted(MoleculeEvent event) {
        ThreadUtils.invokeAsSoonAsPossible(new Runnable(){

            @Override
            public void run() {
                GraphOM.this.handleMoleculeChanged();
            }
        });
    }

    @Override
    public void moleculeListHuckelAtomSeqNumReset(MoleculeEvent event) {
        ThreadUtils.invokeAsSoonAsPossible(new Runnable(){

            @Override
            public void run() {
                GraphOM.this.handleMoleculeChanged();
            }
        });
    }

    @Override
    public void huckelAtomHxChanged(HuckelAtomEvent e) {
        ThreadUtils.invokeAsSoonAsPossible(new Runnable(){

            @Override
            public void run() {
                GraphOM.this.handleMoleculeChanged();
            }
        });
    }

    @Override
    public void huckelAtomRadRChanged(HuckelAtomEvent e) {
        ThreadUtils.invokeAsSoonAsPossible(new Runnable(){

            @Override
            public void run() {
                GraphOM.this.handleMoleculeChanged();
            }
        });
    }

    @Override
    public void huckelAtomSeqNumChanged(HuckelAtomEvent e) {
        ThreadUtils.invokeAsSoonAsPossible(new Runnable(){

            @Override
            public void run() {
                GraphOM.this.handleMoleculeChanged();
            }
        });
    }

    @Override
    public void huckelBondBondTypeChanged(HuckelBondEvent e) {
        ThreadUtils.invokeAsSoonAsPossible(new Runnable(){

            @Override
            public void run() {
                GraphOM.this.handleMoleculeChanged();
            }
        });
    }

    @Override
    public void huckelBondHxyChanged(HuckelBondEvent e) {
        ThreadUtils.invokeAsSoonAsPossible(new Runnable(){

            @Override
            public void run() {
                GraphOM.this.handleMoleculeChanged();
            }
        });
    }

    @Override
    public void monoExcitationTriggered(MonoExcitationEvent e) {
        ThreadUtils.invokeAsSoonAsPossible(new Runnable(){

            @Override
            public void run() {
                GraphOM.this.handleMoleculeChanged();
            }
        });
    }

    @Override
    public void structureDelocalizedSpinChanged(StructureDelocalizedEvent event) {
        ThreadUtils.invokeAsSoonAsPossible(new Runnable(){

            @Override
            public void run() {
                GraphOM.this.handleMoleculeChanged();
            }
        });
    }

    @Override
    public void structureLocalizedCoupleRemoved(StructureLocalizedEvent event) {
        ThreadUtils.invokeAsSoonAsPossible(new Runnable(){

            @Override
            public void run() {
                GraphOM.this.handleMoleculeChanged();
            }
        });
    }

    @Override
    public void structureLocalizedWeightChanged(StructureLocalizedEvent event) {
        ThreadUtils.invokeAsSoonAsPossible(new Runnable(){

            @Override
            public void run() {
                GraphOM.this.handleMoleculeChanged();
            }
        });
    }

    @Override
    public void structureLocalizedCoupleChanged(StructureLocalizedEvent event) {
        ThreadUtils.invokeAsSoonAsPossible(new Runnable(){

            @Override
            public void run() {
                GraphOM.this.handleMoleculeChanged();
            }
        });
    }

    @Override
    public void moleculeBlocDelocalizedAdded(MoleculeEvent event) {
        ThreadUtils.invokeAsSoonAsPossible(new Runnable(){

            @Override
            public void run() {
                GraphOM.this.handleMoleculeChanged();
            }
        });
    }

    @Override
    public void moleculeBlocDelocalizedRemoved(MoleculeEvent event) {
        ThreadUtils.invokeAsSoonAsPossible(new Runnable(){

            @Override
            public void run() {
                GraphOM.this.handleMoleculeChanged();
            }
        });
    }

    @Override
    public void blocDelocalizedHuckelObjectAdded(BlocDelocalizedEvent e) {
    }

    @Override
    public void blocDelocalizedHuckelObjectRemoved(BlocDelocalizedEvent e) {
    }

    @Override
    public void blocDelocalizedNbElectronsChanged(BlocDelocalizedEvent e) {
    }

    public Structure getStructure() {
        return this.structure;
    }

    public Point getCurrentPointDragged() {
        return this.currentPointDragged;
    }

    public void setCurrentPointDragged(Point currentPointDragged) {
        this.currentPointDragged = currentPointDragged;
    }

    public boolean isDrawingExcitation() {
        return this.drawingExcitation;
    }

    public void setDrawingExcitation(boolean drawingExcitation) {
        this.drawingExcitation = drawingExcitation;
    }

    public void setPointFrom(Point2D pointFrom) {
        this.pointFrom = pointFrom;
    }

    public Point2D getPointFrom() {
        return this.pointFrom;
    }

    public OrbitaleMoleculaire getsOMSelected() {
        return this.sOMSelected;
    }

    public void setOMSelected(OrbitaleMoleculaire sOMSelected) {
        this.sOMSelected = sOMSelected;
    }
}

