/*
 * Decompiled with CFR 0.152.
 */
package views;

import controller.globalCommands.ActionQuit;
import controller.globalCommands.PopUp;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.net.URL;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import util.FollowLink;
import util.MyResourceBundle;
import util.languages.LanguageManager;
import views.FrameApp;
import views.Informations;
import views.MyJDialog;
import views.prefs.PreferencesGUI;

public class LicenseFrame
extends MyJDialog {
    protected MyResourceBundle bundle;

    public LicenseFrame(final FrameApp app) {
        super(JOptionPane.getFrameForComponent(app));
        this.setDefaultCloseOperation(0);
        this.bundle = LanguageManager.getInstance().getResource("LicenseFrame");
        this.setTitle(this.bundle.getString("title"));
        Container contenu = this.getContentPane();
        contenu.setLayout(new BorderLayout(5, 5));
        JTextPane txtLicence = new JTextPane();
        txtLicence.setContentType("text/html; charset=UTF-8");
        txtLicence.setPreferredSize(this.getPreferredSize());
        txtLicence.setEditable(false);
        try {
            txtLicence.setPage((URL)this.bundle.getObject("license"));
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        txtLicence.setCaretPosition(0);
        PopUp.pop(txtLicence);
        txtLicence.setFont(new Font("Monaco", 0, 12));
        JScrollPane txtLicenceScroll = new JScrollPane(txtLicence, 20, 32);
        txtLicenceScroll.setHorizontalScrollBarPolicy(32);
        txtLicenceScroll.setVerticalScrollBarPolicy(22);
        txtLicenceScroll.setPreferredSize(new Dimension(800, 600));
        txtLicence.addHyperlinkListener(new FollowLink(txtLicence));
        txtLicence.setMargin(new Insets(5, 10, 5, 10));
        Font btFont = (Font)this.bundle.getObject("font2");
        JPanel panneauBoutons = new JPanel();
        JButton acceptBt = new JButton(this.bundle.getString("accept"));
        JButton closeBt = new JButton(this.bundle.getString("quit"));
        panneauBoutons.add(acceptBt);
        panneauBoutons.add(closeBt);
        acceptBt.setFont(btFont);
        closeBt.setFont(btFont);
        acceptBt.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PreferencesGUI.getInstance().setAcceptLicense(true);
                LicenseFrame.this.dispose();
            }
        });
        closeBt.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                new ActionQuit(app).execute();
                LicenseFrame.this.dispose();
            }
        });
        Informations.setFrameApp(app);
        JTextPane label = new JTextPane();
        label.setMargin(new Insets(10, 10, 5, 10));
        label.setContentType("text/html; charset=UTF-8");
        label.setEditable(false);
        label.setSize(100, 20);
        label.setOpaque(false);
        label.setText("<body align='justify'>" + this.bundle.getString("texthead") + "</body>");
        label.addHyperlinkListener(new FollowLink(label));
        contenu.add((Component)label, "North");
        contenu.add((Component)txtLicenceScroll, "Center");
        contenu.add((Component)panneauBoutons, "South");
        this.pack();
        this.setPreferredSize(new Dimension(500, 600));
        this.setSize(new Dimension(500, 600));
        this.setLocationRelativeTo(app);
        this.setModal(true);
    }
}

