/*
 * Decompiled with CFR 0.152.
 */
package views;

import controller.globalCommands.EnableActionManager;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.swing.BoxLayout;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.ctom.hulis.huckel.Mesomery;
import org.ctom.hulis.huckel.events.BlocDelocalizedEvent;
import org.ctom.hulis.huckel.events.HuckelAtomEvent;
import org.ctom.hulis.huckel.events.HuckelBondEvent;
import org.ctom.hulis.huckel.events.MesomeryEvent;
import org.ctom.hulis.huckel.events.MoleculeEvent;
import org.ctom.hulis.huckel.events.MonoExcitationEvent;
import org.ctom.hulis.huckel.events.StructureDelocalizedEvent;
import org.ctom.hulis.huckel.events.StructureEvent;
import org.ctom.hulis.huckel.events.StructureLocalizedEvent;
import org.ctom.hulis.huckel.listeners.IMesomeryListener;
import org.ctom.hulis.huckel.structures.Structure;
import org.ctom.hulis.huckel.structures.StructureLocalized;
import util.io.SwingIO;
import views.FrameApp;
import views.GraphOM;
import views.IMesomeryReference;
import views.StructureView;

public class MesomeryView
extends JTabbedPane
implements IMesomeryReference,
ChangeListener,
IMesomeryListener {
    public static final double DEFAULT_ZOOM = 0.8;
    public static final double INCR_ZOOM = 0.1;
    public static final double MAX_ZOOM = 10.0;
    public static final double MIN_ZOOM = 0.1;
    public static final String PSI = "\u03c8";
    public static final String TAU = "\u03c4";
    public boolean isDisplayPolynomes = false;
    public boolean isDisplayHxHxy = false;
    public boolean isDisplayCharges = false;
    public boolean isDisplayNum = false;
    private FrameApp frameApp;
    private HashMap<Structure, Child> indexedTabsMap;
    protected Mesomery mesomery;
    protected double zoom;
    protected double angle;
    protected StructureLocalized structureLocalizedOwnerCurrentBloc;
    private double xMargin;
    private double yMargin;

    public MesomeryView(Mesomery mesomery, FrameApp frameApp) {
        super(1);
        this.setFont(new Font("Helvetica", 0, 11));
        this.mesomery = mesomery;
        this.frameApp = frameApp;
        mesomery.addListener(this);
        this.indexedTabsMap = new HashMap();
        this.addChangeListener(this);
        this.setDefaultsPrefs();
    }

    public void updateLanguage() {
        if (this.getCurrentStructureView() != null) {
            this.getCurrentStructureView().repaint();
        }
    }

    public StructureView getFirstStructureWithSelectedBloc() {
        for (StructureView sv : this.getListStructureView()) {
            if (StructureView.getSelectedBlocDelocalized() == null || StructureView.getSelectedBlocDelocalized().getMoleculeParent() != sv.getStructure()) continue;
            return sv;
        }
        return null;
    }

    public synchronized void addStructureView(Structure structure) throws Exception {
        if (!this.mesomery.exists(structure)) {
            throw new Exception("structure does not belong to the mesomery");
        }
        StructureView structureView = new StructureView(structure, this);
        Child child = new Child(structureView);
        child.setPreferredSize(this.getPreferredSize());
        this.indexedTabsMap.put(structure, child);
        this.addTab(PSI + structure.getName(), child);
        structureView.setPreferredSize(new Dimension((int)this.getPreferredSize().getWidth() * 5 / 7, (int)this.getPreferredSize().getHeight()));
        structureView.getGraphOM().setPreferredSize(new Dimension((int)(this.getPreferredSize().getWidth() * 2.0 / 7.0), (int)this.getPreferredSize().getHeight()));
        structureView.setBackground(this.getBackground());
        structureView.getGraphOM().setBackground(this.getBackground());
        child.setLayout(new BoxLayout(child, 0));
        child.add(structureView);
        GraphOM graphOM = structureView.getGraphOM();
        child.add(graphOM);
    }

    public int countDisplayedStructures() {
        return super.getTabCount();
    }

    public boolean isDisplayPolynomes() {
        return this.isDisplayPolynomes;
    }

    public boolean isDisplayCharges() {
        return this.isDisplayCharges;
    }

    public boolean isDisplayHxHxy() {
        return this.isDisplayHxHxy;
    }

    public boolean isDisplayNum() {
        return this.isDisplayNum;
    }

    public Structure getCurrentStructure() {
        StructureView sv = this.getCurrentStructureView();
        if (sv == null) {
            SwingIO.warning(this.getClass().getName(), "getCurrentStructure", "cannot select structure view");
            return null;
        }
        return sv.getStructure();
    }

    public StructureView getCurrentStructureView() {
        Child child;
        block3: {
            try {
                child = (Child)this.getSelectedComponent();
                if (child != null) break block3;
                return null;
            }
            catch (Exception e) {
                SwingIO.warning(this.getClass().getName(), "getCurrentStructureView", "cannot select tab", e);
                return null;
            }
        }
        return child.getStructureView();
    }

    public FrameApp getFrameApp() {
        return this.frameApp;
    }

    @Override
    public Insets getInsets() {
        return new Insets(0, 0, 0, 0);
    }

    @Override
    public Mesomery getMesomery() {
        return this.mesomery;
    }

    public StructureView getStructureView(Structure structure) {
        Child child = this.indexedTabsMap.get(structure);
        if (child == null) {
            SwingIO.warning(this.getClass().getName(), "getStructureView", "cannot select tab");
            return null;
        }
        return child.getStructureView();
    }

    public List<StructureView> getListStructureView() {
        ArrayList<StructureView> lst = new ArrayList<StructureView>();
        for (Structure s : this.indexedTabsMap.keySet()) {
            lst.add(this.indexedTabsMap.get(s).getStructureView());
        }
        return lst;
    }

    public double getZoom() {
        return this.zoom;
    }

    public void rebuild() {
        Child child;
        Structure sav = this.getCurrentStructure();
        List<Structure> lstSelect = this.mesomery.getAllStructures();
        int i2 = this.getTabCount() - 1;
        while (i2 >= 0) {
            child = (Child)super.getComponentAt(i2);
            child.erase();
            this.remove(i2);
            child = null;
            --i2;
        }
        this.indexedTabsMap.clear();
        lstSelect = this.mesomery.getSelectedStructures();
        i2 = 0;
        while (i2 < this.mesomery.countSelectedStructs()) {
            Structure structure = lstSelect.get(i2);
            if (this.mesomery.getSelectedStructures().contains(structure)) {
                try {
                    this.addStructureView(structure);
                }
                catch (Exception e) {
                    SwingIO.error(this.getName(), "rebuild", e.getMessage(), e);
                    SwingIO.reportError(this.frameApp);
                }
            }
            ++i2;
        }
        i2 = 0;
        while (i2 < this.getTabCount()) {
            StructureView sv;
            child = (Child)this.getComponent(i2);
            if (child == null || (sv = child.getStructureView()) == null) break;
            Structure s = sv.getStructure();
            if (s == sav) {
                this.setCurrentStructure(s);
                break;
            }
            ++i2;
        }
    }

    public void refresh() {
        List<Structure> lstSelect = this.mesomery.getSelectedStructures();
        int i2 = 0;
        while (i2 < this.mesomery.countSelectedStructs()) {
            StructureView structureView = this.getStructureView(lstSelect.get(i2));
            if (structureView != null) {
                structureView.repaint();
            } else {
                SwingIO.warning(this.getClass().getName(), "refresh", "cannot select structure view in the mersomery view to refresh it");
            }
            ++i2;
        }
    }

    public synchronized void removeStructureView(Structure structure) throws Exception {
        Child child = this.indexedTabsMap.get(structure);
        if (child == null) {
            throw new Exception("structure not found in viewer");
        }
        this.remove(child);
        this.indexedTabsMap.remove(structure);
        int i2 = 1;
        while (i2 < this.getTabCount()) {
            Structure tmp = ((Child)this.getComponentAt(i2)).getStructureView().getStructure();
            this.setTitleAt(i2, PSI + tmp.getName());
            ++i2;
        }
    }

    public synchronized void setCurrentStructure(Structure structure) {
        if (structure == null) {
            return;
        }
        Child component = this.indexedTabsMap.get(structure);
        if (component == null) {
            return;
        }
        this.setSelectedComponent(component);
    }

    public void setDefaultsPrefs() {
        this.isDisplayPolynomes = false;
        this.isDisplayCharges = false;
        this.isDisplayHxHxy = false;
        this.isDisplayNum = false;
        this.zoom = 0.8;
        this.xMargin = 0.0;
        this.yMargin = 0.0;
        this.angle = 0.0;
    }

    @Override
    public void setMesomery(Mesomery mesomery) {
        this.mesomery.removeListener(this);
        this.mesomery = mesomery;
        this.mesomery.addListener(this);
        this.rebuild();
    }

    public void setZoom(double zoom) {
        this.zoom = zoom;
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        MesomeryView mesomeryView = (MesomeryView)e.getSource();
        try {
            Structure currentStructure = mesomeryView.getCurrentStructure();
            EnableActionManager.getInstance().updateActionsToEnable(this.frameApp);
            this.frameApp.toolBarMesomery.updateInfoStructure(currentStructure);
        }
        catch (Exception e1) {
            SwingIO.warning(this.getClass().getName(), "stateChanged", e1.getMessage(), e1);
            return;
        }
    }

    public void structureAdded(MesomeryEvent e) {
    }

    public void switchPolynomes() {
        this.isDisplayPolynomes = !this.isDisplayPolynomes;
    }

    public void switchCharges() {
        this.isDisplayCharges = !this.isDisplayCharges;
    }

    public void switchHxHxy() {
        this.isDisplayHxHxy = !this.isDisplayHxHxy;
    }

    public void switchNum() {
        this.isDisplayNum = !this.isDisplayNum;
    }

    @Override
    public void mesomeryStructuresSelectionTresholdChanged(MesomeryEvent e) {
        this.rebuild();
    }

    @Override
    public void mesomeryListWeightCalculated(MesomeryEvent e) {
    }

    @Override
    public void mesomeryMethodAdded(MesomeryEvent e) {
        this.refresh();
    }

    @Override
    public void mesomeryMethodRemoved(MesomeryEvent e) {
        this.refresh();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void mesomeryStructureAdded(MesomeryEvent e) {
        MesomeryView mesomeryView = this;
        synchronized (mesomeryView) {
            Structure structure = (Structure)e.getNewValue();
            if (e.getSource().getSelectedStructures().contains(structure)) {
                try {
                    this.addStructureView(structure);
                }
                catch (Exception e1) {
                    SwingIO.error(this.getName(), "structureAdded", e1.getMessage(), e1);
                    SwingIO.reportError(this.frameApp);
                }
                if (structure instanceof StructureLocalized) {
                    if (((StructureLocalized)structure).getMethodCreation() == StructureLocalized.CreationMethod.CREATED_MANUALLY) {
                        this.setCurrentStructure(structure);
                    }
                } else {
                    this.setCurrentStructure(structure);
                }
            }
        }
    }

    @Override
    public void mesomeryStructureRemoved(MesomeryEvent e) {
        try {
            this.removeStructureView((Structure)e.getOldValue());
        }
        catch (Exception e1) {
            SwingIO.log(this.getClass().getName(), "structureRemoved", "Just info : Structure not found in mesomery viewer");
        }
    }

    @Override
    public void structureDelocalizedSpinChanged(StructureDelocalizedEvent event) {
    }

    @Override
    public void structureNameChanged(StructureEvent event) {
    }

    @Override
    public void moleculeAtomAdded(MoleculeEvent e) {
    }

    @Override
    public void moleculeAtomRemoved(MoleculeEvent e) {
    }

    @Override
    public void moleculeAtomReplaced(MoleculeEvent e) {
    }

    @Override
    public void moleculeBondAdded(MoleculeEvent e) {
    }

    @Override
    public void moleculeBondRemoved(MoleculeEvent e) {
    }

    @Override
    public void moleculeChargeChanged(MoleculeEvent event) {
    }

    @Override
    public void moleculeDeleted(MoleculeEvent e) {
    }

    @Override
    public void moleculeListHuckelAtomSeqNumAutoSetted(MoleculeEvent event) {
    }

    @Override
    public void moleculeListHuckelAtomSeqNumReset(MoleculeEvent event) {
    }

    @Override
    public void huckelAtomHxChanged(HuckelAtomEvent e) {
    }

    @Override
    public void huckelAtomRadRChanged(HuckelAtomEvent e) {
        StructureView structureView = this.getCurrentStructureView();
        structureView.repaint();
    }

    @Override
    public void huckelAtomSeqNumChanged(HuckelAtomEvent e) {
    }

    @Override
    public void huckelBondBondTypeChanged(HuckelBondEvent e) {
        StructureView structureView = this.getCurrentStructureView();
        structureView.repaint();
    }

    @Override
    public void huckelBondHxyChanged(HuckelBondEvent e) {
    }

    @Override
    public void monoExcitationTriggered(MonoExcitationEvent e) {
    }

    @Override
    public void structureLocalizedCoupleRemoved(StructureLocalizedEvent event) {
        StructureView structureView = this.getCurrentStructureView();
        System.out.println("mesomeryview   structureLocalizedCoupleRemoved -> repaint");
        structureView.repaint();
    }

    @Override
    public void structureLocalizedWeightChanged(StructureLocalizedEvent event) {
    }

    @Override
    public void structureLocalizedCoupleChanged(StructureLocalizedEvent event) {
        StructureView structureView = this.getCurrentStructureView();
        System.out.println("mesomeryview   structureLocalizedCoupleChanged -> repaint");
        structureView.repaint();
    }

    @Override
    public void moleculeBlocDelocalizedAdded(MoleculeEvent event) {
    }

    @Override
    public void moleculeBlocDelocalizedRemoved(MoleculeEvent event) {
    }

    @Override
    public void blocDelocalizedHuckelObjectAdded(BlocDelocalizedEvent e) {
        StructureView structureView = this.getCurrentStructureView();
        structureView.repaint();
    }

    @Override
    public void blocDelocalizedHuckelObjectRemoved(BlocDelocalizedEvent e) {
        StructureView structureView = this.getCurrentStructureView();
        structureView.repaint();
    }

    @Override
    public void blocDelocalizedNbElectronsChanged(BlocDelocalizedEvent e) {
        StructureView structureView = this.getCurrentStructureView();
        structureView.repaint();
    }

    @Override
    public void mesomeryExceptionOccured(MesomeryEvent e, Exception exception) {
    }

    public double getXMargin() {
        return this.xMargin;
    }

    public double getYMargin() {
        return this.yMargin;
    }

    public void setXMargin(double xMargin) {
        this.xMargin = xMargin;
    }

    public void setYMargin(double yMargin) {
        this.yMargin = yMargin;
    }

    public double getAngle() {
        return this.angle;
    }

    public void setAngle(double angle) {
        this.angle = angle;
    }

    @Override
    public void mesomeryStartComputeWeights(MesomeryEvent event) {
    }

    public void setMargins(double xMargin, double yMargin) {
        this.xMargin = xMargin;
        this.yMargin = yMargin;
    }

    @Override
    public void mesomeryStructuresSelectorChanged(MesomeryEvent event) {
    }

    public class Child
    extends JPanel {
        StructureView structureView = null;

        public Child(StructureView structureView) {
            this.structureView = structureView;
        }

        public void erase() {
            this.structureView.erase();
            this.structureView = null;
        }

        public StructureView getStructureView() {
            return this.structureView;
        }
    }
}

