/*
 * Decompiled with CFR 0.152.
 */
package views;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import org.ctom.hulis.huckel.OrbitaleMoleculaire;
import views.GraphOM;

public abstract class OrbitalControl {
    public static final Color COLOR_LINE = Color.BLACK;
    public static final Color COLOR_SELECT = new Color(83, 251, 234);
    protected Point2D p;
    protected GraphOM gom;
    protected OrbitaleMoleculaire om;

    public OrbitalControl(GraphOM graphOM, OrbitaleMoleculaire om, Point2D p) {
        this.gom = graphOM;
        this.om = om;
        this.p = p;
    }

    public OrbitaleMoleculaire getOM() {
        return this.om;
    }

    public boolean contains(Point2D p) {
        return this.getCircle(p).contains(p);
    }

    public Ellipse2D getCircle(Point2D p) {
        return new Ellipse2D.Double(this.p.getX() - 13.0, this.p.getY() - 15.0, 26.0, 30.0);
    }

    public Point2D getPoint() {
        return this.p;
    }

    public boolean intersects(OrbitalControl eC) {
        return new Rectangle2D.Double(this.p.getX() - 6.5, this.p.getY() - 7.5, 13.0, 15.0).intersects(new Rectangle2D.Double(eC.p.getX() - 6.5, eC.p.getY() - 7.5, 13.0, 15.0));
    }

    public void setLocation(Point2D p) {
        this.p = p;
    }

    protected void draw(Graphics2D g2d) {
        g2d.setStroke(new BasicStroke(0.0f));
        if (this.gom.getsOMSelected() == this.getOM()) {
            g2d.setColor(COLOR_SELECT);
            g2d.fill(this.getCircle(this.p));
        }
        g2d.setStroke(new BasicStroke(1.52f));
        g2d.setColor(COLOR_LINE);
        g2d.setStroke(new BasicStroke(1.52f));
        g2d.draw(new Line2D.Double(this.p.getX() - 6.5, this.p.getY(), this.p.getX() + 6.5, this.p.getY()));
    }
}

