/*
 * Decompiled with CFR 0.152.
 */
package views;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import org.ctom.hulis.huckel.OrbitaleAtomique;
import org.ctom.hulis.prefs.Preferences;
import org.ctom.util.maths.Maths;
import views.AtomColor;
import views.FrameApp;
import views.StructureView;
import views.prefs.PreferencesGUI;

public class OrbitalDrawer {
    public static final double ProjXInfoOrb = 12.0;
    public static final double ProjYInfoOrb = 12.0;
    private OrbitaleAtomique orb;
    private double coeff;
    public final double GAP_FACTOR = 0.0;
    public final int SPACE_X_BACK_CIRCLE = 4;
    public final int SPACE_X_FORE_CIRCLE = 0;
    public final int SPACE_Y_BACK_CIRCLE = -8;
    public final int SPACE_Y_FORE_CIRCLE = 0;
    private final StructureView structureView;

    public OrbitalDrawer(StructureView structureView, OrbitaleAtomique orb, double coeff) {
        this.structureView = structureView;
        this.coeff = coeff;
        this.orb = orb;
    }

    public double getCoeff() {
        return this.coeff;
    }

    public double getScaleOrbitals() {
        if (Preferences.isDISPLAY_DENSITY()) {
            return PreferencesGUI.getScaleOrbDefault() / 4.0;
        }
        return PreferencesGUI.getInstance().getSCALE_ORB();
    }

    public void activeTransparency(Graphics2D g2d) {
        float transparency = 0.7f;
        g2d.setComposite(AlphaComposite.getInstance(3, Math.min(transparency, 1.0f)));
    }

    protected void draw(int order, Graphics2D g2d) {
        double radius = this.getRadius();
        Color colorOM = Color.RED;
        Color colorDensity = Color.GREEN;
        Color colorNatOrb = Color.ORANGE;
        Color color = null;
        if (Preferences.isDISPLAY_DENSITY()) {
            color = colorDensity;
        } else {
            switch (Preferences.DISPLAY_ORBITAL) {
                case CANONICAL: {
                    color = colorOM;
                    break;
                }
                case NATURAL: {
                    color = colorNatOrb;
                    break;
                }
            }
        }
        if (this.getCoeff() * this.getScaleOrbitals() < 0.0) {
            if (order == 1) {
                this.activeTransparency(g2d);
                g2d.setColor(color);
                g2d.setStroke(new BasicStroke(1.0f));
                g2d.fill(this.getBackCircle(radius));
                this.stopTransparency(g2d);
                g2d.setStroke(new BasicStroke(1.0f));
                g2d.draw(this.getBackCircle(radius));
            } else {
                this.activeTransparency(g2d);
                g2d.setColor(Color.WHITE);
                g2d.setStroke(new BasicStroke(1.0f));
                g2d.fill(this.getForeCircle(radius));
                this.stopTransparency(g2d);
                g2d.setColor(color);
                g2d.setStroke(new BasicStroke(2.0f));
                g2d.draw(this.getForeCircle(radius));
            }
        } else if (this.getCoeff() * this.getScaleOrbitals() > 0.0) {
            if (order == 1) {
                this.activeTransparency(g2d);
                g2d.setColor(Color.WHITE);
                g2d.setStroke(new BasicStroke(1.0f));
                g2d.fill(this.getBackCircle(radius));
                g2d.setColor(color);
                g2d.setStroke(new BasicStroke(1.0f));
                g2d.draw(this.getBackCircle(radius));
            } else {
                this.activeTransparency(g2d);
                g2d.setColor(color);
                g2d.setStroke(new BasicStroke(1.0f));
                g2d.fill(this.getForeCircle(radius));
                this.stopTransparency(g2d);
                g2d.setStroke(new BasicStroke(2.0f));
                g2d.draw(this.getForeCircle(radius));
            }
        }
        g2d.setStroke(new BasicStroke(1.0f));
        this.stopTransparency(g2d);
    }

    public Shape getBackCircle(double radius) {
        Point2D atomLocation = this.structureView.getImagePoint(new Point2D.Double(this.orb.getHuckelAtom().getLocation().getX() + 4.0 + radius * 0.0, this.orb.getHuckelAtom().getY() + -8.0 + radius * 0.0));
        return new Ellipse2D.Double(atomLocation.getX() - radius, atomLocation.getY() - radius, 2.0 * radius, 2.0 * radius);
    }

    public Shape getForeCircle(double radius) {
        Point2D atomLocation = this.structureView.getImagePoint(new Point2D.Double(this.orb.getHuckelAtom().getLocation().getX() + 0.0, this.orb.getHuckelAtom().getY() + 0.0));
        return new Ellipse2D.Double(atomLocation.getX() - radius, atomLocation.getY() - radius, 2.0 * radius, 2.0 * radius);
    }

    protected Shape getForm() {
        GeneralPath path = new GeneralPath();
        double radius = this.getRadius();
        path.append(this.getBackCircle(radius), false);
        path.append(this.getForeCircle(radius), false);
        return path;
    }

    public double getRadius() {
        double radius = Math.abs(this.structureView.getZoom() * 12.0 * this.getCoeff() * this.getScaleOrbitals());
        return radius;
    }

    public boolean isContained(Point2D p) {
        return this.getForm().contains(p);
    }

    public void stopTransparency(Graphics2D g2d) {
        g2d.setComposite(AlphaComposite.getInstance(3, 1.0f));
    }

    public void writeInfos(Graphics2D g2d) {
        if (Maths.round(this.getCoeff(), 2) != 0.0) {
            AtomColor atomColor = null;
            try {
                atomColor = AtomColor.valueOf(this.orb.getHuckelAtom().getSigle());
            }
            catch (IllegalArgumentException e) {
                atomColor = AtomColor.Xx;
            }
            double projInfo = this.structureView.getZoom() * (double)atomColor.getRadius() * Math.abs(this.getCoeff()) * this.getScaleOrbitals();
            Font fontI = new Font("Helvetica", 0, (int)(14.0 * (this.structureView.getZoom() % 5.0)));
            g2d.setFont(fontI);
            g2d.setColor(Color.RED);
            Point2D atomLocation = this.structureView.getImagePoint(this.structureView.getPoint2D(this.orb.getHuckelAtom().getLocation()));
            double xTemp = atomLocation.getX() + projInfo;
            double yTemp = atomLocation.getY() + projInfo;
            String txtInfo = "C" + this.orb.getHuckelAtom().getSeqNum() + "=" + FrameApp.form.format(this.getCoeff());
            g2d.drawString(txtInfo, (int)xTemp, (int)yTemp);
        }
    }
}

