/*
 * Decompiled with CFR 0.152.
 */
package views;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JSpinner;
import javax.swing.JTabbedPane;
import javax.swing.JTextPane;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.ctom.hulis.prefs.Preferences;
import util.FollowLink;
import util.IntegerSpinner;
import util.MyDecimalFormat;
import util.MyResourceBundle;
import util.io.SwingIO;
import util.languages.LanguageManager;
import views.FrameApp;
import views.FrameResult;
import views.Informations;
import views.MyJDialog;
import views.prefs.PreferencesGUI;

public class PreferencesFrame
extends MyJDialog
implements ActionListener {
    protected JButton btOK;
    protected JButton btUndo;
    FrameApp app;
    JSpinner spinnerMO;
    JSpinner spinnerEnergy;
    JSpinner spinnerMOratio;
    JSlider sliderMOratio;
    JCheckBox chkCircle;
    JCheckBox chkSymbol;
    JSpinner spinnerNSepCharge;
    JCheckBox checkBoxCouple;
    JCheckBox chkCheckVersion;
    JTextPane lblCheckVersion;
    JCheckBox chkSendInformation;
    protected MyResourceBundle bundle;
    private boolean oldCheckBoxCouple;
    private int oldSpinnerNSepCharge;
    int oldMOprecision;
    int oldEnergyPrecision;
    double oldZoomMO;
    boolean oldDisplayAtomsCircles;
    boolean oldDisplayAtomsSymbols;
    boolean oldCheckVersion;
    boolean oldSendInformation;
    PreferencesGUI preferencesGUI = PreferencesGUI.getInstance();

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource().equals(this.btOK)) {
            SwingIO.log(this.getClass().getName(), "actionPerformed", "validate changes");
            this.dispose();
        } else if (e.getSource().equals(this.btUndo)) {
            SwingIO.log(this.getClass().getName(), "actionPerformed", "cancel changes");
            this.restoreOldValues();
            this.dispose();
        }
    }

    public void restoreOldValues() {
        SwingIO.log(this.getClass().getName(), "restoreOldValues", "restore old values");
        this.preferencesGUI.setResultsPrecisionMO(this.oldMOprecision);
        this.preferencesGUI.setResultsPrecisionEnergies(this.oldEnergyPrecision);
        this.preferencesGUI.setSCALE_ORB(this.oldZoomMO);
        this.preferencesGUI.setDisplayAtomsCircles(this.oldDisplayAtomsCircles);
        this.preferencesGUI.setDisplayAtomsSymbols(this.oldDisplayAtomsSymbols);
        this.preferencesGUI.setCheckVersion(this.oldCheckVersion);
        this.preferencesGUI.setSendInformation(this.oldSendInformation);
        Preferences.setCOUPLE_AUTOGEN(this.oldCheckBoxCouple);
        Preferences.setNUM_CHARGE_SEPARATION(this.oldSpinnerNSepCharge);
    }

    public void saveCurrentValues() {
        this.oldMOprecision = this.preferencesGUI.getResultsPrecisionMO();
        this.oldEnergyPrecision = this.preferencesGUI.getResultsPrecisionEnergies();
        this.oldZoomMO = this.preferencesGUI.getSCALE_ORB();
        this.oldDisplayAtomsCircles = this.preferencesGUI.isDisplayAtomsCircles();
        this.oldDisplayAtomsSymbols = this.preferencesGUI.isDisplayAtomsSymbols();
        this.oldCheckVersion = this.preferencesGUI.isCheckVersion();
        this.oldSendInformation = this.preferencesGUI.isSendInformation();
        this.oldCheckBoxCouple = Preferences.isCOUPLE_AUTOGEN();
        this.oldSpinnerNSepCharge = Preferences.getNUM_CHARGE_SEPARATION();
    }

    public void applyValuesToUI() {
        this.spinnerMO.setValue(this.preferencesGUI.getResultsPrecisionMO());
        this.spinnerEnergy.setValue(this.preferencesGUI.getResultsPrecisionEnergies());
        this.sliderMOratio.setValue(PreferencesFrame.convertRealMoRatioToSpinnerMoRatioValue(this.preferencesGUI.getSCALE_ORB()));
        this.chkCircle.setSelected(this.preferencesGUI.isDisplayAtomsCircles());
        this.chkSymbol.setSelected(this.preferencesGUI.isDisplayAtomsSymbols());
        this.checkBoxCouple.setSelected(Preferences.isCOUPLE_AUTOGEN());
        this.spinnerNSepCharge.setValue(Preferences.getNUM_CHARGE_SEPARATION());
        this.chkCheckVersion.setSelected(this.preferencesGUI.isCheckVersion());
        this.chkSendInformation.setSelected(this.preferencesGUI.isSendInformation());
        this.lblCheckVersion.setText(this.getTextCheckVersion(this.chkCheckVersion.isSelected()));
    }

    public void applyPreferences() {
        SwingIO.log(this.getClass().getName(), "applyPreferences", "apply preferences");
        int precisionMO = (Integer)this.spinnerMO.getValue();
        int precisionEnergies = (Integer)this.spinnerEnergy.getValue();
        boolean selected = this.checkBoxCouple.isSelected();
        Preferences.setCOUPLE_AUTOGEN(selected);
        Preferences.setNUM_CHARGE_SEPARATION((Integer)this.spinnerNSepCharge.getValue());
        Window[] windowArray = JFrame.getWindows();
        int n = windowArray.length;
        int n2 = 0;
        while (n2 < n) {
            Window r = windowArray[n2];
            if (r instanceof FrameResult) {
                FrameResult frameResult = (FrameResult)r;
                frameResult.setMyDecimalFormat(new MyDecimalFormat(precisionMO), new MyDecimalFormat(precisionEnergies));
                frameResult.refresh();
            }
            ++n2;
        }
        this.preferencesGUI.setResultsPrecisionMO(precisionMO);
        this.preferencesGUI.setResultsPrecisionEnergies(precisionEnergies);
        this.preferencesGUI.setSCALE_ORB(PreferencesFrame.convertSpinnerMoRatioValueToRealMoRatio(this.sliderMOratio.getValue()));
        this.preferencesGUI.setDisplayAtomsCircles(this.chkCircle.isSelected());
        this.preferencesGUI.setDisplayAtomsSymbols(this.chkSymbol.isSelected());
        this.app.getCurrentMesomeryView().getCurrentStructureView().repaint();
        this.preferencesGUI.setCheckVersion(this.chkCheckVersion.isSelected());
        this.preferencesGUI.setSendInformation(this.chkSendInformation.isSelected());
    }

    private static double convertSpinnerMoRatioValueToRealMoRatio(int spinnerMoRatioValue) {
        return spinnerMoRatioValue / 10;
    }

    private static int convertRealMoRatioToSpinnerMoRatioValue(double moRatioValue) {
        return (int)(10.0 * moRatioValue);
    }

    public PreferencesFrame(FrameApp app) {
        super(JOptionPane.getFrameForComponent(app));
        this.app = app;
        ApplyPreferencesListener applyPreferencesListener = new ApplyPreferencesListener();
        final PreferencesFrame preferencesFrame = this;
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                SwingIO.log(this.getClass().getName(), "windowClosing", "cancel changes");
                PreferencesFrame.this.restoreOldValues();
                preferencesFrame.dispose();
            }
        });
        Container contenu = this.getContentPane();
        this.bundle = LanguageManager.getInstance().getResource("Preferences");
        this.setTitle(this.bundle.getString("title"));
        this.spinnerMO = IntegerSpinner.makeIntegerSpinner(this.preferencesGUI.getResultsPrecisionMO(), 0, 99, 1);
        this.spinnerMO.addChangeListener(applyPreferencesListener);
        this.spinnerEnergy = IntegerSpinner.makeIntegerSpinner(this.preferencesGUI.getResultsPrecisionEnergies(), 0, 99, 1);
        this.spinnerEnergy.addChangeListener(applyPreferencesListener);
        this.sliderMOratio = new JSlider(0, -100, 100, PreferencesFrame.convertRealMoRatioToSpinnerMoRatioValue(this.preferencesGUI.getSCALE_ORB()));
        this.sliderMOratio.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                PreferencesFrame.this.spinnerMOratio.setValue(PreferencesFrame.this.sliderMOratio.getValue());
                PreferencesFrame.this.sliderMOratio.setToolTipText(String.valueOf(PreferencesFrame.this.sliderMOratio.getValue()));
            }
        });
        this.sliderMOratio.addChangeListener(applyPreferencesListener);
        SpinnerNumberModel spinnerModel = new SpinnerNumberModel(PreferencesFrame.convertRealMoRatioToSpinnerMoRatioValue(this.preferencesGUI.getSCALE_ORB()), -100, 100, 1);
        this.spinnerMOratio = new JSpinner(spinnerModel);
        this.spinnerMOratio.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                PreferencesFrame.this.sliderMOratio.setValue((Integer)PreferencesFrame.this.spinnerMOratio.getValue());
            }
        });
        this.chkCircle = new JCheckBox(this.bundle.getString("kcircle"));
        this.chkCircle.setSelected(this.preferencesGUI.isDisplayAtomsCircles());
        this.chkCircle.addChangeListener(applyPreferencesListener);
        this.chkSymbol = new JCheckBox(this.bundle.getString("ksymbols"));
        this.chkSymbol.setSelected(this.preferencesGUI.isDisplayAtomsSymbols());
        this.chkSymbol.addChangeListener(applyPreferencesListener);
        this.btOK = new JButton(this.bundle.getString("kOK"));
        this.btOK.addActionListener(this);
        this.btUndo = new JButton(this.bundle.getString("kundo"));
        this.btUndo.addActionListener(this);
        this.spinnerNSepCharge = IntegerSpinner.makeIntegerSpinner(Preferences.getNUM_CHARGE_SEPARATION(), 0, 1, 1);
        this.spinnerNSepCharge.addChangeListener(applyPreferencesListener);
        this.checkBoxCouple = new JCheckBox(this.bundle.getString("kautocouple"));
        this.checkBoxCouple.setSelected(Preferences.isCOUPLE_AUTOGEN());
        this.checkBoxCouple.addChangeListener(applyPreferencesListener);
        JTabbedPane tabbedPane = new JTabbedPane();
        JPanel panel1 = new JPanel();
        panel1.setLayout(new FlowLayout(0));
        this.chkCheckVersion = new JCheckBox(this.bundle.getString("checkVersion"));
        this.chkCheckVersion.setSelected(this.preferencesGUI.isCheckVersion());
        this.chkCheckVersion.addChangeListener(applyPreferencesListener);
        this.lblCheckVersion = new JTextPane();
        this.lblCheckVersion.setContentType("text/html");
        this.lblCheckVersion.setEditable(false);
        this.lblCheckVersion.setOpaque(false);
        this.lblCheckVersion.setText(this.getTextCheckVersion(this.chkCheckVersion.isSelected()));
        this.lblCheckVersion.setPreferredSize(new Dimension(420, 80));
        this.lblCheckVersion.addHyperlinkListener(new FollowLink(this.lblCheckVersion));
        panel1.add(this.chkCheckVersion);
        panel1.add(this.lblCheckVersion);
        tabbedPane.addTab(this.bundle.getString("updates"), panel1);
        JPanel panel2 = new JPanel();
        panel2.setLayout(new FlowLayout(0));
        JTextPane infos = new JTextPane();
        infos.setContentType("text/html");
        infos.setEditable(false);
        infos.setOpaque(false);
        infos.setText(this.bundle.getString("sendInformation"));
        infos.setPreferredSize(new Dimension(420, 80));
        infos.addHyperlinkListener(new FollowLink(infos));
        panel2.add(infos);
        this.chkSendInformation = new JCheckBox(this.bundle.getString("chkSendInformation"));
        this.chkSendInformation.setSelected(this.preferencesGUI.isSendInformation());
        Informations.setFrameApp(app);
        this.chkSendInformation.addChangeListener(applyPreferencesListener);
        panel2.add(this.chkSendInformation);
        tabbedPane.addTab(this.bundle.getString("privacy"), panel2);
        tabbedPane.setPreferredSize(new Dimension(450, 160));
        GridBagLayout repartiteur = new GridBagLayout();
        GridBagConstraints contraintes = new GridBagConstraints();
        contenu.setLayout(repartiteur);
        contraintes.gridx = 1;
        contraintes.gridy = 1;
        contraintes.insets = new Insets(10, 0, 0, 0);
        contraintes.gridwidth = 3;
        contraintes.gridheight = 1;
        contraintes.weightx = 0.0;
        contraintes.weighty = 0.0;
        contraintes.ipadx = 0;
        contraintes.ipady = 0;
        contraintes.fill = 0;
        contraintes.anchor = 21;
        this.add((Component)new JLabel(this.bundle.getString("kdecimal")), contraintes);
        contraintes.gridx = 2;
        contraintes.gridy = 2;
        contraintes.insets = new Insets(0, 0, 0, 0);
        contraintes.gridwidth = 1;
        contraintes.gridheight = 1;
        contraintes.weightx = 0.0;
        contraintes.weighty = 0.0;
        contraintes.ipadx = 0;
        contraintes.ipady = 0;
        contraintes.fill = 0;
        contraintes.anchor = 21;
        this.add((Component)new JLabel(this.bundle.getString("kprecisionMO")), contraintes);
        contraintes.gridx = 3;
        contraintes.gridy = 2;
        contraintes.insets = new Insets(0, 0, 0, 0);
        contraintes.gridwidth = 1;
        contraintes.gridheight = 1;
        contraintes.weightx = 0.0;
        contraintes.weighty = 0.0;
        contraintes.ipadx = 0;
        contraintes.ipady = 0;
        contraintes.fill = 0;
        contraintes.anchor = 21;
        this.add((Component)this.spinnerMO, contraintes);
        contraintes.gridx = 2;
        contraintes.gridy = 3;
        contraintes.insets = new Insets(5, 0, 0, 0);
        contraintes.gridwidth = 1;
        contraintes.gridheight = 1;
        contraintes.weightx = 0.0;
        contraintes.weighty = 0.0;
        contraintes.ipadx = 0;
        contraintes.ipady = 0;
        contraintes.fill = 0;
        contraintes.anchor = 21;
        this.add((Component)new JLabel(this.bundle.getString("kprecisionEnergy")), contraintes);
        contraintes.gridx = 3;
        contraintes.gridy = 3;
        contraintes.insets = new Insets(5, 0, 0, 0);
        contraintes.gridwidth = 1;
        contraintes.gridheight = 1;
        contraintes.weightx = 0.0;
        contraintes.weighty = 0.0;
        contraintes.ipadx = 0;
        contraintes.ipady = 0;
        contraintes.fill = 0;
        contraintes.anchor = 21;
        this.add((Component)this.spinnerEnergy, contraintes);
        contraintes.gridx = 1;
        contraintes.gridy = 4;
        contraintes.insets = new Insets(10, 0, 0, 0);
        contraintes.gridwidth = 1;
        contraintes.gridheight = 1;
        contraintes.weightx = 0.0;
        contraintes.weighty = 0.0;
        contraintes.ipadx = 0;
        contraintes.ipady = 0;
        contraintes.fill = 0;
        contraintes.anchor = 21;
        this.add((Component)new JLabel(this.bundle.getString("kMOratio")), contraintes);
        contraintes.gridx = 2;
        contraintes.gridy = 4;
        contraintes.insets = new Insets(10, 0, 0, 0);
        contraintes.gridwidth = 1;
        contraintes.gridheight = 1;
        contraintes.weightx = 0.0;
        contraintes.weighty = 0.0;
        contraintes.ipadx = 0;
        contraintes.ipady = 0;
        contraintes.fill = 2;
        contraintes.anchor = 21;
        this.add((Component)this.sliderMOratio, contraintes);
        contraintes.gridx = 3;
        contraintes.gridy = 4;
        contraintes.insets = new Insets(10, 0, 0, 0);
        contraintes.gridwidth = 1;
        contraintes.gridheight = 1;
        contraintes.weightx = 0.0;
        contraintes.weighty = 0.0;
        contraintes.ipadx = 0;
        contraintes.ipady = 0;
        contraintes.fill = 0;
        contraintes.anchor = 21;
        this.add((Component)this.spinnerMOratio, contraintes);
        contraintes.gridx = 1;
        contraintes.gridy = 5;
        contraintes.insets = new Insets(10, 0, 0, 0);
        contraintes.gridwidth = 3;
        contraintes.gridheight = 1;
        contraintes.weightx = 0.0;
        contraintes.weighty = 0.0;
        contraintes.ipadx = 0;
        contraintes.ipady = 0;
        contraintes.fill = 0;
        contraintes.anchor = 21;
        this.add((Component)new JLabel(this.bundle.getString("kAtomDisplay")), contraintes);
        contraintes.gridx = 2;
        contraintes.gridy = 6;
        contraintes.insets = new Insets(5, 0, 0, 0);
        contraintes.gridwidth = 1;
        contraintes.gridheight = 1;
        contraintes.weightx = 0.0;
        contraintes.weighty = 0.0;
        contraintes.ipadx = 0;
        contraintes.ipady = 0;
        contraintes.fill = 0;
        contraintes.anchor = 21;
        this.add((Component)this.chkCircle, contraintes);
        contraintes.gridx = 3;
        contraintes.gridy = 6;
        contraintes.insets = new Insets(5, 0, 0, 0);
        contraintes.gridwidth = 1;
        contraintes.gridheight = 1;
        contraintes.weightx = 0.0;
        contraintes.weighty = 0.0;
        contraintes.ipadx = 0;
        contraintes.ipady = 0;
        contraintes.fill = 0;
        contraintes.anchor = 21;
        this.add((Component)this.chkSymbol, contraintes);
        contraintes.gridx = 1;
        contraintes.gridy = 7;
        contraintes.insets = new Insets(10, 0, 0, 0);
        contraintes.gridwidth = 3;
        contraintes.gridheight = 1;
        contraintes.weightx = 0.0;
        contraintes.weighty = 0.0;
        contraintes.ipadx = 0;
        contraintes.ipady = 0;
        contraintes.fill = 0;
        contraintes.anchor = 21;
        this.add((Component)new JLabel(this.bundle.getString("prefAutoGen")), contraintes);
        JPanel panel = new JPanel();
        panel.add(new JLabel(this.bundle.getString("Nsep")));
        panel.add(this.spinnerNSepCharge);
        contraintes.gridx = 2;
        contraintes.gridy = 8;
        contraintes.insets = new Insets(5, 0, 0, 0);
        contraintes.gridwidth = 2;
        contraintes.gridheight = 1;
        contraintes.weightx = 0.0;
        contraintes.weighty = 0.0;
        contraintes.ipadx = 0;
        contraintes.ipady = 0;
        contraintes.fill = 0;
        contraintes.anchor = 21;
        this.add((Component)panel, contraintes);
        contraintes.gridx = 3;
        contraintes.gridy = 8;
        contraintes.insets = new Insets(5, 0, 0, 0);
        contraintes.gridwidth = 1;
        contraintes.gridheight = 1;
        contraintes.weightx = 0.0;
        contraintes.weighty = 0.0;
        contraintes.ipadx = 0;
        contraintes.ipady = 0;
        contraintes.fill = 0;
        contraintes.anchor = 21;
        this.add((Component)this.checkBoxCouple, contraintes);
        contraintes.gridx = 1;
        contraintes.gridy = 9;
        contraintes.insets = new Insets(5, 0, 0, 0);
        contraintes.gridwidth = 3;
        contraintes.gridheight = 1;
        contraintes.weightx = 0.0;
        contraintes.weighty = 0.0;
        contraintes.ipadx = 0;
        contraintes.ipady = 0;
        contraintes.fill = 0;
        contraintes.anchor = 21;
        this.add((Component)tabbedPane, contraintes);
        contraintes.gridx = 1;
        contraintes.gridy = 10;
        contraintes.insets = new Insets(10, 0, 0, 0);
        contraintes.gridwidth = 1;
        contraintes.gridheight = 1;
        contraintes.weightx = 0.0;
        contraintes.weighty = 0.0;
        contraintes.ipadx = 0;
        contraintes.ipady = 0;
        contraintes.fill = 0;
        contraintes.anchor = 21;
        this.add((Component)this.btOK, contraintes);
        contraintes.gridx = 3;
        contraintes.gridy = 10;
        contraintes.insets = new Insets(10, 0, 0, 0);
        contraintes.gridwidth = 1;
        contraintes.gridheight = 1;
        contraintes.weightx = 0.0;
        contraintes.weighty = 0.0;
        contraintes.ipadx = 0;
        contraintes.ipady = 0;
        contraintes.fill = 0;
        contraintes.anchor = 22;
        this.add((Component)this.btUndo, contraintes);
        this.pack();
        this.setPreferredSize(new Dimension(500, 480));
        this.setSize(new Dimension(500, 480));
        this.setLocationRelativeTo(app);
        this.setModal(true);
        this.applyValuesToUI();
        this.saveCurrentValues();
    }

    private String getTextCheckVersion(boolean selected) {
        if (!selected) {
            return "";
        }
        String txt = this.app.getCheckVersionTxt();
        if (!this.app.isExecutedOnInternet() && txt.equals("")) {
            return this.bundle.getString("uptodate");
        }
        return "<html>" + txt + "</html>";
    }

    protected class ApplyPreferencesListener
    implements ChangeListener {
        protected ApplyPreferencesListener() {
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            PreferencesFrame.this.applyPreferences();
        }
    }
}

