/*
 * Decompiled with CFR 0.152.
 */
package views;

import controller.globalCommands.PopUp;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.net.URL;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import util.FollowLink;
import util.MyResourceBundle;
import util.languages.LanguageManager;
import views.MyJDialog;

public class SimpleDialogScrollText
extends MyJDialog {
    JTextPane pane;

    public SimpleDialogScrollText(JFrame frame, String title, URL url) {
        super(frame);
        this.init(frame, title);
        try {
            this.pane.setPage(url);
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        this.setVisible(true);
    }

    public SimpleDialogScrollText(JFrame frame, String title, String text) {
        super(frame);
        this.init(frame, title);
        System.out.println(text);
        this.pane.setText(text);
        this.setVisible(true);
    }

    protected void init(JFrame frame, String title) {
        MyResourceBundle bundle = LanguageManager.getInstance().getResource("About");
        this.setTitle(title);
        this.pane = new JTextPane();
        this.pane.setPreferredSize(this.getPreferredSize());
        this.pane.setEditable(false);
        this.pane.setContentType("text/html; charset=UTF-8");
        this.pane.setCaretColor(Color.black);
        this.pane.setFont(new Font("Monaco", 0, 12));
        this.pane.setCaretPosition(0);
        this.pane.setMargin(new Insets(10, 10, 10, 10));
        this.pane.addHyperlinkListener(new FollowLink(this.pane));
        PopUp.pop(this.pane);
        JScrollPane scrollPane = new JScrollPane(this.pane, 20, 32);
        scrollPane.setHorizontalScrollBarPolicy(32);
        scrollPane.setVerticalScrollBarPolicy(22);
        scrollPane.setPreferredSize(new Dimension(800, 600));
        Container contenu = this.getContentPane();
        contenu.setLayout(new BorderLayout(5, 5));
        JButton btClose = new JButton(bundle.getString("close"));
        btClose.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SimpleDialogScrollText.this.setVisible(false);
                SimpleDialogScrollText.this.dispose();
            }
        });
        JPanel panelButtons = new JPanel();
        panelButtons.setLayout(new FlowLayout());
        panelButtons.add(btClose);
        contenu.add((Component)scrollPane, "Center");
        contenu.add((Component)panelButtons, "South");
        this.pack();
        this.setPreferredSize(new Dimension(500, 600));
        this.setSize(new Dimension(500, 600));
        this.setLocationRelativeTo(frame);
    }
}

