/*
 * Decompiled with CFR 0.152.
 */
package views;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JWindow;
import javax.swing.SwingUtilities;
import util.MyResourceBundle;
import util.io.SwingIO;
import util.languages.LanguageManager;
import views.AboutPanel;
import views.FrameApp;

class SplashWindow
extends JWindow {
    FrameApp app;
    MyResourceBundle bundle;
    Thread splashThread;

    public SplashWindow(FrameApp app, int waitTime) {
        super((Frame)null);
        this.app = app;
        try {
            this.setAlwaysOnTop(true);
        }
        catch (SecurityException e3) {
            SwingIO.warning(this.getClass().getName(), "SplashWindow", "AlwaysOnTop does not work in the online version", e3);
        }
        catch (Exception e4) {
            SwingIO.warning(this.getClass().getName(), "SplashWindow", "AlwaysOnTop does not work in the online version", e4);
        }
        this.bundle = LanguageManager.getInstance().getResource("About");
        int aboutWidth = (Integer)this.bundle.getObject("ksplashWidth");
        int aboutHeight = (Integer)this.bundle.getObject("ksplashHeight");
        AboutPanel bigPanel = new AboutPanel(app, this);
        bigPanel.imgLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                SplashWindow.this.close();
            }
        });
        bigPanel.aboutLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                SplashWindow.this.close();
            }
        });
        Container contenu = this.getContentPane();
        contenu.setLayout(new BorderLayout());
        contenu.add((Component)bigPanel, "Center");
        this.pack();
        this.setSize(new Dimension(aboutWidth, aboutHeight));
        this.setLocationRelativeTo(app);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                SplashWindow.this.close();
            }
        });
        final int pause = waitTime;
        final Runnable closerRunner = new Runnable(){

            @Override
            public void run() {
                SplashWindow.this.close();
            }
        };
        Runnable waitRunner = new Runnable(){

            @Override
            public void run() {
                try {
                    Thread.sleep(pause);
                    SwingUtilities.invokeAndWait(closerRunner);
                }
                catch (InterruptedException e) {
                    SwingIO.log("SplasScreen", "close timer", "timer interruption ok");
                }
                catch (Exception e) {
                    SwingIO.error(this.getClass().getName(), "run", e.getMessage(), e);
                }
            }
        };
        this.setVisible(true);
        this.splashThread = new Thread(waitRunner, "SplashThread");
        if (app.getRights().isValidUser()) {
            this.splashThread.start();
        }
    }

    protected void close() {
        this.splashThread.interrupt();
        this.setVisible(false);
        this.dispose();
        this.app.displayLicenseToAccept();
    }
}

