/*
 * Decompiled with CFR 0.152.
 */
package views;

import controller.structureViewController.GhostMolecule;
import controller.structureViewController.StructureViewController;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.text.DecimalFormat;
import java.text.MessageFormat;
import java.util.ArrayList;
import javax.swing.JPanel;
import org.ctom.hulis.huckel.Atom;
import org.ctom.hulis.huckel.BlocDelocalized;
import org.ctom.hulis.huckel.Bond;
import org.ctom.hulis.huckel.CoupleLocal;
import org.ctom.hulis.huckel.IHuckelObject;
import org.ctom.hulis.huckel.IMoleculeComponent;
import org.ctom.hulis.huckel.Mesomery;
import org.ctom.hulis.huckel.OrbitaleAtomique;
import org.ctom.hulis.huckel.OrbitaleMoleculaire;
import org.ctom.hulis.huckel.SpinOrbitaleMoleculaire;
import org.ctom.hulis.huckel.events.BlocDelocalizedEvent;
import org.ctom.hulis.huckel.events.GeometryEvent;
import org.ctom.hulis.huckel.events.HuckelAtomEvent;
import org.ctom.hulis.huckel.events.HuckelBondEvent;
import org.ctom.hulis.huckel.events.MoleculeEvent;
import org.ctom.hulis.huckel.events.MonoExcitationEvent;
import org.ctom.hulis.huckel.events.StructureDelocalizedEvent;
import org.ctom.hulis.huckel.events.StructureEvent;
import org.ctom.hulis.huckel.events.StructureLocalizedEvent;
import org.ctom.hulis.huckel.exception.NoSOMAvailableException;
import org.ctom.hulis.huckel.exception.RedundanceException;
import org.ctom.hulis.huckel.exception.UnavailableSOMException;
import org.ctom.hulis.huckel.listeners.IMoleculeGeometryListener;
import org.ctom.hulis.huckel.listeners.IStructureDelocalizedListener;
import org.ctom.hulis.huckel.listeners.IStructureListener;
import org.ctom.hulis.huckel.listeners.IStructureLocalizedListener;
import org.ctom.hulis.huckel.methods.IMethod;
import org.ctom.hulis.huckel.structures.Structure;
import org.ctom.hulis.huckel.structures.StructureDelocalized;
import org.ctom.hulis.huckel.structures.StructureLocalized;
import org.ctom.hulis.huckel.structures.symmetry.Symmetry;
import org.ctom.hulis.prefs.Preferences;
import org.ctom.util.maths.Point3D;
import util.ComponentsTools;
import util.MyJOptionPane;
import util.MyResourceBundle;
import util.io.SwingIO;
import util.languages.LanguageManager;
import views.AtomColor;
import views.AtomDrawer;
import views.BondDrawer;
import views.GhostAtomDrawer;
import views.GhostBondDrawer;
import views.GraphOM;
import views.MesomeryView;
import views.OrbitalDrawer;
import views.Selection;

public class StructureView
extends JPanel
implements IStructureLocalizedListener,
IStructureDelocalizedListener,
IStructureListener,
IMoleculeGeometryListener {
    public static boolean WARNING_NEGATIVE_CHARGE = false;
    public static boolean DEBUG = false;
    private static final Color COLOR_ETOT = Color.BLACK;
    private static final Color COLOR_ERROR_INFOS = Color.RED;
    private static final Color COLOR_BLOC_NB_ELECTRONS = Color.BLUE;
    public static final Color COUPLE_COLOR = Color.GREEN;
    public static final Color SELECTED_BLOC_DELOCALIZED_COLOR = new Color(197, 162, 3);
    public static final float SELECTED_BLOC_DELOCALIZED_STROKE = 2.0f;
    public static final Color OVERFLIGHT_BLOC_DELOCALIZED_COLOR = new Color(226, 181, 0);
    public static final float COUPLE_LINE_STROKE = 3.0f;
    public static final DecimalFormat FORM = new DecimalFormat("#.#");
    public static final int MODULO_TEXT_ZOOM = 5;
    public static final String FONT_TEXT_ENERGY_FAMILY = "Helvetica";
    public static final int FONT_TEXT_ENERGY_STYLE = 0;
    public static final int FONT_TEXT_ENERGY_DEFAULT_SIZE = 13;
    public static final Font FONT_TEXT_ENERGY = new Font("Helvetica", 0, 13);
    public static final String FONT_TEXT_INFORMATIONS_FAMILY = "Helvetica";
    public static final int FONT_TEXT_INFORMATIONS_STYLE = 0;
    public static final int FONT_TEXT_INFORMATIONS_DEFAULT_SIZE = 14;
    public static final Font FONT_TEXT_INFORMATIONS = new Font("Helvetica", 0, 14);
    public static final String FONT_FAMILY_BLOC_NB_ELECTRONS = "Helvetica";
    public static final int FONT_STYLE_BLOC_NB_ELECTRONS = 1;
    public static final int FONT_SIZE_BLOC_NB_ELECTRONS = 14;
    public static int SPACE_BETWEEN_MOLECULE_AND_TEXT = 10;
    private static final int X_TEXT_MARGIN = 10;
    private static BlocDelocalized selectedBlocDelocalized;
    protected MyResourceBundle bundle;
    StructureViewController controller;
    private GraphOM graphOM;
    private OrbitaleMoleculaire orbitalMoleculaireShown;
    private Structure structure;
    private MesomeryView mesomeryView;
    private Selection selection;
    private BlocDelocalized overflightBlocDelocalized;
    private Symmetry symmetry;
    private GhostMolecule ghost;
    private ArrayList<Integer> atomsToHighlight;

    public static void setSelectedBlocDelocalized(BlocDelocalized blocDelocalized) {
        selectedBlocDelocalized = blocDelocalized;
    }

    public static BlocDelocalized getSelectedBlocDelocalized() {
        return selectedBlocDelocalized;
    }

    public StructureView(Structure structure, MesomeryView mesomeryView) throws Exception {
        if (structure == null) {
            throw new Exception("Structure must be initialized");
        }
        if (structure.getMesomeryParent() != mesomeryView.getMesomery()) {
            throw new Exception("Structure does not belong to mesomery parent viewer");
        }
        this.structure = structure;
        this.mesomeryView = mesomeryView;
        this.controller = new StructureViewController(this, structure);
        this.addMouseListener(this.controller);
        this.addMouseMotionListener(this.controller);
        this.structure.addListener(this);
        this.graphOM = new GraphOM(structure, this);
        this.selection = null;
        this.symmetry = null;
    }

    public Point2D getImagePoint(Point2D p) {
        return new Point2D.Double((this.getXMargin() + p.getX()) * this.getZoom(), (this.getYMargin() + p.getY()) * this.getZoom());
    }

    public Point2D getAntecedentPoint(Point2D p) {
        return new Point2D.Double(p.getX() / this.getZoom() - this.getXMargin(), p.getY() / this.getZoom() - this.getYMargin());
    }

    public Point3D getPoint3D(Point2D p2d) {
        return new Point3D(p2d.getX(), p2d.getY(), 0.0);
    }

    public Point2D getPoint2D(Point3D p3d) {
        return new Point2D.Double(p3d.getX(), p3d.getY());
    }

    public double getXMargin() {
        return this.mesomeryView.getXMargin();
    }

    public double getYMargin() {
        return this.mesomeryView.getYMargin();
    }

    public void setSelection(Selection selection) {
        this.selection = selection;
    }

    public Selection getSelection() {
        return this.selection;
    }

    public Point getMousePointerLocationOrRelativeCoordinatesOnScreeen(Point3D location) {
        Point pos = null;
        try {
            pos = (Point)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    return MouseInfo.getPointerInfo().getLocation();
                }
            });
        }
        catch (Exception e) {
            SwingIO.PrintIf(e);
            pos = new Point((int)(ComponentsTools.getLocationOnScreen(this).getX() + location.getX() * this.getZoom()), (int)(ComponentsTools.getLocationOnScreen(this).getY() + location.getY() * this.getZoom()));
        }
        return pos;
    }

    public boolean isDisplayPolynomes() {
        return this.mesomeryView.isDisplayPolynomes();
    }

    public boolean isDisplayCharges() {
        return this.mesomeryView.isDisplayCharges();
    }

    public boolean isDisplayHxHxy() {
        return this.mesomeryView.isDisplayHxHxy();
    }

    public boolean isDisplayNum() {
        return this.mesomeryView.isDisplayNum();
    }

    public void drawMolecule(Graphics2D g2d) {
        if (!Preferences.isDISPLAY_DENSITY()) {
            if (this.orbitalMoleculaireShown != null) {
                this.drawOrbitalUnder(g2d);
            }
        } else if (this.structure instanceof Structure) {
            this.drawDensityUnder(g2d);
        }
        this.drawSkeleton(g2d);
        if (!Preferences.isDISPLAY_DENSITY()) {
            if (this.orbitalMoleculaireShown != null) {
                this.drawOrbitalOver(g2d);
            }
        } else if (this.structure instanceof Structure) {
            this.drawDensityOver(g2d);
        }
        for (Atom a : this.structure.getAtoms()) {
            new AtomDrawer(this, a).writeInfos(g2d);
        }
        for (Bond b : this.structure.getBonds()) {
            new BondDrawer(this, b).writeInfos(g2d);
        }
        if (this.isDisplayNum() && this.orbitalMoleculaireShown != null) {
            int size = this.orbitalMoleculaireShown.getSize();
            int i2 = 0;
            while (i2 < size) {
                double coeff = this.orbitalMoleculaireShown.getCoeff(i2);
                OrbitaleAtomique orb = this.structure.getOAs()[i2];
                new OrbitalDrawer(this, orb, coeff).writeInfos(g2d);
                ++i2;
            }
        }
    }

    private void drawOrbitalUnder(Graphics2D g2d) {
        this.drawOrbital(g2d, 1);
    }

    private void drawOrbitalOver(Graphics2D g2d) {
        this.drawOrbital(g2d, 2);
    }

    private void drawDensityUnder(Graphics2D g2d) {
        this.drawDensity(g2d, 1);
    }

    private void drawDensityOver(Graphics2D g2d) {
        this.drawDensity(g2d, 2);
    }

    private void drawOrbital(Graphics2D g2d, int jval) {
        int size = this.orbitalMoleculaireShown.getSize();
        int i2 = 0;
        while (i2 < size) {
            double coeff = this.orbitalMoleculaireShown.getCoeff(i2);
            OrbitaleAtomique orb = this.structure.getOAs()[i2];
            new OrbitalDrawer(this, orb, coeff).draw(jval, g2d);
            ++i2;
        }
    }

    private void drawDensity(Graphics2D g2d, int jval) {
        OrbitaleAtomique[] oAs = this.structure.getOAs();
        int nOAs = oAs.length;
        SpinOrbitaleMoleculaire[] occSOM = null;
        try {
            occSOM = this.structure.getOccSOM();
        }
        catch (NoSOMAvailableException e) {
            e.printStackTrace();
        }
        catch (UnavailableSOMException e) {
            e.printStackTrace();
        }
        int nOccOM = occSOM.length;
        int iOA = 0;
        while (iOA < nOAs) {
            OrbitaleAtomique orb = oAs[iOA];
            double coeff = 0.0;
            int iOM = 0;
            while (iOM < nOccOM) {
                coeff += Math.pow(occSOM[iOM].getCoeff(iOA), 2.0);
                ++iOM;
            }
            new OrbitalDrawer(this, orb, coeff).draw(jval, g2d);
            ++iOA;
        }
    }

    private void drawSkeleton(Graphics2D g2d) {
        for (Bond b : this.structure.getBonds()) {
            new BondDrawer(this, b).draw(g2d);
        }
        for (Atom a : this.structure.getAtoms()) {
            new AtomDrawer(this, a).draw(g2d);
        }
    }

    private void drawGhost(Graphics2D g2d) {
        if (this.ghost != null) {
            AffineTransform at_reset = g2d.getTransform();
            AffineTransform trans = new AffineTransform();
            trans.translate(this.ghost.getOffset().getX(), this.ghost.getOffset().getY());
            g2d.transform(trans);
            for (Atom a : this.ghost.getAtoms()) {
                new GhostAtomDrawer(this, a).draw(g2d);
            }
            for (Bond b : this.ghost.getBonds()) {
                new GhostBondDrawer(this, b).draw(g2d);
            }
            g2d.setTransform(at_reset);
        }
    }

    public void erase() {
        this.addMouseListener(this.controller);
        this.addMouseMotionListener(this.controller);
        this.structure.removeListener(this);
        this.graphOM.erase();
        this.graphOM = null;
    }

    public Atom getAtom(Point2D p) {
        for (Atom a : this.structure.getAtoms()) {
            if (!new AtomDrawer(this, a).isContained(p)) continue;
            return a;
        }
        return null;
    }

    public Bond getBond(Point2D p) {
        for (Bond b : this.structure.getBonds()) {
            if (!new BondDrawer(this, b).isContained(p)) continue;
            return b;
        }
        return null;
    }

    public GraphOM getGraphOM() {
        return this.graphOM;
    }

    public MesomeryView getMesomeryView() {
        return this.mesomeryView;
    }

    public IMoleculeComponent getMoleculeComponent(Point2D p) {
        Atom a = this.getAtom(p);
        if (a != null) {
            return a;
        }
        Bond l = this.getBond(p);
        if (l != null) {
            return l;
        }
        return null;
    }

    public OrbitaleAtomique getOrbital(Point2D p) {
        if (this.getShownOrbital() == null) {
            return null;
        }
        int size = this.orbitalMoleculaireShown.getSize();
        int i2 = 0;
        while (i2 < size) {
            double coeff = this.orbitalMoleculaireShown.getCoeff(i2);
            OrbitaleAtomique orb = this.structure.getOAs()[i2];
            if (new OrbitalDrawer(this, orb, coeff).isContained(p)) {
                return orb;
            }
            ++i2;
        }
        i2 = 0;
        while (i2 < size) {
            OrbitaleAtomique orb = this.structure.getOAs()[i2];
            if (new AtomDrawer(this, orb.getHuckelAtom()).isContained(p)) {
                return orb;
            }
            ++i2;
        }
        return null;
    }

    public OrbitaleMoleculaire getShownOrbital() {
        return this.orbitalMoleculaireShown;
    }

    public Structure getStructure() {
        return this.structure;
    }

    public double getZoom() {
        return this.mesomeryView.zoom;
    }

    public double getAngle() {
        return this.mesomeryView.getAngle();
    }

    public boolean isAtom(Point2D p) {
        return this.getAtom(p) != null;
    }

    public boolean isBond(Point2D p) {
        return this.getBond(p) != null;
    }

    @Override
    public void moleculeDeleted(MoleculeEvent e) {
        this.repaint();
    }

    protected void drawCouple(Graphics2D g2d) {
        CoupleLocal couple;
        if (this.structure instanceof StructureLocalized && (couple = ((StructureLocalized)this.structure).getCouple()) != null) {
            g2d.setColor(COUPLE_COLOR);
            g2d.setStroke(new BasicStroke((float)this.getZoom() * 3.0f));
            AtomColor atomColor1 = null;
            try {
                atomColor1 = AtomColor.valueOf(couple.getHuckelAtom1().getSigle());
            }
            catch (IllegalArgumentException e) {
                atomColor1 = AtomColor.Xx;
            }
            AtomColor atomColor2 = null;
            try {
                atomColor2 = AtomColor.valueOf(couple.getHuckelAtom2().getSigle());
            }
            catch (IllegalArgumentException e) {
                atomColor2 = AtomColor.Xx;
            }
            g2d.draw(new Line2D.Double(this.getImagePoint(new Point2D.Double(couple.getHuckelAtom1().getX() + -1.5 * (double)atomColor1.getRadius(), couple.getHuckelAtom1().getY() + -0.4 * (double)atomColor1.getRadius())), this.getImagePoint(new Point2D.Double(couple.getHuckelAtom2().getX() + -1.5 * (double)atomColor2.getRadius(), couple.getHuckelAtom2().getY() + -0.4 * (double)atomColor2.getRadius()))));
        }
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
        Graphics2D g2d = (Graphics2D)g;
        g2d.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2d.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        this.bundle = LanguageManager.getInstance().getResource("StructureView");
        if (this.selection != null) {
            this.selection.draw(g2d);
        }
        if (this.structure.countAtoms() == 0) {
            return;
        }
        this.drawCouple(g2d);
        this.drawMolecule(g2d);
        this.writeBlocElectronsNumber(g2d);
        this.writeInfos(g2d);
    }

    protected void writeBlocElectronsNumber(Graphics2D g2d) {
        if (this.structure instanceof StructureDelocalized) {
            return;
        }
        g2d.setFont(this.getFontBlocElectronsNumber());
        for (BlocDelocalized blocDelocalized : ((StructureLocalized)this.structure).getListBlocDelocalized()) {
            if (blocDelocalized.countHuckelObjects() == 0) continue;
            Point2D barycentre = this.getBlocBarycenter(blocDelocalized);
            double xBary = barycentre.getX();
            double yBary = barycentre.getY();
            if (blocDelocalized == StructureView.getSelectedBlocDelocalized()) {
                g2d.setColor(SELECTED_BLOC_DELOCALIZED_COLOR);
            } else if (blocDelocalized == this.getOverflightBlocDelocalized()) {
                g2d.setColor(OVERFLIGHT_BLOC_DELOCALIZED_COLOR);
            } else {
                g2d.setColor(COLOR_BLOC_NB_ELECTRONS);
            }
            g2d.drawString(this.getFormattedStringBlocElectronsNumber(blocDelocalized), (int)xBary, (int)yBary);
        }
    }

    public BlocDelocalized getBlocDelocalized(Point2D p) {
        if (this.structure instanceof StructureDelocalized) {
            return null;
        }
        IMoleculeComponent moleculeComponent = this.getMoleculeComponent(p);
        if (moleculeComponent instanceof IHuckelObject) {
            IHuckelObject huckelObject = (IHuckelObject)moleculeComponent;
            BlocDelocalized bloc = huckelObject.getBlocDelocalizedParent();
            return bloc;
        }
        Structure structure = this.getStructure();
        boolean height = false;
        for (BlocDelocalized bloc : ((StructureLocalized)structure).getListBlocDelocalized()) {
            boolean width = false;
            Point2D barycentre = this.getBlocBarycenter(bloc);
            if (!(p.getX() >= barycentre.getX()) || !(p.getX() <= barycentre.getX() + (double)width) || !(p.getY() >= barycentre.getY() - (double)height) || !(p.getY() <= barycentre.getY())) continue;
            return bloc;
        }
        return null;
    }

    public String getFormattedStringBlocElectronsNumber(BlocDelocalized blocDelocalized) {
        return "[" + blocDelocalized.getNbElectron() + "]";
    }

    public Font getFontBlocElectronsNumber() {
        return new Font("Helvetica", 1, (int)(14.0 * (this.getZoom() % 5.0)));
    }

    public Point2D getBlocBarycenter(BlocDelocalized bloc) {
        double xtemp = 0.0;
        double ytemp = 0.0;
        double pond = 0.0;
        double radius = 0.0;
        double zoom = this.getZoom();
        for (IHuckelObject huckelObject : bloc.getListHuckelObject()) {
            if (huckelObject instanceof Atom) {
                AtomColor atomColor = null;
                try {
                    atomColor = AtomColor.valueOf(((Atom)((Object)huckelObject)).getSigle());
                }
                catch (IllegalArgumentException e) {
                    atomColor = AtomColor.Xx;
                }
                radius = (double)atomColor.getRadius() * zoom;
            } else {
                radius = this.getZoom();
            }
            pond += radius;
            Point2D pTemp = this.getImagePoint(this.getPoint2D(huckelObject.getLocation()));
            xtemp += pTemp.getX() * radius;
            ytemp += pTemp.getY() * radius;
        }
        double xBary = xtemp / pond;
        double yBary = ytemp / pond;
        return new Point2D.Double(xBary, yBary);
    }

    protected void writeInfos(Graphics2D g2d) {
        Font fontText = (Font)this.bundle.getObject("font");
        String mess = "";
        g2d.setColor(COLOR_ETOT);
        g2d.setFont(FONT_TEXT_ENERGY);
        g2d.setStroke(new BasicStroke(1.0f));
        int incr = 0;
        int verticalSpaceBetweenLines = (Integer)this.bundle.getObject("kverticalspacebetweenlines");
        int xResult = 10;
        int yResult = (int)((this.getYMargin() + this.structure.getYMax()) * this.getZoom() + this.getZoom() * 12.0 + (double)SPACE_BETWEEN_MOLECULE_AND_TEXT);
        if (this.getShownOrbital() != null) {
            int y = yResult + ++incr;
            Font currentFont = g2d.getFont();
            FontMetrics metrics = this.getFontMetrics(currentFont);
            int indexOrb = 0;
            int index = 0;
            int indexPartner = 0;
            if (this.getShownOrbital() instanceof SpinOrbitaleMoleculaire) {
                indexOrb = ((SpinOrbitaleMoleculaire)this.getShownOrbital()).getIndexTableOrbitale();
                index = ((SpinOrbitaleMoleculaire)this.getShownOrbital()).getIndex();
                indexPartner = ((SpinOrbitaleMoleculaire)this.getShownOrbital()).getPartner().getIndex();
            }
            if (DEBUG) {
                g2d.drawString("(" + index + ", " + indexPartner + ") " + indexOrb + " - " + "\u025b", xResult, y);
            } else {
                g2d.drawString("\u025b", xResult, y);
            }
            Font f = new Font(currentFont.getFamily(), currentFont.getStyle(), currentFont.getSize() - 3);
            g2d.setFont(f);
            int l1 = metrics.stringWidth("\u025b");
            if (DEBUG) {
                l1 = metrics.stringWidth("(" + index + ", " + indexPartner + ") " + indexOrb + " - " + "\u025b");
            }
            g2d.drawString(" = " + this.getShownOrbital().getEnergy(), xResult + l1, y);
        }
        if (this.mesomeryView.getFrameApp().getCurrentEnabledCommand() == "9") {
            String messTerminateBloc;
            g2d.setColor(COLOR_ERROR_INFOS);
            g2d.setFont(fontText);
            StructureView tmp = this.getMesomeryView().getFirstStructureWithSelectedBloc();
            if (tmp != null) {
                Object[] args = new Object[]{"\u03c8" + tmp.getStructure().getName()};
                messTerminateBloc = MessageFormat.format(this.bundle.getString("kendbloc"), args);
            } else {
                messTerminateBloc = this.bundle.getString("kselectbloc");
            }
            g2d.drawString(messTerminateBloc, xResult, yResult + ++incr * verticalSpaceBetweenLines);
            ++incr;
        }
        g2d.setFont(FONT_TEXT_INFORMATIONS);
        if (this.isDisplayPolynomes() && (this.structure instanceof StructureDelocalized || ((StructureLocalized)this.structure).getError() == StructureLocalized.Error.NOT_ERROR)) {
            g2d.drawString(this.structure.getCharacteristicPolynomial().toString(), xResult, this.getHeight() - verticalSpaceBetweenLines);
        }
        Mesomery mesomery = this.structure.getMesomeryParent();
        if (this.structure instanceof StructureLocalized && mesomery != null && mesomery.isEnabledFlyCalculate()) {
            StructureLocalized localized = (StructureLocalized)this.structure;
            g2d.setColor(COLOR_ERROR_INFOS);
            g2d.setFont(fontText);
            switch (localized.getError()) {
                case NOT_ERROR: {
                    break;
                }
                case ERROR_INCORRECT_NB_PI_ELEC: {
                    int nbElecPiDelocalized = this.structure.getMesomeryParent().getDelocalizedStructure().getSumOfPiElec();
                    Object[] args = new Object[]{new Integer(Math.abs(nbElecPiDelocalized - this.structure.getSumOfPiElec()))};
                    mess = nbElecPiDelocalized > this.structure.getSumOfPiElec() ? "kelecerror1" : "kelecerror2";
                    g2d.drawString(this.bundle.getString("kelecerror"), xResult, yResult + ++incr * verticalSpaceBetweenLines);
                    g2d.drawString(this.bundle.getString("kelecerrorb"), xResult, yResult + ++incr * verticalSpaceBetweenLines);
                    g2d.drawString(MessageFormat.format(this.bundle.getString(mess), args), xResult, yResult + ++incr * verticalSpaceBetweenLines);
                    break;
                }
                case ERROR_TOO_MUCH_SINGLE_ELECTRONS: {
                    mess = this.bundle.getString("tooMuchSingleElec");
                    g2d.drawString(this.bundle.getString("kelecerror"), xResult, yResult + ++incr * verticalSpaceBetweenLines);
                    g2d.drawString(this.bundle.getString("kelecerrorb"), xResult, yResult + ++incr * verticalSpaceBetweenLines);
                    g2d.drawString(mess, xResult, yResult + ++incr * verticalSpaceBetweenLines);
                    break;
                }
                case ERROR_ALREADY_EXIST: {
                    g2d.drawString(this.bundle.getString("kelecerror4"), xResult, yResult + ++incr * verticalSpaceBetweenLines);
                    g2d.drawString(String.valueOf(this.bundle.getString("kelecerror4b")) + "\u03c8" + localized.getIdenticalStruct().getName(), xResult, yResult + ++incr * verticalSpaceBetweenLines);
                    break;
                }
            }
            IMethod[] iMethodArray = this.getMesomeryView().getMesomery().getMethods();
            int n = iMethodArray.length;
            int n2 = 0;
            while (n2 < n) {
                IMethod method = iMethodArray[n2];
                if (method.getError() != null) {
                    if (method.getError() instanceof RedundanceException) {
                        g2d.drawString(this.bundle.getString("kErrorRedundance"), xResult, yResult + ++incr * verticalSpaceBetweenLines);
                    } else {
                        Object[] args = new Object[]{method.getName(), method.getError().getMessage()};
                        g2d.drawString(MessageFormat.format(this.bundle.getString("methoderror"), args), xResult, yResult + ++incr * verticalSpaceBetweenLines);
                    }
                }
                ++n2;
            }
        }
    }

    public void setShownOrbital(OrbitaleMoleculaire orbShown) {
        this.orbitalMoleculaireShown = orbShown;
    }

    public StructureViewController getController() {
        return this.controller;
    }

    public void setController(StructureViewController controller) {
        this.controller = controller;
    }

    public void setGhost(GhostMolecule ghostMolecule) {
        this.ghost = ghostMolecule;
    }

    public void setAtomsToHighlight(ArrayList<Integer> list) {
        for (int i2 : list) {
            System.out.println(i2);
        }
        this.atomsToHighlight = list;
    }

    public ArrayList<Integer> getAtomsToHighlight() {
        return this.atomsToHighlight;
    }

    @Override
    public void structureLocalizedWeightChanged(StructureLocalizedEvent event) {
        this.repaint();
    }

    @Override
    public void structureLocalizedCoupleChanged(StructureLocalizedEvent event) {
    }

    @Override
    public void structureNameChanged(StructureEvent event) {
        this.repaint();
    }

    @Override
    public void moleculeAtomAdded(MoleculeEvent e) {
        this.createSymmetry();
        this.repaint();
    }

    @Override
    public void moleculeAtomRemoved(MoleculeEvent e) {
        this.createSymmetry();
        this.repaint();
    }

    @Override
    public void moleculeAtomReplaced(MoleculeEvent e) {
        this.createSymmetry();
        this.repaint();
    }

    @Override
    public void moleculeBondAdded(MoleculeEvent e) {
        this.createSymmetry();
        this.repaint();
    }

    @Override
    public void moleculeBondRemoved(MoleculeEvent e) {
        this.createSymmetry();
        this.repaint();
    }

    @Override
    public void moleculeChargeChanged(MoleculeEvent event) {
        if (WARNING_NEGATIVE_CHARGE && (Integer)event.getOldValue() <= 0 && (Integer)event.getNewValue() > 0) {
            MyJOptionPane.showMessageDialog(this, this.bundle.getString("kWarNegCharge"), this.bundle.getString("kwarning"), 2);
        }
        this.repaint();
    }

    @Override
    public void moleculeListHuckelAtomSeqNumAutoSetted(MoleculeEvent event) {
        this.repaint();
    }

    @Override
    public void moleculeListHuckelAtomSeqNumReset(MoleculeEvent event) {
        this.repaint();
    }

    @Override
    public void atomLocationChanged(GeometryEvent event) {
        this.repaint();
    }

    @Override
    public void moleculeMoved(GeometryEvent e) {
        this.repaint();
    }

    @Override
    public void moleculeRotated(GeometryEvent e) {
        this.repaint();
    }

    @Override
    public void huckelAtomHxChanged(HuckelAtomEvent e) {
        this.createSymmetry();
        this.repaint();
    }

    @Override
    public void huckelAtomRadRChanged(HuckelAtomEvent e) {
    }

    @Override
    public void huckelAtomSeqNumChanged(HuckelAtomEvent e) {
        this.repaint();
    }

    @Override
    public void huckelBondBondTypeChanged(HuckelBondEvent e) {
    }

    @Override
    public void huckelBondHxyChanged(HuckelBondEvent e) {
        this.createSymmetry();
        this.repaint();
    }

    @Override
    public void monoExcitationTriggered(MonoExcitationEvent e) {
        this.repaint();
    }

    @Override
    public void structureDelocalizedSpinChanged(StructureDelocalizedEvent event) {
        this.repaint();
    }

    @Override
    public void moleculeBlocDelocalizedAdded(MoleculeEvent event) {
    }

    @Override
    public void moleculeBlocDelocalizedRemoved(MoleculeEvent event) {
        this.repaint();
    }

    @Override
    public void blocDelocalizedHuckelObjectAdded(BlocDelocalizedEvent e) {
    }

    @Override
    public void blocDelocalizedHuckelObjectRemoved(BlocDelocalizedEvent e) {
    }

    @Override
    public void blocDelocalizedNbElectronsChanged(BlocDelocalizedEvent e) {
    }

    public BlocDelocalized getOverflightBlocDelocalized() {
        return this.overflightBlocDelocalized;
    }

    public void setOverflightBlocDelocalized(BlocDelocalized blocDelocalized) {
        this.overflightBlocDelocalized = blocDelocalized;
    }

    public Symmetry getSymmetry() {
        if (this.symmetry == null) {
            this.createSymmetry();
        }
        return this.symmetry;
    }

    private void createSymmetry() {
        this.symmetry = new Symmetry(this.getStructure());
    }

    @Override
    public void structureLocalizedCoupleRemoved(StructureLocalizedEvent event) {
        this.repaint();
    }
}

